/*
 * dia_ASFComponentSWUpdatePrj.cpp
 *
 *  Created on: Dec 27, 2015
 *      Author: nbs3kor
 */

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif


#include "fcswupdatesrv/FcSwUpdateSrvProxy.h"

#ifndef __INCLUDED_DIA_COMMON_APPLICATION__
#include "common/framework/application/dia_common_application.h"
#endif

#ifndef DIA_SAFEATURESWUPDATE_H_
#include <common/framework/sysadapters/dia_SAFeatureSwUpdate.h>
#endif

#ifndef DIA_SAFEATURESWUPDATEPRJ_H_
#include  <project/framework/sysadapters/dia_SAFeatureSWUpdatePrj.h>
#endif

#ifndef __INCLUDED_DIA_ASF_COMPONENT_SW_UPDATE_PRJ__
#include "dia_ASFComponentSWUpdatePrj.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

using namespace fcswupdatesrv::FcSwUpdateSrv;

namespace asf {

//------------------------------------------------------------------------------

dia_ASFComponentSWUpdatePrj::dia_ASFComponentSWUpdatePrj()
{
   dia_tclFnctTrace oTrace("--> dia_ASFComponentSWUpdatePrj::dia_ASFComponentSWUpdatePrj");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
      DIA_TR_ERR("!!! Error: Failed to get pointer to global factory !!");
      return;
   }

   tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("!!! Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
      return;
   }

   //
   // System Adapter object
   //

   // create the ASF system adapter object
   //dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
   ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy > proxy = FcSwUpdateSrvProxy::createProxy("fcSwUpdatePort", *pSystemAdapter);

   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginASF< FcSwUpdateSrvProxy >* pSASWUpdateService =
         dia_ASFComponent::createSystemAdapterServicePlugin<FcSwUpdateSrvProxy>(
            "DIA_SASWUpdateSrv",
            proxy,
            pSystemAdapter);

   if (pSASWUpdateService)
   {
      pSASWUpdateService->setCondVarRetries(15);
   }

   //
   // Feature Plugins
   //
   dia_SAFeatureSwUpdate* pSAFeatureSWUpdate =
         dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureSwUpdate, FcSwUpdateSrvProxy>(pSASWUpdateService);

   if ( pSAFeatureSWUpdate )
   {
      if (assignInterfaceAndNotifier<dia_ISwUpdate,dia_ISwUpdateListener,dia_ISwUpdateNotifier>(pSAFeatureSWUpdate) != DIA_SUCCESS)
      {
         DIA_TR_ERR("!!! dia_ASFComponentSWUpdatePrj::dia_ASFComponentSWUpdatePrj => Error: assignInterfaceAndNotifier failed");
      }
   }

   //
   // Feature Plugins
   //
   //Might have to add an IF-DEF variant to differentiate the usecase between feature plugins
   //IF-DEF Variant needs to be added in prod.xml
   dia_SAFeatureSWUpdatePrj* pSAFeatureSWUpdatePrj= dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureSWUpdatePrj, FcSwUpdateSrvProxy>(pSASWUpdateService);

   if ( pSAFeatureSWUpdatePrj )
   {
     if (assignInterfaceAndNotifier<dia_ISWUpdatePrj, dia_ISWUpdatePrjListener, dia_ISWUpdatePrjNotifier>(pSAFeatureSWUpdatePrj) != DIA_SUCCESS)
     {
       DIA_TR_ERR("dia_ASFComponentSWUpdatePrj::dia_ASFComponentSWUpdatePrj. Error: assignInterfaceAndNotifier failed");
     }
   }

}
//------------------------------------------------------------------------------

dia_ASFComponentSWUpdatePrj::~dia_ASFComponentSWUpdatePrj()
{
}
//------------------------------------------------------------------------------

} //namespace asf

