/*
 * dia_ASFComponentPhoneConnectionSetting.cpp
 *
 *  Created on: Jun 1, 2016
 *      Author: jas1hi
 */



#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef DIA_SAFEATUREPHONECONNECTIONSETTING_H_
#include <project/framework/sysadapters/dia_SAFeaturePhoneConnectionSetting.h>
#endif

#ifndef BOSCH_CM_AI_NISSAN_HMI_PHONECONNECTIONDURATION_PHONECONNECTIONDURATIONPROXY_H
#include <bosch/cm/ai/nissan/hmi/phoneconnectionduration/PhoneConnectionDurationProxy.h>
#endif

#include "dia_ASFComponentPhoneConnectionSetting.h"

using namespace bosch::cm::ai::nissan::hmi::phoneconnectionduration::PhoneConnectionDuration;


namespace asf {

dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting()
{
	dia_tclFnctTrace oTrace("--> dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting");

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	dia_Factory* pFactory = getInstanceOfFactory();
	if ( !pFactory )
	{
	  DIA_TR_ERR("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. Error: Failed to get pointer to global factory !!");
	  return;
	}

	tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
	if ( retCode != DIA_SUCCESS )
	{
	  DIA_TR_ERR("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
	  return;
	}

	//
	// asf System Adapter object
	//
	//dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
	if (pSystemAdapter){
		DIA_TR_INF("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. pSystemAdapter = OK");
	}
	else {
		DIA_TR_ERR("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. Error: pSystemAdapter = NULL");
	}

	::boost::shared_ptr< PhoneConnectionDurationProxy > proxy =  PhoneConnectionDurationProxy::createProxy("phoneConnectionSettingPort", *pSystemAdapter);
	if (proxy.get()){
		DIA_TR_INF("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. proxy.get() = OK");
	}
	else {
		DIA_TR_ERR("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. Error: proxy = NULL");
	}

	//
	// Service Plugins
	//
	dia_SystemAdapterServicePluginASF< PhoneConnectionDurationProxy >* pSAPhoneConnectionDurationService = dia_ASFComponent::createSystemAdapterServicePlugin<PhoneConnectionDurationProxy>("DIA_SAPhoneConnectionSrv", proxy, pSystemAdapter);
	if (pSystemAdapter){
		DIA_TR_INF("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. pSAPhoneConnectionDurationService = OK");
	}
	else {
		DIA_TR_ERR("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. Error: pSAPhoneConnectionDurationService = NULL");
	}

	//
	// Feature Plugins
	//
	dia_SAFeaturePhoneConnectionSetting* pSAFeaturePhoneConnectionSetting = dia_ASFComponent::createSystemAdapterFeature<dia_SAFeaturePhoneConnectionSetting, PhoneConnectionDurationProxy>(pSAPhoneConnectionDurationService);

	if ( pSAFeaturePhoneConnectionSetting )
	{
	   DIA_TR_INF("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. pSAFeaturePhoneConnectionSetting = OK");

	  if (assignInterfaceAndNotifier<dia_IPhoneConnectionSetting, dia_IPhoneConnectionSettingListener, dia_IPhoneConnectionSettingNotifier>(pSAFeaturePhoneConnectionSetting) != DIA_SUCCESS)
	  {
		 DIA_TR_ERR("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. Error: assignInterfaceAndNotifier failed");
	  }
	}
	else {
		DIA_TR_ERR("dia_ASFComponentPhoneConnectionSetting::dia_ASFComponentPhoneConnectionSetting. pSAFeaturePhoneConnectionSetting = NULL");
	}
#endif
}

dia_ASFComponentPhoneConnectionSetting::~dia_ASFComponentPhoneConnectionSetting() {
	// TODO Auto-generated destructor stub
}

}

