/*
 * dia_ASFComponentHmiNavigationDataUpdate.cpp
 *
 *  Created on: March 24, 2017
 *      Author: kaa1hi
 */

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef DIA_SAFEATUREHMINAVIGATION_DATA_UPDATE_H_
#include <project/framework/sysadapters/dia_SAFeatureHMINavigationDataUpdate.h>
#endif

//GEN directory
#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICEPROXY_H
#include <org/bosch/cm/navigation/NavigationDataUpdateServiceProxy.h>
#endif

#include "dia_ASFComponentHmiNavigationDataUpdate.h"

using namespace org::bosch::cm::navigation::NavigationDataUpdateService;

namespace asf {

dia_ASFComponentHmiNavigationDataUpdate::dia_ASFComponentHmiNavigationDataUpdate()
{
   dia_tclFnctTrace oTrace("--> dia_ASFComponentHmiNavigationDataUpdate::dia_ASFComponentHmiNavigationDataUpdate");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
     DIA_TR_ERR("dia_ASFComponentHmiNavigationDataUpdate::dia_ASFComponentHmiNavigationDataUpdate. Error: Failed to get pointer to global factory !!");
     return;
   }

   tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
   if ( retCode != DIA_SUCCESS )
   {
     DIA_TR_ERR("dia_ASFComponentHmiNavigationDataUpdate::dia_ASFComponentHmiNavigationDataUpdate. Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
     return;
   }

   //
   // asf System Adapter object
   //
   //dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
   ::boost::shared_ptr< NavigationDataUpdateServiceProxy > proxy =  NavigationDataUpdateServiceProxy::createProxy("hmiNavigationDataUpdatePort", *pSystemAdapter);

   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginASF< NavigationDataUpdateServiceProxy >* pSAHMINavigationDataUpdateService = dia_ASFComponent::createSystemAdapterServicePlugin<NavigationDataUpdateServiceProxy>("DiaSANavDataUpdSrv", proxy, pSystemAdapter);

   //
   // Feature Plugins
   //
   dia_SAFeatureHMINavigationDataUpdate* pSAFeatureHMINavigationDataUpdate = dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureHMINavigationDataUpdate, NavigationDataUpdateServiceProxy>(pSAHMINavigationDataUpdateService);

   if ( pSAFeatureHMINavigationDataUpdate )
   {
      if (assignInterfaceAndNotifier<dia_IHMINavigationDataUpdate, dia_IHMINavigationDataUpdateListener, dia_IHMINavigationDataUpdateNotifier>(pSAFeatureHMINavigationDataUpdate) != DIA_SUCCESS)
      {
         DIA_TR_ERR("dia_ASFComponentHmiNavigationDataUpdate::dia_ASFComponentHmiNavigationDataUpdate. Error: assignInterfaceAndNotifier failed");
      }
   }
   else
   {
      DIA_TR_ERR("dia_ASFComponentHmiNavigationDataUpdate::dia_ASFComponentHmiNavigationDataUpdate pSAFeatureHMINavigationDataUpdate NULL");
   }
}

dia_ASFComponentHmiNavigationDataUpdate::~dia_ASFComponentHmiNavigationDataUpdate() {
   // TODO Auto-generated destructor stub
}

} //namespace asf
