/*!
 * \file       dia_ASFComponentErrorLog.h
 *
 * \brief      header file for dia_ASFComponentErrorLog
 *
 * \details    ASF component for Diaglog
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponents
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef DIA_ASFCOMPONENTERRORLOG_H_
#define DIA_ASFCOMPONENTERRORLOG_H_

#include "dia_ASFComponent.h"

namespace asf {

class dia_ASFComponentErrorLog: public dia_ASFComponent
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_ASFComponentErrorLog);

private:
   /*lint -save -e1704 class constructor could be private, because this class is not referenced at the moment. ;) */
   friend BaseComponent* ComponentFactory<dia_ASFComponentErrorLog>::getComponent();

private:
   //! default class constructor called only by ComponentFactory<dia_ASFComponentErrorLog>::getComponent()
   dia_ASFComponentErrorLog();
   /*lint -restore +e1704 */

public:
   //! default class destructor
   virtual ~dia_ASFComponentErrorLog();
};

} //namespace asf

#endif /* DIA_ASFCOMPONENTERRORLOG_H_ */
