/*!
 * \file       dia_ASFComponentErrorLog.cpp
 *
 * \brief      ASF component for Diaglog
 *
 * \details    ASF component for Diaglog
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponents
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef DIA_SAFEATUREERRORLOGASF_H_
#include <project/framework/sysadapters/dia_SAFeatureErrorLogASF.h>
#endif

#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGLOGPROXY_H
#include <org/bosch/cm/diagnosis/dbus/DiaglogProxy.h>
#endif

#ifndef DIA_ASFCOMPONENTERRORLOG_H_
#include "dia_ASFComponentErrorLog.h"
#endif

using namespace org::bosch::cm::diagnosis::dbus::Diaglog;


namespace asf {

dia_ASFComponentErrorLog::dia_ASFComponentErrorLog()
{
	dia_tclFnctTrace oTrace("--> dia_ASFComponentErrorLog::dia_ASFComponentErrorLog");

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	dia_Factory* pFactory = getInstanceOfFactory();
	if ( !pFactory )
	{
	  DIA_TR_ERR("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. Error: Failed to get pointer to global factory !!");
	  return;
	}

	tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
	if ( retCode != DIA_SUCCESS )
	{
	  DIA_TR_ERR("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
	  return;
	}

	//
	// asf System Adapter object
	//
	//dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
	if (pSystemAdapter){
		DIA_TR_INF("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. pSystemAdapter = OK");
	}
	else {
		DIA_TR_ERR("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. Error: pSystemAdapter = NULL");
	}

	::boost::shared_ptr< DiaglogProxy > proxy =  DiaglogProxy::createProxy("errorLogPort", *pSystemAdapter);
	if (proxy.get()){
		DIA_TR_INF("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. proxy.get() = OK");
	}
	else {
		DIA_TR_ERR("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. Error: proxy = NULL");
	}

	//
	// Service Plugins
	//
	dia_SystemAdapterServicePluginASF< DiaglogProxy >* pSAErrorLogService = dia_ASFComponent::createSystemAdapterServicePlugin<DiaglogProxy>("DIA_SAErrorLogSrv", proxy, pSystemAdapter);
	if (pSystemAdapter){
		DIA_TR_INF("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. pSAErrorLogService = OK");
	}
	else {
		DIA_TR_ERR("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. Error: pSAErrorLogService = NULL");
	}

	//
	// Feature Plugins
	//
	dia_SAFeatureErrorLogASF* pSAFeatureErrorLogASF = dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureErrorLogASF, DiaglogProxy>(pSAErrorLogService);

	if ( pSAFeatureErrorLogASF )
	{
	   DIA_TR_INF("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. pSAFeatureErrorLogASF = OK");

	  if (assignInterfaceAndNotifier<dia_IErrorLogASF, dia_IErrorLogASFListener, dia_IErrorLogASFNotifier>(pSAFeatureErrorLogASF) != DIA_SUCCESS)
	  {
		 DIA_TR_ERR("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. Error: pSAFeatureErrorLogASF failed");
	  }
	}
	else {
		DIA_TR_ERR("dia_ASFComponentErrorLog::dia_ASFComponentErrorLog. pSAFeatureErrorLogASF = NULL");
	}
#endif
}

dia_ASFComponentErrorLog::~dia_ASFComponentErrorLog() {
	// TODO Auto-generated destructor stub
}

}

