/*
 * dia_ASFComponentAuthorizationLevel.cpp
 *
 *  Created on: Jul 17, 2014
 *      Author: shw2abt
 */

//Redefinition of new and delete when both OSAL and std::stl is used
#if 1
#define __PLACEMENT_NEW_INLINE
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#include <com/adit/de/ALD/change_levelProxy.h>
#include <com/adit/de/ALD/level_statusProxy.h>

#include <common/framework/sysadapters/dia_SAFeatureAuthorizationLevel.h>
#include "dia_ASFComponentAuthorizationLevel.h"

using namespace com::adit::de::ALD::change_level;
using namespace com::adit::de::ALD::level_status;

#define DIA_ASF_PORT_NAME_ALD_CHANGE_LEVEL      "portALDChangeLevel" // according dia_ASFComponentAuthorizationLevel cmc file
#define DIA_ASF_PORT_NAME_ALD_LEVEL_STATUS      "portALDLevelStatus" // according dia_ASFComponentAuthorizationLevel cmc file

namespace asf {

//------------------------------------------------------------------------------

dia_ASFComponentAuthorizationLevel::dia_ASFComponentAuthorizationLevel()
{
   dia_tclFnctTrace trc("dia_ASFComponentAuthorizationLevel::dia_ASFComponentAuthorizationLevel");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
      DIA_TR_ERR("##### dia_ASFComponentAuthorizationLevel: ERROR: MASTER FACTORY NOT AVAILABLE #####");
      return;
   }

   tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("##### dia_ASFComponentAuthorizationLevel: ERROR: FAILED TO INITIALIZE DIA_EN_INITLEVEL_1 #####");
      return;
   }

   //
   // System Adapter object
   //
   //dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());

   //
   // Service Plugins
   //

   // service plugin for interface change_level
   ::boost::shared_ptr<Change_levelProxy> proxyChangeLevel = Change_levelProxy::createProxy (
         DIA_ASF_PORT_NAME_ALD_CHANGE_LEVEL, *pSystemAdapter
   );

   dia_SystemAdapterServicePluginASF<Change_levelProxy>* pSALDChangeLevelService = dia_ASFComponent::createSystemAdapterServicePlugin<Change_levelProxy> (
         "DIA_SAALDChangeLevelSrv", proxyChangeLevel, pSystemAdapter
   );

   // service plugin for interface level_status
   ::boost::shared_ptr<Level_statusProxy> proxyLevelStatus = Level_statusProxy::createProxy (
         DIA_ASF_PORT_NAME_ALD_LEVEL_STATUS, *pSystemAdapter
   );

   dia_SystemAdapterServicePluginASF<Level_statusProxy>* pSALDLevelStatusService = dia_ASFComponent::createSystemAdapterServicePlugin<Level_statusProxy> (
         "DIA_SAALDLevelStatusSrv", proxyLevelStatus, pSystemAdapter
   );

   //
   // Feature Plugins
   //

   if ( pSALDChangeLevelService && pSALDLevelStatusService )
   {
      pSALDLevelStatusService->setCondVarTimeout(20);
      pSALDLevelStatusService->setCondVarRetries(1);
      dia_SAFeatureAuthorizationLevel* pSAFeatureALD = new dia_SAFeatureAuthorizationLevel(*pSALDChangeLevelService,*pSALDLevelStatusService); //lint !e429: custodial pointer is freed service plugin
      if ( pSAFeatureALD && ( pSAFeatureALD->setup() == DIA_SUCCESS ) )
      {
         pSALDChangeLevelService->addFeature(*pSAFeatureALD);
         pSALDLevelStatusService->addFeature(*pSAFeatureALD);

         retCode = assignInterfaceAndNotifier<dia_IAuthorizationLevel,dia_IAuthorizationLevelListener,dia_IAuthorizationLevelNotifier>(pSAFeatureALD);
         if ( retCode != DIA_SUCCESS )
         {
            DIA_TR_ERR("##### dia_ASFComponentAuthorizationLevel: ERROR: FAILED TO LINK SAFEATURE TO INTERFACE (ERR=0x%08x) #####", retCode);
         }
      }

      // make lint happy
      pSAFeatureALD = 0; //lint !e423 !e438 Warning: Creation of memory leak in assignment to 'pSAFeatureALD'. --> lifetime is controlled by service plugin

   } //lint !e438 Warning: last value assigned to variable 'poMsgBuffer' not used
}

//------------------------------------------------------------------------------

dia_ASFComponentAuthorizationLevel::~dia_ASFComponentAuthorizationLevel()
{}

} // namespace asf
