/*
 * dia_ASFComponentAudioManager.cpp
 *
 *  Created on: Nov 29, 2013
 *      Author: stc2hi
 */

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif
#ifndef __INCLUDED_DIA_COMMON_APPLICATION__
#include "common/framework/application/dia_common_application.h"
#endif

#include <org/genivi/audiomanager/CommandInterfaceProxy.h>

#ifndef DIA_SAFEATUREAUDIOMANAGER_H_
#include <common/framework/sysadapters/dia_SAFeatureAudioManager.h>
#endif
#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_AUDIO__
#include "common/framework/sysadapters/dia_RemoteControlPluginAudio.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_AUDIO_MODE_CONTROL__
#include <common/framework/sysadapters/dia_SAFeatureAudioModeControl.h>
#endif
#ifndef __INCLUDED_DIA_IAUDIO_MODE_CONTROL_LISTENER__
#include <common/interfaces/dia_IAudioModeControlListener.h>
#endif

#ifndef __INCLUDED_DIA_ASF_COMPONENT_AUDIO_MANAGER__
#include "dia_ASFComponentAudioManager.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_BASE
#include "trcGenProj/Header/dia_ASFComponentAudioManager.cpp.trc.h"
#endif

using namespace org::genivi::audiomanager::CommandInterface;

namespace asf {

//------------------------------------------------------------------------------

dia_ASFComponentAudioManager::dia_ASFComponentAudioManager()
{
   dia_tclFnctTrace oTrace("--> dia_ASFComponentAudioManager::dia_ASFComponentAudioManager");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
      DIA_TR_ERR("!!! Error: Failed to get pointer to global factory !!");
      return;
   }

   tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("!!! Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
      return;
   }

   //
   // System Adapter object
   //

   // create the ASF system adapter object
  //dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
   // connect the system adapter to the given port that is bound to interface org.genivi.audiomanager.CommandInterface. see dia_ASFComponentAudioManager.cmc for port definition
   ::boost::shared_ptr<CommandInterfaceProxy> proxy = CommandInterfaceProxy::createProxy("audioManagerPort",*pSystemAdapter);

   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginASF< CommandInterfaceProxy >* pSAAudioManagerService =
         dia_ASFComponent::createSystemAdapterServicePlugin<CommandInterfaceProxy>(
            "DIA_SAAudioManagerSrv",
            proxy,
            pSystemAdapter);

   //
   // Feature Plugins
   //
   dia_SAFeatureAudioManager* pSAFeatureAudioManager =
         dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureAudioManager,CommandInterfaceProxy> (
               pSAAudioManagerService);

   if ( pSAFeatureAudioManager )
   {
      if (assignInterfaceAndNotifier<dia_IAudioSource,dia_IAudioSourceListener,dia_IAudioSourceNotifier>(pSAFeatureAudioManager) != DIA_SUCCESS)
      {
         DIA_TR_ERR("!!! dia_ASFComponentAudioManager::dia_ASFComponentAudioManager => Error: assignInterfaceAndNotifier(dia_IAudioSource) failed");
      }
   }

#ifdef __DIA_NEW_AUDIO_SOURCE_SWITCHING_FSM__
   dia::SAFeatureAudioModeControl* pSAFeatureAudioModeControl =
         dia_ASFComponent::createSystemAdapterFeature<dia::SAFeatureAudioModeControl,CommandInterfaceProxy>(pSAAudioManagerService);

   if ( pSAFeatureAudioModeControl )
   {
      if (assignInterfaceAndNotifier<dia::IAudioModeControl,dia::IAudioModeControlListener,dia::IAudioModeControlNotifier>(pSAFeatureAudioModeControl) != DIA_SUCCESS)
      {
         DIA_TR_ERR("!!! dia_ASFComponentAudioManager::dia_ASFComponentAudioManager => Error: assignInterfaceAndNotifier(dia::IAudioModeControl) failed");
      }
   }
#endif

#ifdef __ENABLE_FEATURE_REMOTE_CONTROL_INCLUDE_AUDIO_MANAGER__
   dia_RemoteControlPluginAudio* pRemoteControlPluginAudio =
           dia_ASFComponent::createSystemAdapterFeature<dia_RemoteControlPluginAudio,CommandInterfaceProxy> (
                 "SAFeatureAudioManagerRemoteControl",
                 DIA_EN_REMOTE_PLUGIN_AUDIO_MANAGER,
                 pSAAudioManagerService
           );

   if ( pRemoteControlPluginAudio )
   {
      (void) dia_RemoteControl::getInstance()->addRemoteControlPlugin(pRemoteControlPluginAudio);
   }
#endif
}

//------------------------------------------------------------------------------

dia_ASFComponentAudioManager::~dia_ASFComponentAudioManager()
{
}


//------------------------------------------------------------------------------

} //namespace asf

