///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SubsystemDiagnosisFSM.cpp
//
// Generated by SMC 4.5.5 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c dia_SubsystemDiagnosis.fsm
//   --protected_interface
//   --use_factory_method
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_SUBSYSTEMDIAGNOSISFSM__
#include "dia_SubsystemDiagnosisFSM.h"
#endif

namespace dia_SubsystemDiagnosisFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evChkPowerMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evChkRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evChkTCPSocket ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnect ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnectFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnectSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDEDTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvalRoutedReq ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvaluateActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evEvaluateDeactivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdentifyResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdentifyStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnPMResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnRAResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnRoutingDelayTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnRoutingResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPMRDelayTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPreCondChkDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRADelayTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadSubNodeRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestConnectReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestConnectValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestIdentifyReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestIdentifyValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestRouteReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestRouteValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRouteRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRouteResponseFinal ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRouteResponseWait ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActivatingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ActivatingState
   : public FsmState
{
public:
   //! default constructor
   ActivatingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evEvaluateActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ActivatingState::mStateName = "Activating";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ConnectingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ConnectingState
   : public FsmState
{
public:
   //! default constructor
   ConnectingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evChkPowerMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evChkRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evChkTCPSocket ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnectFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnectSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnPMResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnRAResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPMRDelayTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPreCondChkDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRADelayTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ConnectingState::mStateName = "Connecting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DeactivatingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DeactivatingState
   : public FsmState
{
public:
   //! default constructor
   DeactivatingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evEvaluateDeactivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DeactivatingState::mStateName = "Deactivating";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DisconnectingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DisconnectingState
   : public FsmState
{
public:
   //! default constructor
   DisconnectingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evConnect ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestConnectReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestConnectValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DisconnectingState::mStateName = "Disconnecting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdentifyingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdentifyingState
   : public FsmState
{
public:
   //! default constructor
   IdentifyingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnect ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDEDTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdentifyResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdentifyStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRouteRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdentifyingState::mStateName = "Identifying";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RoutingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RoutingState
   : public FsmState
{
public:
   //! default constructor
   RoutingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evEvalRoutedReq ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnRoutingDelayTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnRoutingResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRouteResponseFinal ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRouteResponseWait ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RoutingState::mStateName = "Routing";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SubsystemActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SubsystemActiveState
   : public FsmState
{
public:
   //! default constructor
   SubsystemActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnect ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdentifyResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdentifyStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestConnectReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestConnectValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestIdentifyReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestIdentifyValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRouteRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SubsystemActiveState::mStateName = "SubsystemActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SubsystemConnectedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SubsystemConnectedState
   : public FsmState
{
public:
   //! default constructor
   SubsystemConnectedState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnect ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdentifyStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestRouteReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestRouteValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRouteRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SubsystemConnectedState::mStateName = "SubsystemConnected";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SubsystemIdentifiedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SubsystemIdentifiedState
   : public FsmState
{
public:
   //! default constructor
   SubsystemIdentifiedState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnect ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdentifyResult ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdentifyStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadSubNodeRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestConnectReady ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestConnectValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRouteRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SubsystemIdentifiedState::mStateName = "SubsystemIdentified";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SubsystemInactiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SubsystemInactiveState
   : public FsmState
{
public:
   //! default constructor
   SubsystemInactiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SubsystemInactiveState::mStateName = "SubsystemInactive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ActivatingState oActivatingState;
    ConnectingState oConnectingState;
    DeactivatingState oDeactivatingState;
    DisconnectingState oDisconnectingState;
    IdentifyingState oIdentifyingState;
    RoutingState oRoutingState;
    SubsystemActiveState oSubsystemActiveState;
    SubsystemConnectedState oSubsystemConnectedState;
    SubsystemIdentifiedState oSubsystemIdentifiedState;
    SubsystemInactiveState oSubsystemInactiveState;
    TopLevelState oTopLevelState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evActivate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evActivate *** 
}

void
FsmState::evChkPowerMode ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evChkPowerMode *** 
}

void
FsmState::evChkRoutingActivation ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evChkRoutingActivation *** 
}

void
FsmState::evChkTCPSocket ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evChkTCPSocket *** 
}

void
FsmState::evConnect ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evConnect *** 
}

void
FsmState::evConnectFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evConnectFailed *** 
}

void
FsmState::evConnectSuccess ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evConnectSuccess *** 
}

void
FsmState::evDeactivate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDeactivate *** 
}

void
FsmState::evDEDTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDEDTimeout *** 
}

void
FsmState::evEvalRoutedReq ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evEvalRoutedReq *** 
}

void
FsmState::evEvaluateActivation ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evEvaluateActivation *** 
}

void
FsmState::evEvaluateDeactivation ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evEvaluateDeactivation *** 
}

void
FsmState::evIdentifyResult ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdentifyResult *** 
}

void
FsmState::evIdentifyStart ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdentifyStart *** 
}

void
FsmState::evOnPMResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOnPMResponse *** 
}

void
FsmState::evOnRAResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOnRAResponse *** 
}

void
FsmState::evOnRoutingDelayTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOnRoutingDelayTimeout *** 
}

void
FsmState::evOnRoutingResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOnRoutingResponse *** 
}

void
FsmState::evPMRDelayTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evPMRDelayTimeout *** 
}

void
FsmState::evPreCondChkDone ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evPreCondChkDone *** 
}

void
FsmState::evRADelayTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRADelayTimeout *** 
}

void
FsmState::evReadSubNodeRequest ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReadSubNodeRequest *** 
}

void
FsmState::evRequestConnectReady ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestConnectReady *** 
}

void
FsmState::evRequestConnectValid ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestConnectValid *** 
}

void
FsmState::evRequestIdentifyReady ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestIdentifyReady *** 
}

void
FsmState::evRequestIdentifyValid ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestIdentifyValid *** 
}

void
FsmState::evRequestRouteReady ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestRouteReady *** 
}

void
FsmState::evRequestRouteValid ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestRouteValid *** 
}

void
FsmState::evReset ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReset *** 
}

void
FsmState::evRouteRequest ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRouteRequest *** 
}

void
FsmState::evRouteResponseFinal ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRouteResponseFinal *** 
}

void
FsmState::evRouteResponseWait ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRouteResponseWait *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActivatingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ActivatingState::ActivatingState ( void )
{}

void
ActivatingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmActivateSubsystemSession(pArg);
}

void
ActivatingState::evEvaluateActivation ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsActivationComplete(pArg) )
   {
        // transition Actions
        s.sendSubsytemSessionPosResponse(pArg);
        b.setState(b.oSubsystemActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.sendSubsytemSessionNegResponse(pArg);
   b.setState(b.oSubsystemInactiveState,pArg);
    }
}

void
ActivatingState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ConnectingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ConnectingState::ConnectingState ( void )
{}

void
ConnectingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmCheckConnectPreconditions(pArg);
}

void
ConnectingState::evChkPowerMode ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsPowerModeOk(pArg) )
   {
        // transition Actions
        s.vFsmStartRADelayTimer(pArg);
        s.vFsmTriggerRAR(pArg);
        // this is an internal transition
    }
    else
    {
   // trigger events
   FsmEvent event = dia_SubsystemDiagnosisFSM::evUnknown;

   event = dia_SubsystemDiagnosisFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
    }
}

void
ConnectingState::evChkRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsRoutingActivationOk(pArg) )
   {
        // transition Actions
        s.vFsmSendReqSessionSwitch2Extended(pArg);
        // trigger events
        FsmEvent event = dia_SubsystemDiagnosisFSM::evUnknown;

        event = dia_SubsystemDiagnosisFSM::evConnectSuccess; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
    else
    {
   // trigger events
   FsmEvent event = dia_SubsystemDiagnosisFSM::evUnknown;

   event = dia_SubsystemDiagnosisFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
    }
}

void
ConnectingState::evChkTCPSocket ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsTCPSocketOk(pArg) )
   {
        // transition Actions
        s.vFsmStartPMRDelayTimer(pArg);
        s.vFsmTriggerPMR(pArg);
        // this is an internal transition
    }
    else
    {
   // trigger events
   FsmEvent event = dia_SubsystemDiagnosisFSM::evUnknown;

   event = dia_SubsystemDiagnosisFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
    }
}

void
ConnectingState::evConnectFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsystemConnectNegResponse(pArg);
   b.setState(b.oSubsystemIdentifiedState,pArg);
}

void
ConnectingState::evConnectSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsystemConnectPosResponse(pArg);
   b.setState(b.oSubsystemConnectedState,pArg);
}

void
ConnectingState::evOnPMResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmStopPMRDelayTimer(pArg);
   s.vFsmTriggerESR(pArg);
   // trigger events
   FsmEvent event = dia_SubsystemDiagnosisFSM::evUnknown;

   event = dia_SubsystemDiagnosisFSM::evChkPowerMode; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ConnectingState::evOnRAResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmStopRADelayTimer(pArg);
   // trigger events
   FsmEvent event = dia_SubsystemDiagnosisFSM::evUnknown;

   event = dia_SubsystemDiagnosisFSM::evChkRoutingActivation; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ConnectingState::evPMRDelayTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmOnPMRTimeout(pArg);
   // trigger events
   FsmEvent event = dia_SubsystemDiagnosisFSM::evUnknown;

   event = dia_SubsystemDiagnosisFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ConnectingState::evPreCondChkDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsPreCondChkOk(pArg) )
   {
        // transition Actions
        s.vFsmCreateTCPSocketandConnect(pArg);
        // trigger events
        FsmEvent event = dia_SubsystemDiagnosisFSM::evUnknown;

        event = dia_SubsystemDiagnosisFSM::evChkTCPSocket; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    } 
    else if ( s.bIsEntityListEmpty(pArg) )
   {
        // transition Actions
        s.sendSubsystemConnectNegResponse(pArg);
        b.setState(b.oSubsystemActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.sendSubsystemConnectNegResponse(pArg);
   b.setState(b.oSubsystemIdentifiedState,pArg);
    }
}

void
ConnectingState::evRADelayTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmOnRATimeout(pArg);
   // trigger events
   FsmEvent event = dia_SubsystemDiagnosisFSM::evUnknown;

   event = dia_SubsystemDiagnosisFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ConnectingState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DeactivatingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DeactivatingState::DeactivatingState ( void )
{}

void
DeactivatingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmDeactivateSubsystemSession(pArg);
}

void
DeactivatingState::evEvaluateDeactivation ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsDeactivationComplete(pArg) )
   {
        // transition Actions
        s.vFsmOnSessionDeactivated(pArg);
        b.setState(b.oSubsystemInactiveState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmDeactivationFailed(pArg);
   b.setState(b.oSubsystemInactiveState,pArg);
    }
}

void
DeactivatingState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DisconnectingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DisconnectingState::DisconnectingState ( void )
{}

void
DisconnectingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmDisconnect(pArg);
}

void
DisconnectingState::evConnect ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateConnectRequest(pArg);
   // this is an internal transition
}

void
DisconnectingState::evRequestConnectReady ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oConnectingState,pArg);
}

void
DisconnectingState::evRequestConnectValid ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.areConnectConditionsOk(pArg) )
   {
        // transition Actions
        s.preprocessConnect(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendSubsystemConnectNegResponse(pArg);
   // this is an internal transition
    }
}

void
DisconnectingState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdentifyingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdentifyingState::IdentifyingState ( void )
{}

void
IdentifyingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartDEDelayTimer(pArg);
   s.vFsmDiscoverEntities(pArg);
}

void
IdentifyingState::evActivate ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsytemSessionPosResponse(pArg);
   // this is an internal transition
}

void
IdentifyingState::evConnect ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsystemConnectNegResponse(pArg);
   // this is an internal transition
}

void
IdentifyingState::evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmStopDEDelayTimer(pArg);
   b.setState(b.oDeactivatingState,pArg);
}

void
IdentifyingState::evDEDTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsEntityListEmpty(pArg) )
   {
        b.setState(b.oSubsystemActiveState,pArg);
    }
    else
    {
   b.setState(b.oSubsystemIdentifiedState,pArg);
    }
}

void
IdentifyingState::evIdentifyResult ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendIdentifyResultRunningResponse(pArg);
   // this is an internal transition
}

void
IdentifyingState::evIdentifyStart ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendIdentifyStartRunningResponse(pArg);
   // this is an internal transition
}

void
IdentifyingState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

void
IdentifyingState::evRouteRequest ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsystemRoutingNegResponse(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RoutingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RoutingState::RoutingState ( void )
{}

void
RoutingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartSubsystemRoutingDelayTimer(pArg);
   s.vFsmRouteRcvdRequest(pArg);
}

void
RoutingState::evEvalRoutedReq ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsRequestRouted(pArg) )
   {
        // transition Actions
        s.vFsmOnRequestRoutingDone(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendSubsystemRoutingNegResponse(pArg);
   b.setState(b.oSubsystemConnectedState,pArg);
    }
}

void
RoutingState::evOnRoutingDelayTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsystemRoutingNegResponse(pArg);
   b.setState(b.oSubsystemConnectedState,pArg);
}

void
RoutingState::evOnRoutingResponse ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateRouteResponse(pArg);
   // this is an internal transition
}

void
RoutingState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

void
RoutingState::evRouteResponseFinal ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmStopSubsystemRoutingDelayTimer(pArg);
   s.vFsmRouteRcvdResponse(pArg);
   s.postprocessRoute(pArg);
   b.setState(b.oSubsystemConnectedState,pArg);
}

void
RoutingState::evRouteResponseWait ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmOnSubsystemWaitResponse(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SubsystemActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SubsystemActiveState::SubsystemActiveState ( void )
{}

void
SubsystemActiveState::evActivate ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsytemSessionPosResponse(pArg);
   // this is an internal transition
}

void
SubsystemActiveState::evConnect ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateConnectRequest(pArg);
   // this is an internal transition
}

void
SubsystemActiveState::evDeactivate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDeactivatingState,pArg);
}

void
SubsystemActiveState::evIdentifyResult ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendIdentifyResultNokResponse(pArg);
   // this is an internal transition
}

void
SubsystemActiveState::evIdentifyStart ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateIdentifyRequest(pArg);
   // this is an internal transition
}

void
SubsystemActiveState::evRequestConnectReady ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oConnectingState,pArg);
}

void
SubsystemActiveState::evRequestConnectValid ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.areConnectConditionsOk(pArg) )
   {
        // transition Actions
        s.preprocessConnect(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendSubsystemConnectNegResponse(pArg);
   // this is an internal transition
    }
}

void
SubsystemActiveState::evRequestIdentifyReady ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdentifyingState,pArg);
}

void
SubsystemActiveState::evRequestIdentifyValid ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.areIdentifyConditionsOk(pArg) )
   {
        // transition Actions
        s.preprocessIdentify(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendIdentifyStartNokResponse(pArg);
   // this is an internal transition
    }
}

void
SubsystemActiveState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

void
SubsystemActiveState::evRouteRequest ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsystemRoutingNegResponse(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SubsystemConnectedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SubsystemConnectedState::SubsystemConnectedState ( void )
{}

void
SubsystemConnectedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.postprocessConnect(pArg);
}

void
SubsystemConnectedState::evActivate ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsytemSessionPosResponse(pArg);
   // this is an internal transition
}

void
SubsystemConnectedState::evConnect ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsEntityAlreadyConnected(pArg) )
   {
        // transition Actions
        s.sendSubsystemConnectPosResponse(pArg);
        // this is an internal transition
    }
    else
    {
   b.setState(b.oDisconnectingState,pArg);
    }
}

void
SubsystemConnectedState::evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.prepareDeactivate(pArg);
   b.setState(b.oDeactivatingState,pArg);
}

void
SubsystemConnectedState::evIdentifyStart ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vfsmCloseCurrentConnectiontoNode(pArg);
   b.setState(b.oIdentifyingState,pArg);
}

void
SubsystemConnectedState::evRequestRouteReady ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oRoutingState,pArg);
}

void
SubsystemConnectedState::evRequestRouteValid ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.areRouteConditionsOk(pArg) )
   {
        // transition Actions
        s.preprocessRoute(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendSubsystemConnectNegResponse(pArg);
   // this is an internal transition
    }
}

void
SubsystemConnectedState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

void
SubsystemConnectedState::evRouteRequest ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateRouteRequest(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SubsystemIdentifiedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SubsystemIdentifiedState::SubsystemIdentifiedState ( void )
{}

void
SubsystemIdentifiedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.postprocessIdentify(pArg);
}

void
SubsystemIdentifiedState::evActivate ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsytemSessionPosResponse(pArg);
   // this is an internal transition
}

void
SubsystemIdentifiedState::evConnect ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateConnectRequest(pArg);
   // this is an internal transition
}

void
SubsystemIdentifiedState::evDeactivate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDeactivatingState,pArg);
}

void
SubsystemIdentifiedState::evIdentifyResult ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendIdentifyResultOkResponse(pArg);
   // this is an internal transition
}

void
SubsystemIdentifiedState::evIdentifyStart ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdentifyingState,pArg);
}

void
SubsystemIdentifiedState::evReadSubNodeRequest ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubNodeListResponse(pArg);
   // this is an internal transition
}

void
SubsystemIdentifiedState::evRequestConnectReady ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oConnectingState,pArg);
}

void
SubsystemIdentifiedState::evRequestConnectValid ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.areConnectConditionsOk(pArg) )
   {
        // transition Actions
        s.preprocessConnect(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendSubsystemConnectNegResponse(pArg);
   // this is an internal transition
    }
}

void
SubsystemIdentifiedState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

void
SubsystemIdentifiedState::evRouteRequest ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendSubsystemRoutingNegResponse(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SubsystemInactiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SubsystemInactiveState::SubsystemInactiveState ( void )
{}

void
SubsystemInactiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReset(pArg);
}

void
SubsystemInactiveState::evActivate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oActivatingState,pArg);
}

void
SubsystemInactiveState::evDeactivate ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDeactivatingState,pArg);
}

void
SubsystemInactiveState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

void
TopLevelState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSubsystemInactiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oActivatingState.initState(&oTopLevelState);
    oConnectingState.initState(&oTopLevelState);
    oDeactivatingState.initState(&oTopLevelState);
    oDisconnectingState.initState(&oTopLevelState);
    oIdentifyingState.initState(&oTopLevelState);
    oRoutingState.initState(&oTopLevelState);
    oSubsystemActiveState.initState(&oTopLevelState);
    oSubsystemConnectedState.initState(&oTopLevelState);
    oSubsystemIdentifiedState.initState(&oTopLevelState);
    oSubsystemInactiveState.initState(&oTopLevelState);
    oTopLevelState.initSuperState(0, &oSubsystemInactiveState, false);

    setState(oTopLevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evActivate:
            if ( mpState ) mpState->evActivate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evChkPowerMode:
            if ( mpState ) mpState->evChkPowerMode(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evChkRoutingActivation:
            if ( mpState ) mpState->evChkRoutingActivation(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evChkTCPSocket:
            if ( mpState ) mpState->evChkTCPSocket(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evConnect:
            if ( mpState ) mpState->evConnect(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evConnectFailed:
            if ( mpState ) mpState->evConnectFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evConnectSuccess:
            if ( mpState ) mpState->evConnectSuccess(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDeactivate:
            if ( mpState ) mpState->evDeactivate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDEDTimeout:
            if ( mpState ) mpState->evDEDTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evEvalRoutedReq:
            if ( mpState ) mpState->evEvalRoutedReq(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evEvaluateActivation:
            if ( mpState ) mpState->evEvaluateActivation(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evEvaluateDeactivation:
            if ( mpState ) mpState->evEvaluateDeactivation(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdentifyResult:
            if ( mpState ) mpState->evIdentifyResult(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdentifyStart:
            if ( mpState ) mpState->evIdentifyStart(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOnPMResponse:
            if ( mpState ) mpState->evOnPMResponse(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOnRAResponse:
            if ( mpState ) mpState->evOnRAResponse(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOnRoutingDelayTimeout:
            if ( mpState ) mpState->evOnRoutingDelayTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOnRoutingResponse:
            if ( mpState ) mpState->evOnRoutingResponse(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evPMRDelayTimeout:
            if ( mpState ) mpState->evPMRDelayTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evPreCondChkDone:
            if ( mpState ) mpState->evPreCondChkDone(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRADelayTimeout:
            if ( mpState ) mpState->evRADelayTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReadSubNodeRequest:
            if ( mpState ) mpState->evReadSubNodeRequest(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestConnectReady:
            if ( mpState ) mpState->evRequestConnectReady(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestConnectValid:
            if ( mpState ) mpState->evRequestConnectValid(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestIdentifyReady:
            if ( mpState ) mpState->evRequestIdentifyReady(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestIdentifyValid:
            if ( mpState ) mpState->evRequestIdentifyValid(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestRouteReady:
            if ( mpState ) mpState->evRequestRouteReady(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestRouteValid:
            if ( mpState ) mpState->evRequestRouteValid(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReset:
            if ( mpState ) mpState->evReset(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRouteRequest:
            if ( mpState ) mpState->evRouteRequest(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRouteResponseFinal:
            if ( mpState ) mpState->evRouteResponseFinal(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRouteResponseWait:
            if ( mpState ) mpState->evRouteResponseWait(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evActivate",
      "evChkPowerMode",
      "evChkRoutingActivation",
      "evChkTCPSocket",
      "evConnect",
      "evConnectFailed",
      "evConnectSuccess",
      "evDeactivate",
      "evDEDTimeout",
      "evEvalRoutedReq",
      "evEvaluateActivation",
      "evEvaluateDeactivation",
      "evIdentifyResult",
      "evIdentifyStart",
      "evOnPMResponse",
      "evOnRAResponse",
      "evOnRoutingDelayTimeout",
      "evOnRoutingResponse",
      "evPMRDelayTimeout",
      "evPreCondChkDone",
      "evRADelayTimeout",
      "evReadSubNodeRequest",
      "evRequestConnectReady",
      "evRequestConnectValid",
      "evRequestIdentifyReady",
      "evRequestIdentifyValid",
      "evRequestRouteReady",
      "evRequestRouteValid",
      "evReset",
      "evRouteRequest",
      "evRouteResponseFinal",
      "evRouteResponseWait",
   };

   return eventNames[event];
}


} // namespace
