#ifndef __INCLUDED_FACTORY_PLUGIN_SYSTEM_SETTINGS__
#include "dia_FactoryPluginSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_CONFIGURATION__
#include <common/framework/sysset/dia_SystemSettingsConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MODULE__
#include <common/framework/sysset/dia_SystemSettingsModule.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_PLUGIN__
#include <common/framework/sysset/dia_SystemSettingsPlugin.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEMSETTINGS__
#include <common/interfaces/dia_ISystemSettings.h>
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_DEFAULT_CONFIGURATION__
#include "project/framework/config/dia_DefaultConfiguration.cpp"
#endif

#include "common/framework/sysset/dia_SystemSetPluginPM.h"
#include "project/framework/sysset/dia_SystemSetPluginDefaultConfigCustomer.h"
#include "project/framework/sysset/dia_SystemSetPluginLockDevice.h"
#include "common/framework/sysset/dia_SystemSetPluginFileDeletion.h"

#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
#ifndef __INCLUDED_DIA_SYSTEMSET_PLUGIN_DEFAULT_CONFIG_VIN__
#include "project/framework/sysset/dia_SystemSetPluginDefaultConfigVin.h"
#endif
#endif

#ifndef __INCLUDED_DIA_SYSTEMSET_PLUGIN_DEFAULT_CONFIG_HISTORICAL_INTERROGATION_REC__
#include "project/framework/sysset/dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec.h"
#endif

static const dia_SystemSettingTypeInfo arDefaultSystemSettingTypes[] = {
//       name                                       UID                 isSpecific
      { "DIA_SYSSET_TYPE_UNKNOWN",						0,                  true  },
      { DIA_C_STR_SYSTEM_SETTING_TYPE_PRODUCTION,	DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION, false },
      { "DIA_SYSSET_TYPE_CUSTOMER",						0,                  false },
      { DIA_C_STR_SYSTEM_SETTING_TYPE_ALIGNMENT,	DIA_C_UID_SYSTEM_SETTING_TYPE_ALIGNMENT,  false },
      { "DIA_SYSSET_TYPE_CALIBRATION",					0,                  false },
      { "DIA_SYSSET_TYPE_USER_PROFILE",					0,                  false },
      { "DIA_SYSSET_TYPE_LANGUAGE",						0,                  false },
      { "DIA_SYSSET_TYPE_UNITS",						0,                  false },
      { DIA_C_STR_SYSTEM_SETTING_TYPE_HMI,			DIA_C_UID_SYSTEM_SETTING_TYPE_HMI,        false },
      { "DIA_SYSSET_TYPE_HMI_NAVIGATION",				0,                  true  },
      { "DIA_SYSSET_TYPE_HMI_TUNER",					0,                  true  },
      { "DIA_SYSSET_TYPE_HMI_SYSTEM",					0,                  true  },
      { "DIA_SYSSET_TYPE_HMI_AUDIO",					0,                  true  },
      { "DIA_SYSSET_TYPE_HMI_MEDIA",					0,                  true  },
      { "DIA_SYSSET_TYPE_CLEAR_MCAN_HISTORIES",			0,                  true  },
      { "DIA_SYSSET_TYPE_SELF_DIAGNOSIS",				0,                  true  },
      { "DIA_SYSSET_TYPE_DIAGNOSTICS_INTERNAL",     DIA_C_UID_SYSTEM_SETTING_TYPE_DIAGNOSTICS_INTERNAL,  true  }
};

static const dia_SystemSetPluginFileDeletionTEF arNames[] =
{
	{"/var/opt/bosch/dynamic/connectivity/bt_module/rta_enable"}
};
// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginSystemSettings)

//-----------------------------------------------------------------------------

dia_FactoryPluginSystemSettings::dia_FactoryPluginSystemSettings ( tVoid )
   : dia_FactoryPlugin("dia_FactoryPluginSystemSettings",DIA_EN_FACTORY_PLUGIN_TYPE_SYSTEM_SETTINGS),
     mpManager(0)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginSystemSettings::~dia_FactoryPluginSystemSettings ( tVoid )
{
   mpManager = 0;
}

//-----------------------------------------------------------------------------

#define ADD_SYSTEMSET_PLUGIN(className) \
   { \
      className* pSysSetPlugin = OSAL_NEW className; \
      if ( pSysSetPlugin ) { \
         (tVoid) mpManager->addSystemSettingsPlugin(*pSysSetPlugin); \
         mSystemSetPluginRep.push_back(pSysSetPlugin); \
      } \
   }

//-----------------------------------------------------------------------------

#define ADD_SYSTEMSET_PLUGIN_WITH_PARAM(className, param) \
   { \
      className* pSysSetPlugin = OSAL_NEW className(param); \
      if ( pSysSetPlugin ) { \
         (tVoid) mpManager->addSystemSettingsPlugin(*pSysSetPlugin); \
         mSystemSetPluginRep.push_back(pSysSetPlugin); \
      } \
   }

//-----------------------------------------------------------------------------

#define ADD_SYSTEMSET_PLUGIN_LOAD_DELIVERY(className,data) \
   { \
      className* pSysSetPlugin = OSAL_NEW className; \
      if ( pSysSetPlugin ) \
      { \
         (tVoid) mpManager->addSystemSettingsPlugin(*pSysSetPlugin); \
         mSystemSetPluginRep.push_back(pSysSetPlugin); \
         pSysSetPlugin->loadConfigInfo(data, sizeof(data)/sizeof(dia_ConfigToDeliveryInfo)); \
      } \
   }

//-----------------------------------------------------------------------------
#define ADD_SYSTEMSET_PLUGIN_ADD_FILES(className,data) \
   { \
      className* pSysSetPlugin = OSAL_NEW className; \
      if ( pSysSetPlugin ) { \
         (tVoid) mpManager->addSystemSettingsPlugin(*pSysSetPlugin); \
         pSysSetPlugin->addFile(data, sizeof(data)/sizeof(tCString)); \
      } \
   }
tDiaResult
dia_FactoryPluginSystemSettings::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF SYSTEMSETTINGS FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   tDiaResult retCode = DIA_SUCCESS;

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      mpManager = getInstanceOfSystemSettingsManager();
   }

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      if ( mpManager )
      {
         dia_SystemSettingsConfiguration* pSysSetConfig = mpManager->getConfiguration();
         if ( pSysSetConfig )
         {
            // Adaption for timeouts
            tU32 arPrepTimeout[] = { 30000, 10000 };
            tU32 arExecTimeout[] = { 45000, 10000 };
            tU32 arFinalTimeout[] = {4000};
            (void) pSysSetConfig->loadTimeoutValues(DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE, arPrepTimeout, 2);
            (void) pSysSetConfig->loadTimeoutValues(DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE, arExecTimeout, 2);
            (void) pSysSetConfig->loadTimeoutValues(DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE, arFinalTimeout, 1);

            // assign system setting types
            (void) pSysSetConfig->resetSystemSettingTypeInformation();
            retCode = pSysSetConfig->loadSystemSettingTypeInformation(arDefaultSystemSettingTypes,
                  (tU16) (sizeof(arDefaultSystemSettingTypes)/sizeof(dia_SystemSettingTypeInfo)));
            if ( retCode != DIA_SUCCESS )
            {
               DIA_TR_ERR("##### FAILED TO LOAD SYSTEM SETTING TYPES #####");
            }
         }

         (void) getInstanceOfFactory()->assignInterfaceImplementation<dia_ISystemSettings>(mpManager);

         DIA_TR_INF("###############################################");
         DIA_TR_INF("# ADDING SYSTEM SETTINGS RELATED OBJECTS");
         DIA_TR_INF("###############################################");

         ADD_SYSTEMSET_PLUGIN(dia_SystemSetPluginDefaultConfigCustomer) //lint !e429: custodial pointer is freed by manager class(Center CM-C 19:Plugin disabled for Project specific requirements.)
         ADD_SYSTEMSET_PLUGIN_WITH_PARAM(dia_SystemSetPluginPM, 20000)     //lint !e429: custodial pointer is freed by manager class
         ADD_SYSTEMSET_PLUGIN(dia_SystemSetPluginLockDevice)            //lint !e429: custodial pointer is freed by manager class
         ADD_SYSTEMSET_PLUGIN_ADD_FILES(dia_SystemSetPluginFileDeletion,arNames)			//lint !e429: custodial pointer is freed by manager class
#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
         ADD_SYSTEMSET_PLUGIN(dia_SystemSetPluginDefaultConfigVin)
#endif
         ADD_SYSTEMSET_PLUGIN(dia_SystemSetPluginDefaultConfigHistorical_InterrogationRec)
      }
      else
      {
         DIA_TR_ERR("##### FAILED TO INITIALIZE LEVEL 2 #####");
      }
   }

   if ( retCode == DIA_SUCCESS )
   {
      setInitializationLevel(level);
      DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginSystemSettings::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemAdapters::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy all system setting plugins
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_SystemSettingsPlugin,mSystemSetPluginRep)
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy the routine control manager object
      releaseInstanceOfSystemSettingsManager();
      mpManager = 0;
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

