#ifndef __INCLUDED_DIA_FACTORY_SYSTEM_ADAPTERS__
#define __INCLUDED_DIA_FACTORY_SYSTEM_ADAPTERS__

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include "common/framework/factory/dia_FactoryPlugin.h"
#endif

/* Add here because needed by many FactoryObjects */
static const tU16 CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION = 1;
static const tU16 CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION = 0;

class dia_SystemAdapter;

class dia_FactoryPluginSystemAdapters
   : public dia_FactoryPlugin
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_FactoryPluginSystemAdapters);

public:
   //! setup (create objects,...)
   virtual tDiaResult setup ( dia_enInitLevel level );
   //! tear down (destroy objects,...)
   virtual tDiaResult tearDown ( dia_enInitLevel level ); // { return tearDownObjects(level); }

   dia_SystemAdapter* createSystemAdapter ( tCString name, tU16 clientAppID ) const;
   dia_SystemAdapterServicePlugin* createSystemAdapterServicePlugin ( tCString name, tU16 srvID, tU16 srvMajVersion, tU16 srvMinVersion, dia_SystemAdapter* adapter ) const;
   dia_SystemAdapterServicePlugin* createSystemAdapterServicePluginNoMonitoring ( tCString name, tU16 srvID, tU16 srvMajVersion, tU16 srvMinVersion, dia_SystemAdapter* adapter ) const;
   dia_SystemAdapterServicePluginDiaglib* createSystemAdapterServicePluginDiaglib ( tCString name, tU16 srvMajVersion, tU16 srvMinVersion, dia_SystemAdapter* adapter ) const;
   template<class _T> _T* createSystemAdapterFeature ( tCString name, dia_SystemAdapterServicePlugin* pSrvPlugin );
   template<class _T> _T* createSystemAdapterFeatureDiaglib ( tCString name, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin );
   template<class _T> _T* createSystemAdapterSysSetFeature ( tCString name, tU32 sysSetId, tU32 sysSetTypes, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin );
   template<class _T> _T* createSystemAdapterSysSetFeature ( tCString name, tU32 sysSetId, tU32 sysSetTypes, dia_SystemAdapterServicePlugin* pSrvPlugin );
   template<class _T> _T* createSystemAdapterDefSetFeature ( tCString name, tU32 sysSetId, tU32 sysSetTypes, dia_SystemAdapterServicePlugin* pSrvPlugin, tU8 defsetGroup, tU16 methFID, tU16 propFID=0xFFFF );
   template<class _T> _T* createSystemAdapterIOControlFeature ( tCString name, dia_SystemAdapterServicePlugin* pSrvPlugin );
   template<class _T> _T* createSystemAdapterRemoteControlFeature ( tCString name, dia_eRemoteControlPluginType id, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin ); // obsolete, do not use anymore
   template<class _T> _T* createSystemAdapterRemoteControlFeature ( tCString name, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin );
   template<class _T> _T* createSystemAdapterConfigUpdateFeature ( tCString name, tU32 propID, tU32 sysSetId, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin );

protected:
   //! class constructor
   dia_FactoryPluginSystemAdapters ( void )
      : dia_FactoryPlugin("dia_FactoryPluginSystemAdapters",DIA_EN_FACTORY_PLUGIN_TYPE_SYSTEM_ADAPTERS)
   {}

   //! class destructor
   virtual ~dia_FactoryPluginSystemAdapters ( void ) {}
//      (void) tearDownObjects();
//   }

   //! tear down all objects created by this class
//   tDiaResult tearDownObjects ( dia_enInitLevel level=DIA_EN_INITLEVEL_ALL );

protected:
   //! list of routine control objects
// std::list<dia_SystemAdapter*> mSystemAdapterRep;

private:
   class InstanceElementBase {
   public:
      virtual ~InstanceElementBase() {};
      virtual void createInstance()=0;
      virtual void deleteInstance()=0;
   };

   template<class SA>
   class InstanceElement: public InstanceElementBase {
   public:
      virtual void createInstance() {
         (void)SA::createObject();
      }
      virtual void deleteInstance() {
         (void)SA::destroyObject();
      }
   };

   class InstanceList {
   public:
      ~InstanceList() {
         for (std::list<InstanceElementBase*>::reverse_iterator iter=mRepo.rbegin(); iter!=mRepo.rend(); ++iter) {
            delete (*iter);
         }
         mRepo.clear();
         
      }
      template<class SA>
      void registerInstance() {
         mRepo.push_back(new InstanceElement<SA>);
      }
      void createAll() {
         for (std::list<InstanceElementBase*>::iterator iter=mRepo.begin(); iter!=mRepo.end(); ++iter) {
            (*iter)->createInstance();
         }
      }

      void destroyAll() {
         for (std::list<InstanceElementBase*>::reverse_iterator iter=mRepo.rbegin(); iter!=mRepo.rend(); ++iter) {
            (*iter)->deleteInstance();
         }
      }
      
   private:
      std::list<InstanceElementBase*> mRepo;

   }; 

   InstanceList mInstanceList;
};

//------------------------------------------------------------------------------

template<class _T>
_T*
dia_FactoryPluginSystemAdapters::createSystemAdapterFeature ( tCString name, dia_SystemAdapterServicePlugin* pSrvPlugin )
{
   _T* pFeature = 0;

   if ( pSrvPlugin )
   {
      pFeature = OSAL_NEW _T(name,*pSrvPlugin);
      if ( pFeature )
      {
         pSrvPlugin->addFeature(*pFeature);
      }
   }

   return pFeature;
}

//------------------------------------------------------------------------------

template<class _T>
_T*
dia_FactoryPluginSystemAdapters::createSystemAdapterFeatureDiaglib ( tCString name, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin )
{
   _T* pFeature = 0;

   if ( pSrvPlugin )
   {
      pFeature = OSAL_NEW _T(name,*pSrvPlugin);
      if ( pFeature )
      {
         pSrvPlugin->addFeature(*pFeature);
      }
   }

   return pFeature;
}

//------------------------------------------------------------------------------

template<class _T>
_T*
dia_FactoryPluginSystemAdapters::createSystemAdapterSysSetFeature ( tCString name, tU32 sysSetId, tU32 sysSetTypes, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin )
{
   _T* pFeature = 0;

   if ( pSrvPlugin )
   {
      pFeature = OSAL_NEW _T(name,sysSetId,sysSetTypes,*pSrvPlugin);
      if ( pFeature )
      {
         pSrvPlugin->addFeature(*pFeature);
      }
   }

   return pFeature;
}

//------------------------------------------------------------------------------

template<class _T>
_T*
dia_FactoryPluginSystemAdapters::createSystemAdapterSysSetFeature (
      tCString name,
      tU32 sysSetId,
      tU32 sysSetTypes,
      dia_SystemAdapterServicePlugin* pSrvPlugin
   )
{
   _T* pFeature = 0;

   if ( pSrvPlugin )
   {
      pFeature = OSAL_NEW _T(name,sysSetId,sysSetTypes,*pSrvPlugin);
      if ( pFeature )
      {
         pSrvPlugin->addFeature(*pFeature);
      }
   }

   return pFeature;
}

//------------------------------------------------------------------------------

template<class _T>
_T*
dia_FactoryPluginSystemAdapters::createSystemAdapterDefSetFeature (
      tCString name,
      tU32 sysSetId,
      tU32 sysSetTypes,
      dia_SystemAdapterServicePlugin* pSrvPlugin,
      tU8  defsetGroup,
      tU16 methFID,
      tU16 propFID
   )
{
   _T* pFeature = 0;

   if ( pSrvPlugin )
   {
      pFeature = OSAL_NEW _T(name,sysSetId,sysSetTypes,*pSrvPlugin,defsetGroup,methFID,propFID);
      if ( pFeature )
      {
         pSrvPlugin->addFeature(*pFeature);
      }
   }

   return pFeature;
}

//------------------------------------------------------------------------------

template<class _T>
_T*
dia_FactoryPluginSystemAdapters::createSystemAdapterIOControlFeature ( tCString name, dia_SystemAdapterServicePlugin* pSrvPlugin )
{
   _T* pFeature = 0;

   if ( pSrvPlugin )
   {
      pFeature = OSAL_NEW _T(name, *pSrvPlugin);
      if ( pFeature )
      {
         pSrvPlugin->addFeature(*pFeature);
      }
   }

   return pFeature;
}

//------------------------------------------------------------------------------

template<class _T>
_T*
dia_FactoryPluginSystemAdapters::createSystemAdapterRemoteControlFeature ( tCString name, dia_eRemoteControlPluginType /*id*/, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin )
{
   _T* pFeature = 0;

   if ( pSrvPlugin )
   {
      pFeature = OSAL_NEW _T(name,*pSrvPlugin);
      if ( pFeature )
      {
         pSrvPlugin->addFeature(*pFeature);
      }
   }

   return pFeature;
}

//------------------------------------------------------------------------------

template<class _T>
_T*
dia_FactoryPluginSystemAdapters::createSystemAdapterRemoteControlFeature ( tCString name, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin )
{
   _T* pFeature = 0;

   if ( pSrvPlugin )
   {
      pFeature = OSAL_NEW _T(name,*pSrvPlugin);
      if ( pFeature )
      {
         pSrvPlugin->addFeature(*pFeature);
      }
   }

   return pFeature;
}

//------------------------------------------------------------------------------

template<class _T>
_T*
dia_FactoryPluginSystemAdapters::createSystemAdapterConfigUpdateFeature ( tCString name, tU32 propID, tU32 sysSetId, dia_SystemAdapterServicePluginDiaglib* pSrvPlugin )
{
   _T* pFeature = 0;

   if ( pSrvPlugin )
   {
      pFeature = OSAL_NEW _T(name,propID,sysSetId,*pSrvPlugin);
      if ( pFeature )
      {
         pSrvPlugin->addFeature(*pFeature);
      }
   }

   return pFeature;
}


#endif
