#ifndef __INCLUDED_PROJECT_FACTORY__
#include "dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER__
#include <common/framework/sysadapters/dia_SystemAdapter.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_SYSTEM_ADAPTERS__
#include "dia_FactoryPluginSystemAdapters.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_AUDIOCOMPRESSED__
#include "dia_FactoryObjectSAAudioCompressed.h"
#endif

#if 0 //STC2HI: TODO

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_AUDIOPLAYERCD__
#include "dia_FactoryObjectSAAudioPlayerCD.h"
#endif

#endif //STC2HI: TODO

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_BLUETOOTH__
#include "dia_FactoryObjectSABluetooth.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_PHONE__
#include "dia_FactoryObjectSAPhone.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_PHONE_BOOK__
#include "dia_FactoryObjectSAPhoneBook.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_MESSAGING__
#include "dia_FactoryObjectSAMessaging.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_AUDIO__
#include "dia_FactoryObjectSAAudio.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_AUX__
#include "dia_FactoryObjectSAAux.h"
#endif


#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_CLOCK__
#include "dia_FactoryObjectSAClock.h"
#endif
#if 0 //STC2HI: TODO

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_DOWNLOAD__
#include "dia_FactoryObjectSADownload.h"
#endif

#endif //STC2HI: TODO

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_DIMMING__
#include "dia_FactoryObjectSADimming.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_ERROR_LOG__
#include "dia_FactoryObjectSAErrorLog.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_HEATCONTROL__
#include "dia_FactoryObjectSAHeatControl.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_IPOD__
#include "dia_FactoryObjectSAIPOD.h"
#endif

#if 0 //STC2HI: TODO

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_KEYBOARD__
#include "dia_FactoryObjectSAKeyboard.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_NAVIGATION__
#include "dia_FactoryObjectSANavigation.h"
#endif

#endif //STC2HI: TODO

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_SENSOR__
#include "dia_FactoryObjectSASensor.h"
#endif


#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_PARK_ASSIST__
#include "dia_FactoryObjectSAParkAssist.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_SPM__
#include "dia_FactoryObjectSASPM.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TUNER_AMFM__
#include "dia_FactoryObjectSATunerAMFM.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TUNER_DAB__
#include "dia_FactoryObjectSATunerDAB.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TUNER_MASTER__
#include "dia_FactoryObjectSATunerMaster.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_VDDEVICEMGR__
#include "dia_FactoryObjectSAVDDeviceMGR.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_VEHICLEDATA__
#include "dia_FactoryObjectSAVehicleData.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_METER__
#include "dia_FactoryObjectSAMeter.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_INPUTHANLING__
#include "dia_FactoryObjectSAInputHandling.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TUNER_XM__
#include "dia_FactoryObjectSATunerXM.h"
#endif

#ifndef DIA_SAFEATURERVC_H_
#include "dia_FactoryObjectSARVC.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   // Include SystemAdapter Factories only for Scope2

   #ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_SWITCHCTRL__
   #include "dia_FactoryObjectSASwitchCtrl.h"
   #endif

   #ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TCU__
   #include "dia_FactoryObjectSATCU.h"
   #endif

   #ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_VDMMGR__
   #include "dia_FactoryObjectSAVDMMGR.h"
   #endif
#endif

#ifndef DIA_FACTORYOBJECTSASPI_H_
#include "dia_FactoryObjectSASPI.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_DIAGNOSIS_SERVICE__
#include "dia_FactoryObjectSADiagnosisService.h"
#endif
#define VARIANT_CODING_PROP_LEN 32
#define TUNER_BITS ((tU8)0x30)
#define TUNER_XM  ((tU8)0x10)
#define TUNER_DAB ((tU8)0x20)

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginSystemAdapters)

//------------------------------------------------------------------------------

class dia_SystemAdapterServicePluginNoMonitoring
   : public dia_SystemAdapterServicePlugin
{
public:
   //! default constructor
   dia_SystemAdapterServicePluginNoMonitoring (
         tCString name,        // name used to create name for lock and condvar object
         tU16 srvID,           // service of the client we are using
         tU16 srvMajVersion,   // major version number of the diaglib service we are using
         tU16 srvMinVersion,   // minor version number of the diaglib service we are using
         dia_SystemAdapter& adapter)
      : dia_SystemAdapterServicePlugin(name, srvID, srvMajVersion, srvMinVersion, adapter)
   {}

   virtual tBool bOnServiceStateAvailable ( tU16 /*u16SrvID*/, tU16 /*u16SubId*/ ) { return TRUE; }
};

//------------------------------------------------------------------------------

class dia_SystemAdapterServicePluginDiaglibPrj
   : public dia_SystemAdapterServicePluginDiaglib
{
public:
   //! default constructor
   dia_SystemAdapterServicePluginDiaglibPrj (
         tCString name,        // name used to create name for lock and condvar object
         tU16 srvMajVersion,   // major version number of the diaglib service we are using
         tU16 srvMinVersion,   // minor version number of the diaglib service we are using
         dia_SystemAdapter& adapter)
      : dia_SystemAdapterServicePluginDiaglib(name, srvMajVersion, srvMinVersion, adapter)
   {}

   virtual tBool bOnServiceStateAvailable ( tU16 /*u16SrvID*/, tU16 /*u16SubId*/ ) { return TRUE; }
};

//------------------------------------------------------------------------------

dia_SystemAdapter*
dia_FactoryPluginSystemAdapters::createSystemAdapter ( tCString name, tU16 clientAppID ) const
{
   return dia_SystemAdapter::create(name,clientAppID);
}

//------------------------------------------------------------------------------

dia_SystemAdapterServicePlugin*
dia_FactoryPluginSystemAdapters::createSystemAdapterServicePlugin (
      tCString name,        // name used to create name for lock and condvar object
      tU16 srvID,           // service of the client we are using
      tU16 srvMajVersion,   // major version number of the service
      tU16 srvMinVersion,   // minor version number of the service
      dia_SystemAdapter* adapter ) const
{
   dia_SystemAdapterServicePlugin* pPlugin = 0;

   if ( adapter )
   {
      pPlugin = OSAL_NEW dia_SystemAdapterServicePlugin(name,srvID,srvMajVersion,srvMinVersion,*adapter);
      if ( pPlugin )
      {
         adapter->addServicePlugin(*pPlugin);
      }
   }
   return pPlugin;
}

//------------------------------------------------------------------------------

dia_SystemAdapterServicePlugin*
dia_FactoryPluginSystemAdapters::createSystemAdapterServicePluginNoMonitoring (
      tCString name,        // name used to create name for lock and condvar object
      tU16 srvID,           // service of the client we are using
      tU16 srvMajVersion,   // major version number of the service
      tU16 srvMinVersion,   // minor version number of the service
      dia_SystemAdapter* adapter ) const
{
   dia_SystemAdapterServicePlugin* pPlugin = 0;

   if ( adapter )
   {
      pPlugin = OSAL_NEW dia_SystemAdapterServicePluginNoMonitoring(name,srvID,srvMajVersion,srvMinVersion,*adapter);
      if ( pPlugin )
      {
         adapter->addServicePlugin(*pPlugin);
      }
   }
   return pPlugin;
}

//------------------------------------------------------------------------------

dia_SystemAdapterServicePluginDiaglib*
dia_FactoryPluginSystemAdapters::createSystemAdapterServicePluginDiaglib (
      tCString name,        // name used to create name for lock and condvar object
      tU16 srvMajVersion,   // major version number of the service
      tU16 srvMinVersion,   // minor version number of the service
      dia_SystemAdapter* adapter ) const
{
   dia_SystemAdapterServicePluginDiaglib* pPlugin = 0;

   if ( adapter )
   {
      pPlugin = OSAL_NEW dia_SystemAdapterServicePluginDiaglibPrj(name,srvMajVersion,srvMinVersion,*adapter);
      if ( pPlugin )
      {
         adapter->addServicePlugin(*pPlugin);
      }
   }
   return pPlugin;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginSystemAdapters::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemAdapters::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF SYSTEM ADAPTER FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if (level == DIA_EN_INITLEVEL_3 || level == DIA_EN_INITLEVEL_ALL)
   {
      DIA_TR_INF("###############################################");
      DIA_TR_INF("# ADDING SYSTEM ADAPTERS");
      DIA_TR_INF("###############################################");

#if 0 //STC2HI: TODO
      mInstanceList.registerInstance<dia_FactoryObjectSAAudioPlayerCD>();
      mInstanceList.registerInstance<dia_FactoryObjectSADownload>();
#endif //STC2HI: TODO
      mInstanceList.registerInstance<dia_FactoryObjectSAAudioCompressed>();
      mInstanceList.registerInstance<dia_FactoryObjectSAHeatControl>();
      mInstanceList.registerInstance<dia_FactoryObjectSAAudio>();
      mInstanceList.registerInstance<dia_FactoryObjectSAAux>();
      mInstanceList.registerInstance<dia_FactoryObjectSAIPOD>();
      mInstanceList.registerInstance<dia_FactoryObjectSADimming>();
      mInstanceList.registerInstance<dia_FactoryObjectSAClock>();
      //mInstanceList.registerInstance<dia_FactoryObjectSARVC>();
#if 0 //STC2HI: TODO
      mInstanceList.registerInstance<dia_FactoryObjectSAKeyboard>();
      mInstanceList.registerInstance<dia_FactoryObjectSANavigation>();
#endif //STC2HI: TODO
      mInstanceList.registerInstance<dia_FactoryObjectSASPM>();
      mInstanceList.registerInstance<dia_FactoryObjectSATunerAMFM>();
      mInstanceList.registerInstance<dia_FactoryObjectSATunerMaster>();
      mInstanceList.registerInstance<dia_FactoryObjectSABluetooth>();
      mInstanceList.registerInstance<dia_FactoryObjectSAPhoneBook>();
      mInstanceList.registerInstance<dia_FactoryObjectSAMessaging>();
      mInstanceList.registerInstance<dia_FactoryObjectSASensor>();
//    mInstanceList.registerInstance<dia_FactoryObjectSASensorPV>();
  
      mInstanceList.registerInstance<dia_FactoryObjectSAErrorLog>();
      
      //mInstanceList.registerInstance<dia_FactoryObjectSATunerDAB>();
      mInstanceList.registerInstance<dia_FactoryObjectSAParkAssist>();
      mInstanceList.registerInstance<dia_FactoryObjectSASPI>();
      mInstanceList.registerInstance<dia_FactoryObjectSADiagnosisService>();

	  #ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
	  
	  mInstanceList.registerInstance<dia_FactoryObjectSAVDDeviceMGR>();

	  #endif
      tU8 u8data[VARIANT_CODING_PROP_LEN] = { 0 };

      if ( dia_getProperty(DIA_PROP_CM_VARIANT_CODING, u8data, VARIANT_CODING_PROP_LEN) == DIA_SUCCESS)
      {
         tU8 hw_type = u8data[4] & TUNER_BITS;
         switch(hw_type)
		 {
		    case TUNER_XM:

			  mInstanceList.registerInstance<dia_FactoryObjectSATunerXM>();
			   break;
		    case TUNER_DAB:
			  mInstanceList.registerInstance<dia_FactoryObjectSATunerDAB>();
			   break;
			default:
				break;
		 }
      }
	  else
	  {
		   DIA_TR_INF("dia_FactoryPluginSystemAdapters::setup DIA_PROP_CM_VARIANT_CODING PROPERTY READ FAILED");
	  }

            mInstanceList.registerInstance<dia_FactoryObjectSAMeter>();
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
      // Include SystemAdapter Factories only for Scope2
      mInstanceList.registerInstance<dia_FactoryObjectSASwitchCtrl>();
      mInstanceList.registerInstance<dia_FactoryObjectSATCU>();
 #ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
      mInstanceList.registerInstance<dia_FactoryObjectSAVDMMGR>();
 #endif
#endif

      mInstanceList.registerInstance<dia_FactoryObjectSAPhone>();
      mInstanceList.registerInstance<dia_FactoryObjectSAVehicleData>();
      mInstanceList.registerInstance<dia_FactoryObjectSAInputHandling>();
   }

   mInstanceList.createAll();
   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginSystemAdapters::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemAdapters::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      mInstanceList.destroyAll();
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

