/*!
 * \file       dia_FactoryPluginSubsystemLogoInstallation.h
 *
 * \brief      subsystem logo installation factory plugin
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       23.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_FACTORY_PLUGIN_SUBSYSTEM_LOGO_INSTALLATION__
#define __INCLUDED_FACTORY_PLUGIN_SUBSYSTEM_LOGO_INSTALLATION__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include "common/framework/factory/dia_FactoryPlugin.h"
#endif

class dia_SubsystemLogoInstallationManager;

class dia_FactoryPluginSubsystemLogoInstallation
   : public dia_FactoryPlugin
{
	   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_FactoryPluginSubsystemLogoInstallation);
public:

	//! setup (create objects,...)
	virtual tDiaResult setup ( dia_enInitLevel level );
	//! tear down (destroy objects,...)
	virtual tDiaResult tearDown ( dia_enInitLevel level );

protected:
	//! class constructor
	dia_FactoryPluginSubsystemLogoInstallation(void);
	//! class destructor
	virtual ~dia_FactoryPluginSubsystemLogoInstallation(void);
};

#endif /* __INCLUDED_FACTORY_PLUGIN_SUBSYSTEM_LOGO_INSTALLATION__ */
