/*!
 * \file       dia_FactoryPluginSubsystemLogoInstallation.h
 *
 * \brief      subsystem logo installation factory plugin
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       23.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_FACTORY_PLUGIN_SUBSYSTEM_LOGO_INSTALLATION__
#include "dia_FactoryPluginSubsystemLogoInstallation.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationManager.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER_PLUGIN__
#include "project/framework/cislogo/dia_SubsystemLogoInstallationManagerPlugin.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_LOGO_INSTALLATION__
#include "project/interfaces/dia_ISubsystemLogoInstallation.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DATA_DOWNLOAD_CFG__
#include "project/framework/cis/logoinstallation/dia_cfgSubsystemLogoInstallationDataDownload.h"
#endif

DIA_IMPL_SINGLETON(dia_FactoryPluginSubsystemLogoInstallation)

dia_FactoryPluginSubsystemLogoInstallation::dia_FactoryPluginSubsystemLogoInstallation(void)
: dia_FactoryPlugin("dia_FactoryPluginSubsystemLogoInstallation")
{
	// TODO Auto-generated constructor stub

}

//---------------------------------------------------------------------------------------------

dia_FactoryPluginSubsystemLogoInstallation::~dia_FactoryPluginSubsystemLogoInstallation(void)
{
	// TODO Auto-generated destructor stub
}

//---------------------------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginSubsystemLogoInstallation::setup ( dia_enInitLevel level )
{
	dia_tclFnctTrace oTrace("dia_FactoryPluginSubsystemLogoInstallation::setup");

	dia_LockScope mScopeLock(mSyncObj);

    if ( level <= getInitializationLevel() )
    {
       DIA_TR_INF("##### REQUESTED LEVEL OF SUBSYSTEM LOGO INSTALLATION FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
       return DIA_SUCCESS;
    }

   if ( level == DIA_EN_INITLEVEL_1 || level == DIA_EN_INITLEVEL_ALL )
   {
	    dia_SubsystemLogoInstallationManager* pManager = getInstanceOfSubsystemLogoInstallationManager();
		
		if ( pManager )
		{
			pManager->loadDatasetCfgs(aDiaCISHMILogoInstallationCfg,sizeof(aDiaCISHMILogoInstallationCfg)/sizeof(dia_DatasetConfigLogo));
			
			if (assignInterfaceAndNotifier<  dia_ISubsystemLogoInstallation,
											dia_ISubsystemLogoInstallationListener,
											dia_ISubsystemLogoInstallationNotifier   >(pManager) != DIA_SUCCESS)
			{
				return DIA_FAILED;
			}
			
		}
   }
   
   //
   // RTCTL SERVICE HANDLER IS ADDED IN THE FACTORY PROJECT PLUGIN DIRECTLY
   // 

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;

}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginSubsystemLogoInstallation::tearDown ( dia_enInitLevel level )
{
	dia_tclFnctTrace oTrace("dia_FactoryPluginSubsystemLogoInstallation::tearDown");

    dia_LockScope mScopeLock(mSyncObj);

    if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
    {
        // destroy the input output control manager object
		releaseInstanceOfSubsystemLogoInstallationManager();
    }

    if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
    {
       setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
       DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
    }

    return DIA_SUCCESS;

}

















