/*
 * dia_FactoryPluginSubsystemDiagnosis.cpp
 *
  *
 * \brief      ...
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * \date       19.09.2019
 *
 *      Author: MKY6KOR
 */

#ifndef __INCLUDED_FACTORY_PLUGIN_SUBSYSTEM_DIAGNOSIS__
#include "project/framework/factory/dia_FactoryPluginSubsystemDiagnosis.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY_DEFAULT__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisStrategyDefault.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisManager.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER_PLUGIN__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisManagerPlugin.h"
#endif

#ifndef __INCLUDED_SUBSYSTEM_DIAGNOSIS_STRATEGY__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisStrategyDefault.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS__
#include "project/interfaces/dia_ISubsystemDiagnosis.h"
#endif

#ifndef DIA_ROUTINECTRLIDENTIFYSUBSYSTEM_H_
#include "project/services/customer/dia_RoutineCtrlIdentifySubSystem.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CONNECT_SPECIFIC_SUBSYSTEM_H_
#include "project/services/customer/dia_RoutineCtrlConnectToSpecificSubSystem.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_REQUEST_ROUTER__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisRequestRouter.h"
#endif

static std::string subsystemStrategyName("SubsystemDiagnosis");

DIA_IMPL_SINGLETON(dia_FactoryPluginSubsystemDiagnosis)


dia_FactoryPluginSubsystemDiagnosis::dia_FactoryPluginSubsystemDiagnosis(void)
: dia_FactoryPlugin("dia_FactoryPluginSubsystemDiagnosis")
{
	// TODO Auto-generated constructor stub

}

//---------------------------------------------------------------------------------------------

dia_FactoryPluginSubsystemDiagnosis::~dia_FactoryPluginSubsystemDiagnosis(void)
{
	// TODO Auto-generated destructor stub
}

//---------------------------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginSubsystemDiagnosis::setup ( dia_enInitLevel level )
{
	dia_tclFnctTrace oTrace("dia_FactoryPluginSubsystemDiagnosis::setup");

	dia_LockScope mScopeLock(mSyncObj);


   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF SUBSYSTEM DIAGNOSIS FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_1 || level == DIA_EN_INITLEVEL_ALL )
   {
	   dia_SubsystemDiagnosisManager* pSubsystemManager = getInstanceOfSubsystemDiagnosisManager();
      if ( pSubsystemManager )
      {
		
         if (DIA_SUCCESS!=(pSubsystemManager->addSubsystemDiagnosisStrategy(new dia_SubsystemDiagnosisStrategyDefault(subsystemStrategyName, (tU32)DIA_C_SUBSYSTEM_DIAGNOSIS_STRATEGY_PRJ))) )
         {
            DIA_TR_ERR("### addSubsystemDiagnosisStrategy failed for dia_SubsystemDiagnosisStrategyDefault ###");
         }

         dia_SubsystemDiagnosisManagerPlugin* pSubsystemManagerPlugin = new dia_SubsystemDiagnosisManagerPlugin();
         if ( pSubsystemManagerPlugin ) pSubsystemManager->setPlugin(*pSubsystemManagerPlugin);


         if (assignInterfaceAndNotifier<dia_ISubsystemDiagnosis,dia_ISubsystemDiagnosisListener,dia_ISubsystemDiagnosisNotifier>(pSubsystemManager) != DIA_SUCCESS)
         {
            return DIA_FAILED;
         }
		 
      }
   }

   if ( level == DIA_EN_INITLEVEL_3 || level == DIA_EN_INITLEVEL_ALL )
   {
      dia_EngineServer* pEngineCustomer = 0;
      if ( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngineCustomer) != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO CUSTOMER DIAGNOSIS ENGINE #####");
         return DIA_FAILED;
      }

		// ADD_ROUTINE(dia_RoutineCtrlConnectToSpecificSubSystem)
		// ADD_ROUTINE(dia_RoutineCtrlIdentifySubSystem)
		//(void) pEngineCustomer->bAddServiceHandler(new dia_RoutineCtrlIdentifySubSystem());
        //(void) pEngineCustomer->bAddServiceHandler(new dia_RoutineCtrlConnectToSpecificSubSystem());
        //(void) pEngineCustomer->bAddServiceHandler(new dia_SubsystemDiagnosisRequestRouter());
   }

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginSubsystemDiagnosis::tearDown ( dia_enInitLevel level )
{
	dia_tclFnctTrace oTrace("dia_FactoryPluginSubsystemDiagnosis::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy the input output control manager object
      releaseInstanceOfSubsystemDiagnosisManager();
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}





