/**
 * \file      dia_FactoryPluginSecurity.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Nov 3, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#include "dia_FactoryPluginSecurity.h"

#ifndef __INCLUDED_DIA_COMMON_SECURITY__
#include "common/framework/security/dia_common_security.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY_LEVEL_ALD__
#include "common/framework/security/dia_SecurityLevelALD.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY_LEVEL_AIVI__
#include "project/framework/security/dia_SecurityLevelAIVI.h"
#endif

#ifndef __INCLUDED_DIA_CMC_SECURITY_LEVEL_DOIP__
#include "project/framework/security/dia_CMCSecurityLevelDoip.h"
#endif
#ifndef __INCLUDED_DIA_CMC_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER__
#include "project/framework/security/dia_CMCSecurityLevelCISInstallationContainer.h"
#endif

#include "project/framework/sysadapters/dia_SAFeatureSecurity.h"


#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#include "common/framework/application/dia_SessionController.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifdef __ENABLE_FEATURE_SECURITY_INCLUDE_ALD__
#define DIA_C_U16_SECURITY_LEVEL_MAX_LOGIN_ATTEMPTS_ALD        ((tU16)    3)
#define DIA_C_U16_SECURITY_LEVEL_LOCKING_TIME_SECONDS_ALD      ((tU16)   60)
#define DIA_C_U8_SECURITY_LEVEL_ACCESS_TYPE_SEED_ALD           ((tU8 ) 0x63)
#define DIA_C_U8_SECURITY_LEVEL_ACCESS_TYPE_KEY_ALD            ((tU8 ) 0x64)
#define DIA_C_U8_SECURITY_LEVEL_BITMASK_SCC_ALD                ((tU8)  0x02)
#endif

#define DIA_C_U8_SECURITY_LEVEL_ACCESS_TYPE_SEED_AIVI          ((tU8 ) 0x01)
#define DIA_C_U8_SECURITY_LEVEL_ACCESS_TYPE_KEY_AIVI           ((tU8 ) 0x02)

#define DIA_C_U8_CMC_SECURITY_LEVEL_DOIP_ACCESS_TYPE_SEED      ((tU8 ) 0x05)
#define DIA_C_U8_CMC_SECURITY_LEVEL_DOIP_ACCESS_TYPE_KEY       ((tU8 ) 0x06)

#define DIA_C_U8_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_ACCESS_TYPE_SEED   ((tU8 ) 0x61)
#define DIA_C_U8_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_ACCESS_TYPE_KEY    ((tU8 ) 0x62)

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginSecurity)

//-----------------------------------------------------------------------------

dia_FactoryPluginSecurity::dia_FactoryPluginSecurity ( void )
   : dia_FactoryPlugin("dia_FactoryPluginSecurity",DIA_EN_FACTORY_PLUGIN_TYPE_SECURITY),
     mpSecMgr(0)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginSecurity::~dia_FactoryPluginSecurity ( void )
{
   /*(void) tearDownObjects();*/
   mpSecMgr = 0;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginSecurity::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSecurity::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF SECURITY FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // get the pointer to the security manager
      mpSecMgr = getInstanceOfSecurityManager();
      if ( !mpSecMgr )
      {
         DIA_TR_ERR("dia_FactoryPluginSecurity::setup(DIA_EN_INITLEVEL_0) - creation of security manager failed !!");
         return DIA_FAILED;
      }
   }

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      if ( mpSecMgr )
      {
         //lint -e429 custodial pointer is freed by this factory class

         DIA_TR_INF("###############################################");
         DIA_TR_INF("# ADDING LEVELS AND MODULES");
         DIA_TR_INF("###############################################");

#ifdef __ENABLE_FEATURE_SECURITY_MODULE_INCLUDE_TTFIS__         // security modules
         dia_SecurityModuleTTFIS* pSecModuleTTFIS = OSAL_NEW dia_SecurityModuleTTFIS(getInstanceOfFactory()->makeDriver(DIA_EN_DRVTYPE_TRACE));
         if ( pSecModuleTTFIS ) mModuleRep.push_back(pSecModuleTTFIS);
#endif

#ifdef __ENABLE_FEATURE_SECURITY_INCLUDE_ALD__
         DIA_TR_INF("########################################################");
         DIA_TR_INF("# ADDING ALD (Authorization Level Daemon) SECURITY LEVEL");
         DIA_TR_INF("########################################################");

         dia_SecurityLevelConfiguration* pSecLevelConfigALD = OSAL_NEW dia_SecurityLevelConfiguration;
         if ( pSecLevelConfigALD )
         {
            pSecLevelConfigALD->setAccessTypeSeed(DIA_C_U8_SECURITY_LEVEL_ACCESS_TYPE_SEED_ALD);
            pSecLevelConfigALD->setAccessTypeKey(DIA_C_U8_SECURITY_LEVEL_ACCESS_TYPE_KEY_ALD);
            pSecLevelConfigALD->setSecurityLevelBitmask(DIA_U32_BITMASK_SECURITY_LEVEL_ALD);
            pSecLevelConfigALD->setSecurityLevelBitmaskSCC(DIA_C_U8_SECURITY_LEVEL_BITMASK_SCC_ALD);
            pSecLevelConfigALD->setLoginLockTime(DIA_C_U16_SECURITY_LEVEL_LOCKING_TIME_SECONDS_ALD);
            pSecLevelConfigALD->setMaxNumberOfLogins(DIA_C_U16_SECURITY_LEVEL_MAX_LOGIN_ATTEMPTS_ALD);

            // security levels
            dia_SecurityLevelALD* pSecLevelALD = OSAL_NEW dia_SecurityLevelALD(*pSecLevelConfigALD);
            if ( pSecLevelALD )
            {
               pSecLevelALD->initialize();

               mLevelRep.push_back(pSecLevelALD);
               mLevelConfigRep.push_back(pSecLevelConfigALD);
               mpSecMgr->addSecurityLevel(pSecLevelALD);
            }
         }
#endif

         DIA_TR_INF("########################################################");
         DIA_TR_INF("# ADDING A-IVI SECURITY LEVEL FOR CALIBRATION");
         DIA_TR_INF("########################################################");

         dia_SecurityLevelConfiguration* pSecLevelConfigAIVI = OSAL_NEW dia_SecurityLevelConfiguration;
         if ( pSecLevelConfigAIVI )
         {
            pSecLevelConfigAIVI->setAccessTypeSeed(DIA_C_U8_SECURITY_LEVEL_ACCESS_TYPE_SEED_AIVI);
            pSecLevelConfigAIVI->setAccessTypeKey(DIA_C_U8_SECURITY_LEVEL_ACCESS_TYPE_KEY_AIVI);
#if 0
            pSecLevelConfigAIVI->setSecurityLevelBitmask(DIA_U32_BITMASK_SECURITY_LEVEL_ALD);
            pSecLevelConfigAIVI->setSecurityLevelBitmaskSCC(DIA_C_U8_SECURITY_LEVEL_BITMASK_SCC_ALD);
            pSecLevelConfigAIVI->setLoginLockTime(DIA_C_U16_SECURITY_LEVEL_LOCKING_TIME_SECONDS_ALD);
            pSecLevelConfigAIVI->setMaxNumberOfLogins(DIA_C_U16_SECURITY_LEVEL_MAX_LOGIN_ATTEMPTS_ALD);
#endif

            dia_SecurityLevelAIVI* pSecLevelAIVI = OSAL_NEW dia_SecurityLevelAIVI(*pSecLevelConfigAIVI);
            if ( pSecLevelAIVI )
            {
               pSecLevelAIVI->initialize();

               mLevelRep.push_back(pSecLevelAIVI);
               mLevelConfigRep.push_back(pSecLevelConfigAIVI);
               mpSecMgr->addSecurityLevel(pSecLevelAIVI);
            }
         }

         DIA_TR_INF("########################################################");
         DIA_TR_INF("# ADDING CMC SECURITY LEVEL FOR DOIP");
         DIA_TR_INF("########################################################");

         dia_SecurityLevelConfiguration* pCMCConfig_SecLevelDoip = OSAL_NEW dia_SecurityLevelConfiguration;
         if ( pCMCConfig_SecLevelDoip )
         {
        	 pCMCConfig_SecLevelDoip->setAccessTypeSeed(DIA_C_U8_CMC_SECURITY_LEVEL_DOIP_ACCESS_TYPE_SEED);
        	 pCMCConfig_SecLevelDoip->setAccessTypeKey(DIA_C_U8_CMC_SECURITY_LEVEL_DOIP_ACCESS_TYPE_KEY);

        	 dia_CMCSecurityLevelDoip* pCMC_SecLevelDoip = OSAL_NEW dia_CMCSecurityLevelDoip(*pCMCConfig_SecLevelDoip);
            if ( pCMC_SecLevelDoip )
            {
            	pCMC_SecLevelDoip->initialize();

               mLevelRep.push_back(pCMC_SecLevelDoip);
               mLevelConfigRep.push_back(pCMCConfig_SecLevelDoip);
               mpSecMgr->addSecurityLevel(pCMC_SecLevelDoip);
            }
         }
         DIA_TR_INF("########################################################");
         DIA_TR_INF("# ADDING CMC SECURITY LEVEL FOR CIS Installation Container");
         DIA_TR_INF("########################################################");
         dia_SecurityLevelConfiguration* pCMCConfig_SecLevel_CIS_Installation_Container = OSAL_NEW dia_SecurityLevelConfiguration;
         if ( pCMCConfig_SecLevel_CIS_Installation_Container )
         {
        	 pCMCConfig_SecLevel_CIS_Installation_Container->setAccessTypeSeed(DIA_C_U8_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_ACCESS_TYPE_SEED);
        	 pCMCConfig_SecLevel_CIS_Installation_Container->setAccessTypeKey(DIA_C_U8_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_ACCESS_TYPE_KEY);

        	 dia_CMCSecurityLevelCISInstallationContainer* pCMC_SecLevel_CIS_Installation_Container = OSAL_NEW dia_CMCSecurityLevelCISInstallationContainer(*pCMCConfig_SecLevel_CIS_Installation_Container);
        	 if ( pCMC_SecLevel_CIS_Installation_Container )
        	 {
        		 pCMC_SecLevel_CIS_Installation_Container->initialize();

        		 mLevelRep.push_back(pCMC_SecLevel_CIS_Installation_Container);
        		 mLevelConfigRep.push_back(pCMCConfig_SecLevel_CIS_Installation_Container);
        		 mpSecMgr->addSecurityLevel(pCMC_SecLevel_CIS_Installation_Container);
        	 }
         }

         (void) mpSecMgr->initialize();

         dia_EngineServer* pEngineCustomer = 0;
         if ( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngineCustomer) == DIA_SUCCESS &&
               pEngineCustomer )
         {
            pEngineCustomer->getSessionController()->addListener(mpSecMgr);
         }

         //lint -e429 custodial pointer is freed by this factory class
      } //if ( mpSecMgr )

      DIA_TR_INF("########################################################");
      DIA_TR_INF("# ADDING A-IVI SYSTEMADAPTER SECURITY");
      DIA_TR_INF("########################################################");

      dia_SAFeatureSecurity* pSASecurity = OSAL_NEW dia_SAFeatureSecurity();
      if (pSASecurity)
      {
         (void) assignInterfaceAndNotifier<dia_IAIVISecurity,dia_IAIVISecurityListener,dia_IAIVISecurityNotifier>(pSASecurity);
      }

   } //if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginSecurity::tearDown ( dia_enInitLevel level )
{
   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy all security modules
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_SecurityModule,mModuleRep)
      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_SecurityLevel,mLevelRep)
      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_SecurityLevelConfiguration,mLevelConfigRep)

      // destroy the routine control manager object
      dia_SecurityManager::deleteInstance();
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy the security manager object
      if ( mpSecMgr ) {
         dia_SecurityManager::deleteInstance();
         mpSecMgr = 0;
      }
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}


