#include "dia_FactoryPluginRoutineControls.h"

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ROUTINECONTROL_LISTENER__
#include "common/interfaces/dia_IRoutineControlListener.h"
#endif

#include "common/services/uds/generic/dia_common_uds_generic_services.h"

#ifndef __INCLUDED_DIA_COMMON_SERVICES_UDS_PRODUCTION__
#include "common/services/uds/production/dia_common_services_uds_production.h"
#endif

#if 0 //STC2HI: TODO
#include "project/services/customer/dia_services_customer.h"
#endif //STC2HI: TODO
#ifndef DIA_PROJECT_SERVICES_PRODUCTION_H_
#include "project/services/production/dia_project_services_production.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_PHONE_CONNECT_BLUETOOTH_DEVICE__
#include "common/services/uds/production/dia_RoutineCtrlPhoneConnectBluetoothDevice.h"
#endif

#ifndef DIA_ROUTINECTRLCHECKSUM_H_
#include "common/services/uds/production/dia_RoutineCtrlChecksum.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EM_ERASE_H_
#include "common/services/uds/generic/dia_RoutineCtrlEMErase.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EM_PRINT_2_TRACE_H_
#include "common/services/uds/generic/dia_RoutineCtrlEMPrint2Trace.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GET_PROC_STAT_BY_PROCESSNAME_H_
#include "common/services/uds/generic/dia_RoutineCtrlGetProcStatByProcessname.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GET_PROC_STATM_BY_PROCESSNAME_H_
#include "common/services/uds/generic/dia_RoutineCtrlGetProcStatMByProcessname.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_CALCULATE_CONFIG_FINGERPRINT__
#include "common/services/uds/generic/dia_RoutineCtrlGenericCalculateConfigFingerprint.h"
#endif

#ifdef __ENABLE_FEATURE_RUN_IN__
#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_RUNIN__
#include <common/services/uds/production/dia_RoutineCtrlRunIn.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_RUNIN_CLEAR_RESULTS__
#include <common/services/uds/production/dia_RoutineCtrlRunInClearResults.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_STRESSTEST__
#include <common/services/uds/production/dia_RoutineCtrlStressTest.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_DISPLAY_TESTSCREEN_SLIDESHOW__
#include <common/services/uds/production/dia_RoutineCtrlDisplayTestScreenSlideshow.h>
#endif

#endif
#endif

#ifndef DIA_RTCTRLGETBT_SIGQ_RSSI_H_
#include "project/services/customer/dia_RtCtrlGetBT_SigQ_RSSI.h"
#endif
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_SYSTEM_INSTALLATION_H__
#include "project/services/customer/dia_RoutineCtrlSystemInstallation.h"
#endif
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_COPY_INSTALLATION_LOG_FILE_TO_USB_H__
#include "project/services/customer/dia_RoutineCtrlCopyInstallationLogFileToUSB.h"
#endif

#ifndef DIA_ROUTINECTRLIDENTIFYSUBSYSTEM_H_
#include "project/services/customer/dia_RoutineCtrlIdentifySubSystem.h"
#endif

#ifndef DIA_ROUTINECTRLRELOADSUPPLIERDELIVERYSTATE_H_
#include "project/services/customer/dia_RoutineCtrlReloadSupplierDeliveryState.h"
#endif

#ifndef  __INCLUDED_DIA_RTCTRL_SUBSYSTEM_LOGO_INSTALLATION__
#include "project/services/customer/dia_RoutineCtrlSubsystemLogoInstallation.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERATE_KEY_PAIR__
#include "project/services/production/dia_RoutineCtrlGenerateKeyPair.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_SWUP_UPDATE_MAP_DATA__
#include "project/services/production/dia_RoutineCtrlSWUPUpdateMapData.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_START_SW_UPDATE_OF_ALL_SUBMODULES__
#include "project/services/production/dia_RoutineCtrlStartSoftwareUpdateOfAllSubModules.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CHECK_PROGRAMMING_DEPENDENCIES__
#include "project/services/customer/dia_RoutineCtrlCheckProgrammingDependencies.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_SELF_DIAGNOSIS__
#include "project/services/customer/dia_RtCtrlSelfDiagnosis.h"
#endif
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CHANGE_TP_BLOCK_SIZE__
#include "project/services/customer/dia_RtCtrlChangeTpBlockSize.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
#ifndef __INCLUDED_RTCTRL_RESET_VIN__
#include "project/services/customer/vin/dia_RtCtrl_VinReset.h"
#endif
#endif
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CONNECT_SPECIFIC_SUBSYSTEM_H_
#include "project/services/customer/dia_RoutineCtrlConnectToSpecificSubSystem.h"
#endif
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CIS_INSTALL_CONT_EXTRACT_H__
#include "project/services/customer/dia_RoutineCtrlCISInstallContainerExtract.h"
#endif
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE1_H__
#include "project/services/customer/dia_RoutineCtrlCISSWUpdateStage1.h"
#endif
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE2_H__
#include "project/services/customer/dia_RoutineCtrlCISSWUpdateStage2.h"
#endif

#define DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT              "/opt/bosch/base/bin/diag_checksumproxy.sh"

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginRoutineControls)

//-----------------------------------------------------------------------------

dia_FactoryPluginRoutineControls::dia_FactoryPluginRoutineControls ( tVoid )
   : dia_FactoryPlugin("dia_FactoryPluginRoutineControls",DIA_EN_FACTORY_PLUGIN_TYPE_ROUTINE_CONTROL),
     mpRCtrlMgr(0)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginRoutineControls::~dia_FactoryPluginRoutineControls ( tVoid )
{
   /*(tVoid) tearDownObjects();*/
   mpRCtrlMgr = 0;
}

//-----------------------------------------------------------------------------

#define ADD_ROUTINE(className) \
   { \
      className* pRoutine = OSAL_NEW className; \
      if ( pRoutine ) \
      { \
         (tVoid) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

#define ADD_ROUTINE_WITH_INITIALIZER(className) \
   { \
      className* pRoutine = OSAL_NEW className; \
      if ( pRoutine ) \
      { \
         pRoutine->vInit(); \
         (tVoid) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

#define ADD_ROUTINE_FINGERPRINT(className,name,did,data) \
   { \
      className* pRoutine = OSAL_NEW className(name,did); \
      if ( pRoutine ) \
      { \
         (tVoid) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
         pRoutine->loadFingerprintInfo(data, sizeof(data)/sizeof(dia_FingerprintInfo)); \
      } \
   }

#define ADD_ROUTINE_NAME_DID(className,name,did) \
   { \
      className* pRoutine = OSAL_NEW className(name,did); \
      if ( pRoutine ) \
      { \
         (void) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

#define ADD_ROUTINE_NAME_DID_ID(className,name,did,id) \
   { \
      className* pRoutine = OSAL_NEW className(name,did,id); \
      if ( pRoutine ) \
      { \
         (void) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

   #define ADD_ROUTINE_NAME_DID_ID_STRING(className,name,did,id,script) \
   { \
      className* pRoutine = OSAL_NEW className(name,did,id, script); \
      if ( pRoutine ) \
      { \
         (void) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

#define ADD_ROUTINE_NAME_DID_ID_CMD(className,name,did,id,cmd) \
   { \
      className* pRoutine = OSAL_NEW className(name,did,id,cmd); \
      if ( pRoutine ) \
      { \
         (void) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginRoutineControls::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginRoutineControls::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF ROUTINE CONTROL FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // get the pointer to the routine control manager
      mpRCtrlMgr = dia_RoutineCtrlManager::getInstance();
      if ( !mpRCtrlMgr ) {
         DIA_TR_ERR("dia_FactoryPluginIOControls::setup(DIA_EN_INITLEVEL_0) - creation of routine control manager failed !!");
         return DIA_FAILED;
      }
   }

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      if ( mpRCtrlMgr )
      {
         using namespace dia;
         DIA_TR_INF("###############################################");
         DIA_TR_INF("# ADDING ROUTINE CONTROL OBJECTS");
         DIA_TR_INF("###############################################");

         //lint -e429 custodial pointer is freed by this factory class

#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
		 ADD_ROUTINE(dia::RtCtrlGetWifiSNR)
		 ADD_ROUTINE(dia::RoutineCtrlIPODSelfTest)
		 ADD_ROUTINE(dia::RtCtrlAccSelftest)
		 ADD_ROUTINE(dia::RtCtrlGyroSelftest)
		 ADD_ROUTINE(dia_RoutineCtrlLcmStartAlternativeSoftware)

         ADD_ROUTINE(dia::dia_ReadErrorStateHistoryForSWVersion)
         ADD_ROUTINE(dia::dia_ReadAverageCpuLoadForSWVersion)
         ADD_ROUTINE(dia::dia_ReadMaximumRamConsumptionForSWVersion)
         ADD_ROUTINE(dia::dia_ReadResetHistoryForSWVersion)
         ADD_ROUTINE(dia::dia_ReadResetInformationForSWVersion)
         ADD_ROUTINE(dia::dia_ReadStartupTimeStatisticForSWVersion)
         ADD_ROUTINE(dia::dia_ReadStateHistoryForSWVersion)
         ADD_ROUTINE(dia::dia_ReadSystemOperationTimeForSWVersion)
         ADD_ROUTINE(dia::dia_ReadWakeupHistoryForSWVersion)
		 ADD_ROUTINE(dia::RoutineCtrlGNSSCalcAndVerifyChecksum)
         ADD_ROUTINE(dia::RoutineCtrlSetSystemToDeliveryState)
         ADD_ROUTINE(dia::RoutineCtrlStartSoftwareUpdate)
		 ADD_ROUTINE(dia::RoutineCtrlTouchSelfTest)
#endif
         ADD_ROUTINE(dia::RoutineCtrlSetDiagnosticsToDeliveryState)         
         ADD_ROUTINE(dia::RtCtrlCDDriveSelftest)
         ADD_ROUTINE(dia_RtCtrlClearMCANConnectionHistory)
         
         
         ADD_ROUTINE(dia::RtCtrlresetSystemResetInformation)
         ADD_ROUTINE(dia_RtCtrlSystemOperationTime_Reset)
#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
         ADD_ROUTINE(dia_RtCtrl_VinReset)
#endif
         ADD_ROUTINE(RoutineCtrlGenerateKeyPair)
         ADD_ROUTINE(dia_RoutineCtrlSystemInstallation)
         ADD_ROUTINE(dia_RoutineCtrlCopyInstallationLogFileToUSB)
         ADD_ROUTINE(RoutineCtrlSWUPUpdateMapData)
         ADD_ROUTINE(dia_RoutineCtrlGenerateCSR)
         ADD_ROUTINE(dia_RtCtrlGetBT_SigQ_RSSI)
         ADD_ROUTINE(dia_RoutineCtrlCertificateStoring)
         ADD_ROUTINE(dia_RoutineCtrlCheckProgrammingDependencies)
         ADD_ROUTINE(RoutineCtrlStartSoftwareUpdateOfAllSubModules)
         ADD_ROUTINE(dia_RoutineCtrlIdentifySubSystem)
         ADD_ROUTINE(dia_RoutineCtrlCISSWUpdateStage1)
         ADD_ROUTINE(dia_RoutineCtrlCISSWUpdateStage2)
         ADD_ROUTINE(dia_RoutineCtrlConnectToSpecificSubSystem)
         ADD_ROUTINE(dia_RoutineCtrlSubsystemLogoInstallation)
         ADD_ROUTINE(dia_RoutineCtrlReloadSupplierDeliveryState)
         ADD_ROUTINE(dia_RoutineCtrlCISInstallContainerExtract)

         ADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlEMErase,                         "RoutineCtrlEMErase",            DIA_C_U16_DID_RBCM_RTCTRL_EM_ERASE,                DIA_EN_RTCTRL_ID_EM_ERASE)
         ADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlEMPrint2Trace,                   "RoutineCtrlEMPrint2Trace",      DIA_C_U16_DID_RBCM_RTCTRL_EM_PRINT2TRACE,          DIA_EN_RTCTRL_ID_EM_PRINT_TO_TRACE)
         //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlGetProcStatByProcessname,       "RoutineCtrlGetProcStatByProcessname",  DIA_C_U16_DID_RBCM_RTCTRL_GET_PROC_STAT_BY_PROCESSNAME,  DIA_EN_RTCTRL_ID_GET_PROC_STAT_BY_PROCESSNAME)
         //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlGetProcStatMByProcessname,      "RoutineCtrlGetProcStatMByProcessname", DIA_C_U16_DID_RBCM_RTCTRL_GET_PROC_STATM_BY_PROCESSNAME, DIA_EN_RTCTRL_ID_GET_PROC_STATM_BY_PROCESSNAME)
         ADD_ROUTINE_NAME_DID_ID(dia_tclUDS_BD_ConnectionControl,                "UDS_BD_ConnectionControl",      DIA_C_U16_DID_RBCM_RTCTRL_PHONESET_CONNECT_BT_DEVICE, DIA_EN_RTCTRL_ID_PHONE_BT_CONNECTION) //Routine contol for BT connect to Device
         ADD_ROUTINE_NAME_DID_ID(dia_tclUDS_DiagLogWriteTestResult,              "UDS_DiagLogWriteTestResult",    0x1010,                                            DIA_EN_RTCTRL_ID_SIMULATE_ITC)

         /* **************************** */
         /* FINGERPRINTS                 */
         /* **************************** */
         ADD_ROUTINE_FINGERPRINT(dia::RoutineCtrlGenericCalculateConfigFingerprint, "CMConfigFingerprint", DIA_C_U16_DID_RBCM_CM_CONFIGURATION_FINGERPRINT, aCMFingerprintData) //lint !e429: custodial pointer is freed by manager class
         ADD_ROUTINE_NAME_DID(dia_RoutineCtrlAIVICalculateConfigFingerprint,       "CustomerConfigFingerprint_withAIVISetSwitch", DIA_C_U16_DID_RBCM_CUSTOMER_CONFIG_FINGERPRINT)
         ADD_ROUTINE_NAME_DID(dia_RoutineCtrlAIVICalculateConfigFingerprint,       "CustomerDefaultConfigFingerprint_withAIVISetSwitch", DIA_C_U16_DID_RBCM_CUSTOMER_DEF_CONFIG_FINGERPRINT)
#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumNOR_RAW",            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_NOR_RAW,            DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_NOR_RAW,    DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumV850_APP",           DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_APP,           DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_V850_APP,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumV850_BOOT",          DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_BOOT,          DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_V850_BOOT,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_R",         DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_ROOT,      DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_ROOT,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FASTBOOT",      DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FASTBOOT,      DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FASTBOOT,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_RAW",           DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_RAW,           DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_RAW,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_STATIC",    DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_STATIC,    DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_STATIC,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_MAP_DATA",  DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_MAP_DATA,  DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_MAP_DATA,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_SDB",       DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_SDB,       DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_SDB,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_GRACENOTE", DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_GRACENOTE, DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_GRACENOTE,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
#endif

#ifdef __ENABLE_FEATURE_RUN_IN__
#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
         ADD_ROUTINE(dia::RoutineCtrlRunIn)
         ADD_ROUTINE(dia::RoutineCtrlRunInClearResults)
         ADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlStressTest, "dia_RoutineCtrlStressTest1",DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_1, DIA_EN_RTCTRL_ID_DIAG_STRESS_TEST_1)
         ADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlStressTest, "dia_RoutineCtrlStressTest2",DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_2, DIA_EN_RTCTRL_ID_DIAG_STRESS_TEST_2)
         ADD_ROUTINE(dia_RoutineCtrlDisplayTestScreenSlideshow)
#endif
#endif


#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
         ADD_ROUTINE(dia_RtCtrlSelfDiagnosis)
#endif


         {
            //Fill the map of logical block id to pair properties (data, digest).
            std::pair <tU32,tU32> pair00(DIA_PROP_AIVI_BLOCK_FD00_REFERENCE_CHECKSUM,  DIA_PROP_AIVI_DIGEST_FD00_REFERENCE_CHECKSUM);
            std::pair <tU32,tU32> pair01(DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB,        DIA_PROP_AIVI_DIGEST_FD01_PHONE_ECNR_NBS);
            std::pair <tU32,tU32> pair02(DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB,        DIA_PROP_AIVI_DIGEST_FD02_PHONE_ECNR_WBS);
            std::pair <tU32,tU32> pair03(DIA_PROP_AIVI_VR_PARAM,                       DIA_PROP_AIVI_DIGEST_FD03_VR_PARAM);
            std::pair <tU32,tU32> pair04(DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB,        DIA_PROP_AIVI_DIGEST_FD04_CARPLAY_PHONE_ECNR_NBS);
            std::pair <tU32,tU32> pair05(DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB,        DIA_PROP_AIVI_DIGEST_FD05_CARPLAY_PHONE_ECNR_WBS);
            std::pair <tU32,tU32> pair06(DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB,    DIA_PROP_AIVI_DIGEST_FD06_CARPLAY_FACETIME_ECNR_SWB);
            std::pair <tU32,tU32> pair07(DIA_PROP_AIVI_ACOUSTIC_PARAM,                 DIA_PROP_AIVI_DIGEST_FD07_ACOUSTIC_PARAM);
            std::pair <tU32,tU32> pair08(DIA_PROP_AIVI_BLOCK_FD08_ESE,                 DIA_PROP_AIVI_DIGEST_FD08_ESE_PARAM);
            std::pair <tU32,tU32> pair09(DIA_PROP_AID_DATASET_ECNR_BT_VOICE_NB,        DIA_PROP_AIVI_DIGEST_FD09_BT_VOICE_ECNR_NBS);
            std::pair <tU32,tU32> pair10(DIA_PROP_AID_DATASET_ECNR_BT_VOICE_WB,        DIA_PROP_AIVI_DIGEST_FD0A_BT_VOICE_ECNR_WBS);
            std::pair <tU32,tU32> pair11(DIA_PROP_AID_DATASET_ECNR_BT_SIRI_WB,         DIA_PROP_AIVI_DIGEST_FD0B_BT_SIRI_ECNR_WBS);
            std::pair <tU32,tU32> pair12(DIA_PROP_AID_DATASET_ECNR_CP_VOICE_WB,        DIA_PROP_AIVI_DIGEST_FD0C_CARPLAY_SIRI_ECNR_WBS);
            std::pair <tU32,tU32> pair13(DIA_PROP_AID_DATASET_ECNR_AA_VOICE_WB,        DIA_PROP_AIVI_DIGEST_FD0D_ANDROID_AUTO_VR_ECNR_WBS);
            std::pair <tU32,tU32> pair14(DIA_PROP_AID_DATASET_ECNR_VPA_VOICE_WB,       DIA_PROP_AIVI_DIGEST_FD0E_ECNR_VPA_VOICE_WB);

            mPropRepo[DIA_LOGICAL_BLOCK_00] = pair00;
            mPropRepo[DIA_LOGICAL_BLOCK_01] = pair01;
            mPropRepo[DIA_LOGICAL_BLOCK_02] = pair02;
            mPropRepo[DIA_LOGICAL_BLOCK_03] = pair03;
            mPropRepo[DIA_LOGICAL_BLOCK_04] = pair04;
            mPropRepo[DIA_LOGICAL_BLOCK_05] = pair05;
            mPropRepo[DIA_LOGICAL_BLOCK_06] = pair06;
            mPropRepo[DIA_LOGICAL_BLOCK_07] = pair07;
            mPropRepo[DIA_LOGICAL_BLOCK_08] = pair08;
            mPropRepo[DIA_LOGICAL_BLOCK_09] = pair09;
            mPropRepo[DIA_LOGICAL_BLOCK_10] = pair10;
            mPropRepo[DIA_LOGICAL_BLOCK_11] = pair11;
            mPropRepo[DIA_LOGICAL_BLOCK_12] = pair12;
            mPropRepo[DIA_LOGICAL_BLOCK_13] = pair13;
            mPropRepo[DIA_LOGICAL_BLOCK_14] = pair14;

            dia_RoutineCtrlCheckReprogrammingDtc* pRtCtrlCheckReproDtc = OSAL_NEW dia_RoutineCtrlCheckReprogrammingDtc("dia_RoutineCtrlCheckReprogrammingDtc",
                  DIA_C_U16_ID_AIVI_RTCTRL_RUN_DTC_TEST_LOGICAL_BLOCK, mPropRepo);
            if ( pRtCtrlCheckReproDtc )
            {
               (tVoid) mpRCtrlMgr->addRoutine(pRtCtrlCheckReproDtc);
               mRoutineRep.push_back(pRtCtrlCheckReproDtc);
            }

            std::map<dia_e_logical_block,std::pair <tU32,tU32> >::const_iterator lbIter;
            for (lbIter = mPropRepo.begin(); lbIter != mPropRepo.end(); lbIter++)
            {
               pRtCtrlCheckReproDtc = OSAL_NEW dia_RoutineCtrlCheckReprogrammingDtc(
                     getInstanceOfStringComposer()->composeString("dia_RoutineCheckLogicalBlockDtc%04X%02X", lbIter->first, FTB_INTERNAL_FAILURE),
                     0, mPropRepo);

               if ( pRtCtrlCheckReproDtc )
               {
                  (tVoid) mpRCtrlMgr->addRoutine(pRtCtrlCheckReproDtc);
                  mRoutineRep.push_back(pRtCtrlCheckReproDtc);
               }

               pRtCtrlCheckReproDtc = OSAL_NEW dia_RoutineCtrlCheckReprogrammingDtc(
                     getInstanceOfStringComposer()->composeString("dia_RoutineCheckLogicalBlockDtc%04X%02X", lbIter->first, FTB_PROGRAMMING_FAILURE),
                     0, mPropRepo);

               if ( pRtCtrlCheckReproDtc )
               {
                  (tVoid) mpRCtrlMgr->addRoutine(pRtCtrlCheckReproDtc);
                  mRoutineRep.push_back(pRtCtrlCheckReproDtc);
               }

               pRtCtrlCheckReproDtc = OSAL_NEW dia_RoutineCtrlCheckReprogrammingDtc(
                     getInstanceOfStringComposer()->composeString("dia_RoutineCheckLogicalBlockDtc%04X%02X", lbIter->first, FTB_ALGORITHM_FAILURE),
                     0, mPropRepo);

               if ( pRtCtrlCheckReproDtc )
               {
                  (tVoid) mpRCtrlMgr->addRoutine(pRtCtrlCheckReproDtc);
                  mRoutineRep.push_back(pRtCtrlCheckReproDtc);
               }
            }

         }
      /*
         {
            using namespace dia;
            RoutineCtrlConfigureSecuritySettingsSCC* pRtConfigureSecuritySettingsSCC = OSAL_NEW RoutineCtrlConfigureSecuritySettingsSCC;
            if ( pRtConfigureSecuritySettingsSCC )
            {
               pRtConfigureSecuritySettingsSCC->setRequestedSystemSubState(DIA_EN_SPM_SUBSTATE_DIAGNOSIS_MODE);
               (tVoid) mpRCtrlMgr->addRoutine(pRtConfigureSecuritySettingsSCC);
               mRoutineRep.push_back(pRtConfigureSecuritySettingsSCC);
            }

            RoutineCtrlVerifySecuritySettingsSCC* pRtVerifySecuritySettingsSCC = OSAL_NEW RoutineCtrlVerifySecuritySettingsSCC;
            if ( pRtVerifySecuritySettingsSCC )
            {
               pRtVerifySecuritySettingsSCC->setRequestedSystemSubState(DIA_EN_SPM_SUBSTATE_DIAGNOSIS_MODE);
               (tVoid) mpRCtrlMgr->addRoutine(pRtVerifySecuritySettingsSCC);
               mRoutineRep.push_back(pRtVerifySecuritySettingsSCC);
            }
         }
      */
         //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID(dia_RtCtrlChangeTpBlockSize, "RtCtrlBootBsAndStMin",         DIA_C_U16_ID_AIVI_RTCTRL_BOOT_BS_AND_STMIN)
         //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID(dia_RtCtrlChangeTpBlockSize, "RtCtrlBootSpecificBsAndStMin", DIA_C_U16_ID_AIVI_RTCTRL_BOOT_SPECIFIC_BS_AND_STMIN)

         (tVoid) assignInterfaceAndNotifier<dia_IRoutineControl,dia_IRoutineControlListener,dia_IRoutineControlNotifier>(mpRCtrlMgr);
      }
   }

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginRoutineControls::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginRoutineControls::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_Routine,mRoutineRep)
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy the routine control manager object
      if ( mpRCtrlMgr ) {
         dia_RoutineCtrlManager::deleteInstance();
         mpRCtrlMgr = 0;
      }
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

