#include "dia_FactoryPluginProductionServices.h"

#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#include "common/framework/application/dia_SessionController.h"
#endif

#include "common/services/uds/production/dia_common_services_uds_production.h"

#ifndef __DIA_UNIT_TESTING__
#ifndef __INCLUDED_DIA_COMMON_SERVICES_UDS_PRODUCTION__
#include "common/services/uds/production/dia_common_services_uds_production.h"
#endif
#ifndef DIA_PROJECT_SERVICES_PRODUCTION_H_
#include "project/services/production/dia_project_services_production.h"
#endif
#else
#include "common/services/uds/production/dia_IOCtrlTunerDAB_Antenna_1_EnsembleFrequency.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include <project/framework/factory/dia_project_factory.h>
#endif

#ifndef DIA_PROJECT_SERVICES_PRODUCTION_H_
#include "project/services/production/dia_project_services_production.h"
#endif

#include "common/services/uds/generic/dia_common_uds_generic_services.h"

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_PHONE_CONNECT_BLUETOOTH_DEVICE__
#include "common/services/uds/production/dia_RoutineCtrlPhoneConnectBluetoothDevice.h"
#endif

#ifndef DIA_ROUTINECTRLCHECKSUM_H_
#include "common/services/uds/production/dia_RoutineCtrlChecksum.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EM_ERASE_H_
#include "common/services/uds/generic/dia_RoutineCtrlEMErase.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EM_PRINT_2_TRACE_H_
#include "common/services/uds/generic/dia_RoutineCtrlEMPrint2Trace.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_CALCULATE_CONFIG_FINGERPRINT__
#include "common/services/uds/generic/dia_RoutineCtrlGenericCalculateConfigFingerprint.h"
#endif

#ifdef __ENABLE_FEATURE_RUN_IN__

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_RUNIN__
#include <common/services/uds/production/dia_RoutineCtrlRunIn.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_RUNIN_CLEAR_RESULTS__
#include <common/services/uds/production/dia_RoutineCtrlRunInClearResults.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_STRESSTEST__
#include <common/services/uds/production/dia_RoutineCtrlStressTest.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_DISPLAY_TESTSCREEN_SLIDESHOW__
#include <common/services/uds/production/dia_RoutineCtrlDisplayTestScreenSlideshow.h>
#endif

#endif

#ifndef __INCLUDED_DIA_FACTORY_SYSTEM_ADAPTERS__
#include "dia_FactoryPluginSystemAdapters.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONFIGURE_SECURITY_SETTINGS_SCC__
#include <common/services/uds/production/dia_RoutineCtrlConfigureSecuritySettingsSCC.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_VERIFY_SECURITY_SETTINGS_SCC__
#include <common/services/uds/production/dia_RoutineCtrlVerifySecuritySettingsSCC.h>
#endif

#if 0
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CHECK_CRYPTO_MATERIAL__
#include "project/services/production/dia_RoutineCtrlCheckCryptoMaterial.h"
#endif
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERATE_KEY_PAIR__
#include "project/services/production/dia_RoutineCtrlGenerateKeyPair.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_SWUP_UPDATE_MAP_DATA__
#include "project/services/production/dia_RoutineCtrlSWUPUpdateMapData.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_START_SW_UPDATE_OF_ALL_SUBMODULES__
#include "project/services/production/dia_RoutineCtrlStartSoftwareUpdateOfAllSubModules.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_GENERIC_PRINT2DIAGNOSIS_TRACE_H_
#include <common/services/uds/generic/dia_SrvHandlerGenericPrint2DiagnosisTrace.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
#ifndef DIA_ROUTINECTRLTOUCHSELFTESTPIVI_H_
#include "project/services/production/dia_RoutineCtrlTouchSelfTestPIVI.h"
#endif
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GET_PROC_STATM_BY_PROCESSNAME_H_
#include "common/services/uds/generic/dia_RoutineCtrlGetProcStatMByProcessname.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GET_PROC_STAT_BY_PROCESSNAME_H_
#include "common/services/uds/generic/dia_RoutineCtrlGetProcStatByProcessname.h"
#endif

#if 0
#ifndef __INCLUDED_DIA_IOCTRL_DISPLAY_WHITE_POINT_CONTROL__
#include "project/services/production/dia_IOCtrlDisplayWhitePointControl.h"
#endif


#ifndef DIA_ROUTINECTRLWHITEPOINTDATATONOR_H_
#include "project/services/production/dia_RoutineCtrlWhitePointDataToNOR.h"
#endif
#endif
#ifndef DIA_IOCTRL_EXTERNAL_SWITCH_WAKEOUT_H_
#include "project/services/production/dia_IOCtrlExternalSwitchWakeOut.h"
#endif

#ifndef DIA_SRVHANDLER_READINPUTHDLPRESSEDKEYPRJ_H_
#include "project/services/production/dia_SrvHandler_ReadInputHdlPressedKeyPrj.h"
#endif
#define DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT              "/opt/bosch/base/bin/diag_checksumproxy.sh"

using namespace dia;

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginProductionServices)

//-----------------------------------------------------------------------------

dia_FactoryPluginProductionServices::dia_FactoryPluginProductionServices ( void )
   : dia_FactoryPlugin("dia_FactoryPluginProductionServices",DIA_EN_FACTORY_PLUGIN_TYPE_PRODUCTION_SERVICES),
     mpIOCtrlMgr(0),
     mpRCtrlMgr(0),
     pEngineCustomer(0)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginProductionServices::~dia_FactoryPluginProductionServices ( void )
{
   /*(void) tearDownObjects();*/
   mpIOCtrlMgr = 0;
   mpRCtrlMgr = 0 ;
}

//-----------------------------------------------------------------------------
/*lint -save -e750 */
/* gib2hi: macro 'macro_name' not referenced, but we are defining utility macros in this file to be used now or in future */
#define ADD_NEW_SRVHDL(className) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className());

#define ADD_NEW_SRVHDL_NAME_SID_SUBID(className,name,sid,subid) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU8) subid));

#define ADD_NEW_SRVHDL_DID(className,did) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className((tU8) did));

#define ADD_NEW_SRVHDL_01_PARAM(className,para) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(para));

#define ADD_NEW_SRVHDL_NAME_SID_ARGLIST(className,name,sid,...) \
      {                                                     \
         static const intptr_t args[] = __VA_ARGS__ ;           \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid), (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
      }

#define ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(className,name,sid,did,...) \
      {                                                     \
         static const intptr_t args[] = __VA_ARGS__ ;           \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU16) did), (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
      }

#define ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(className,name,sid,did,propID) \
      {                                                     \
         static const intptr_t args[] = {(intptr_t) propID};              \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU16) did, (tU32) propID), (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
      }

#define ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(className,name,sid,did,para,...) \
      {                                                     \
         static const intptr_t args[] = __VA_ARGS__ ;           \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU16) did, para), (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
      }

#define ADD_SRVHDL_FOR_SPECIFIC_SESSION(obj,sessionVec) \
      (void) pEngineCustomer->bAddServiceHandler(obj, (tU16) (sizeof(sessionVec)/sizeof(tU8)), (tU8*) sessionVec); \

#define ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(className,name,sid,did,propID,supportMask) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU8) did, propID, supportMask));

#define ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_THREE_PARAM_ARGLIST(className,name,sid,did,propID,supportMask,testCondition,...) \
      {                                                     \
         static const intptr_t args[] = __VA_ARGS__ ;           \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU8) did, propID, supportMask, testCondition), (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
      }

#define ADD_SRVHDL_NISSAN_02(className,name,sid,did,supportMask) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU8) did, supportMask));

#define ADD_SRVHDL_NISSAN_03(className,sid,did,propID,supportMask) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(sid, (tU8) did, propID, supportMask));

#define ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(obj,sessionVec,...) \
      {                                                     \
         static const intptr_t args[] = __VA_ARGS__ ;           \
		 (void) pEngineCustomer->bAddServiceHandler(obj, (tU16) (sizeof(sessionVec)/sizeof(tU8)), (tU8*) sessionVec, (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
	  }

//---------------------------------------------------------------------------------------------------------------
/********************************************* Routine Controls Macros *****************************************/
//---------------------------------------------------------------------------------------------------------------
#define ADD_ROUTINE(className) \
   { \
      className* pRoutine = OSAL_NEW className; \
      if ( pRoutine ) \
      { \
         (tVoid) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

#define ADD_ROUTINE_WITH_INITIALIZER(className) \
   { \
      className* pRoutine = OSAL_NEW className; \
      if ( pRoutine ) \
      { \
         pRoutine->vInit(); \
         (tVoid) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

#define ADD_ROUTINE_FINGERPRINT(className,name,did,data) \
   { \
      className* pRoutine = OSAL_NEW className(name,did); \
      if ( pRoutine ) \
      { \
         (tVoid) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
         pRoutine->loadFingerprintInfo(data, sizeof(data)/sizeof(dia_FingerprintInfo)); \
      } \
   }

#define ADD_ROUTINE_NAME_DID(className,name,did) \
   { \
      className* pRoutine = OSAL_NEW className(name,did); \
      if ( pRoutine ) \
      { \
         (void) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

#define ADD_ROUTINE_NAME_DID_ID(className,name,did,id) \
   { \
      className* pRoutine = OSAL_NEW className(name,did,id); \
      if ( pRoutine ) \
      { \
         (void) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

   #define ADD_ROUTINE_NAME_DID_ID_STRING(className,name,did,id,script) \
   { \
      className* pRoutine = OSAL_NEW className(name,did,id, script); \
      if ( pRoutine ) \
      { \
         (void) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }

#define ADD_ROUTINE_NAME_DID_ID_CMD(className,name,did,id,cmd) \
   { \
      className* pRoutine = OSAL_NEW className(name,did,id,cmd); \
      if ( pRoutine ) \
      { \
         (void) mpRCtrlMgr->addRoutine(pRoutine); \
         mRoutineRep.push_back(pRoutine); \
      } \
   }
//---------------------------------------------------------------------------------------------------------------
/********************************************* IO Controls Macros *****************************************/
//---------------------------------------------------------------------------------------------------------------

#define ADD_SIGNAL(className) \
   { \
      className* pSignal = OSAL_NEW className; \
      (void) mpIOCtrlMgr->addSignal(pSignal); \
      mSignalRep.push_back(pSignal); \
   }

//-----------------------------------------------------------------------------

#define ADD_SIGNAL_WITH_ONE_PARAM(className,classParam) \
   { \
      className* pSignal = OSAL_NEW className(classParam); \
      (void) mpIOCtrlMgr->addSignal(pSignal); \
      mSignalRep.push_back(pSignal); \
   }

//---------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginProductionServices::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginProductionServices::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF PRODUCTION SERVICES FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   static tU8 arSessionsProdADR[]  = { 0x61 };
   static tU8 arSessionsProd[]     = { 0x60 };
   static tU8 arSessionsCust_Prog_ProdADR[]     = { 0x02, 0x03, 0x60, 0x61 };
   static tU8 arVariantCoding[32] = {
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
   };

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
	   //-----------------------------------------------------------------------------
	   /******************************IOCTRL Services *******************************/
	   //-----------------------------------------------------------------------------

      // get the pointer to the IOCtrl manager
      mpIOCtrlMgr = dia_IOCtrlManager::getInstance();
      if ( !mpIOCtrlMgr ) {
         DIA_TR_ERR("dia_FactoryPluginProductionServices::setup(DIA_EN_INITLEVEL_0) - creation of input/output control manager failed !!");
         return DIA_FAILED;
      }

	   //-----------------------------------------------------------------------------
	   /***************************  ROUTINE CTRL Services **************************/
	   //-----------------------------------------------------------------------------
      // get the pointer to the routine control manager
      mpRCtrlMgr = dia_RoutineCtrlManager::getInstance();
      if ( !mpRCtrlMgr ) {
         DIA_TR_ERR("dia_FactoryPluginRoutineControls::setup(DIA_EN_INITLEVEL_0) - creation of routine control manager failed !!");
         return DIA_FAILED;
      }

	   //-----------------------------------------------------------------------------
	   /***********************  Read and Write Services Services *******************/
	   //-----------------------------------------------------------------------------
      //dia_EngineServer* pEngineCustomer = 0;
      if ( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngineCustomer) != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO CUSTOMER DIAGNOSIS ENGINE #####");
         return DIA_FAILED;
      }
   }

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {

	   //-----------------------------------------------------------------------------
	   /******************************IOCTRL Services *******************************/
	   //-----------------------------------------------------------------------------
      if  ( mpIOCtrlMgr )
      {
         DIA_TR_INF("###############################################");
         DIA_TR_INF("# ADDING IO CONTROL SIGNALS");
         DIA_TR_INF("###############################################");

#ifndef __DIA_UNIT_TESTING__
         //lint -e429 custodial pointer is freed by this factory class
#if 0 //STC2HI
         ADD_SIGNAL(dia_IOCtrl_PressedKey)
         ADD_SIGNAL(dia_IOCtrlGNSSPositioningSystem)
         ADD_SIGNAL(dia_IOCtrl_PlayedTrack)
#endif //STC2HI
         ADD_SIGNAL(dia_IOCtrlRVCControlLine)
         ADD_SIGNAL(dia_IOCtrlCDResetLine)
         ADD_SIGNAL(dia_IOCtrl_KeyIllumination)
         ADD_SIGNAL(dia_IOCtrlCompressedAudioTitle)
         ADD_SIGNAL(dia_IOCtrlHmiRemoteControl)
         ADD_SIGNAL(dia_IOCtrlDisplayTestPatternAIVI) //AIVI
         ADD_SIGNAL(dia_IOCtrlFanSpeed) // FanSpeed
         ADD_SIGNAL(dia_IOCtrlTunerAMFM_SelectActiveTuner)
         ADD_SIGNAL(dia_IOCtrlTunerAMFM_Frequency)
         ADD_SIGNAL(dia_IOCtrlTunerAMFM_Band)
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlTunerAMFM_Antenna_PowerSupply,DIA_EN_ANTENNA_1)
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlTunerAMFM_Antenna_PowerSupply,DIA_EN_ANTENNA_2)
         ADD_SIGNAL(dia_IOCtrlTunerDAB_Antenna_1_PowerSupply)
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
         ADD_SIGNAL(dia_IOCtrlTunerDAB_Antenna_1_EnsembleFrequency)
         ADD_SIGNAL(dia_IOCtrlTunerDAB_Antenna_1_ServiceID)
#endif
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlUSB_PowerSupply,USB_DEVICE_1)
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlUSB_PowerSupply,USB_DEVICE_2)
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlUSB_PowerSupply,USB_DEVICE_3)
         ADD_SIGNAL(dia_IOCtrlDisplayBrightness)
         ADD_SIGNAL(dia_IOCtrlCDModeControl)
         ADD_SIGNAL(dia_IOCtrlSystemHmiOn)
         ADD_SIGNAL(dia_IOCtrlDatasetBlockSize)
         ADD_SIGNAL(dia_IOCtrlAudioExtOutTelMode)
         ADD_SIGNAL(dia_IOCtrlAudioExtOutHfVr)
         ADD_SIGNAL(IOCtrlAudioSinkSet)

         ADD_SIGNAL(dia_IOCtrlGNSSPositioningSystem)
         ADD_SIGNAL(dia_IOCtrlTunerXM_1_Channel)
         ADD_SIGNAL(dia_IOCtrlActiveVideoSource)
         ADD_SIGNAL(dia_IOCtrlHMILanguage_set)
         //ADD_SIGNAL(dia_IOCtrlInputHdlPressedKeyPrj)
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
          ADD_SIGNAL(dia_IOCtrlExtOutSpare3)
#endif

         ADD_SIGNAL(dia_IOCtrlAudioSourceSet)
         ADD_SIGNAL(dia_IOCtrl_KeyIlluminationPWM)

         ADD_SIGNAL(dia_IOCtrlAudioGain)
         ADD_SIGNAL(dia_IOCtrlAudioTestTone)
         ADD_SIGNAL(dia_IOCtrlAudioBalance)
         ADD_SIGNAL(dia_IOCtrlAudioFader)
         ADD_SIGNAL(dia_IOCtrlAudioLinearMode)
         ADD_SIGNAL(dia_IOCtrlBtModuleReset)
         ADD_SIGNAL(dia_IOCtrlWifiModuleReset)
         ADD_SIGNAL(dia_IOCtrlBluetoothMode)
         ADD_SIGNAL(dia_IOCtrlExternalAmplifierControlLine)
         ADD_SIGNAL(dia_IOCtrlTunerDRM_Antenna_ServiceID)
         ADD_SIGNAL(dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency)
         ADD_SIGNAL(dia_IOCtrlInputHdlPressedKeyPrj)
         //ADD_SIGNAL(dia_IOCtrlBuzzer)
         //ADD_SIGNAL(dia_IOCtrlDVDSetMenuPlayBackControl)
         //ADD_SIGNAL(dia_IOCtrlDVDRequestDirectSearch)
		 //ADD_SIGNAL(dia_IOCtrlDVDDirectNumber)
		 ADD_SIGNAL(dia_IOCtrlExternalSwitchWakeOut)
#if 0
#if defined(VARIANT_S_FTR_ENABLE_NPIVI) || (defined(VARIANT_S_FTR_ENABLE_RNAIVI) && !defined(VARIANT_S_FTR_ENABLE_RIVIE))
         ADD_SIGNAL(dia_IOCtrlDTVInternalTestScreenMode)
		 ADD_SIGNAL(dia_IOCtrlDTVTuner_SetPhysicalChannel)
		 ADD_SIGNAL(dia_IOCtrlDTVSetSystem)
		 ADD_SIGNAL(dia_IOCtrlDTVModuleReset)
		 ADD_SIGNAL(dia_IOCtrlDTVSetParameter)
#endif


#ifdef VARIANT_S_FTR_ENABLE_NPIVI
         ADD_SIGNAL(dia_IOCtrlDisplayWhitePointControl)
#endif
#endif

#if 0 //STC2HI
         ADD_SIGNAL_WITH_INITIALIZER(dia_IOCtrlBluetoothMode)
         ADD_SIGNAL_WITH_INITIALIZER(dia_IOCtrlBluetoothModuleReset)
         //ADD_SIGNAL(dia_IOCtrlMicrophonePowerSupply)
#endif //STC2HI
         //lint +e429 custodial pointer is freed by this factory class
#else    //__DIA_UNIT_TESTING__
         //only one example
         ADD_SIGNAL(dia_IOCtrlTunerDAB_Antenna_1_EnsembleFrequency)
#endif

         dia_EngineServer* pEngine = 0;
         tDiaResult queryEngineRet;
         if ( ((queryEngineRet = getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine)) == DIA_SUCCESS) &&
              (NULL!=pEngine) )
         {
            pEngine->getSessionController()->addListener(mpIOCtrlMgr);
         }
         else
         {
            if (DIA_SUCCESS!=queryEngineRet)    DIA_TR_INF("dia_FactoryPluginIOControls::setup queryEngine failed");
            else if (NULL==pEngine)             DIA_TR_INF("dia_FactoryPluginIOControls::setup pEngine is NULL.");
         }
      }

	   //-----------------------------------------------------------------------------
	   /**************************Routine Control Services **************************/
	   //-----------------------------------------------------------------------------

      if ( mpRCtrlMgr )
      {
    	  using namespace dia;

          DIA_TR_INF("###############################################");
          DIA_TR_INF("# ADDING PRODUCTION ROUTINE CONTROL OBJECTS");
          DIA_TR_INF("###############################################");

          ADD_ROUTINE(dia::RoutineCtrlGNSSCalcAndVerifyChecksum)
          ADD_ROUTINE(dia::RoutineCtrlIPODSelfTest)
          ADD_ROUTINE(dia_RoutineCtrlLcmStartAlternativeSoftware)

          ADD_ROUTINE(dia::dia_ReadErrorStateHistoryForSWVersion)
          ADD_ROUTINE(dia::dia_ReadAverageCpuLoadForSWVersion)
          ADD_ROUTINE(dia::dia_ReadMaximumRamConsumptionForSWVersion)
          ADD_ROUTINE(dia::dia_ReadResetHistoryForSWVersion)
          ADD_ROUTINE(dia::dia_ReadResetInformationForSWVersion)
          ADD_ROUTINE(dia::dia_ReadStartupTimeStatisticForSWVersion)
          ADD_ROUTINE(dia::dia_ReadStateHistoryForSWVersion)
          ADD_ROUTINE(dia::dia_ReadSystemOperationTimeForSWVersion)
          ADD_ROUTINE(dia::dia_ReadWakeupHistoryForSWVersion)

          ADD_ROUTINE(dia::RoutineCtrlSetSystemToDeliveryState)
          ADD_ROUTINE(dia::RoutineCtrlStartSoftwareUpdate)
          ADD_ROUTINE(dia::RtCtrlAccSelftest)
          ADD_ROUTINE(dia::RtCtrlCDDriveSelftest)
          ADD_ROUTINE(dia::RtCtrlGetWifiSNR)
          ADD_ROUTINE(dia::RtCtrlGyroSelftest)
          ADD_ROUTINE(dia_RtCtrlSystemOperationTime_Reset)
          ADD_ROUTINE(RoutineCtrlGenerateKeyPair)
          ADD_ROUTINE(RoutineCtrlSWUPUpdateMapData)
          ADD_ROUTINE(dia_RoutineCtrlGenerateCSR)
          ADD_ROUTINE(dia_RoutineCtrlCertificateStoring)
          ADD_ROUTINE(RoutineCtrlStartSoftwareUpdateOfAllSubModules)

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
          ADD_ROUTINE(dia_RoutineCtrlTouchSelfTestPIVI)
#else
          ADD_ROUTINE(dia::RoutineCtrlTouchSelfTest)
#endif
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
//          ADD_ROUTINE(dia_RoutineCtrlWhitePointDataToNOR)
#endif
          //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID_ID(RoutineCtrlGetProcStatByProcessname,        "RoutineCtrlProcStat",           DIA_C_U16_DID_RBCM_RTCTRL_GET_PROC_STAT_BY_PROCESSNAME,  DIA_EN_RTCTRL_ID_GET_PROC_STAT_BY_PROCESSNAME)
          //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID_ID(RoutineCtrlGetProcStatMByProcessname,       "RoutineCtrlProcStatM",          DIA_C_U16_DID_RBCM_RTCTRL_GET_PROC_STATM_BY_PROCESSNAME, DIA_EN_RTCTRL_ID_GET_PROC_STATM_BY_PROCESSNAME)

          ADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlEMErase,                     "RoutineCtrlEMErase",            DIA_C_U16_DID_RBCM_RTCTRL_EM_ERASE,                   DIA_EN_RTCTRL_ID_EM_ERASE)
          ADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlEMPrint2Trace,               "RoutineCtrlEMPrint2Trace",      DIA_C_U16_DID_RBCM_RTCTRL_EM_PRINT2TRACE,             DIA_EN_RTCTRL_ID_EM_PRINT_TO_TRACE)
          ADD_ROUTINE_NAME_DID_ID(dia_tclUDS_BD_ConnectionControl,             "UDS_BD_ConnectionControl",      DIA_C_U16_DID_RBCM_RTCTRL_PHONESET_CONNECT_BT_DEVICE, DIA_EN_RTCTRL_ID_PHONE_BT_CONNECTION) //Routine contol for BT connect to Device
          ADD_ROUTINE_NAME_DID_ID(dia_tclUDS_DiagLogWriteTestResult,           "UDS_DiagLogWriteTestResult",    0x1010,                                               DIA_EN_RTCTRL_ID_SIMULATE_ITC)

          /* **************************** */
          /* FINGERPRINTS                 */
          /* **************************** */
          ADD_ROUTINE_FINGERPRINT(dia::RoutineCtrlGenericCalculateConfigFingerprint, "CMConfigFingerprint", DIA_C_U16_DID_RBCM_CM_CONFIGURATION_FINGERPRINT, aCMFingerprintData) //lint !e429: custodial pointer is freed by manager class
          ADD_ROUTINE_NAME_DID(dia_RoutineCtrlAIVICalculateConfigFingerprint,       "CustomerConfigFingerprint_withAIVISetSwitch", DIA_C_U16_DID_RBCM_CUSTOMER_CONFIG_FINGERPRINT)
          ADD_ROUTINE_NAME_DID(dia_RoutineCtrlAIVICalculateConfigFingerprint,       "CustomerDefaultConfigFingerprint_withAIVISetSwitch", DIA_C_U16_DID_RBCM_CUSTOMER_DEF_CONFIG_FINGERPRINT)

          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumNOR_RAW",            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_NOR_RAW,            DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_NOR_RAW,    DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumV850_APP",           DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_APP,           DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_V850_APP,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumV850_BOOT",          DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_BOOT,          DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_V850_BOOT,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_R",         DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_ROOT,      DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_ROOT,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FASTBOOT",      DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FASTBOOT,      DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FASTBOOT,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_RAW",           DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_RAW,           DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_RAW,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_STATIC",    DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_STATIC,    DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_STATIC,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_MAP_DATA",  DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_MAP_DATA,  DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_MAP_DATA,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          ADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_SDB",       DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_SDB,       DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_SDB,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)
          //RTC-5990073 Cleanup ActivityADD_ROUTINE_NAME_DID_ID_STRING(dia_RoutineCtrlChecksum, "ChcksumEMMC_FFS_GRACENOTE", DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_GRACENOTE, DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_GRACENOTE,   DIA_FACTORY_ROUTINE_CHECKSUM_SCRIPT)

#ifdef __ENABLE_FEATURE_RUN_IN__
          ADD_ROUTINE(dia::RoutineCtrlRunIn)
          ADD_ROUTINE(dia::RoutineCtrlRunInClearResults)
          ADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlStressTest, "dia_RoutineCtrlStressTest1",DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_1, DIA_EN_RTCTRL_ID_DIAG_STRESS_TEST_1)
          ADD_ROUTINE_NAME_DID_ID(dia::RoutineCtrlStressTest, "dia_RoutineCtrlStressTest2",DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_2, DIA_EN_RTCTRL_ID_DIAG_STRESS_TEST_2)
          ADD_ROUTINE(dia_RoutineCtrlDisplayTestScreenSlideshow)
#endif

          {
        	  using namespace dia;
        	  RoutineCtrlConfigureSecuritySettingsSCC* pRtConfigureSecuritySettingsSCC = OSAL_NEW RoutineCtrlConfigureSecuritySettingsSCC;
        	  if ( pRtConfigureSecuritySettingsSCC )
        	  {
        		  pRtConfigureSecuritySettingsSCC->setRequestedSystemSubState(DIA_EN_SPM_SUBSTATE_DIAGNOSIS_MODE);
        		  (tVoid) mpRCtrlMgr->addRoutine(pRtConfigureSecuritySettingsSCC);
        		  mRoutineRep.push_back(pRtConfigureSecuritySettingsSCC);
        	  }

        	  RoutineCtrlVerifySecuritySettingsSCC* pRtVerifySecuritySettingsSCC = OSAL_NEW RoutineCtrlVerifySecuritySettingsSCC;
        	  if ( pRtVerifySecuritySettingsSCC )
        	  {
        		  pRtVerifySecuritySettingsSCC->setRequestedSystemSubState(DIA_EN_SPM_SUBSTATE_DIAGNOSIS_MODE);
        		  (tVoid) mpRCtrlMgr->addRoutine(pRtVerifySecuritySettingsSCC);
        		  mRoutineRep.push_back(pRtVerifySecuritySettingsSCC);
        	  }
          }

		  //ADD_ROUTINE_NAME_DID(dia_RoutineCtrlCheckCryptoMaterial, "RoutineCtrlCheckCryptoMaterial", DIA_C_U16_ID_RTCTRL_CHECK_CRYPTO_MATERIAL)
		  
          (tVoid) assignInterfaceAndNotifier<dia_IRoutineControl,dia_IRoutineControlListener,dia_IRoutineControlNotifier>(mpRCtrlMgr);
      }

	   

	   
	   //-----------------------------------------------------------------------------
	   /**************************Read and Write Services ***************************/
	   //-----------------------------------------------------------------------------

      ADD_NEW_SRVHDL(dia_SrvHandler_ReadADCRefPlusActualVoltage)
      ADD_NEW_SRVHDL(dia_SrvHandler_GNSSPositioningSystem_Get)
      ADD_NEW_SRVHDL(dia_SrvHandler_ReadADR3AmpConfig)
      ADD_NEW_SRVHDL(dia_SrvHandler_AudioSourceActiveGet)
      ADD_NEW_SRVHDL(dia_SrvHandler_GNSSAntennaStatus_Get)
      ADD_NEW_SRVHDL(dia_SrvHandler_GNSSAntennaCurrent_Get)
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerDAB_Antenna1Status)
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerDAB_Antenna1Current)
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerAMFM_Antenna2Status);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerAMFM_Antenna2Current);

      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_TunerDTV_AntennaStatus,          "dia_SrvHandler_TunerDTV_Antenna1Status",                  0x22, DIA_C_U16_DID_AIVI_TUNER_DTV_ANTENNA_1_STATUS, { (intptr_t) NULL })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_TunerDTV_AntennaStatus,          "dia_SrvHandler_TunerDTV_Antenna2Status",                  0x22, DIA_C_U16_DID_AIVI_TUNER_DTV_ANTENNA_2_STATUS, { (intptr_t) NULL })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_TunerDTV_AntennaStatus,          "dia_SrvHandler_TunerDTV_Antenna3Status",                  0x22, DIA_C_U16_DID_AIVI_TUNER_DTV_ANTENNA_3_STATUS, { (intptr_t) NULL })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_TunerDTV_AntennaStatus,          "dia_SrvHandler_TunerDTV_Antenna4Status",                  0x22, DIA_C_U16_DID_AIVI_TUNER_DTV_ANTENNA_4_STATUS, { (intptr_t) NULL })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_TunerDTV_AntennaCurrent,          "dia_SrvHandler_TunerDTV_Antenna1Current",                0x22, DIA_C_U16_DID_AIVI_TUNER_DTV_ANTENNA_1_CURRENT, { (intptr_t) NULL })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_TunerDTV_AntennaCurrent,          "dia_SrvHandler_TunerDTV_Antenna2Current",                0x22, DIA_C_U16_DID_AIVI_TUNER_DTV_ANTENNA_2_CURRENT, { (intptr_t) NULL })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_TunerDTV_AntennaCurrent,          "dia_SrvHandler_TunerDTV_Antenna3Current",                0x22, DIA_C_U16_DID_AIVI_TUNER_DTV_ANTENNA_3_CURRENT, { (intptr_t) NULL })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_TunerDTV_AntennaCurrent,          "dia_SrvHandler_TunerDTV_Antenna4Current",                0x22, DIA_C_U16_DID_AIVI_TUNER_DTV_ANTENNA_4_CURRENT, { (intptr_t) NULL })
	 
      ADD_NEW_SRVHDL(dia_SrvHandler_HistoryState)
      ADD_NEW_SRVHDL(dia_SrvHandler_HistoryReset)
      ADD_NEW_SRVHDL(dia_SrvHandler_HistoryWakeup)
	  
      ADD_NEW_SRVHDL(dia_SrvHandler_PowerSupplyStatus)
	  ADD_NEW_SRVHDL(dia_SrvHandler_SDCard1MediaInfo)
      ADD_NEW_SRVHDL(dia_SrvHandler_SDCard1SlotState)
	  
	  //ADD_NEW_SRVHDL(dia_SrvHandler_InputHdlPressedKey_Get_Prj)
      ADD_NEW_SRVHDL(dia_SrvHandler_ReadInputHdlPressedKeyPrj)
      ADD_NEW_SRVHDL(dia_SrvHandler_RadioTypeApprovalModeWrite)
      ADD_NEW_SRVHDL(dia_SrvHandler_RadioTypeApprovalModeRead)
      ADD_NEW_SRVHDL(dia_SrvHandler_GetActiveALDlevel)
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency)
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerDRM_AntennaServiceID)

      ADD_NEW_SRVHDL(dia_SrvHandler_ReadEmmcJedecCidReg);
      ADD_NEW_SRVHDL(dia_SrvHandler_ReadEmmcJedecEcsdData);
      ADD_NEW_SRVHDL(dia_SrvHandler_ECUUniqueFieldDataId);
      ADD_NEW_SRVHDL(dia_SrvHandler_ReadRefreshStatusManagement);
      ADD_NEW_SRVHDL(dia_SrvHandler_ReadTotalWrittenBlockCount);
      ADD_NEW_SRVHDL(dia_SrvHandler_AverageCpuLoad);
      ADD_NEW_SRVHDL(dia_SrvHandler_MaximumRamConsumption);
      ADD_NEW_SRVHDL(dia_SrvHandler_StartupTimeStatistic);
#if 0
#if defined(VARIANT_S_FTR_ENABLE_NPIVI) || (defined(VARIANT_S_FTR_ENABLE_RNAIVI) && !defined(VARIANT_S_FTR_ENABLE_RIVIE))
      ADD_NEW_SRVHDL(dia_SrvHandler_DtvGetSystem)
      ADD_NEW_SRVHDL(dia_SrvHandler_DtvGetParam)
#endif
#endif

      ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_HistoryErrState, "SrvHandler_ReadHistoryErrState_01",     0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_01, DIA_EN_SPM_ERR_STATE_01,{ (intptr_t) DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_01 })
      ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_HistoryErrState, "SrvHandler_ReadHistoryErrState_02",     0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_02, DIA_EN_SPM_ERR_STATE_02,{ (intptr_t) DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_02 })
      ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_HistoryErrState, "SrvHandler_ReadHistoryErrState_03",     0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_03, DIA_EN_SPM_ERR_STATE_03,{ (intptr_t) DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_03 })
      ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_HistoryErrState, "SrvHandler_ReadHistoryErrState_04",     0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_04, DIA_EN_SPM_ERR_STATE_04,{ (intptr_t) DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_04 })
      ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_HistoryErrState, "SrvHandler_ReadHistoryErrState_05",     0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_05, DIA_EN_SPM_ERR_STATE_05,{ (intptr_t) DIA_PROP_CM_SPM_HISTORY_ERROR_STATE_05 })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_USB_PowerSupply,          "USB_PowerSupply_1_Read",                0x22, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_1, { (intptr_t) NULL })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_USB_PowerSupply,          "USB_PowerSupply_2_Read",                0x22, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_2, { (intptr_t) NULL })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_USB_PowerSupply,          "USB_PowerSupply_3_Read",                0x22, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_3, { (intptr_t) NULL })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_USB_PowerSupplyInfoPort,  "USB_PowerSupplyInfoPort_1",             0x22, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_1, { (intptr_t) NULL })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_USB_PowerSupplyInfoPort,  "USB_PowerSupplyInfoPort_2",             0x22, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_2, { (intptr_t) NULL })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_USB_PowerSupplyInfoPort,  "USB_PowerSupplyInfoPort_3",             0x22, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_3, { (intptr_t) NULL })

	  //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_tclUDS_BD_GetMacAddress, "UDS_BD_GetMacAddress",  0x22, DIA_C_U16_DID_RBCM_BT_MAC_ADDRESS, { (intptr_t) NULL })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_tclUDS_BD_GetLinkQuality,"UDS_BD_GetLinkQuality", 0x22, DIA_C_U16_DID_RBCM_BLUETOOTH_LINK_QUALITY, { (intptr_t) NULL })

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadExtDisplayPartNumberSNNumber",    0x22, DIA_C_U16_DID_AIVI_EXT_DISPLAY_PART_NUMBER_SN_NUMBER,  { (intptr_t) DIA_PROP_CM_AIVI_SECOND_DISPLAY_PN_AND_SN })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadExtDisplayDeviceProductionTime",  0x22, DIA_C_U16_DID_AIVI_EXT_DISPLAY_DEVICE_PRODUCTION_TIME, { (intptr_t) DIA_PROP_CM_AIVI_SECOND_DISPLAY_PROD_TIME })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadExtDisplayWhitePointCorrection",  0x22, DIA_C_U16_DID_AIVI_EXT_DISPLAY_WHITE_POINT_CORRECTION, { (intptr_t) DIA_PROP_CM_AIVI_SECOND_DISPLAY_WHITE_POINT_CORRECTION })
#endif


#ifndef VARIANT_S_FTR_ENABLE_RNAIVI
      //Scope1: GenericIdentRead for both Customer and Production
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadBTSubModuleSWVersion",            0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_SW_VERSION, { (intptr_t) DIA_PROP_VERSION_SW_BLUETOOTH })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadBTSubModuleHWVersion",            0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_HW_VERSION, { (intptr_t) DIA_PROP_VERSION_HW_BLUETOOTH })
#else
      //Scope2: separate ServiceHandlers because of different response length
      dia_SrvHandlerGenericIdentRead* pProdBTSubModuleSWVersion  = OSAL_NEW dia_SrvHandlerGenericIdentRead("SrvHandler_ReadBTSubModuleSWVersion", 0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_SW_VERSION); //DID 0x7001 - Production Session
      if(pProdBTSubModuleSWVersion)
      {
    	  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(pProdBTSubModuleSWVersion,arSessionsProd,{ (intptr_t) DIA_PROP_VERSION_SW_BLUETOOTH })
      }

      dia_SrvHandlerGenericIdentRead* pProdBTSubModuleHWVersion  = OSAL_NEW dia_SrvHandlerGenericIdentRead("SrvHandler_ReadBTSubModuleHWVersion", 0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_HW_VERSION); //DID 0x7002 - Production Session
      if(pProdBTSubModuleHWVersion)
      {
    	  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(pProdBTSubModuleHWVersion,arSessionsProd,{ (intptr_t) DIA_PROP_VERSION_HW_BLUETOOTH })
      }
#endif

      dia_SrvHandlerGenericIdentRead* p_defSystemInfo = OSAL_NEW dia_SrvHandlerGenericIdentRead("SrvHandler_ReadDefSystemInformationCommon",0x22, DIA_C_U16_DID_AIVI_DEF_SYSTEM_INFO_COMMON); //DID 0x3000 - Production Session
      if(p_defSystemInfo)
      {
    	  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(p_defSystemInfo,arSessionsProd,{ (intptr_t) DIA_PROP_AIVI_DEF_SYSTEM_INFO_COMMON })
      }

     //RTC-5990073 Cleanup Activity dia_SrvHandlerGenericIdentRead* p_defVehicleInfo = OSAL_NEW dia_SrvHandlerGenericIdentRead("SrvHandler_ReadDefVehicleInformation",0x22, DIA_C_U16_DID_AIVI_DEF_SYSTEM_VEHICLE_INFO); //DID 0x3001 - Production Session
     //RTC-5990073 Cleanup Activity if(p_defVehicleInfo)
     //RTC-5990073 Cleanup Activity {
    //RTC-5990073 Cleanup Activity	  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(p_defVehicleInfo,arSessionsProd,{ (intptr_t) DIA_PROP_AIVI_DEF_VEHICLE_INFO })
     //RTC-5990073 Cleanup Activity }

      dia_SrvHandlerGenericIdentRead* p_defCameraSystem = OSAL_NEW dia_SrvHandlerGenericIdentRead("SrvHandler_ReadDefCameraSystem",0x22, DIA_C_U16_DID_AIVI_DEF_CAMERA_SYSTEM); //DID 0x3003 - Production Session
      if(p_defCameraSystem)
      {
    	  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(p_defCameraSystem,arSessionsProd,{ (intptr_t) DIA_PROP_AIVI_DEF_CAMERA_SYSTEM })
      }

      dia_SrvHandlerGenericIdentADCRead* p_AdcInfo = OSAL_NEW dia_SrvHandlerGenericIdentADCRead("SrvHandler_ADC_02",0x22, DIA_C_U16_DID_RBCM_ADC_AMP_CLIP_VOLTAGE); //DID 0x1102 -Production Session
      if(p_AdcInfo)
      {
    	  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(p_AdcInfo,arSessionsProd,{ (intptr_t) DIA_PROP_CM_ADC_DEVICE_AMP_CLIP })
      }
      dia_tclUDS_BD_GetMacAddress* p_getBTMacAddr = OSAL_NEW dia_tclUDS_BD_GetMacAddress("UDS_BD_GetMacAddress",  0x22, DIA_C_U16_DID_RBCM_BT_MAC_ADDRESS); //DID 0x7008 - Production Session
      if(p_getBTMacAddr)
      {
    	  ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_getBTMacAddr,arSessionsProd)
      }

      dia_tclUDS_WIFI_GetMacAddress* p_getWIFIMacAddr = OSAL_NEW dia_tclUDS_WIFI_GetMacAddress("UDS_WIFI_GetMacAddress",  0x22, DIA_C_U16_DID_RBCM_WIFI_MAC_ADDRESS); //DID 0x7009 - Production Session
      if(p_getBTMacAddr)
      {
    	  ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_getWIFIMacAddr,arSessionsProd)
      }

      dia_SrvHandler_WireDimmingInfo_Get* p_WireDimmingInfoRead = OSAL_NEW dia_SrvHandler_WireDimmingInfo_Get(); //DID 0x1007 - Production Session
      if(p_WireDimmingInfoRead)
      {
    	  ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_WireDimmingInfoRead,arSessionsProd)
      }
#if 1
      dia_SrvHandlerGenericIdentRead* p_KdsProductionTimeRead = OSAL_NEW dia_SrvHandlerGenericIdentRead("SrvHandler_ReadDeviceProductionTime",0x22, DIA_C_U16_DID_RBCM_DEVICE_PRODUCTION_TIME); //DID 0xD010 - Production Session
      if(p_KdsProductionTimeRead)
      {
    	  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(p_KdsProductionTimeRead,arSessionsProd,{ (intptr_t) DIA_PROP_PRODUCTION_TIME })
      }
#endif

     ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_AuxIn_Get(), arSessionsProd)
     //RTC-5990073 Cleanup Activity dia_SrvHandlerGenericIdentRead* p_ReadILLUM = OSAL_NEW dia_SrvHandlerGenericIdentRead("SrvHandler_ReadILLUM",0x22, DIA_C_U16_DID_RBCM_GPIO_ILLUMINATION_SWITCH); //DID 0x1005 - Production Session
     //RTC-5990073 Cleanup Activity if(p_ReadILLUM)
     //RTC-5990073 Cleanup Activity {
     //RTC-5990073 Cleanup Activity	  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(p_ReadILLUM,arSessionsProd,{ (intptr_t) DIA_PROP_GPIO_ILLUM })
     //RTC-5990073 Cleanup Activity }

      //RTC-5990073 Cleanup Activitydia_SrvHandlerGenericIdentRead* p_ConfigPartsNumber = OSAL_NEW dia_SrvHandlerGenericIdentRead("SrvHandler_ReadDefConfigurationPartNumber",0x22, DIA_C_U16_DID_AIVI_DEF_CONFIG_PARTS_NUMBER); //DID 0x3004 - Production Session for scope 1&2
      //RTC-5990073 Cleanup Activityif(p_ConfigPartsNumber)
      //RTC-5990073 Cleanup Activity{
    	//RTC-5990073 Cleanup Activity  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(p_ConfigPartsNumber,arSessionsProd, { (intptr_t) DIA_PROP_AIVI_DEF_CONFIG_PARTS_NUMBER })
      //RTC-5990073 Cleanup Activity}
      //RTC-5990073 Cleanup Activitydia_SrvHandlerGenericIdentRead* p_ConfigHashValueRead = OSAL_NEW dia_SrvHandlerGenericIdentRead("SrvHandler_ReadConfigHashValue",0x22, DIA_C_U16_DID_AIVI_DEF_CONFIG_HASH_VALUE); //DID 0x3005
      //RTC-5990073 Cleanup Activityif(p_ConfigHashValueRead)
      //RTC-5990073 Cleanup Activity{
    	//RTC-5990073 Cleanup Activity  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(p_ConfigHashValueRead,arSessionsProd,{ (intptr_t) DIA_PROP_AIVI_DEF_CONFIG_HASH_VALUE  })
      //RTC-5990073 Cleanup Activity}

      ADD_NEW_SRVHDL(dia_SrvHandler_WireSpeedInformation_Get)
      ADD_NEW_SRVHDL(dia_SrvHandler_Disp_BrightnessInfo_Get)
      ADD_NEW_SRVHDL(dia_SrvHandler_KeyB_BrightnessInfo_Get)

      ADD_NEW_SRVHDL(dia_SrvHandler_GetSystemOperationTime)

      ADD_NEW_SRVHDL(dia_SrvHandler_RVC_ControlLineCurrent)
      ADD_NEW_SRVHDL(dia_SrvHandler_RVC_ControlLineStatus)

      ADD_NEW_SRVHDL(dia_SrvHandler_TunerAMFM_SelectActiveTuner);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerAMFM_Frequency);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerAMFM_Band);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerAMFM_Fieldstrength);
	  ADD_NEW_SRVHDL(dia_SrvHandler_TunerAMFM_Antenna1Status);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerAMFM_Antenna1Current);
      ADD_NEW_SRVHDL(dia_SrvHandler_InputHdlTouchPanelStatus_Get);
     ADD_NEW_SRVHDL(dia_SrvHandler_GNSSSatellitesSignalQuality_Get)
      ADD_NEW_SRVHDL(dia_SrvHandler_GNSSReceiverStatus_Get)
      ADD_NEW_SRVHDL(dia_SrvHandler_WireSpeedInformationGPIO)

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerDAB_Antenna1EnsembleFrequency);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerDAB_Antenna1ServiceID);
#endif
      ADD_NEW_SRVHDL(dia_SrvHandler_SystemHmiOnGet);
      ADD_NEW_SRVHDL(dia_SrvHandler_GNSSReceiverFirmwareVersion_Get)
      ADD_NEW_SRVHDL(dia_SrvHandler_InputHdlEncoder1CounterValue_Get);
      ADD_NEW_SRVHDL(dia_SrvHandler_InputHdlEncoder2CounterValue_Get);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerXM_Channel);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerXM_SignalQuality);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerXM_AntennaStatus);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerXM_UPC);
      ADD_NEW_SRVHDL(dia_SrvHandler_TunerXM_BER);

      //ADD_NEW_SRVHDL(dia_SrvHandler_OpticaldriveLoaderstatusAIVI);

      ADD_NEW_SRVHDL(dia_SrvHandler_WriteADCRefPlusActualVoltage);
      ADD_NEW_SRVHDL(dia_SrvHandler_ReadADCRefPlusActualVoltage);
      //ADD_NEW_SRVHDL(dia_SrvHandler_DtvMonitorStatus)
#if 0
      ADD_NEW_SRVHDL(dia_SrvHandler_DtvHwVersion)
      ADD_NEW_SRVHDL(dia_SrvHandler_DtvSwVersion)
      ADD_NEW_SRVHDL(dia_SrvHandler_DtvBootVersion)
      ADD_NEW_SRVHDL(dia_SrvHandler_DtvFpgaSwVersion)
#endif
      //ADD_NEW_SRVHDL(dia_SrvHandler_DvdDriveSwVersion)

      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadCPLDVersion",             0x22, DIA_C_U16_DID_CPLD_VERSION, { (intptr_t) DIA_PROP_VERSION_CPLD_VERSION })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadACC",                     0x22, DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_ACC, { (intptr_t) DIA_PROP_GPIO_ACC })
#if ((defined(VARIANT_S_FTR_ENABLE_RIVIE)) && (!defined(VARIANT_S_FTR_ENABLE_NPIVI)))
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadSpare2",                  0x22, DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_ACC_SPARE2, { (intptr_t) DIA_PROP_GPIO_EXT_IN_SPARE2 })//Renault Specific
#endif
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadReverseGear",             0x22, DIA_C_U16_DID_RBCM_GPIO_REVERSEGEAR, { (intptr_t) DIA_PROP_GPIO_REVERSE_GEAR })

      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadImmobilizer",             0x22, 0x3200, { (intptr_t) DIA_PROP_CM_IMMOBILIZER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadIgnition",                0x22, DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_IGNTION, { (intptr_t) DIA_PROP_GPIO_IGNITION })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadADR3HWVersion",           0x22, 0x7011, { (intptr_t) DIA_PROP_VERSION_HW_ADR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadADR3SWVersion",           0x22, 0x7010, { (intptr_t) DIA_PROP_VERSION_SW_ADR })
     //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadParkingBrake",            0x22, DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_PARKING_BRAKE, { (intptr_t) DIA_PROP_GPIO_PARKING_BRAKE })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadThermalTempThresholds",   0x22, DIA_C_U16_DID_RBCM_THERMAL_MGNT_TEMPERATURE_THRESHOLDS, { (intptr_t) DIA_PROP_THERMALMNGMT_TEMPERATURE_THRESHOLDS })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadBTName",                  0x22, DIA_C_U16_DID_RBCM_BT_NAME, { (intptr_t) DIA_PROP_CM_BT_NAME })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadBTWifiName_1",            0x22, DIA_C_U16_DID_RBCM_WIFI_NAME_1, { (intptr_t) DIA_PROP_CM_WIFI_NAME_1 })
     //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadBTWifiName_2",            0x22, DIA_C_U16_DID_RBCM_WIFI_NAME_2, { (intptr_t) DIA_PROP_CM_WIFI_NAME_2 })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_CustomerSWVersion_Read",      0x22, DIA_C_U16_DID_CM_CUSTOMER_SOFTWARE_VERSION, { (intptr_t) DIA_PROP_VERSION_SW_CUSTOMER })
      
      ////////////////////////////////////////////////////////////////////////////
      //
      // Service 0x22 (read data by identifier - Implement service for Production related Identification and configuration data)
      //
      ////////////////////////////////////////////////////////////////////////////
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadLastDiagnosisError,"SrvHandler_ReadLastDiagnosisError",         0x22, DIA_C_U16_DID_LAST_DIAG_ERROR,                      { (intptr_t) DIA_PROP_CM_CONFIG_LAST_DIAG_ERROR })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadAnonymousVIN,      "SrvHandler_ReadAnonymousVIN",               0x22, DIA_C_U16_DID_VIN_WMI_AND_VDS,                      { (intptr_t) NULL })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadAIVIVariantCoding",               0x22, DIA_C_U16_DID_AIVI_VARIANT_CODING, { (intptr_t) DIA_PROP_AIVI_VARIANT_CODING })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSCCSoftwareVersion",              0x22, DIA_C_U16_DID_SCC_APP_SW_VERSION,  { (intptr_t) DIA_PROP_CM_VERSION_SW_SCC })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSCCBLSoftwareVersion",            0x22, DIA_C_U16_DID_SCC_BL_SW_VERSION,   { (intptr_t) DIA_PROP_CM_VERSION_BL_SCC })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSCCBMSoftwareVersion",            0x22, DIA_C_U16_DID_SCC_BM_SW_VERSION,   { (intptr_t) DIA_PROP_CM_VERSION_BM_SCC })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSCCSoftwareVersionLabel",         0x22, DIA_C_U16_DID_SCC_APP_SW_VERSION_LABEL,{ (intptr_t) DIA_PROP_CM_VERSION_LABEL_SW_SCC })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSCCBLSoftwareVersionLabel",       0x22, DIA_C_U16_DID_SCC_BL_SW_VERSION_LABEL,{ (intptr_t) DIA_PROP_CM_VERSION_LABEL_BL_SCC })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSCCBMSoftwareVersionLabel",       0x22, DIA_C_U16_DID_SCC_BM_SW_VERSION_LABEL,{ (intptr_t) DIA_PROP_CM_VERSION_LABEL_BM_SCC })

      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadWORM_ID",                         0x22, DIA_C_U16_DID_WORM_ID, { (intptr_t) DIA_PROP_VERSION_DATACARRIER_WORM_ID })

      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadAudioSourceOffsetIn",             0x22, DIA_C_U16_DID_AIVI_AUDIO_SOURCE_OFFSET_IN,    { (intptr_t) DIA_PROP_AID_AUDIO_SOURCE_OFFSET })

      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadDrmTunerParameterSetPD",          0x22, DIA_C_U16_DID_RBCM_DRM_TUNER_PARAMETER_SET,   { (intptr_t) DIA_PROP_CM_DRM_TUNER_PARAMETER_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadDrmTunerParameterSet",            0x22, DIA_C_U16_DID_AIVI_DRM_TUNER_PARAMETER_SET,   { (intptr_t) DIA_PROP_CM_DRM_TUNER_PARAMETER_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadEarlyConfig_Display",             0x22, DIA_C_U16_DID_RBCM_EARLY_CONFIG_DISPLAY,      { (intptr_t) DIA_PROP_CM_EARLY_CONFIG_DISPLAY })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadEarlyConfig_TwoDisplay",          0x22, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TWO_DISPLAY,  { (intptr_t) DIA_PROP_CM_EARLY_CONFIG_TWO_DISPLAY })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadEarlyConfig_TouchDriver",         0x22, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER, { (intptr_t) DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadEarlyConfig_TouchDriver2",        0x22, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER_2,{ (intptr_t) DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER2 })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadDimmingParametSet",               0x22, DIA_C_U16_DID_RBCM_DIMMING_PARAMETER_SET,     { (intptr_t) DIA_PROP_CM_DIMMING_PARAMETER_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadKeyIlluminationAlignmentCoeff",   0x22, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_ALIGNMENT, { (intptr_t) DIA_PROP_CM_KEY_ILLUMINATION_ALIGNMENT_COEFF })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadKeyIlluminationAlignmentCoeff2",  0x22, DIA_C_U16_DID_AIVI_KEY_ILLUMINATION_ALIGNMENT_2, { (intptr_t) DIA_PROP_AIVI_KEY_ILLUMINATION_ALIGNMENT_COEFF2 })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadDispIlluminationAlignmentCoeff",  0x22, DIA_C_U16_DID_AIVI_DISP_ILLUMINATION_ALIGNMENT, { (intptr_t) DIA_PROP_AIVI_DISP_ILLUMINATION_ALIGNMENT_COEFF })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadInputKeyMappingTable_1",          0x22, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_ONE,   { (intptr_t) DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_ONE })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadInputKeyMappingTable_2",          0x22, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_TWO,   { (intptr_t) DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_TWO })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadInputKeyMappingTable_3",          0x22, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_THREE, { (intptr_t) DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_THREE })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadInputKeyMappingTable_4",          0x22, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_FOUR,  { (intptr_t) DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_FOUR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadCustomerECUPartNumber",           0x22, DIA_C_U16_DID_RBCM_CUSTOMER_ECU_PART_NUMBER,  { (intptr_t) DIA_PROP_CM_CUSTOMER_ECU_PART_NR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadSWUPD_VariantInfo",               0x22, DIA_C_U16_DID_RBCM_CUSTOMER_SWUP_VARIANT_INFO,{ (intptr_t) DIA_PROP_SW_UPD_VARIANT_INFO })
	  //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadSystemFanConfig",                 0x22, DIA_C_U16_DID_AIVI_SYSTEM_FAN_CONFIG,{ (intptr_t) DIA_PROP_AIVI_SYSTEM_FAN_CONFIG })
      
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadGenTunerParamSet",                0x22, DIA_C_U16_DID_RBCM_GENERIC_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_GENERIC_TUNER_PARAM_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadAntennaParamSet",                 0x22, DIA_C_U16_DID_RBCM_ANTENNA_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_ANTENNA_PARAMETER_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadFmAmTunerParamSet",               0x22, DIA_C_U16_DID_RBCM_FM_AM_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_FM_AM_TUNER_PARAMETER_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadDAB_Parameter_Set",               0x22, DIA_C_U16_DID_RBCM_DAB_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_DAB_TUNER_PARAMETER_SET })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadCMVariantCoding",                 0x22, DIA_C_U16_DID_CM_VARIANT_CODING, { (intptr_t) DIA_PROP_CM_VARIANT_CODING })
	  #if 0
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadCMVariantCoding",                 0x22, DIA_C_U16_DID_CM_VARIANT_CODING, { (intptr_t) DIA_PROP_CM_VARIANT_CODING })
	  #endif
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadSensorConfigurationGyro",         0x22, DIA_C_U16_DID_SENSOR_CONFIGURATION_GYRO, { (intptr_t) DIA_PROP_CM_SENSOR_CONFIG_GYRO })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadSensorConfigurationACC",          0x22, DIA_C_U16_DID_SENSOR_CONFIGURATION_ACC, { (intptr_t) DIA_PROP_CM_SENSOR_CONFIG_ACC })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadConfigInfo",                      0x22, DIA_C_U16_DID_CM_CONFIGURATION_INFO, { (intptr_t) DIA_PROP_CM_CONF_INFO })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadNaviDefaultPosition",             0x22, DIA_C_U16_DID_NAV_DEFAULT_POSITION, { (intptr_t) DIA_PROP_CM_NAVIGATION_DEFAULT_POSITION })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadSensorConfigurationGNSS",         0x22, DIA_C_U16_DID_SENSOR_CONFIGURATION_GNSS, { (intptr_t) DIA_PROP_CM_SENSOR_CONFIG_GNSS })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadNavDataCopyProtectionSecEccKey",  0x22, DIA_C_U16_DID_NAV_DATA_COPY_PROTECTION_SEC_ECC_KEY, { (intptr_t) DIA_PROP_CM_NAVI_DATA_SEC_KEY })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadHDParameterSet",                  0x22, DIA_C_U16_DID_RBCM_HD_PARAMETER_SET,                { (intptr_t) DIA_PROP_CM_HD_PARAMETER_SET })

      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefSensorConfigGyro",             0x22, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GYRO, { (intptr_t) DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GYRO })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefSensorConfigGNSS",             0x22, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GNSS, { (intptr_t) DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GNSS })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefSensorConfigACC",              0x22, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_ACC, { (intptr_t) DIA_PROP_AIVI_DEF_SENSOR_CONFIG_ACC })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefFMAMTunerParameterSet",        0x22, DIA_C_U16_DID_AIVI_DEF_FMAM_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_FMAM_TUNER_PARAM_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefAntennaParameterSet",          0x22, DIA_C_U16_DID_AIVI_DEF_ANTENNA_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_ANTENNA_PARAM_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefDABParameterSet",              0x22, DIA_C_U16_DID_AIVI_DEF_DAB_SET, { (intptr_t) DIA_PROP_AIVI_DEF_DAB_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefGenericTunerParameterSet",     0x22, DIA_C_U16_DID_AIVI_DEF_GENERIC_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_GENERIC_TUNER_PARAM_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefHDParameterSet",               0x22, DIA_C_U16_DID_AIVI_DEF_HD_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_HD_PARAM_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericWIFINameRead,"SrvHandler_ReadDefWifiName",                     0x22, DIA_C_U16_DID_AIVI_DEF_WIFI_NAME, { (intptr_t) DIA_PROP_AIVI_DEF_WIFI_NAME_1, (intptr_t) DIA_PROP_AIVI_DEF_WIFI_NAME_2 })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefAcousticParam",                0x22, DIA_C_U16_DID_AIVI_DEF_ACOUSTIC_PARAM, { (intptr_t) DIA_PROP_AIVI_DEF_ACOUSTIC_PARAM })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefPhoneECNRWBS",                 0x22, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_WBS, { (intptr_t) DIA_PROP_AIVI_DEF_PHONE_ECNR_WBS })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefPhoneECNRNBS",                 0x22, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_NBS, { (intptr_t) DIA_PROP_AIVI_DEF_PHONE_ECNR_NBS })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefAntiThefMapSelection",         0x22, DIA_C_U16_DID_AIVI_DEF_ANTITHEF_MAP_SELECTION, { (intptr_t) DIA_PROP_AIVI_DEF_ANTITHEF_MAP_SELECTION })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefAudioParamSet",                0x22, DIA_C_U16_DID_AIVI_DEF_AUDIO_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_AUDIO_PARAM_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefMEXConfig",                    0x22, DIA_C_U16_DID_AIVI_DEF_MEX_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_MEX_CONFIG })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefFactoryMode",                  0x22, DIA_C_U16_DID_AIVI_DEF_FACTORY_MODE, { (intptr_t) DIA_PROP_AIVI_DEF_FACTORY_MODE })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefConnectivityConfig",           0x22, DIA_C_U16_DID_AIVI_DEF_CONNECTIVITY_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_CONNECTIVITY_CONFIG })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefHmiConfig",                    0x22, DIA_C_U16_DID_AIVI_DEF_HMI_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_HMI_CONFIG })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefSoundVolConfig",               0x22, DIA_C_U16_DID_AIVI_DEF_SOUND_VOLUME_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_SOUND_VOLUME_CONFIG })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefDrmTunerParameterSet",         0x22, DIA_C_U16_DID_AIVI_DEF_DRM_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_AIVI_DEF_DRM_TUNER_PARAMETER_SET })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefXCallConfiguration",           0x22, DIA_C_U16_DID_AIVI_DEF_XCALL_CONFIG,               { (intptr_t) DIA_PROP_AIVI_DEF_XCALL })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefST3Configuration",             0x22, DIA_C_U16_DID_AIVI_DEF_ST3_CONFIG,               { (intptr_t) DIA_PROP_AIVI_DEF_ST3 })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadECUHWVersion",                    0x22, DIA_C_U16_DID_RBCM_ECU_HW_VERSION,                  { (intptr_t) DIA_PROP_CM_ECU_HW_VERSION })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadECUSWVersion",                    0x22, DIA_C_U16_DID_RBCM_ECU_SW_VERSION,                  { (intptr_t) DIA_PROP_CM_ECU_SW_VERSION })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadECUSparePartNumber",              0x22, DIA_C_U16_DID_RBCM_ECU_SPARE_PART_NUMBER,           { (intptr_t) DIA_PROP_CM_ECU_SPARE_PART_NR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadECUSerialNumber",                 0x22, DIA_C_U16_DID_RBCM_ECU_SERIAL_NUMBER,               { (intptr_t) DIA_PROP_CM_ECU_SERIAL_NR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadNaviUnit",                        0x22, DIA_C_U16_DID_AIVI_NAVI_UNIT,                       { (intptr_t) DIA_PROP_CM_NAVI_UNIT })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadMainboardSparePartNumber",        0x22, DIA_C_U16_DID_RBCM_PCB_SPARE_PART_NUMBER,           { (intptr_t) DIA_PROP_CM_MAINBOARD_SPARE_PART_NR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadMainboardSerialNumber",           0x22, DIA_C_U16_DID_RBCM_PCB_SERIAL_NUMBER,               { (intptr_t) DIA_PROP_CM_MAINBOARD_SERIAL_NR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadECUSWBuildVersionLabel",          0x22, DIA_C_U16_DID_RBCM_ECU_SW_BUILD_VERSION_LABEL,      { (intptr_t) DIA_PROP_CM_ECU_SW_BUILD_VERSION })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadBTSubModuleHWLoaderVersion",      0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_HW_LOADER_VERSION,  { (intptr_t) DIA_PROP_VERSION_SW_BLUETOOTH_BOOTLOADER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadNavigationSWVersion",             0x22, DIA_C_U16_DID_RBCM_NAVI_SW_VERSION,                 { (intptr_t) DIA_PROP_CM_NAVIGATION_SW_VERSION })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadVariantID",                       0x22, DIA_C_U16_DID_CM_VARIANT_ID,                        { (intptr_t) DIA_PROP_CM_VARIANT_ID })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadVehicleInformation",             0x22, DIA_C_U16_DID_AIVI_SYSTEM_VEHICLE_INFO,             { (intptr_t) DIA_PROP_AIVI_VEHICLE_INFO })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSoundVolConfig",                 0x22, DIA_C_U16_DID_AIVI_SOUND_VOLUME_CONFIG,             { (intptr_t) DIA_PROP_AIVI_SOUND_VOLUME_CONFIG })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadHmiConfig",                      0x22, DIA_C_U16_DID_AIVI_HMI_CONFIG,                      { (intptr_t) DIA_PROP_AIVI_HMI_CONFIG })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadConfigPartNumber",               0x22, DIA_C_U16_DID_AIVI_CONFIG_PARTS_NUMBER,             { (intptr_t) DIA_PROP_AIVI_CONFIG_PARTS_NUMBER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSpeedLockout",                   0x22, DIA_C_U16_DID_AIVI_SPEED_LOCKOUT,                   { (intptr_t) DIA_PROP_AIVI_SPEED_LOCKOUT })
	  //Center CMC-19
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadPrivateMicSwitch",               0x22, DIA_C_U16_DID_CENTER_CMC_19_PRIVATE_MIC_SWITCH, { (intptr_t) DIA_PROP_CENTER_CMC_19_PRIVATE_MIC_SWITCH })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadWakeInStatus",                   0x22, DIA_C_U16_DID_CENTER_CMC_19_WAKEIN_STATUS, { (intptr_t) DIA_PROP_CENTER_CMC_19_WAKEIN_STATUS })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadTestModeDTM", 					 0x22, DIA_C_U16_DID_CENTER_CMC_19_TESTMODE_DTM, { (intptr_t) DIA_PROP_CENTER_CMC_19_TESTMODE_DTM })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_PDReadNVMConfiguration", 			 0x22, DIA_C_U16_DID_CENTER_CMC_19_NVM_CONFIG, { (intptr_t) DIA_PROP_CENTER_CMC_19_NVM_PNM_GROUP_10_CONFIG })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_PDReadAudioparameterset", 			 0x22, DIA_C_U16_DID_RBCM_AUDIO_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_AUDIO_PARAMETER_SET })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadAVDECCConfiguration",       	 0x22, DIA_C_U16_DID_CENTER_CMC_19_AVDECC_CONFIGURATION, { (intptr_t) DIA_PROP_CMC_AVDECC_CONFIG })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadCISConfiguration",      	     0x22, DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION,      { (intptr_t) DIA_PROP_CMC_CIS_CONFIG })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadIntercomPhoneName",      	     0x22, DIA_C_U16_DID_CENTER_CMC_19_INTERCOM_PHONE_NAME,    { (intptr_t) DIA_PROP_CMC_INTERCOM_PHONE_NAME})
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadCISConfigurationCD",      	     0x22, DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION_CD,      { (intptr_t) DIA_PROP_CMC_CIS_CONFIG_CD })
	  ////////////////////////////////////////////////////////////////////////////
	  // Center CMC-19 Service 0x2E (write data by identifier)
      //
      ////////////////////////////////////////////////////////////////////////////
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,  "SrvHandler_WriteTestModeDTM",				     0x2E, DIA_C_U16_DID_CENTER_CMC_19_TESTMODE_DTM,{ (intptr_t) DIA_PROP_CENTER_CMC_19_TESTMODE_DTM })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,  "SrvHandler_PDWriteNVMConfiguration",		     0x2E, DIA_C_U16_DID_CENTER_CMC_19_NVM_CONFIG,{ (intptr_t) DIA_PROP_CENTER_CMC_19_NVM_PNM_GROUP_10_CONFIG,(intptr_t) DIA_PROP_CENTER_CMC_19_CD_PNM_GROUP_10_CONFIG,(intptr_t) DIA_PROP_CENTER_CMC_19_NVM_PNM_GROUP_10_CONFIG_SCC })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,  "SrvHandler_PDWriteAudioparameterset",		     0x2E, DIA_C_U16_DID_RBCM_AUDIO_PARAMETER_SET,{ (intptr_t) DIA_PROP_CM_AUDIO_PARAMETER_SET })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,  "SrvHandler_WriteAVDECCConfiguration",	         0x2E, DIA_C_U16_DID_CENTER_CMC_19_AVDECC_CONFIGURATION,{ (intptr_t) DIA_PROP_CMC_AVDECC_CONFIG, (intptr_t) DIA_PROP_CENTER_CMC_19_AVDECC_CONFIG_DP })
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCISConfiguration",             0x2E, DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION,       { (intptr_t) DIA_PROP_CMC_CIS_CONFIG, (intptr_t) DIA_PROP_CMC_CIS_CONFIG_DEFAULT, (intptr_t) DIA_PROP_CENTER_CMC_19_CIS_CONFIG_DP})
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteIntercomPhoneName",            0x2E, DIA_C_U16_DID_CENTER_CMC_19_INTERCOM_PHONE_NAME,     { (intptr_t) DIA_PROP_CMC_INTERCOM_PHONE_NAME})
	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCISConfigurationCD",           0x2E, DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION_CD,       { (intptr_t) DIA_PROP_CMC_CIS_CONFIG_CD})

      //microphone
      {
    	  tU8 sessions[] = {0x60}; //Production

    	  //diagnosis via Audio
    	 //RTC-5990073 Cleanup Activitydia_ServiceHandler* pServiceHandlerMicAudio1 = OSAL_NEW dia_SrvHandlerMicrophoneConnectionInfo("dia_SrvHandlerMicrophoneConnectionInfo", 0x22, DIA_C_U16_DID_RBCM_MICROPHONE_CONNECTION_INFO_1, DIA_EN_MICROPHONE_1 );
    	 //RTC-5990073 Cleanup Activityif (pServiceHandlerMicAudio1)
    	 //RTC-5990073 Cleanup Activity{
    	 //RTC-5990073 Cleanup Activity (void) pEngineCustomer->bAddServiceHandler(pServiceHandlerMicAudio1, sizeof(sessions)/sizeof(tU8), sessions, 0, NULL);

    		  //current measurement via Audio is impossible
    	 //RTC-5990073 Cleanup Activity ((dia_SrvHandlerMicrophoneConnectionInfo*)pServiceHandlerMicAudio1)->SetCurrentMeasurementImpossible(TRUE);
    	 //RTC-5990073 Cleanup Activity}

    	  //diagnosis via Rvc
    	  dia_ServiceHandler* pServiceHandlerMicRvc1 = OSAL_NEW dia_SrvHandlerMicrophonePowerSupplyInfo("dia_SrvHandlerMicrophonePowerSupplyInfo", 0x22, DIA_C_U16_DID_RBCM_MIC_PS_INFO_1, DIA_EN_MICROPHONE_1 );
    	  if (pServiceHandlerMicRvc1)
    	  {
    		  (void) pEngineCustomer->bAddServiceHandler(pServiceHandlerMicRvc1, sizeof(sessions)/sizeof(tU8), sessions, 0, NULL);
    	  }
      }

      if ( dia_getProperty(DIA_PROP_CM_VARIANT_CODING,arVariantCoding, 32) == DIA_SUCCESS )
      {
    	  if((arVariantCoding[4] & 0x10) == 0x10 )
    	  {
    		  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_XMRadioID",                     0x22, DIA_C_U16_DID_SXM_RADIO_ID, { (intptr_t) DIA_PROP_CM_SXM_SERIALNO_VER })
            		ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_XMSubModuleSWVersion",          0x22, DIA_C_U16_DID_SXM_SUBBMODULE_SW_VERSION, { (intptr_t) DIA_PROP_CM_SXM_SW_VER })
            		ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_XMSubModuleHWVersion",          0x22, DIA_C_U16_DID_SXM_SUBBMODULE_HW_VERSION, { (intptr_t) DIA_PROP_CM_SXM_SXM_HW_VER })
    	  }
      }
      #if 0
	  tU8 xmTunerSupported = 0x00;
	  if (dia_getProperty(DIA_PROP_CM_CONFIG_TUNER_SUPPORT_XM, xmTunerSupported) == DIA_SUCCESS)
	  {
		  if(xmTunerSupported != 0x00)
		  {
			  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_XMRadioID",                     0x22, DIA_C_U16_DID_SXM_RADIO_ID, { (intptr_t) DIA_PROP_CM_SXM_SERIALNO_VER })
        	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_XMSubModuleSWVersion",          0x22, DIA_C_U16_DID_SXM_SUBBMODULE_SW_VERSION, { (intptr_t) DIA_PROP_CM_SXM_SW_VER })
        	  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_XMSubModuleHWVersion",          0x22, DIA_C_U16_DID_SXM_SUBBMODULE_HW_VERSION, { (intptr_t) DIA_PROP_CM_SXM_SXM_HW_VER })
		  }
	  }
	  #endif
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadDeviceManager",                  0x22, DIA_C_U16_DID_RBCM_DEVICE_MANAGER,   { (intptr_t) DIA_PROP_CM_DEVICE_MANAGER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadMediaPlayer",                    0x22, DIA_C_U16_DID_RBCM_MEDIA_PLAYER,   { (intptr_t) DIA_PROP_CM_MEDIA_PLAYER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadDisplay",                   	  0x22, DIA_C_U16_DID_RBCM_DISPLAY, 						 { (intptr_t) DIA_PROP_CM_DISPLAY })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadSmartPhoneIntegrationDisplay",   0x22, DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION_DISPLAY,   { (intptr_t) DIA_PROP_CM_SMARTPHONE_INTEGRATION_DISPLAY })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadSmartPhoneIntegration",          0x22, DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION, 			 { (intptr_t) DIA_PROP_CM_SMARTPHONE_INTEGRATION })

      ////////////////////////////////////////////////////////////////////////////
      //
      // Service 0x2E (write data by identifier - Implement service for Software Development)
      //
      ////////////////////////////////////////////////////////////////////////////

      dia_SrvHandlerGenericPrint2DiagnosisTrace* pServiceHandlerprint2DiagnosisTrace = OSAL_NEW dia_SrvHandlerGenericPrint2DiagnosisTrace();
      if (pServiceHandlerprint2DiagnosisTrace)
      {
    	  ADD_SRVHDL_FOR_SPECIFIC_SESSION(pServiceHandlerprint2DiagnosisTrace,arSessionsProd)
      }

      ADD_NEW_SRVHDL(dia_SrvHandler_AIVI_VariantCoding_Write)
      ADD_NEW_SRVHDL(dia_SrvHandler_WriteADCRefPlusActualVoltage)
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDrmTunerParameterSetPD",       0x2E, DIA_C_U16_DID_RBCM_DRM_TUNER_PARAMETER_SET,   { (intptr_t) DIA_PROP_CM_DRM_TUNER_PARAMETER_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDrmTunerParameterSet",         0x2E, DIA_C_U16_DID_AIVI_DRM_TUNER_PARAMETER_SET,   { (intptr_t) DIA_PROP_CM_DRM_TUNER_PARAMETER_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteEarlyConfig_Display",          0x2E, DIA_C_U16_DID_RBCM_EARLY_CONFIG_DISPLAY,      { (intptr_t) DIA_PROP_CM_EARLY_CONFIG_DISPLAY })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteEarlyConfig_TwoDisplay",       0x2E, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TWO_DISPLAY,  { (intptr_t) DIA_PROP_CM_EARLY_CONFIG_TWO_DISPLAY })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteEarlyConfig_TouchDriver",      0x2E, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER, { (intptr_t) DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteEarlyConfig_TouchDriver2",     0x2E, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER_2,{ (intptr_t) DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER2 })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteInputKeyMappingTable_1",       0x2E, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_ONE,   { (intptr_t) DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_ONE })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteInputKeyMappingTable_2",       0x2E, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_TWO,   { (intptr_t) DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_TWO })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteInputKeyMappingTable_3",       0x2E, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_THREE, { (intptr_t) DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_THREE })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteInputKeyMappingTable_4",       0x2E, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_FOUR,  { (intptr_t) DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_FOUR })

      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteAudioSourceOffsetIn",          0x2E, DIA_C_U16_DID_AIVI_AUDIO_SOURCE_OFFSET_IN, { (intptr_t) DIA_PROP_AID_AUDIO_SOURCE_OFFSET })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteBTName",                       0x2E, DIA_C_U16_DID_RBCM_BT_NAME,           { (intptr_t) DIA_PROP_CM_BT_NAME })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCustomerECUPartNumber",        0x2E, DIA_C_U16_DID_RBCM_CUSTOMER_ECU_PART_NUMBER, { (intptr_t) DIA_PROP_CM_CUSTOMER_ECU_PART_NR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSWUPD_VariantInfo",            0x2E, DIA_C_U16_DID_RBCM_CUSTOMER_SWUP_VARIANT_INFO, { (intptr_t) DIA_PROP_SW_UPD_VARIANT_INFO })
	  //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSystemFanConfig",              0x2E, DIA_C_U16_DID_AIVI_SYSTEM_FAN_CONFIG,{ (intptr_t) DIA_PROP_AIVI_SYSTEM_FAN_CONFIG })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDimmingParametSet",            0x2E, DIA_C_U16_DID_RBCM_DIMMING_PARAMETER_SET,    { (intptr_t) DIA_PROP_CM_DIMMING_PARAMETER_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteKeyIlluminationAlignmentCoeff",0x2E, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_ALIGNMENT,{ (intptr_t) DIA_PROP_CM_KEY_ILLUMINATION_ALIGNMENT_COEFF })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteKeyIlluminationAlignmentCoeff2",0x2E, DIA_C_U16_DID_AIVI_KEY_ILLUMINATION_ALIGNMENT_2,{ (intptr_t) DIA_PROP_AIVI_KEY_ILLUMINATION_ALIGNMENT_COEFF2 })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDispIlluminationAlignmentCoeff",0x2E, DIA_C_U16_DID_AIVI_DISP_ILLUMINATION_ALIGNMENT,{ (intptr_t) DIA_PROP_AIVI_DISP_ILLUMINATION_ALIGNMENT_COEFF })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteGenTunerParamSet",             0x2E, DIA_C_U16_DID_RBCM_GENERIC_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_GENERIC_TUNER_PARAM_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteAntennaParamSet",              0x2E, DIA_C_U16_DID_RBCM_ANTENNA_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_ANTENNA_PARAMETER_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteFmAmTunerParamSet",            0x2E, DIA_C_U16_DID_RBCM_FM_AM_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_FM_AM_TUNER_PARAMETER_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDAB_Parameter_Set",            0x2E, DIA_C_U16_DID_RBCM_DAB_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_DAB_TUNER_PARAMETER_SET })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteNavDataCopyProtectionSecEccKey",0x2E, DIA_C_U16_DID_NAV_DATA_COPY_PROTECTION_SEC_ECC_KEY, { (intptr_t) DIA_PROP_CM_NAVI_DATA_SEC_KEY })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteNaviDefaultPosition",          0x2E, DIA_C_U16_DID_NAV_DEFAULT_POSITION, { (intptr_t) DIA_PROP_CM_NAVIGATION_DEFAULT_POSITION })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSensorConfigurationGNSS",      0x2E, DIA_C_U16_DID_SENSOR_CONFIGURATION_GNSS, { (intptr_t) DIA_PROP_CM_SENSOR_CONFIG_GNSS })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCMVariantCoding",              0x2E, DIA_C_U16_DID_CM_VARIANT_CODING, { (intptr_t) DIA_PROP_CM_VARIANT_CODING, (intptr_t) DIA_PROP_CM_VARIANT_CODING_SCC })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSensorConfigurationGyro",      0x2E, DIA_C_U16_DID_SENSOR_CONFIGURATION_GYRO, { (intptr_t) DIA_PROP_CM_SENSOR_CONFIG_GYRO })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSensorConfigurationACC",       0x2E, DIA_C_U16_DID_SENSOR_CONFIGURATION_ACC, { (intptr_t) DIA_PROP_CM_SENSOR_CONFIG_ACC })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCMConfigInfo",                 0x2E, DIA_C_U16_DID_CM_CONFIGURATION_INFO, { (intptr_t) DIA_PROP_CM_CONF_INFO })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteHDParameterSet",               0x2E, DIA_C_U16_DID_RBCM_HD_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_HD_PARAMETER_SET })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteThermalTempThresholds",        0x2E, DIA_C_U16_DID_RBCM_THERMAL_MGNT_TEMPERATURE_THRESHOLDS, { (intptr_t) DIA_PROP_THERMALMNGMT_TEMPERATURE_THRESHOLDS })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteWiFiName_1",                   0x2E, DIA_C_U16_DID_RBCM_WIFI_NAME_1,        { (intptr_t) DIA_PROP_CM_WIFI_NAME_1 })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteWiFiName_2",                   0x2E, DIA_C_U16_DID_RBCM_WIFI_NAME_2,        { (intptr_t) DIA_PROP_CM_WIFI_NAME_2 })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSystemInformationCommon",   0x2E, DIA_C_U16_DID_AIVI_DEF_SYSTEM_INFO_COMMON, { (intptr_t) DIA_PROP_AIVI_DEF_SYSTEM_INFO_COMMON })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefCameraSystem",              0x2E, DIA_C_U16_DID_AIVI_DEF_CAMERA_SYSTEM, { (intptr_t) DIA_PROP_AIVI_DEF_CAMERA_SYSTEM })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefVehicleInformation",        0x2E, DIA_C_U16_DID_AIVI_DEF_SYSTEM_VEHICLE_INFO, { (intptr_t) DIA_PROP_AIVI_DEF_VEHICLE_INFO })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefECORoute",                  0x2E, DIA_C_U16_DID_AIVI_DEF_ECO_ROUTE, { (intptr_t) DIA_PROP_AIVI_DEF_ECO_ROUTE })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericBTNameWrite,  "SrvHandler_WriteDefBTName",                    0x2E, DIA_C_U16_DID_AIVI_DEF_BT_NAME, { (intptr_t) DIA_PROP_AIVI_DEF_BT_NAME, (intptr_t) AIVI_BT_NAME_LENGTH })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefConfigurationHashValue",    0x2E, DIA_C_U16_DID_AIVI_DEF_CONFIG_HASH_VALUE, { (intptr_t) DIA_PROP_AIVI_DEF_CONFIG_HASH_VALUE })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefConfigurationPartNumber",   0x2E, DIA_C_U16_DID_AIVI_DEF_CONFIG_PARTS_NUMBER, { (intptr_t) DIA_PROP_AIVI_DEF_CONFIG_PARTS_NUMBER })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSensorConfigGyro",          0x2E, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GYRO, { (intptr_t) DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GYRO })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSensorConfigGNSS",          0x2E, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GNSS, { (intptr_t) DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GNSS })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSensorConfigACC",           0x2E, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_ACC, { (intptr_t) DIA_PROP_AIVI_DEF_SENSOR_CONFIG_ACC })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefFMAMTunerParamSet",         0x2E, DIA_C_U16_DID_AIVI_DEF_FMAM_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_FMAM_TUNER_PARAM_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefAntennaParamSet",           0x2E, DIA_C_U16_DID_AIVI_DEF_ANTENNA_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_ANTENNA_PARAM_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefDABParameterSet",           0x2E, DIA_C_U16_DID_AIVI_DEF_DAB_SET, { (intptr_t) DIA_PROP_AIVI_DEF_DAB_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefGenericTunerParamSet",      0x2E, DIA_C_U16_DID_AIVI_DEF_GENERIC_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_GENERIC_TUNER_PARAM_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefHDParamSet",                0x2E, DIA_C_U16_DID_AIVI_DEF_HD_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_HD_PARAM_SET })

      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericWIFINameWrite,"SrvHandler_WriteDefWifiName",                  0x2E, DIA_C_U16_DID_AIVI_DEF_WIFI_NAME, { (intptr_t) DIA_PROP_AIVI_DEF_WIFI_NAME_1, (intptr_t) AIVI_WIFI_NAME_1_LENGTH, (intptr_t) DIA_PROP_AIVI_DEF_WIFI_NAME_2, (intptr_t) AIVI_WIFI_NAME_1_LENGTH })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefAntiThefMapSelection",      0x2E, DIA_C_U16_DID_AIVI_DEF_ANTITHEF_MAP_SELECTION, { (intptr_t) DIA_PROP_AIVI_DEF_ANTITHEF_MAP_SELECTION })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefAudioParamSet",             0x2E, DIA_C_U16_DID_AIVI_DEF_AUDIO_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_AUDIO_PARAM_SET })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefAcousticParam",             0x2E, DIA_C_U16_DID_AIVI_DEF_ACOUSTIC_PARAM, { (intptr_t) DIA_PROP_AIVI_DEF_ACOUSTIC_PARAM })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefPhoneECNRWBS",              0x2E, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_WBS, { (intptr_t) DIA_PROP_AIVI_DEF_PHONE_ECNR_WBS })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefPhoneECNRNBS",              0x2E, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_NBS, { (intptr_t) DIA_PROP_AIVI_DEF_PHONE_ECNR_NBS })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefMEXConfig",                 0x2E, DIA_C_U16_DID_AIVI_DEF_MEX_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_MEX_CONFIG })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefFactoryMode",               0x2E, DIA_C_U16_DID_AIVI_DEF_FACTORY_MODE, { (intptr_t) DIA_PROP_AIVI_DEF_FACTORY_MODE })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefConnectivityConfig",        0x2E, DIA_C_U16_DID_AIVI_DEF_CONNECTIVITY_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_CONNECTIVITY_CONFIG })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefHmiConfig",                 0x2E, DIA_C_U16_DID_AIVI_DEF_HMI_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_HMI_CONFIG })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSoundVolConfig",            0x2E, DIA_C_U16_DID_AIVI_DEF_SOUND_VOLUME_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_SOUND_VOLUME_CONFIG })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefDrmTunerParameterSet",      0x2E, DIA_C_U16_DID_AIVI_DEF_DRM_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_AIVI_DEF_DRM_TUNER_PARAMETER_SET })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefXcallConfiguration",        0x2E, DIA_C_U16_DID_AIVI_DEF_XCALL_CONFIG,            { (intptr_t) DIA_PROP_AIVI_DEF_XCALL })
      //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefST3Configuration",          0x2E, DIA_C_U16_DID_AIVI_DEF_ST3_CONFIG,            { (intptr_t) DIA_PROP_AIVI_DEF_ST3 })


      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_CustomerAndBuildSWVersion_Write,   "SrvHandler_CustomerAndBuildSWVersion_Write", 0x2E, DIA_C_U16_DID_CM_CUSTOMER_AND_BUILD_SW_VERSION, { (intptr_t) DIA_PROP_CM_ECU_SW_VERSION, (intptr_t) DIA_PROP_CM_ECU_SW_BUILD_VERSION})

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteECUSparePartNumber",           0x2E, DIA_C_U16_DID_RBCM_ECU_SPARE_PART_NUMBER, { (intptr_t) DIA_PROP_CM_ECU_SPARE_PART_NR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteECUSerialNumber",              0x2E, DIA_C_U16_DID_RBCM_ECU_SERIAL_NUMBER, { (intptr_t) DIA_PROP_CM_ECU_SERIAL_NR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteNaviUnit",                     0x2E, DIA_C_U16_DID_AIVI_NAVI_UNIT, { (intptr_t) DIA_PROP_CM_NAVI_UNIT })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteECUHWVersion",                 0x2E, DIA_C_U16_DID_RBCM_ECU_HW_VERSION, { (intptr_t) DIA_PROP_CM_ECU_HW_VERSION })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteMainboardSparePartNumber",     0x2E, DIA_C_U16_DID_RBCM_PCB_SPARE_PART_NUMBER, { (intptr_t) DIA_PROP_CM_MAINBOARD_SPARE_PART_NR })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteMainboardSerialNumber",        0x2E, DIA_C_U16_DID_RBCM_PCB_SERIAL_NUMBER, { (intptr_t) DIA_PROP_CM_MAINBOARD_SERIAL_NR })
     //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteImmobilizer",                  0x2E, 0x3200, { (intptr_t) DIA_PROP_CM_IMMOBILIZER })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteVariantID",                    0x2E, DIA_C_U16_DID_CM_VARIANT_ID, { (intptr_t) DIA_PROP_CM_VARIANT_ID })

      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteHWRefA",                       0x2E, DIA_C_U16_DID_AIVI_HW_REF_A,               { (intptr_t) DIA_PROP_AIVI_HW_REF_A })



#if 1
      dia_SrvHandlerGenericIdentWrite* p_kdsProductionTimeWrite = OSAL_NEW dia_SrvHandlerGenericIdentWrite("SrvHandler_WriteDeviceProductionTime",0x2E, DIA_C_U16_DID_RBCM_DEVICE_PRODUCTION_TIME); //DID 0xD010 - Production Session
      if(p_kdsProductionTimeWrite)
      {
    	  ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(p_kdsProductionTimeWrite,arSessionsProd,{ (intptr_t) DIA_PROP_PRODUCTION_TIME })
      }
#endif
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDeviceManager",           0x2E, DIA_C_U16_DID_RBCM_DEVICE_MANAGER,   { (intptr_t) DIA_PROP_CM_DEVICE_MANAGER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteMediaPlayer",             0x2E, DIA_C_U16_DID_RBCM_MEDIA_PLAYER,   { (intptr_t) DIA_PROP_CM_MEDIA_PLAYER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,	  "SrvHandler_WriteDisplay",                   	    0x2E, DIA_C_U16_DID_RBCM_DISPLAY, 							 { (intptr_t) DIA_PROP_CM_DISPLAY })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSoundVolConfig",               0x2E, DIA_C_U16_DID_AIVI_SOUND_VOLUME_CONFIG,    { (intptr_t) DIA_PROP_AIVI_SOUND_VOLUME_CONFIG })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteHmiConfig",                    0x2E, DIA_C_U16_DID_AIVI_HMI_CONFIG,             { (intptr_t) DIA_PROP_AIVI_HMI_CONFIG })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteConfigPartNumber",             0x2E, DIA_C_U16_DID_AIVI_CONFIG_PARTS_NUMBER,    { (intptr_t) DIA_PROP_AIVI_CONFIG_PARTS_NUMBER })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSpeedLockout",                 0x2E, DIA_C_U16_DID_AIVI_SPEED_LOCKOUT,          { (intptr_t) DIA_PROP_AIVI_SPEED_LOCKOUT })
      //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,	  "SrvHandler_WriteSmartPhoneIntegrationDisplay",   0x2E, DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION_DISPLAY,  	 { (intptr_t) DIA_PROP_CM_SMARTPHONE_INTEGRATION_DISPLAY })
      ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,	  "SrvHandler_WriteSmartPhoneIntegration",          0x2E, DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION, 			 { (intptr_t) DIA_PROP_CM_SMARTPHONE_INTEGRATION })

      ////////////////////////////////////////////////////////////////////////////
      //
      // Service 0x2F (ioctrl by identifier);
      //
      // concrete ioctrls are created in method dia_FactoryPluginIOControls()
      //
      ////////////////////////////////////////////////////////////////////////////

      ADD_NEW_SRVHDL(dia_IOCtrlADR3SetSignalQuality)

      ////////////////////////////////////////////////////////////////////////////
      //
      // Service 0x31 (routine control)
      //
      // concrete routines are created in method dia_FactoryPluginRoutineControls()
      //
      ////////////////////////////////////////////////////////////////////////////

      // generic routine control service handler for CM production diagnosis (really UDS conform)
      ADD_NEW_SRVHDL(dia_SrvHandlerGenericRoutineCtrl)

      ////////////////////////////////////////////////////////////////////////////
      //
      // Service 0x23 (read data by memory address)
      //
      ////////////////////////////////////////////////////////////////////////////

      ADD_NEW_SRVHDL(dia_SrvHandler_ReadDataByMemory)

      ////////////////////////////////////////////////////////////////////////////
      //
      // Service 0x3D (write data by memory address)
      //
      ////////////////////////////////////////////////////////////////////////////

      ADD_NEW_SRVHDL(dia_SrvHandler_WriteDataByMemory)
   }

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginProductionServices::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginProductionServices::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_IOCtrlSignal,mSignalRep)

      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_Routine,mRoutineRep)
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy the input output control manager object
      if ( mpIOCtrlMgr ) {
         dia_IOCtrlManager::deleteInstance();
         mpIOCtrlMgr = 0;
      }
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}
