/*
 * dia_FactoryPluginDataDownload.cpp
 *
 *  Created on: 27.01.2014
 *      Author: gib2hi
 */

#include "dia_FactoryPluginDataDownload.h"

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_REQUEST_DOWNLOAD__
#include "common/services/uds/generic/dia_SrvHandlerGenericRequestDownload.h"
#endif

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_REQUEST_UPLOAD__
#include "common/services/uds/generic/dia_SrvHandlerGenericRequestUpload.h"
#endif

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_REQUEST_FILE_TRANSFER__
#include "common/services/uds/generic/dia_SrvHandlerGenericRequestFileTransfer.h"
#endif

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_REQUEST_TRANSFER_EXIT__
#include "common/services/uds/generic/dia_SrvHandlerGenericRequestTransferExit.h"
#endif

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_TRANSFER_DATA__
#include "common/services/uds/generic/dia_SrvHandlerGenericTransferData.h"
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_MANAGER__
#include "common/framework/datadownload/dia_DataDownloadManager.h"
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_CONFIG__
#include "common/framework/datadownload/dia_DataDownloadConfig.h"
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_CONFIG_PROJECT__
#include "project/framework/datadownload/dia_DataDownloadConfigProject.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_DEFAULT__
#include "common/framework/datadownload/dia_DataDownloadStrategyDefault.h"
#endif

#ifndef __INCLUDED_PRJ_SPECIFIC_DATA_DOWNLOAD_MANAGER_PLUGIN_CMC__
#include "project/framework/datadownload/dia_PrjSpecific_DataDownloadManagerPlugin_CMC.h"
#endif

#ifndef __INCLUDED_DIA_PRJ_SPECIFIC_DATA_DOWNLOAD_STRATEGY_DEFAULT_CMC__
#include "project/framework/datadownload/dia_PrjSpecific_DataDownloadStrategyDefault_CMC.h"
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_INSTALLATION_CONTAINER__
#include "project/framework/datadownload/dia_DataDownloadStrategyInstallationContainer.h"
#endif

const tU8 DIA_AIVI_DTC_INTERNAL_FAILURE    = 0x42;
const tU8 DIA_AIVI_DTC_PROGRAMMING_FAILURE = 0x51;
const tU8 DIA_AIVI_DTC_ALGORITHM_FAILURE   = 0x06;

using namespace dia;

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginDataDownload)

//-----------------------------------------------------------------------------

dia_FactoryPluginDataDownload::dia_FactoryPluginDataDownload ( void )
   : dia_FactoryPlugin("dia_FactoryPluginDataDownload",DIA_EN_FACTORY_PLUGIN_TYPE_DATA_DOWNLOAD)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginDataDownload::~dia_FactoryPluginDataDownload ( void )
{
   /*(void) tearDownObjects();*/
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginDataDownload::setup ( dia_enInitLevel level )
{
   ScopeTrace oTrace("dia_FactoryPluginDataDownload::setup");

   LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF DATADOWNLOAD FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_1 || level == DIA_EN_INITLEVEL_ALL )
   {
      dia_DataDownloadManager* pDnlManager = getInstanceOfDataDownloadManager();
      if ( pDnlManager )
      {
         //remove default strategy
         tU32 defStrategyUID = ((tU32)DIA_C_U8_DATADOWNLOAD_DEFAULT_ADDRESS_AND_FORMAT_IDENTIFIER) | (((tU32)DIA_C_U8_DATADOWNLOAD_DEFAULT_FORMAT_IDENTIFIER)<<8);
         if (DIA_SUCCESS!=(pDnlManager->removeDataDownloadStrategy( defStrategyUID )))
         {
            DIA_TR_ERR("### removeDataDownloadStrategy failed with UID of def strategy = 0x%08X ###", defStrategyUID);
         }

         //add project specific strategy (for transfer exit)
         std::pair <tU32,tU32> LogBl00(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_00, DIA_PROP_AIVI_BLOCK_FD00_REFERENCE_CHECKSUM);
         std::pair <tU32,tU32> LogBl01(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_01, DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB);
         std::pair <tU32,tU32> LogBl02(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_02, DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB);
         std::pair <tU32,tU32> LogBl03(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_03, DIA_PROP_AIVI_VR_PARAM);
         std::pair <tU32,tU32> LogBl04(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_04, DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB);
         std::pair <tU32,tU32> LogBl05(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_05, DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB);
         std::pair <tU32,tU32> LogBl06(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_06, DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB);
         std::pair <tU32,tU32> LogBl07(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_07, DIA_PROP_AIVI_ACOUSTIC_PARAM);
         std::pair <tU32,tU32> LogBl08(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_08, DIA_PROP_AIVI_BLOCK_FD08_ESE);
         std::pair <tU32,tU32> LogBl09(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_09, DIA_PROP_AID_DATASET_ECNR_BT_VOICE_NB);
         std::pair <tU32,tU32> LogBl10(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0A, DIA_PROP_AID_DATASET_ECNR_BT_VOICE_WB);
         std::pair <tU32,tU32> LogBl11(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0B, DIA_PROP_AID_DATASET_ECNR_BT_SIRI_WB);
         std::pair <tU32,tU32> LogBl12(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0C, DIA_PROP_AID_DATASET_ECNR_CP_VOICE_WB);
         std::pair <tU32,tU32> LogBl13(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0D, DIA_PROP_AID_DATASET_ECNR_AA_VOICE_WB);
         std::pair <tU32,tU32> LogBl14(ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0E, DIA_PROP_AID_DATASET_ECNR_VPA_VOICE_WB);


         std::map<tU32, std::pair <tU32,tU32> > mStartAddrToItcAndPropIDRepo;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD00_REFERENCE_CHECKSUM_START]          = LogBl00;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD01_PHONE_ECNR_NBS_START]              = LogBl01;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD02_PHONE_ECNR_WBS_START]              = LogBl02;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD03_VR_PARAM_START]                    = LogBl03;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_START]      = LogBl04;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_START]      = LogBl05;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_START]   = LogBl06;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD07_ACOUSTIC_PARAM_START]              = LogBl07;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD08_ESE_START]                         = LogBl08;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD09_BT_VOICE_ECNR_NBS_START]           = LogBl09;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD0A_BT_VOICE_ECNR_WBS_START]           = LogBl10;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD0B_BT_SIRI_ECNR_WBS_START]            = LogBl11;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_START]       = LogBl12;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_START]    = LogBl13;
         mStartAddrToItcAndPropIDRepo[BLOCK_FD0E_ECNR_VPA_VOICE_WB_START]           = LogBl14;

         if (DIA_SUCCESS!=(pDnlManager->addDataDownloadStrategy(new dia_DataDownloadStrategyDefault_CMC())) )
         {
            DIA_TR_ERR("### addDataDownloadStrategy failed for dia_DataDownloadStrategyDefault_CMC ###");
         }
		 /* Add data download strategy for CIS Installation Container */
		 if (DIA_SUCCESS!=(pDnlManager->addDataDownloadStrategy(OSAL_NEW dia_DataDownloadStrategyInstallationContainer(0x00, 0x44))) )
         {
            DIA_TR_ERR("### addDataDownloadStrategy failed for dia_DataDownloadStrategyInstallationContainer ###");
         }

         //add Download Manager Plugin (for download prepare)
         std::map<tU32, tU16> logicAddrToDtcGroupRepo;
         logicAddrToDtcGroupRepo[BLOCK_FD00_REFERENCE_CHECKSUM_START]        = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_REFERENCE_CHECKSUM;
         logicAddrToDtcGroupRepo[BLOCK_FD01_PHONE_ECNR_NBS_START]            = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_NBS;
         logicAddrToDtcGroupRepo[BLOCK_FD02_PHONE_ECNR_WBS_START]            = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_WBS;
         logicAddrToDtcGroupRepo[BLOCK_FD03_VR_PARAM_START]                  = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_VR_PARAM;
         logicAddrToDtcGroupRepo[BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_START]    = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_NBS;
         logicAddrToDtcGroupRepo[BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_START]    = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_WBS;
         logicAddrToDtcGroupRepo[BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_START] = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_FACETIME_ECNR_SWB;
         logicAddrToDtcGroupRepo[BLOCK_FD07_ACOUSTIC_PARAM_START]            = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ACOUSTIC_PARAM;
         logicAddrToDtcGroupRepo[BLOCK_FD08_ESE_START]                       = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ESE_PARAM;
         logicAddrToDtcGroupRepo[BLOCK_FD09_BT_VOICE_ECNR_NBS_START]         = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_NBS;
         logicAddrToDtcGroupRepo[BLOCK_FD0A_BT_VOICE_ECNR_WBS_START]         = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_WBS;
         logicAddrToDtcGroupRepo[BLOCK_FD0B_BT_SIRI_ECNR_WBS_START]          = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_SIRI_ECNR_WBS;
         logicAddrToDtcGroupRepo[BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_START]     = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_SIRI_ECNR_WBS;
         logicAddrToDtcGroupRepo[BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_START]  = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ANDROID_AUTO_VR_ECNR_WBS;
         logicAddrToDtcGroupRepo[BLOCK_FD0E_ECNR_VPA_VOICE_WB_START]         = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ECNR_VPA_VOICE_WB;

         std::map<tU32, tU32> dtcProgrammingToPropertyIDRepo;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD00_REFERENCE_CHECKSUM_START]        = DIA_PROP_AIVI_LB00_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD01_PHONE_ECNR_NBS_START]            = DIA_PROP_AIVI_LB01_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD02_PHONE_ECNR_WBS_START]            = DIA_PROP_AIVI_LB02_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD03_VR_PARAM_START]                  = DIA_PROP_AIVI_LB03_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_START]    = DIA_PROP_AIVI_LB04_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_START]    = DIA_PROP_AIVI_LB05_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_START] = DIA_PROP_AIVI_LB06_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD07_ACOUSTIC_PARAM_START]            = DIA_PROP_AIVI_LB07_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD08_ESE_START]                       = DIA_PROP_AIVI_LB08_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD09_BT_VOICE_ECNR_NBS_START]         = DIA_PROP_AIVI_LB09_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD0A_BT_VOICE_ECNR_WBS_START]         = DIA_PROP_AIVI_LB10_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD0B_BT_SIRI_ECNR_WBS_START]          = DIA_PROP_AIVI_LB11_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_START]     = DIA_PROP_AIVI_LB12_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_START]  = DIA_PROP_AIVI_LB13_DTC_PROGRAMMING_FAILURE_STATUS;
         dtcProgrammingToPropertyIDRepo[BLOCK_FD0E_ECNR_VPA_VOICE_WB_START]         = DIA_PROP_AIVI_LB14_DTC_PROGRAMMING_FAILURE_STATUS;

         dia_DataDownloadManagerPlugin_CMC* pDnlManagerPlugin = new dia_DataDownloadManagerPlugin_CMC(logicAddrToDtcGroupRepo,
		  dtcProgrammingToPropertyIDRepo, mStartAddrToItcAndPropIDRepo);
         if ( pDnlManagerPlugin ) pDnlManager->setPlugin(*pDnlManagerPlugin);

         pDnlManager->loadDatasets(aDiaDatasetConfig, dia::getDiaDatasetPropDataSize());
         pDnlManager->loadDatasets(aDiaDatasetConfigProject,sizeof(aDiaDatasetConfigProject)/sizeof(dia_DatasetConfig));
         //pDnlManager->loadDatasets(aDiaDatasetConfigXtraData, sizeof(aDiaDatasetConfigXtraData)/sizeof(dia_DatasetConfig));

         if (assignInterfaceAndNotifier<dia_IDataDownload,dia_IDataDownloadListener,dia_IDataDownloadNotifier>(pDnlManager) != DIA_SUCCESS)
         {
            return DIA_FAILED;
         }
      } //lint !e429: custodial pointer is freed by download manager object
   }

   if ( level == DIA_EN_INITLEVEL_3 || level == DIA_EN_INITLEVEL_ALL )
   {
      dia_EngineServer* pEngineCustomer = 0;
      if ( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngineCustomer) != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO CUSTOMER DIAGNOSIS ENGINE #####");
         return DIA_FAILED;
      }

      (void) pEngineCustomer->bAddServiceHandler(new dia_SrvHandlerGenericRequestDownload());
      (void) pEngineCustomer->bAddServiceHandler(new dia_SrvHandlerGenericRequestUpload());
      (void) pEngineCustomer->bAddServiceHandler(new dia_SrvHandlerGenericTransferData());
      (void) pEngineCustomer->bAddServiceHandler(new dia_SrvHandlerGenericRequestTransferExit());
      (void) pEngineCustomer->bAddServiceHandler(new dia::SrvHandlerGenericRequestFileTransfer());
   }

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginDataDownload::tearDown ( dia_enInitLevel level )
{
   ScopeTrace oTrace("dia_FactoryPluginDataDownload::tearDown");

   LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy the input output control manager object
      releaseInstanceOfDataDownloadManager();
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}




