/**
 * \file      dia_FactoryObjectSAVDMMGR.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include "common/framework/sysset/dia_common_sysset.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

//#ifndef DIA_SAFEATUREVDMMGR_H_
#include "project/framework/sysadapters/dia_SAFeatureVDMMGR.h"
//#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif



#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_VDMMGR__
#include "dia_FactoryObjectSAVDMMGR.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAVDMMGR)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAVDMMGR::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAVDMMGR::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_VDMMGR_MAJOR_VERSION = 1;
   static const tU16 CCA_C_U16_SRV_VDMMGR_MINOR_VERSION = 0;
   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
           "DIA_SAVDMMGR",
           CCA_C_U16_APP_MMGR
           );

   //
   // Service Plugins
   //

   dia_SystemAdapterServicePlugin* pSAVDMMGRService = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SAVDMMGRSrv",
         CCA_C_U16_SRV_MMGR,
         CCA_C_U16_SRV_VDMMGR_MAJOR_VERSION,
         CCA_C_U16_SRV_VDMMGR_MINOR_VERSION,
         mpObj
   );

   //
   // Feature Plugins
   //

   // add feature for production test
   dia_SAFeatureVDMMGR* pSAFeatureVDMMGR = pFactory->createSystemAdapterFeature<dia_SAFeatureVDMMGR> (
         "SAFeatureVDMMGR",
         pSAVDMMGRService
   );

   if ( pSAFeatureVDMMGR ) {
       (tVoid) assignInterfaceAndNotifier<dia_IVDMMGR,dia_IVDMMGRListener,dia_IVDMMGRNotifier>(pSAFeatureVDMMGR);
   }

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAVDMMGR::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAVDMMGR::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



