/**
 * \file      dia_FactoryObjectSATunerAMFM.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif

#include "project/framework/sysadapters/dia_SAFeatureTunerAMFM.h"
#include "project/framework/sysadapters/dia_SAFeatureADRContainer.h"

#ifndef __INCLUDED_DIA_SAFEATURE_TUNER_TESTMODE__
#include "project/framework/sysadapters/dia_SAFeatureTunerTestmode.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TUNER_AMFM__
#include "dia_FactoryObjectSATunerAMFM.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AMFMTUNER_LISTENER__
#include "common/interfaces/dia_ITunerAMFMListener.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSATunerAMFM)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSATunerAMFM::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSATunerAMFM::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_TUNERDIAG_MAJOR_VERSION = 2;
   static const tU16 CCA_C_U16_SRV_TUNERDIAG_MINOR_VERSION = 0;

   static const tU16 CCA_C_U16_SRV_TUNERAMFM_MAJOR_VERSION = 3;
   static const tU16 CCA_C_U16_SRV_TUNERAMFM_MINOR_VERSION = 0;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SATunerAMFM",
         CCA_C_U16_APP_TUNER
   );

   //
   // Service Plugins
   //

   // tuner diaglib service
   dia_SystemAdapterServicePlugin* pSATunerAMFMService = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SATunerAMFMSrv",
         CCA_C_U16_SRV_TUNERCONTROL,
         CCA_C_U16_SRV_TUNERAMFM_MAJOR_VERSION,
         CCA_C_U16_SRV_TUNERAMFM_MINOR_VERSION,
         mpObj
   );

   // tuner diagnostics service
   dia_SystemAdapterServicePlugin* pSATunerServiceDiag = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SATunerSrvDiag",
         CCA_C_U16_SRV_TUNERDIAG,
         CCA_C_U16_SRV_TUNERDIAG_MAJOR_VERSION,
         CCA_C_U16_SRV_TUNERDIAG_MINOR_VERSION,
         mpObj
   );

#if defined(__ENABLE_FEATURE_SYSSET_INCLUDE_TUNER_AMFM__) || defined(__ENABLE_FEATURE_REMOTE_CONTROL_INCLUDE_TUNER_AMFM__)
   // AMFM tuner diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSATunerAMFMServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
           "DIA_SATunerAMFMSrvDiagLib",
           CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
           CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
           mpObj
           );
#endif


   //
   // Feature Plugins
   //

   //--- feature: tuner for AM/FM ---------------------------------------------
   dia_SAFeatureTunerAMFM* pFeatureTunerAMFM = pFactory->createSystemAdapterFeature<dia_SAFeatureTunerAMFM> (
         "dia_SAFeatureTunerAMFM",
         pSATunerAMFMService
   );

   if ( pFeatureTunerAMFM ) {
      (tVoid) assignInterfaceAndNotifier<dia_ITunerAMFM,dia_ITunerAMFMListener,dia_ITunerAMFMNotifier>(pFeatureTunerAMFM);
      (tVoid) assignInterfaceAndNotifier<dia_ITunerAMFMPrj,dia_ITunerAMFMPrjListener,dia_ITunerAMFMPrjNotifier>(pFeatureTunerAMFM);
   }

   //--- feature: ADR container -----------------------------------------------
   dia_SAFeatureADRContainer* pFeatureADRContainer = pFactory->createSystemAdapterFeature<dia_SAFeatureADRContainer> (
         "dia_SAFeatureADRContainer",
         pSATunerServiceDiag
   );

   if ( pFeatureADRContainer ) {
      (tVoid) assignInterfaceAndNotifier<dia_IADR,dia_IADRListener,dia_IADRNotifier>(pFeatureADRContainer);
   }

   //--- feature: testmode for tuner ---------------------------------------------
   dia_SAFeatureTunerTestmode* pFeatureTunerTestmode = pFactory->createSystemAdapterFeature<dia_SAFeatureTunerTestmode> (
         "dia_SAFeatureTunerTM",
         pSATunerAMFMService
   );

   if ( pFeatureTunerTestmode ) {
      (tVoid) assignInterfaceAndNotifier<dia_ITunerTestmode,dia_ITunerTestmodeListener,dia_ITunerTestmodeNotifier>(pFeatureTunerTestmode);
   }


#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_TUNER_AMFM__
   //--- system settings feature via the diaglib service ----------------------
   dia_SAFeatureSystemSettings* pSAFeatureTunerAMFMSysset = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings>(
         "SAFeatureTunerAMFMSysset",
         SYSSETID_TUNE_AMFM,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSATunerAMFMServiceDiagLib);

   if (pSAFeatureTunerAMFMSysset) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureTunerAMFMSysset);
   }
#endif

#ifdef __ENABLE_FEATURE_REMOTE_CONTROL_INCLUDE_TUNER_AMFM__
   dia_SAFeatureRemoteControl* pSAFeatureRemoteCtrl = pFactory->createSystemAdapterRemoteControlFeature<dia_SAFeatureRemoteControl> (
         "SAFeatureTunerAMFMRemoteControl",
         DIA_EN_REMOTE_PLUGIN_TUNER_AMFM,
         pSATunerAMFMServiceDiagLib
         );

   if ( pSAFeatureRemoteCtrl )
   {
      (tVoid) dia_RemoteControl::getInstance()->addRemoteControlPlugin(pSAFeatureRemoteCtrl);
   }
#endif

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSATunerAMFM::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSATunerAMFM::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



