/**
 * \file      dia_FactoryObjectSATCU.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    stc2hi
 * \date      30.11.2015
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_TCUFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_TCUFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_TCUFI_SERVICEINFO
#include "midw_ext_fi_if.h"

#ifndef DIA_SAFEATURETCU_H_
#include "project/framework/sysadapters/dia_SAFeatureTCU.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CLEAR_TCU_HISTORY__
#include "project/framework/sysadapters/dia_SAFeatureClearTCUHistory.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TCU__
#include "dia_FactoryObjectSATCU.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSATCU)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSATCU::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSATCU::setup");

   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SATCU",
         CCA_C_U16_APP_FC_MCAN_TCU
         );

   //
   // Service Plugins
   //

   // TCU standard service
   dia_SystemAdapterServicePlugin* pSATCUService = pFactory->createSystemAdapterServicePluginNoMonitoring(
         "DIA_SATCUSrv",
         CCA_C_U16_SRV_MCAN_TCU,
         MIDW_EXT_TCUFI_C_U16_SERVICE_MAJORVERSION,
         MIDW_EXT_TCUFI_C_U16_SERVICE_MINORVERSION,
         mpObj
         );

   //
   // Feature Plugins
   //

   // feature implementation for the TCU base services

   dia_SAFeatureTCU* pSAFeatureTCU = pFactory->createSystemAdapterFeature<dia_SAFeatureTCU> (
         "SAFeatureTCU",
         pSATCUService
         );

   if (pSAFeatureTCU)
   {
      (void) assignInterfaceAndNotifier<dia_ITCU,dia_ITCUListener,dia_TCUNotifier>(pSAFeatureTCU);
   }

   // add feature for clear MCAN history settings (using system settings framework)
   dia_SAFeatureClearTCUHistory* pSAFeatureTCUMCANClear = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureClearTCUHistory> (
         "SAFeatureClearTCUHistory",
         SYSSETID_TCU,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_CLEAR_MCAN_HISTORIES,
         pSATCUService
   );

   if ( pSAFeatureTCUMCANClear )
   {
      getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureTCUMCANClear);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSATCU::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSATCU::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



