/**
 * \file      dia_FactoryObjectSASensor.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#include "common/framework/sysadapters/dia_SAFeatureSensor.h"
#include "common/framework/sysadapters/dia_SAFeatureGNSS.h"

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_SENSOR__
#include "dia_FactoryObjectSASensor.h"
#endif

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_FUNCTIONIDS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_SERVICEINFO
#include "sensor_fi_if.h"

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSASensor)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSASensor::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSASensor::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   /*CHANGED FOR VDS2 : rva5cob*/
   static const tU16 CCA_C_U16_SRV_SENSOR_MINOR_VERSION = SENSOR_LOCATIONFI_C_U16_SERVICE_MINORVERSION; //12
   static const tU16 CCA_C_U16_SRV_SENSOR_MAJOR_VERSION = SENSOR_LOCATIONFI_C_U16_SERVICE_MAJORVERSION;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SASensor",
         CCA_C_U16_APP_SENSOR
         );

   //
   // Service Plugins
   //

   /*CHANGED FOR VDS2 : rva5cob*/
   // Phone standard service
   dia_SystemAdapterServicePlugin* pSASensorService = pFactory->createSystemAdapterServicePluginNoMonitoring(
         "DIA_SASensorSrv",
         CCA_C_U16_SRV_SENSOR_LOCATION,
         CCA_C_U16_SRV_SENSOR_MAJOR_VERSION,
         CCA_C_U16_SRV_SENSOR_MINOR_VERSION,
         mpObj
         );

   //
   // Feature Plugins
   //

   // feature implementation for the Reverse Gear base services

   dia_SAFeatureSensor* pSAFeatureSensor = pFactory->createSystemAdapterFeature<dia_SAFeatureSensor> (
         "SAFeatureSensor",
         pSASensorService
         );

   if (pSASensorService) {
      (tVoid) assignInterfaceAndNotifier<dia_ISensor, dia_ISensorListener, dia_ISensorNotifier>(pSAFeatureSensor);
   }


   // feature implementation for the GNSS base services

   dia_SAFeatureGNSS* pSAFeatureGNSS = pFactory->createSystemAdapterFeature<dia_SAFeatureGNSS>(
         "SAFeatureGNSS",
         pSASensorService
         );

   if (pSASensorService) {
      (tVoid) assignInterfaceAndNotifier<dia_IGNSS, dia_IGNSSListener, dia_GNSSNotifier>(pSAFeatureGNSS);
   }


   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSASensor::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSASensor::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



