/**
 * \file      dia_FactoryObjectSAPhoneBook.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    wgl2hi
 * \date      29.07.2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include "common/framework/sysadapters/dia_SAFeatureDefaultSettingsCompatible.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_PHONE_BOOK__
#include "dia_FactoryObjectSAPhoneBook.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#include "project/framework/sysadapters/dia_SAFeaturePhoneBook.h"

#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_DBGVISITORS        /* needed by most_fi_if.h */
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_STDVISITORS             /* needed by most_fi_if.h */
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_SERVICEINFO
#include "Connectivity/conn_most_fi/most_fi_if.h"



DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAPhoneBook)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAPhoneBook::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAPhoneBook::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_PHBK_MAJOR_VERSION = MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION;    //provided by "most_PhonBk_fi/source/most_phonbkfiserviceinfo.h"
   static const tU16 CCA_C_U16_SRV_PHBK_MINOR_VERSION = MOST_PHONBKFI_C_U16_SERVICE_MINORVERSION;    //provided by "most_PhonBk_fi/source/most_phonbkfiserviceinfo.h"

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SAPhonebook",
         CCA_C_U16_APP_PHONEBOOK
   );

   // Phonebook diaglib service
//#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_PHONEBOOK__
//   dia_SystemAdapterServicePluginDiaglib* pSAPhonebookServiceDiagLib =
//#else
//   (void)
//#endif
   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginDiaglib* pSAPhoneBookServiceDiaglib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SAPhonebookSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
    );


   dia_SystemAdapterServicePlugin* pSAPHBKService = pFactory->createSystemAdapterServicePlugin (
          "DIA_SAPhoneBookSrv",
		   CCA_C_U16_SRV_FB_PHONEBOOK,
		   CCA_C_U16_SRV_PHBK_MAJOR_VERSION,
		   CCA_C_U16_SRV_PHBK_MINOR_VERSION,
           mpObj
           );

   // add feature implementation for the diaglib service of
   dia_SAFeaturePhoneBook* pSAFeaturePhoneBook = pFactory->createSystemAdapterFeature<dia_SAFeaturePhoneBook> (
           "pSAFeaturePhoneBook",
		   pSAPHBKService
           );

   if ( pSAFeaturePhoneBook ) {
      (void) assignInterfaceAndNotifier<dia_IPhonebookPrj,dia_IPhonebookPrjListener,dia_IPhonebookPrjNotifier>(pSAFeaturePhoneBook);
   }


#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_PHONEBOOK__
   // system settings feature via the diaglib service
   dia_SAFeatureSystemSettings* pSAFeaturePhonebookSysSet = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings> (
         "SAFeaturePhonebookSysSet",
         SYSSETID_PHON_BOOK,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSAPhonebookServiceDiagLib
   );

   if ( pSAFeaturePhonebookSysSet ) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeaturePhonebookSysSet);
   }
#endif

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAPhoneBook::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAPhoneBook::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}
