/*****************************************************************************************
*
* \file       dia_FactoryObjectSAParkAssist.cpp
*
* \brief
*
* \details
*
* \author     sbr5kor
*
* \date       02 September 2015
*
* \copyright  (c) 2015-2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_PARK_ASSIST__
#include "dia_FactoryObjectSAParkAssist.h"
#endif

#ifndef DIA_SAFEATURERVIDEOSOURCE_H_
#include "project/framework/sysadapters/dia_SAFeatureVideoSource.h"
#endif

// FI is generated here:
//    <view>_GEN/ai_projects/generated/components/rvc_fi/rvc_cca_fi/source/rvc_ccafifctid.h
#define RVC_FI_S_IMPORT_INTERFACE_RVC_CCAFI_SERVICEINFO          /* needed by rvc_fi_if.h */
#include "rvc_fi/rvc_fi_if.h"

#include "project/framework/sysadapters/dia_SAFeatureRVC.h"
#include "project/framework/sysadapters/dia_SAFeatureRVCControl.h"

#ifndef __INCLUDED_DIA_SAFEATURE_DIMMING_CONTROL__
#include "project/framework/sysadapters/dia_SAFeatureDimmingControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_RVC_DIMMING_SYSTEMSET__
#include "project/framework/sysadapters/dia_SAFeatureRvcDimmingSystemSet.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_TOUCHCNTRL_RESET__H_
#include "project/framework/sysadapters/dia_SAFeatureTouchCntrlReset.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAParkAssist)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAParkAssist::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAParkAssist::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_RVC_MAJOR_VERSION = RVC_CCAFI_C_U16_SERVICE_MAJORVERSION;    //provided by "rvc_cca_fi/source/rvc_ccafiserviceinfo.h"
   static const tU16 CCA_C_U16_SRV_RVC_MINOR_VERSION = RVC_CCAFI_C_U16_SERVICE_MINORVERSION;    //provided by "rvc_cca_fi/source/rvc_ccafiserviceinfo.h"

   //
   // System Adapter object
   //
   mpObj = pFactory->createSystemAdapter (
           "DIA_SAPA",
           CCA_C_U16_APP_DRVASS_VIDEO
           );

   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginDiaglib* pSARVCServiceDiaglib = pFactory->createSystemAdapterServicePluginDiaglib (
           "dia_SAPASrvDiaglib",
           CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
           CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
           mpObj
           );

   dia_SystemAdapterServicePlugin* pSARVCService = pFactory->createSystemAdapterServicePluginNoMonitoring (
           "DIA_SARVCSrv",
           CCA_C_U16_SRV_RVC,
           CCA_C_U16_SRV_RVC_MAJOR_VERSION,
           CCA_C_U16_SRV_RVC_MINOR_VERSION,
           mpObj
           );

   //
   // Feature Plugins
   //

   //video source control linking for RVC
   dia_SAFeatureVideoSource* pSAFeatureVideoSource = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureVideoSource> (
      "SAFeatureVideoSource",
      pSARVCServiceDiaglib
      );

   if (pSAFeatureVideoSource) {
      (void)assignInterfaceAndNotifier<dia_IVideoSource, dia_IVideoSourceListener, dia_IVideoSourceNotifier>(pSAFeatureVideoSource);
   }

   // add feature implementation for the service of RVC (no diaglib)
   dia_SAFeatureRVC* pSAFeatureRVC = pFactory->createSystemAdapterFeature<dia_SAFeatureRVC> (
           "SAFeatureRVC",
           pSARVCService
           );

   if ( pSAFeatureRVC ) {
      (void) assignInterfaceAndNotifier<dia_IRVC,dia_IRVCListener,dia_IRVCNotifier>(pSAFeatureRVC);
   }

   if ( pSAFeatureRVC ) {
      (void) assignInterfaceAndNotifier<dia_IMicrophone,dia_IMicrophoneListener,dia_IMicrophoneNotifier>(pSAFeatureRVC);
   }


   if ( pSARVCService )	{
      (tVoid) assignInterfaceAndNotifier<dia_ICVBSConnection,dia_ICVBSConnectionListener,dia_ICVBSConnectionNotifier>(pSAFeatureRVC);
	}

   // add feature implementation for the diaglib service of RVC
   dia_SAFeatureRVCControl* pSAFeatureRVCControl = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureRVCControl> (
           "pSAFeatureRVCControl",
           pSARVCServiceDiaglib
           );

   if ( pSAFeatureRVCControl ) {
      (void) assignInterfaceAndNotifier<dia_IRVCControl,dia_IRVCControlListener,dia_IRVCControlNotifier>(pSAFeatureRVCControl);
   }

   // add dimming feature for the diaglib service of RVC/Dimming
   dia_SAFeatureDimmingControl* pSAFeatureDimmingControl = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureDimmingControl> (
      "SAFeatureDimmingControl",
      pSARVCServiceDiaglib
      );

   if ( pSAFeatureDimmingControl ) {
       (tVoid) assignInterfaceAndNotifier<dia_IDimmingControl,dia_IDimmingControlListener,dia_IDimmingControlNotifier>(pSAFeatureDimmingControl);
   }

   // add TouchController Reset feature for the diaglib service
   dia_SAFeatureTouchCntrlReset* pSAFeatureTouchCntrlReset = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureTouchCntrlReset> (
        "SAFeatureTouchCntrlReset",
        pSARVCServiceDiaglib
        );

     if ( pSAFeatureTouchCntrlReset ) {
         (tVoid) assignInterfaceAndNotifier<dia_IResetTouchCntlExtDisplay,dia_IResetTouchCntlExtDisplayListener,dia_IResetTouchCntlExtDisplayNotifier>(pSAFeatureTouchCntrlReset);
     }

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_RVC__
   //--- system settings feature via the diaglib service ----------------------
   dia_SAFeatureRvcDimmingSystemSet* pSAFeatureRVCSysset = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureRvcDimmingSystemSet>(
         "SAFeatureRvcSysset",
         SYSSETID_REAR_VIEW_CAME,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSARVCServiceDiaglib
   );

   if (pSAFeatureRVCSysset) {
      (void) getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureRVCSysset);
      (void) getInstanceOfConfigManager()->addConfigNotifier(pSAFeatureRVCSysset);
   }
#endif

   return DIA_SUCCESS;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAParkAssist::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAParkAssist::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}
