/**
 * \file      dia_FactoryObjectSAMeter.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include "common/framework/sysset/dia_common_sysset.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CLEAR_METER_HISTORY__
#include "project/framework/sysadapters/dia_SAFeatureClearMeterHistory.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif

#ifndef DIA_SAFEATUREMETER_H_
#include "project/framework/sysadapters/dia_SAFeatureMeter.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_METER__
#include "dia_FactoryObjectSAMeter.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAMeter)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAMeter::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAMeter::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_METER_MINOR_VERSION = 0;
   static const tU16 CCA_C_U16_SRV_METER_MAJOR_VERSION = 1;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SAMeter",
         CCA_C_U16_APP_FC_MCAN_METER
         );

   //
   // Service Plugins
   //

   // Phone standard service
   dia_SystemAdapterServicePlugin* pSAMeterService = pFactory->createSystemAdapterServicePluginNoMonitoring(
         "DIA_SAMeterSrv",
         CCA_C_U16_SRV_MCAN_METER,
         CCA_C_U16_SRV_METER_MAJOR_VERSION,
         CCA_C_U16_SRV_METER_MINOR_VERSION,
         mpObj
         );

   //
   // Feature Plugins
   //

   // feature implementation for the Reverse Gear base services

   dia_SAFeatureMeter* pSAFeatureMeter = pFactory->createSystemAdapterFeature<dia_SAFeatureMeter> (
         "SAFeatureMeter",
         pSAMeterService
         );

   if (pSAFeatureMeter) {
      (void) assignInterfaceAndNotifier<dia_INissanMCanInfo,dia_INissanMCanInfoListener,dia_NissanMCanInfoNotifier>(pSAFeatureMeter);
   }

   // add feature for clear MCAN history settings (using system settings framework)
   dia_SAFeatureClearMeterHistory* pSAFeatureMeterMCANClear = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureClearMeterHistory> (
         "SAFeatureClearMeterHistory",
         SYSSETID_METER,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_CLEAR_MCAN_HISTORIES,
         pSAMeterService
   );

   if ( pSAFeatureMeterMCANClear ) {
      getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureMeterMCANClear);
   }


   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAMeter::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAMeter::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



