/**
 * \file      dia_FactoryObjectSAInputHandling.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    wgl2hi
 * \date      04.02.2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#if 0
#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#include "project/framework/factory/dia_FactoryObjectSAInputHandling.h"

#ifndef __INCLUDED_DIA_FACTORY_SYSTEM_ADAPTERS__
#include "project/framework/factory/dia_FactoryPluginSystemAdapters.h"
#endif


#ifndef DIA_SAFEATUREINPUTHANDLING_H_
#include "project/framework/sysadapters/dia_SAFeatureInputHandling.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAInputHandling)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAInputHandling::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAInputHandling::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_INPUTHANLING_MAJOR_VERSION = 1;
   static const tU16 CCA_C_U16_SRV_INPUTHANLING_MINOR_VERSION = 0;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SAInputHandling",
         CCA_C_U16_APP_VD_INPUT
   );

   //
   // Service Plugins
   //

   // InputHandling standard service
   dia_SystemAdapterServicePlugin* pSAInputHandlingService = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SAInputHandlingSrv",
         CCA_C_U16_SRV_VD_INPUT,
         CCA_C_U16_SRV_INPUTHANLING_MAJOR_VERSION,
         CCA_C_U16_SRV_INPUTHANLING_MINOR_VERSION,
         mpObj
   );

   if (pSAInputHandlingService)
   {
      pSAInputHandlingService->setCondVarRetries(20);
   }

#if defined (__ENABLE_FEATURE_SYSSET_INCLUDE_INPUT_HANDLING__)
   // VD_Input diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSAInputHandlingServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SAInputSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
   );
#endif

   //
   // Feature Plugins
   //

   // feature implementation for the XM base services
   dia_SAFeatureInputHandling* pSAFeatureInputHandling = pFactory->createSystemAdapterFeature<dia_SAFeatureInputHandling> (
         "dia_SAFeatureInputHandling",
         pSAInputHandlingService
   );

   if ( pSAFeatureInputHandling ) {
      (tVoid) assignInterfaceAndNotifier<dia_IInputHandling,dia_IInputHandlingListener,dia_IInputHandlingNotifier>(pSAFeatureInputHandling);
   }

   if ( pSAFeatureInputHandling ) {
      (tVoid) assignInterfaceAndNotifier<dia_IInputHandlingPrj,dia_IInputHandlingPrjListener,dia_IInputHandlingPrjNotifier>(pSAFeatureInputHandling);
   }

   if ( pSAFeatureInputHandling ) {
      (tVoid) assignInterfaceAndNotifier<dia_IPIVIInputHandling,dia_IPIVIInputHandlingListener,dia_IPIVIInputHandlingNotifier>(pSAFeatureInputHandling);
   }

#if defined (__ENABLE_FEATURE_SYSSET_INCLUDE_INPUT_HANDLING__)
   //--- system settings feature via the diaglib service ----------------------
   dia_SAFeatureSystemSettings* pSAInputHandlingDataSystemSettings = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings> (
         "SAFeatureInputSysset",
         SYSSETID_INPUT,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT |
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION |
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSAInputHandlingServiceDiagLib
   );

   if ( pSAInputHandlingDataSystemSettings )
   {
      getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAInputHandlingDataSystemSettings);
   }
#endif

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAInputHandling::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAInputHandling::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



