/**
 * \file      dia_FactoryObjectSADimming.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include "common/framework/sysadapters/dia_SAFeatureDefaultSettingsCompatible.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif

#ifndef DIA_SAFEATUREDIMMING_H_
#include "project/framework/sysadapters/dia_SAFeatureDimming.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_SECOND_DISPLAY__
#include "project/framework/sysadapters/dia_SAFeatureSelfDiagnosisSecondDisplay.h"
#endif
#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_DIMMING__
#include "dia_FactoryObjectSADimming.h"
#endif


#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_TYPES
#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_FUNCTIONIDS
#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_SERVICEINFO
#include "dimming_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSADimming)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSADimming::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSADimming::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();
   static const tU16 CCA_C_U16_SRV_DIMMING_MAJOR_VERSION = DIMMING_MAINFI_C_U16_SERVICE_MAJORVERSION;
   static const tU16 CCA_C_U16_SRV_DIMMING_MINOR_VERSION = DIMMING_MAINFI_C_U16_SERVICE_MINORVERSION;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
           "DIA_SADimming",
           CCA_C_U16_APP_DRVASS_VIDEO
           );

   //
   // Service Plugins
   //

   dia_SystemAdapterServicePlugin* pSADimmingService = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SADimmingSrv",
         CCA_C_U16_SRV_VD_DIMMING,
         CCA_C_U16_SRV_DIMMING_MAJOR_VERSION,
         CCA_C_U16_SRV_DIMMING_MINOR_VERSION,
         mpObj
   );


   //
   // Feature Plugins
   //

   // add feature for production test
   dia_SAFeatureDimming* pSAFeatureDimming = pFactory->createSystemAdapterFeature<dia_SAFeatureDimming> (
         "SAFeatureDimming",
         pSADimmingService
   );

   if ( pSAFeatureDimming ) {
       (tVoid) assignInterfaceAndNotifier<dia_IDimming,dia_IDimmingListener,dia_IDimmingNotifier>(pSAFeatureDimming);
   }

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_DIMMING__
   // add feature for system settings (method based without using the diaglib --> compatibility mode)
   dia_SAFeatureDefaultSettingsCompatible* pSAFeatureDimmingSysSet = pFactory->createSystemAdapterDefSetFeature<dia_SAFeatureDefaultSettingsCompatible> (
         "SAFeatureDimmingSysset",
         SYSSETID_DIMM,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, //DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION,
         pSADimmingService,
         midw_fi_tcl_e8_DefSetGroups::FI_EN_DEFSET_GROUP__MAINTENANCE,
         DIMMING_MAINFI_C_U16_FI_VD_DIMMING_DEFAULT
   );

   if ( pSAFeatureDimmingSysSet ) {
      getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureDimmingSysSet);
   }
#endif

   dia_SAFeatureSelfDiagnosisSecondDisplay* pSAFeatureSelfDiagnosisSecondDisplay = pFactory->createSystemAdapterFeature<dia_SAFeatureSelfDiagnosisSecondDisplay> (
         "SAFeatureSelfDiagnosisSecondDisplay",
         pSADimmingService
   );
   if ( pSAFeatureSelfDiagnosisSecondDisplay ) {
      getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureSelfDiagnosisSecondDisplay);
   }
   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSADimming::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSADimming::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



