/*****************************************************************************
 * FILE:         dia_FactoryObjectSADiagnosisService.cpp
 * PROJECT:      AIVI
 * SW-COMPONENT: Diagnosis
 *-----------------------------------------------------------------------------
 * DESCRIPTION:  This is factory class for the Diagnosis system adapters to communicate with client components(Ex:HMI)
 *-----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2013 Robert Bosch Car Multimedia GmbH
 *
 * HISTORY:
 * Date      | Modification                                 | Author
 * 22.06.17  | Initial revision                             | abe6kor
 ******************************************************************************/

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include <project/framework/factory/dia_project_factory.h>
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_SERVICEINFO
#include <midw_fi_if.h>

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_DIAGNOSIS_SERVICE__
#include "dia_FactoryObjectSADiagnosisService.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_FactoryObjectSADiagnosisService.cpp.trc.h"
#endif

#ifndef dia_SAFeatureKDSEntry_H_
#include "common/framework/sysadapters/dia_SAFeatureKDSEntry.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_CONFIGITEM__
#include "project/framework/sysadapters/dia_SAFeatureConfigItem.h"
#endif

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_HMI__
#include "common/framework/sysadapters/dia_RemoteControlPluginHMI.h"
#endif

#ifndef __INCLUDED_DIA_SA_FEATURE_DIAG_INTERNAL_REQUEST__
#include "common/framework/sysadapters/dia_SAFeatureDiagInternalRequest.h"
#endif

#ifndef dia_SAFeatureTestPatternAIVI_H_
#include "project/framework/sysadapters/dia_SAFeatureTestPatternAIVI.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSADiagnosisService)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSADiagnosisService::setup ( tVoid )
{
	dia_tclFnctTrace oTrace("dia_FactoryObjectSADiagnosisService::setup");
	dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

	//
	// System Adapter object
	//

	mpObj = pFactory->createSystemAdapter (
			"DIA_SADiag",
			CCA_C_U16_APP_DIAGDEBUG //CCA_C_U16_APP_FC_DIAGNOSIS
	);

	//
	// Service Plugins
	//

	// Our Diagnosis service
	dia_SystemAdapterServicePlugin* pSADiagService = pFactory->createSystemAdapterServicePlugin (
			"DIA_SADiagnosisSrv",
			CCA_C_U16_SRV_DIAGDEBUG,
			MIDW_DIAGNOSTICSFI_C_U16_SERVICE_MAJORVERSION,
			MIDW_DIAGNOSTICSFI_C_U16_SERVICE_MINORVERSION,
			mpObj
	);

	//
	// Feature Plugins --> KDS Entry
	//

	(tVoid)pFactory->createSystemAdapterFeature<dia_SAFeatureKDSEntry> (
			"dia_SAFeatureKDSEntry",
			pSADiagService
	);

	//
	// Feature Plugins --> DiagConfigItem
	//

	(tVoid)pFactory->createSystemAdapterFeature<dia_SAFeatureConfigItem> (
			"dia_SAFeatureConfigItem",
			pSADiagService
	);

	//
	// Feature Plugins --> RemoteControl
	//

	dia_RemoteControlPluginHMI* pSAFeatureRemoteCtrlHMI = pFactory->createSystemAdapterFeature<dia_RemoteControlPluginHMI> (
			"dia_RemoteControlPluginHMI",
			pSADiagService
	);

	if ( pSAFeatureRemoteCtrlHMI )
	{
		(tVoid) dia_RemoteControl::getInstance()->addRemoteControlPlugin(pSAFeatureRemoteCtrlHMI);

		dia_RemoteControl* pRemoteCtrl = dia_RemoteControl::getInstance();
		if(pRemoteCtrl)
		{
			(tVoid) assignInterfaceAndNotifier<dia_IRemoteControl,dia_IRemoteControlListener,dia_IRemoteControlNotifier>(pRemoteCtrl);
		}
	}

	//
	// Feature Plugins --> TestPattern
	//

	dia_SAFeatureTestPatternAIVI* pSAFeatureTestPattern = pFactory->createSystemAdapterFeature<dia_SAFeatureTestPatternAIVI> (
			"dia_SAFeatureTestPatternAIVI",
			pSADiagService
	);

	if ( pSAFeatureTestPattern ) {
		(tVoid) assignInterfaceAndNotifier<dia_IDisplayPatternAIVI,dia_IDisplayPatternAIVIListener,dia_IDisplayPatternAIVINotifier>(pSAFeatureTestPattern);
	}

   //
   // Feature Plugins --> InternalDiagRequest
   //

   (void) pFactory->createSystemAdapterFeature<dia_SAFeatureDiagInternalRequest> (
         "dia_SAFeatureDiagInternalRequest",
         pSADiagService
   );

	return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSADiagnosisService::tearDown ( tVoid )
{
	dia_tclFnctTrace oTrace("dia_FactoryObjectSADiagnosisService::tearDown");
	OSAL_DELETE mpObj;
	mpObj = 0;

	return DIA_SUCCESS;
}



