/**
 * \file      dia_FactoryObjectSAClock.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include "common/framework/sysset/dia_common_sysset.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif
#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include "common/framework/sysadapters/dia_SAFeatureDefaultSettingsCompatible.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_CLOCK__
#include "dia_FactoryObjectSAClock.h"
#endif

#ifndef DIA_SAFEATURE_CLOCK_H_
#include "project/framework/sysadapters/dia_SAFeatureClock.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CLEAR_CLOCK_HISTORY__
#include "project/framework/sysadapters/dia_SAFeatureClearClockHistory.h"
#endif

#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_TYPES
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_FUNCTIONIDS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_SERVICEINFO
#include "clock_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAClock)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAClock::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAClock::setup");

   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SAClock",
         CCA_C_U16_APP_VD_CLOCK
         );

   //
   // Service Plugins
   //

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_CLOCK__

   // VD_CLock diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSAClockServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SAClockSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
    );

#endif

   // vd_clock stadard service
   dia_SystemAdapterServicePlugin* pSAClockService = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SAClockSrv",
         CCA_C_U16_SRV_CLOCK,
         CLOCK_MAINFI_C_U16_SERVICE_MAJORVERSION,
         CLOCK_MAINFI_C_U16_SERVICE_MINORVERSION,
         mpObj
   );

   //
   // Feature Plugins
   //

   // feature for base vd_clock interface methods/properties
   dia_SAFeatureClock* pSAFeatureClock = pFactory->createSystemAdapterFeature<dia_SAFeatureClock> (
           "SAFeatureClock",
           pSAClockService
           );

   if ( pSAFeatureClock )
   {
      (void) assignInterfaceAndNotifier<dia_ISWControl, dia_ISWControlListener, dia_ISWControlNotifier> (pSAFeatureClock);
   }

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_CLOCK__

   // system settings feature via the diaglib service
   dia_SAFeatureSystemSettings* pSAFeatureClockSysSet = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings> (
         "SAFeatureClockSysSet",
         SYSSETID_CLOC,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSAClockServiceDiagLib
   );

   if ( pSAFeatureClockSysSet ) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureClockSysSet);
   }

#endif

   // add feature for clear MCAN history settings (using system settings framework)
   dia_SAFeatureClearClockHistory* pSAFeatureClockMCANClear = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureClearClockHistory> (
         "SAFeatureClearClkHistory",
         SYSSETID_CLOC,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_CLEAR_MCAN_HISTORIES,
         pSAClockService
   );

   if ( pSAFeatureClockMCANClear )
   {
      getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureClockMCANClear);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAClock::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAClock::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



