/**
 * \file      dia_FactoryObjectSABluetooth.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 * --------------------------------------------------------
 * Date 	       | Author	          | Modification
 * 9.12.15         | nce5kor          | Changed major, minor version and created object for Blutooth Most SA(AIVI-13213)
 * --------------------------------------------------------
 */


#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include "common/framework/sysadapters/dia_SAFeatureDefaultSettingsCompatible.h"
#endif

#if 0 //STC2HI: TODO
#include "project/framework/sysadapters/dia_SAFeatureBTPhoneBase.h"
#include "project/framework/sysadapters/dia_SAFeatureMicrophone.h"
#else //STC2HI: TODO
#include "project/framework/sysadapters/dia_SAFeatureBluetooth.h"
#endif //STC2HI: TODO
#include "project/framework/sysadapters/dia_SAFeatureBluetoothMost.h"

#ifndef __INCLUDED_DIA_SAFEATUREBTDEVICELIST_H__
#include <common/framework/sysadapters/dia_SAFeatureBTDeviceList.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_BLUETOOTH__
#include "dia_FactoryObjectSABluetooth.h"
#endif

#if 0 //STC2HI: TODO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_PHONEFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_PHONEFI_SERVICEINFO
#include "midw_ext_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif //STC2HI: TODO

#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO
#include "conn_most_fi_if.h"

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSABluetooth)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSABluetooth::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSABluetooth::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

#if 0 //STC2HI: TODO
   static const tU16 CCA_C_U16_SRV_FC_PHONE_MAJOR_VERSION = MIDW_EXT_PHONEFI_C_U16_SERVICE_MAJORVERSION;
   static const tU16 CCA_C_U16_SRV_FC_PHONE_MINOR_VERSION = MIDW_EXT_PHONEFI_C_U16_SERVICE_MINORVERSION;
#endif //STC2HI: TODO

   static const tU16 CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS_MAJOR_VERSION = MOST_BTSETFI_C_U16_SERVICE_MAJORVERSION;
   static const tU16 CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS_MINOR_VERSION = MOST_BTSETFI_C_U16_SERVICE_MINORVERSION;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SABluetooth",
         CCA_C_U16_APP_BLUETOOTH
   );

   //
   // Service Plugins
   //

#if 0 //STC2HI: TODO
   // Phone standard service
   dia_SystemAdapterServicePlugin* pSAPhoneService = pFactory->createSystemAdapterServicePlugin (
         "DIA_SAPhoneSrv",
         CCA_C_U16_SRV_PHONE_GENERAL,
         CCA_C_U16_SRV_FC_PHONE_MAJOR_VERSION,
         CCA_C_U16_SRV_FC_PHONE_MINOR_VERSION,
         mpObj
   );
#endif //STC2HI: TODO

   // Bluetooth standard service
   dia_SystemAdapterServicePlugin* pSABTDeviceListService = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SABTDeviceListSrv",
         CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS,
         CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS_MAJOR_VERSION,
         CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS_MINOR_VERSION,
         mpObj
   );

   // Bluetooth diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSABluetoothServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SABluetoothSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
    );

   //
   // Feature Plugins
   //

   // feature implementation for the Most Bluetooth services
   dia_SAFeatureBTDeviceList* pSAFeatureBTDeviceListBase = pFactory->createSystemAdapterFeature<dia_SAFeatureBTDeviceList> (
         "SAFeatureBTDeviceList",
         pSABTDeviceListService
   );

   if (pSAFeatureBTDeviceListBase) {
      (tVoid) assignInterfaceAndNotifier<dia_IBTDeviceList, dia_IBTDeviceListListener, dia_IBTDeviceListNotifier>(pSAFeatureBTDeviceListBase);
   }

#if 0 //STC2HI: TODO
   // feature implementation for the phone base services
   dia_SAFeatureBTPhoneBase* pSAFeatureBTPhoneBase = pFactory->createSystemAdapterFeature<dia_SAFeatureBTPhoneBase> (
         "SAFeatureBTPhoneBase",
         pSAPhoneService
   );

   if (pSAFeatureBTPhoneBase) {
      (tVoid) assignInterfaceAndNotifier<dia_IBluetooth, dia_IBluetoothListener, dia_IBluetoothNotifier>(pSAFeatureBTPhoneBase);
   }

   // feature implementation for the phone base services
   dia_SAFeatureMicrophone* pSAFeatureMicrophone = pFactory->createSystemAdapterFeature < dia_SAFeatureMicrophone > (
         "SAFeatureMicrohone",
         pSAPhoneService
   );

   if (pSAFeatureMicrophone) {
      (tVoid) assignInterfaceAndNotifier<dia_IMicrophone, dia_IMicrophoneListener, dia_IMicrophoneNotifier>(pSAFeatureMicrophone);
   }
#endif //STC2HI: TODO

   // Bluetooth Diaglib feature
   dia_SAFeatureBluetooth* pSABluetoothDiaglib = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureBluetooth>(
         "pSABluetoothDiaglib",
         pSABluetoothServiceDiagLib
   );

   if ( pSABluetoothDiaglib ) {
      (tVoid) assignInterfaceAndNotifier<dia_IBluetooth,dia_IBluetoothListener,dia_IBluetoothNotifier>(pSABluetoothDiaglib);
      (tVoid) assignInterfaceAndNotifier<dia_IWifi,dia_IWifiListener,dia_IWifiNotifier>(pSABluetoothDiaglib);
   }

   // Bluetooth MOST feature
   dia_SAFeatureBluetoothMost* pSABluetoothMost = pFactory->createSystemAdapterFeature<dia_SAFeatureBluetoothMost>(
         "pSABluetoothMost",
         pSABTDeviceListService
   );

   if ( pSABluetoothMost ) {
      (tVoid) assignInterfaceAndNotifier<dia_IBluetoothMost,dia_IBluetoothMostListener,dia_IBluetoothMostNotifier>(pSABluetoothMost);
      (tVoid) assignInterfaceAndNotifier<dia_IWifiMost,dia_IWifiMostListener,dia_IWifiMostNotifier>(pSABluetoothMost);
   }

#if 0 //STC2HI: TODO
#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_PHONE__
   // add feature for system settings (method based without using the diaglib --> compatibility mode)
   dia_SAFeatureDefaultSettingsCompatible* pSAFeaturePhoneSysset = pFactory->createSystemAdapterDefSetFeature<dia_SAFeatureDefaultSettingsCompatible> (
         "SAFeaturePhoneSysset",
         SYSSETID_PHON,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSAPhoneService,
         midw_fi_tcl_e8_DiagDefSetGroups::FI_EN_DEFSET_GROUP_UNDEFIEND,
         MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_DIAGNOSIS_CONFIGURATION
         );

   if ( pSAFeaturePhoneSysset ) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeaturePhoneSysset);
   }
#endif
#endif //STC2HI: TODO

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSABluetooth::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSABluetooth::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



