/**
 * \file      dia_FactoryObjectSAAux.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      25.09.2015
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_PROJECT_FACTORY__
#include <project/framework/factory/dia_project_factory.h>
#endif

#include <project/framework/sysadapters/dia_SAFeatureAux.h>

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_IPOD__
#include "dia_FactoryObjectSAAux.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAAux)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAAux::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAAux::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();
   static const tU16 CCA_C_U16_SRV_AUX_MAJOR_VERSION = 1;
   static const tU16 CCA_C_U16_SRV_AUX_MINOR_VERSION = 0;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
          "DIA_SAAux",
          CCA_C_U16_APP_FC_AUX
          );

   //
   // Service Plugins
   //

   dia_SystemAdapterServicePlugin* pSAAuxService = pFactory->createSystemAdapterServicePluginNoMonitoring (
          "DIA_SAAuxSrv",
          CCA_C_U16_SRV_AUX,
          CCA_C_U16_SRV_AUX_MAJOR_VERSION,
          CCA_C_U16_SRV_AUX_MINOR_VERSION,
          mpObj
          );

   //
   // Feature Plugins
   //

   // add feature for production test
   dia_SAFeatureAux* pSAFeatureAux = pFactory->createSystemAdapterFeature<dia_SAFeatureAux> (
          "SAFeatureAux",
          pSAAuxService
          );

   if (pSAFeatureAux) {
      (void) assignInterfaceAndNotifier<dia_IAux, dia_IAuxListener, dia_IAuxNotifier>(pSAFeatureAux);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAAux::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAAux::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}
