/**
 * \file    dia_DataDownloadStrategyInstallationContainer.cpp
 *
 * \brief   Implements the data downlad strategy for CIS Installation Container.
 *
 * \author  ama8kor
 * \date    20.05.2019
 *
 * \copyright Robert Bosch Car Multimedia 2019
 */

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_INSTALLATION_CONTAINER__
#include "dia_DataDownloadStrategyInstallationContainer.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

static std::string dnlStrategyName("dia_DataDownloadStrategyInstallationContainer");
//-----------------------------------------------------------------------------

dia_DataDownloadStrategyInstallationContainer::dia_DataDownloadStrategyInstallationContainer ( tU8 fmtID, tU8 addrFmt )
   : dia_DataDownloadStrategyDefault(dnlStrategyName, fmtID, addrFmt )
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyInstallationContainer::dia_DataDownloadStrategyInstallationContainer (...)");
}

//-----------------------------------------------------------------------------

dia_DataDownloadStrategyInstallationContainer::~dia_DataDownloadStrategyInstallationContainer ( void )
{
	DIA_TR_INF("dia_DataDownloadStrategyInstallationContainer::~dia_DataDownloadStrategyInstallationContainer");
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadStrategyInstallationContainer::transferExit ( std::vector<tU8>& requestData )
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyInstallationContainer::transferExit (...)");
   tDiaResult retVal=DIA_FAILED;

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      pEngine->getSessionController()->removeListener(this);
   }
   else
   {
      DIA_TR_ERR("!!! dia_DataDownloadStrategyInstallationContainer::transferExit => ERROR: Unable to deregister for Session changes");
   }

   retVal = dia_DataDownloadStrategyDefault::transferExit( requestData );

   DIA_TR_INF("dia_DataDownloadStrategyInstallationContainer::transferExit returned 0x%08X.", retVal);
   
   return retVal;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadStrategyInstallationContainer::requestDownload ( std::vector<tU8>& requestData )
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyInstallationContainer::requestDownload()");

   //call base method
   tDiaResult retVal = dia_DataDownloadStrategyDefault::requestDownload( requestData );

   if (retVal == DIA_SUCCESS)
   {
      dia_EngineServer* pEngine = 0;
      if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
      {
         pEngine->getSessionController()->addListener(this);
      }
      else
      {
         DIA_TR_ERR("!!! dia_DataDownloadStrategyInstallationContainer::requestDownload => ERROR: Unable to register for Session changes");
      }
   }
   else
   {
      DIA_TR_ERR("dia_DataDownloadStrategyInstallationContainer::requestDownload => ERROR from base class: 0x%x", retVal);

      if (mpFSM)
      {
         mpFSM->acceptEvent(dia_DataDownloadFSM::evIdle,0);
      }
      else
      {
         DIA_TR_ERR("dia_DataDownloadStrategyInstallationContainer::requestDownload => ERROR: FSM IS NULL!!!");
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadStrategyInstallationContainer::requestUpload ( std::vector<tU8>& requestData )
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyInstallationContainer::requestUpload()");

   //call base method
   tDiaResult retVal = dia_DataDownloadStrategyDefault::requestUpload( requestData );

   if (retVal == DIA_SUCCESS)
   {
      dia_EngineServer* pEngine = 0;
      if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
      {
         pEngine->getSessionController()->addListener(this);
      }
      else
      {
         DIA_TR_ERR("!!! dia_DataDownloadStrategyInstallationContainer::requestUpload => ERROR: Unable to register for Session changes");
      }
   }
   else
   {
      DIA_TR_ERR("dia_DataDownloadStrategyInstallationContainer::requestUpload => ERROR from base class: 0x%x", retVal);

      if (mpFSM)
      {
         mpFSM->acceptEvent(dia_DataDownloadFSM::evIdle,0);
      }
      else
      {
         DIA_TR_ERR("dia_DataDownloadStrategyInstallationContainer::requestUpload => ERROR: FSM IS NULL!!!");
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------

void
dia_DataDownloadStrategyInstallationContainer::vOnSessionChanged ( tU8 newSession, tU8 oldSession )
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyInstallationContainer::vOnSessionChanged(...)");

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      pEngine->getSessionController()->removeListener(this);
   }
   else
   {
      DIA_TR_ERR("!!! dia_DataDownloadStrategyInstallationContainer::vOnSessionChanged => ERROR: Unable to deregister for Session changes");
   }

   postprocessDownload(0);

   if (mpFSM)
   {
      DIA_TR_INF("dia_DataDownloadStrategyInstallationContainer session change from %d to %d in state '%s'", oldSession, newSession, mpFSM->getStateName());

      mpFSM->acceptEvent(dia_DataDownloadFSM::evIdle,0);
   }
   else
   {
      DIA_TR_ERR("dia_DataDownloadStrategyInstallationContainer::vOnSessionChanged => ERROR: FSM IS NULL!!!");
   }
}