/*
 * dia_defsProjectConfig.h
 *
 *  Created on: 13.12.2010
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#define __INCLUDED_DIA_DEFS_CONFIG_PROJECT__

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __DIA_UNIT_TESTING__  /* remove external-component dependency for UT */
#define DP_S_IMPORT_INTERFACE_KDS_FI
#include "dp_kds_if.h"     //_GEN\ai_projects\generated\components\datapool\dp_kds_if.h
#endif

#ifdef VARIANT_S_FTR_ENABLE_NPIVI

#ifndef __INCLUDED_DIA_ENGINE_CONFIG_VEHICLE_SETTINGS_BCM__
#include "project/framework/config/dia_EngineConfigVehicleSettingsBCM.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIG_VEHICLE_SETTINGS_ALC__
#include "project/framework/config/dia_EngineConfigVehicleSettingsALC.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIG_VEHICLE_SETTINGS_ADP__
#include "project/framework/config/dia_EngineConfigVehicleSettingsADP.h"
#endif

#endif //VARIANT_S_FTR_ENABLE_NPIVI

#define DIA_AIVI_VARIANT_CODING_LENGTH                32
#define DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH       3
#define DIA_AIVI_ECU_HW_NR_LENGTH                     10
#define DIA_PROP_CUSTOMER_CONFIG_HASH_VALUE            DIA_PROP_AIVI_CONFIG_HASH_VALUE

// The following macros are used to assign property IDs to certain ranges
#define DIA_PROP_AIVI(pid)              (((tU32) (pid)) | DIA_PROP_RANGE_START_PROJECT_01)
#define DIA_PROP_NISSAN(pid)            (((tU32) (pid)) | DIA_PROP_RANGE_START_PROJECT_02)
#define DIA_PROP_RENAULT(pid)           (((tU32) (pid)) | DIA_PROP_RANGE_START_PROJECT_03)
#define DIA_PROP_CENTER_CMC_19(pid)     (((tU32) (pid)) | DIA_PROP_RANGE_START_PROJECT_04)

// A-IVI specific properties
//#define DIA_PROP_AIVI_BT_NAME                           DIA_PROP_AIVI(((tU32) 0x00000014))
#define DIA_PROP_AIVI_CAMERA_SYSTEM                     DIA_PROP_AIVI(((tU32) 0x00000011))
#define DIA_PROP_AIVI_VEHICLE_INFO                      DIA_PROP_AIVI(((tU32) 0x00000012))
#define DIA_PROP_AIVI_ECO_ROUTE                         DIA_PROP_AIVI(((tU32) 0x00000013))
#define DIA_PROP_AIVI_CONFIG_HASH_VALUE                 DIA_PROP_AIVI(((tU32) 0x00000015))
#define DIA_PROP_AIVI_CONFIG_PARTS_NUMBER               DIA_PROP_AIVI(((tU32) 0x00000016))
#define DIA_PROP_AIVI_SENSOR_CONFIG_GYRO                DIA_PROP_AIVI(((tU32) 0x00000017))
//#define DIA_PROP_AIVI_WIFI_NAME_1                       DIA_PROP_AIVI(((tU32) 0x00000018))
//#define DIA_PROP_AIVI_WIFI_NAME_2                       DIA_PROP_AIVI(((tU32) 0x00000019))
#define DIA_PROP_AIVI_ANTENNA_PARAM_SET                 DIA_PROP_AIVI(((tU32) 0x0000001A))
#define DIA_PROP_AIVI_DAB_SET                           DIA_PROP_AIVI(((tU32) 0x0000001B))
#define DIA_PROP_AIVI_HD_PARAM_SET                      DIA_PROP_AIVI(((tU32) 0x0000001C))
#define DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET           DIA_PROP_AIVI(((tU32) 0x0000001D))
#define DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET_01        DIA_PROP_AIVI(((tU32) 0x0000001E))
#define DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET_02        DIA_PROP_AIVI(((tU32) 0x0000001F))
#define DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET              DIA_PROP_AIVI(((tU32) 0x00000020))
#define DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET_01           DIA_PROP_AIVI(((tU32) 0x00000021))
#define DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET_02           DIA_PROP_AIVI(((tU32) 0x00000022))
#define DIA_PROP_AIVI_AUDIO_PARAM_SET                   DIA_PROP_AIVI(((tU32) 0x00000023))
#define DIA_PROP_AIVI_AUDIO_PARAM_SET_01                DIA_PROP_AIVI(((tU32) 0x00000024))
#define DIA_PROP_AIVI_AUDIO_PARAM_SET_02                DIA_PROP_AIVI(((tU32) 0x00000025))
#define DIA_PROP_AIVI_ACOUSTIC_PARAM                    DIA_PROP_AIVI(((tU32) 0x00000026))
#define DIA_PROP_AIVI_VR_PARAM                          DIA_PROP_AIVI(((tU32) 0x00000029))
#define DIA_PROP_AIVI_SENSOR_CONFIG_GNSS                DIA_PROP_AIVI(((tU32) 0x0000002A))
#define DIA_PROP_AIVI_SENSOR_CONFIG_ACC                 DIA_PROP_AIVI(((tU32) 0x0000002B))
#define DIA_PROP_AIVI_SYSTEM_INFO_COMMON                DIA_PROP_AIVI(((tU32) 0x00000010))
#define DIA_PROP_AIVI_ECU_PART_NUMBER                   DIA_PROP_AIVI(((tU32) 0x0000002C))
#define DIA_PROP_AIVI_ECU_SW_VERSION                    DIA_PROP_AIVI(((tU32) 0x0000002D))
#define DIA_PROP_AIVI_ECU_SW_VERSION_NUMBER             DIA_PROP_AIVI(((tU32) 0x0000002E))
#define DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION            DIA_PROP_AIVI(((tU32) 0x0000002F))
#define DIA_PROP_AIVI_ECU_HW_NUMBER                     DIA_PROP_AIVI(((tU32) 0x00000030))
#define DIA_PROP_AIVI_VEHICLE_MANU_SPARE_PART_NUMBER    DIA_PROP_AIVI(((tU32) 0x00000031))
#define DIA_PROP_AIVI_ECU_SERIAL_NUMBER                 DIA_PROP_AIVI(((tU32) 0x00000032))
#define DIA_PROP_AIVI_THERMAL_MANAGE_TEMP_THRESHOLDS    DIA_PROP_AIVI(((tU32) 0x00000033))
#define DIA_PROP_AIVI_CONFIG_SYSTEM_SUPPLIER_NUMBER     DIA_PROP_AIVI(((tU32) 0x00000034))
#define DIA_PROP_AIVI_VDIAG_NUMBER                      DIA_PROP_AIVI(((tU32) 0x00000035))
#define DIA_PROP_AIVI_VEH_MANUFACTURER_ECU_HW_NR        DIA_PROP_AIVI(((tU32) 0x00000036))
#define DIA_PROP_AIVI_VEH_MANUFACTURER_SPARE_PART_R_NR  DIA_PROP_AIVI(((tU32) 0x00000037))
#define DIA_PROP_AIVI_VEH_MANUFACTURER_SPARE_PART_N_NR  DIA_PROP_AIVI(((tU32) 0x00000038))
#define DIA_PROP_AIVI_VARIANT_CODING                    DIA_PROP_AIVI(((tU32) 0x0000003C))
#define DIA_PROP_AIVI_OCCURENCE_COUNTER                 DIA_PROP_AIVI(((tU32) 0x0000003D))
//#define DIA_PROP_AIVI_AUDIO_SOURCE_OFFSET               DIA_PROP_AIVI(((tU32) 0x0000003E))
#define DIA_PROP_AIVI_AUDIO_SOURCE_OFFSET_LEN           300 // Max 2046
#define DIA_PROP_PNM_GROUP_10_CONFIG_DATA_LEN    		01// Max 8
#define DIA_PROP_PNM_GROUP_10_CONFIG_KDS_KEY   			0x0DC4 // to access PNM group CD KDS key

#define DIA_PROP_AIVI_CAN_GEN_NUMBER                    DIA_PROP_AIVI(((tU32) 0x0000003F))
#define DIA_PROP_AIVI_DISABLE_DTC_AND_CSA_FOR_LBS       DIA_PROP_AIVI(((tU32) 0x00000040))      /* CSA = Customer Security Access */

#define DIA_PROP_AIVI_SIGMA_DATA                        DIA_PROP_AIVI(((tU32) 0x00000044))
#define DIA_PROP_AIVI_SPEED_LOCKOUT                     DIA_PROP_AIVI(((tU32) 0x00000045))
#define DIA_PROP_AIVI_MEX_CONFIG                        DIA_PROP_AIVI(((tU32) 0x00000046))
#define DIA_PROP_AIVI_FACTORY_MODE                      DIA_PROP_AIVI(((tU32) 0x00000047))
#define DIA_PROP_AIVI_CONNECTIVITY_CONFIG               DIA_PROP_AIVI(((tU32) 0x00000048))
#define DIA_PROP_AIVI_HMI_CONFIG                        DIA_PROP_AIVI(((tU32) 0x00000049))
#define DIA_PROP_AIVI_SOUND_VOLUME_CONFIG               DIA_PROP_AIVI(((tU32) 0x0000004A))
#define DIA_PROP_AIVI_HW_REF_A                          DIA_PROP_AIVI(((tU32) 0x0000004B))
#define DIA_PROP_AIVI_SECURITY_FINGERPRINT              DIA_PROP_AIVI(((tU32) 0x0000004C))
#define DIA_PROP_AIVI_BLOCK_FD00_REFERENCE_CHECKSUM     DIA_PROP_AIVI(((tU32) 0x0000004D))
#define DIA_PROP_AIVI_BLOCK_FD08_ESE                    DIA_PROP_AIVI(((tU32) 0x0000004E))
#define DIA_PROP_AIVI_BRIGHTNESS                        DIA_PROP_AIVI(((tU32) 0x0000004F))
#define DIA_PROP_AIVI_RESULT_CHECK_PROG_DEP             DIA_PROP_AIVI(((tU32) 0x00000050))      /* Result of last Check Programming Dependency: 0x00 undefined/test not run, 0x01 Passed, 0x02 Failed */
#define DIA_PROP_AIVI_KEY_ILLUMINATION_ALIGNMENT_COEFF2 DIA_PROP_AIVI(((tU32) 0x00000051))
#define DIA_PROP_AIVI_DISP_ILLUMINATION_ALIGNMENT_COEFF DIA_PROP_AIVI(((tU32) 0x00000052))

// last entry 0x00052

// Reprogramming - Digest
#define DIA_PROP_AIVI_DIGEST_FD00_REFERENCE_CHECKSUM           DIA_PROP_AIVI(((tU32) 0x00000060))
#define DIA_PROP_AIVI_DIGEST_FD01_PHONE_ECNR_NBS               DIA_PROP_AIVI(((tU32) 0x00000061))
#define DIA_PROP_AIVI_DIGEST_FD02_PHONE_ECNR_WBS               DIA_PROP_AIVI(((tU32) 0x00000062))
#define DIA_PROP_AIVI_DIGEST_FD03_VR_PARAM                     DIA_PROP_AIVI(((tU32) 0x00000063))
#define DIA_PROP_AIVI_DIGEST_FD04_CARPLAY_PHONE_ECNR_NBS       DIA_PROP_AIVI(((tU32) 0x00000064))
#define DIA_PROP_AIVI_DIGEST_FD05_CARPLAY_PHONE_ECNR_WBS       DIA_PROP_AIVI(((tU32) 0x00000065))
#define DIA_PROP_AIVI_DIGEST_FD06_CARPLAY_FACETIME_ECNR_SWB    DIA_PROP_AIVI(((tU32) 0x00000066))
#define DIA_PROP_AIVI_DIGEST_FD07_ACOUSTIC_PARAM               DIA_PROP_AIVI(((tU32) 0x00000067))
#define DIA_PROP_AIVI_DIGEST_FD08_ESE_PARAM                    DIA_PROP_AIVI(((tU32) 0x00000068))
#define DIA_PROP_AIVI_DIGEST_FD09_BT_VOICE_ECNR_NBS            DIA_PROP_AIVI(((tU32) 0x00000069))
#define DIA_PROP_AIVI_DIGEST_FD0A_BT_VOICE_ECNR_WBS            DIA_PROP_AIVI(((tU32) 0x0000006A))
#define DIA_PROP_AIVI_DIGEST_FD0B_BT_SIRI_ECNR_WBS             DIA_PROP_AIVI(((tU32) 0x0000006B))
#define DIA_PROP_AIVI_DIGEST_FD0C_CARPLAY_SIRI_ECNR_WBS        DIA_PROP_AIVI(((tU32) 0x0000006C))
#define DIA_PROP_AIVI_DIGEST_FD0D_ANDROID_AUTO_VR_ECNR_WBS     DIA_PROP_AIVI(((tU32) 0x0000006D))
#define DIA_PROP_AIVI_DIGEST_FD0E_ECNR_VPA_VOICE_WB            DIA_PROP_AIVI(((tU32) 0x0000006E))

// A-IVI defautl config items
#define DIA_PROP_AIVI_DEF_SYSTEM_INFO_COMMON            DIA_PROP_AIVI(((tU32) 0x00000070))
#define DIA_PROP_AIVI_DEF_CAMERA_SYSTEM                 DIA_PROP_AIVI(((tU32) 0x00000071))
#define DIA_PROP_AIVI_DEF_VEHICLE_INFO                  DIA_PROP_AIVI(((tU32) 0x00000072))
#define DIA_PROP_AIVI_DEF_ECO_ROUTE                     DIA_PROP_AIVI(((tU32) 0x00000073))
#define DIA_PROP_AIVI_DEF_BT_NAME                       DIA_PROP_AIVI(((tU32) 0x00000074))
#define DIA_PROP_AIVI_DEF_CONFIG_HASH_VALUE             DIA_PROP_AIVI(((tU32) 0x00000075))
#define DIA_PROP_AIVI_DEF_CONFIG_PARTS_NUMBER           DIA_PROP_AIVI(((tU32) 0x00000076))
#define DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GYRO            DIA_PROP_AIVI(((tU32) 0x00000077))
#define DIA_PROP_AIVI_DEF_FMAM_TUNER_PARAM_SET          DIA_PROP_AIVI(((tU32) 0x00000078))
#define DIA_PROP_AIVI_DEF_ANTENNA_PARAM_SET             DIA_PROP_AIVI(((tU32) 0x00000079))
#define DIA_PROP_AIVI_DEF_DAB_SET                       DIA_PROP_AIVI(((tU32) 0x0000007A))
#define DIA_PROP_AIVI_DEF_GENERIC_TUNER_PARAM_SET       DIA_PROP_AIVI(((tU32) 0x0000007B))
#define DIA_PROP_AIVI_DEF_HD_PARAM_SET                  DIA_PROP_AIVI(((tU32) 0x0000007C))
#define DIA_PROP_AIVI_DEF_WIFI_NAME_1                   DIA_PROP_AIVI(((tU32) 0x0000007D))
#define DIA_PROP_AIVI_DEF_WIFI_NAME_2                   DIA_PROP_AIVI(((tU32) 0x0000007E))
#define DIA_PROP_AIVI_DEF_ACOUSTIC_PARAM                DIA_PROP_AIVI(((tU32) 0x0000007F))
#define DIA_PROP_AIVI_DEF_PHONE_ECNR_WBS                DIA_PROP_AIVI(((tU32) 0x00000080))
#define DIA_PROP_AIVI_DEF_PHONE_ECNR_NBS                DIA_PROP_AIVI(((tU32) 0x00000081))
#define DIA_PROP_AIVI_DEF_ANTITHEF_MAP_SELECTION        DIA_PROP_AIVI(((tU32) 0x00000082))
#define DIA_PROP_AIVI_DEF_AUDIO_PARAM_SET               DIA_PROP_AIVI(((tU32) 0x00000083))
#define DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GNSS            DIA_PROP_AIVI(((tU32) 0x00000084))
#define DIA_PROP_AIVI_DEF_SENSOR_CONFIG_ACC             DIA_PROP_AIVI(((tU32) 0x00000085))
#define DIA_PROP_AIVI_DEF_CARPLAY_PHONE_ECNR_NBS        DIA_PROP_AIVI(((tU32) 0x00000086))
#define DIA_PROP_AIVI_DEF_CARPLAY_PHONE_ECNR_WBS        DIA_PROP_AIVI(((tU32) 0x00000087))
#define DIA_PROP_AIVI_DEF_CARPLAY_FACETIME_ECNR_SWB     DIA_PROP_AIVI(((tU32) 0x00000088))
#define DIA_PROP_AIVI_VIN                               DIA_PROP_AIVI(((tU32) 0x00000089))
#define DIA_PROP_AIVI_DEF_MEX_CONFIG                    DIA_PROP_AIVI(((tU32) 0x0000008A))
#define DIA_PROP_AIVI_DEF_FACTORY_MODE                  DIA_PROP_AIVI(((tU32) 0x0000008B))
#define DIA_PROP_AIVI_DEF_CONNECTIVITY_CONFIG           DIA_PROP_AIVI(((tU32) 0x0000008C))
#define DIA_PROP_AIVI_DEF_HMI_CONFIG                    DIA_PROP_AIVI(((tU32) 0x0000008D))
#define DIA_PROP_AIVI_DEF_SOUND_VOLUME_CONFIG           DIA_PROP_AIVI(((tU32) 0x0000008E))
#define DIA_PROP_AIVI_VEH_MANUFACTURER_HW_D_NR          DIA_PROP_AIVI(((tU32) 0x0000008F))
#define DIA_PROP_AIVI_DEF_DRM_TUNER_PARAMETER_SET       DIA_PROP_AIVI(((tU32) 0x00000090))

// last entry 0x00090

#define DIA_PROP_AIVI_CERTIFICATE                       DIA_PROP_AIVI(((tU32) 0x000000A0))

// A-IVI GPIO -- Starts 0x000B0
#define DIA_PROP_GPIO_SYSTEM_AMP_ON_OUTPUT              DIA_PROP_AIVI(((tU32) 0x000000B0))
#define DIA_PROP_GPIO_AUDIO_EXT_OUT_TEL_MODE            DIA_PROP_AIVI(((tU32) 0x000000B1))
#define DIA_PROP_GPIO_AUDIO_EXT_OUT_HF_VR               DIA_PROP_AIVI(((tU32) 0x000000B2))
#define DIA_PROP_GPIO_UNUSED_EXT_IN_DAY_NIGHT           DIA_PROP_AIVI(((tU32) 0x000000B3))
#define DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO     DIA_PROP_AIVI(((tU32) 0x000000B4))
#define DIA_PROP_GPIO_DETECT_PLUG                       DIA_PROP_AIVI(((tU32) 0x000000B5))
#define DIA_PROP_GPIO_DETECT_PLUG_DIAG                  DIA_PROP_AIVI(((tU32) 0x000000B6))
#define DIA_PROP_GPIO_EXT_OUT_SPARE3                    DIA_PROP_AIVI(((tU32) 0x000000B7))

// last entry 0x000B7

//Status of DTC FTB 0x51 for Logical Blocks
#define DIA_PROP_AIVI_LB00_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C0))
#define DIA_PROP_AIVI_LB01_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C1))
#define DIA_PROP_AIVI_LB02_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C2))
#define DIA_PROP_AIVI_LB03_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C3))
#define DIA_PROP_AIVI_LB04_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C4))
#define DIA_PROP_AIVI_LB05_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C5))
#define DIA_PROP_AIVI_LB06_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C6))
#define DIA_PROP_AIVI_LB07_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C7))
#define DIA_PROP_AIVI_LB08_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C8))
#define DIA_PROP_AIVI_LB09_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000C9))
#define DIA_PROP_AIVI_LB10_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000CA))
#define DIA_PROP_AIVI_LB11_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000CB))
#define DIA_PROP_AIVI_LB12_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000CC))
#define DIA_PROP_AIVI_LB13_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000CD))
#define DIA_PROP_AIVI_LB14_DTC_PROGRAMMING_FAILURE_STATUS    DIA_PROP_AIVI(((tU32) 0x000000CE))

//Vehicle Setting (triggered by HMI)
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM                                     DIA_PROP_AIVI(((tU32) 0x000000D0))    /* only reading */
#define DIA_PROP_AIVI_VEHICLE_SETTING_ALC                                     DIA_PROP_AIVI(((tU32) 0x000000D1))    /* only reading */
#define DIA_PROP_AIVI_VEHICLE_SETTING_ADP                                     DIA_PROP_AIVI(((tU32) 0x000000D2))    /* only reading */
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AUTO_LIGHT_TIM                      DIA_PROP_AIVI(((tU32) 0x000000D3))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AUTO_LIGHT_DLY_TIM                  DIA_PROP_AIVI(((tU32) 0x000000D4))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_LANE_CHANGES_3_FLASH                DIA_PROP_AIVI(((tU32) 0x000000D5))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_LED_HYDERDAY_LIGHT                  DIA_PROP_AIVI(((tU32) 0x000000D6))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_ANSWER_BACK_EXTERIOR_LIGHT          DIA_PROP_AIVI(((tU32) 0x000000D7))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_ROOM_LIGHT                          DIA_PROP_AIVI(((tU32) 0x000000D8))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_WELCOME_LIGHT                       DIA_PROP_AIVI(((tU32) 0x000000D9))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AMBIENT_BRIGHTNESS                  DIA_PROP_AIVI(((tU32) 0x000000DA))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_SELECTIVE_DOOR_UNLOCK               DIA_PROP_AIVI(((tU32) 0x000000DB))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AUTO_LOCK                           DIA_PROP_AIVI(((tU32) 0x000000DC))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AUTO_UNLOCK                         DIA_PROP_AIVI(((tU32) 0x000000DD))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_ANSWER_BACK                         DIA_PROP_AIVI(((tU32) 0x000000DE))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_WIPER_WITH_SPEED                    DIA_PROP_AIVI(((tU32) 0x000000DF))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_RAIN_SENSOR                         DIA_PROP_AIVI(((tU32) 0x000000E0))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_DRIP_WIPE                           DIA_PROP_AIVI(((tU32) 0x000000E1))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_REVERSE_LINK                        DIA_PROP_AIVI(((tU32) 0x000000E2))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_LOCK_UNLOCK_BY_HANDS_FREE           DIA_PROP_AIVI(((tU32) 0x000000E3))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_IGN_ACC_BATTERY_SAVER               DIA_PROP_AIVI(((tU32) 0x000000E4))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_REMOTE_ENGINE_START                 DIA_PROP_AIVI(((tU32) 0x000000E5))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_TOUCH_DOOR_SENSOR                   DIA_PROP_AIVI(((tU32) 0x000000E6))
#define DIA_PROP_AIVI_VEHICLE_SETTING_ALC_AMBIENT_BRIGHTNESS                  DIA_PROP_AIVI(((tU32) 0x000000E7))
#define DIA_PROP_AIVI_VEHICLE_SETTING_ALC_FRONT_SEAT_AREA                     DIA_PROP_AIVI(((tU32) 0x000000E8))
#define DIA_PROP_AIVI_VEHICLE_SETTING_ALC_REAR_SEAT_AREA                      DIA_PROP_AIVI(((tU32) 0x000000E9))
#define DIA_PROP_AIVI_VEHICLE_SETTING_ALC_ROOF_AMBINENT_LIGHT                 DIA_PROP_AIVI(((tU32) 0x000000EA))
#define DIA_PROP_AIVI_VEHICLE_SETTING_ADP_LIFT_COLUMN_UPON_EXIT               DIA_PROP_AIVI(((tU32) 0x000000EB))
#define DIA_PROP_AIVI_VEHICLE_SETTING_ADP_ADJUST_DRIVE_SEAT_UPON_EXIT         DIA_PROP_AIVI(((tU32) 0x000000EC))
#define DIA_PROP_AIVI_VEHICLE_SETTING_BCM_CUSTOM_RESET_IT                     DIA_PROP_AIVI(((tU32) 0x000000ED))
#define DIA_PROP_AIVI_VEHICLE_SETTING_ALC_CUSTOM_RESET_IT                     DIA_PROP_AIVI(((tU32) 0x000000EE))
#define DIA_PROP_AIVI_VEHICLE_SETTING_ADP_RESET_IT                            DIA_PROP_AIVI(((tU32) 0x000000EF))

// CENTER_CMC_19 Specific Properties
// Version Information 
#define DIA_PROP_CENTER_CMC_19_VERSION_SW_BOOT									DIA_PROP_CENTER_CMC_19(((tU32) 0x00000000))  // "DIA_PROP_CENTER_CMC_19_VERSION_SW_BOOT"
#define DIA_PROP_CENTER_CMC_19_VERSION_SW_CUSTOMER_BLOCK			           	DIA_PROP_CENTER_CMC_19(((tU32) 0x00000001))  // "DIA_PROP_CENTER_CMC_19_VERSION_SW_CUSTOMER_BLOCK"
#define DIA_PROP_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION							DIA_PROP_CENTER_CMC_19(((tU32) 0x00000002))  // "DIA_PROP_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION"
#define DIA_PROP_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER						DIA_PROP_CENTER_CMC_19(((tU32) 0x00000003))  // "DIA_PROP_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER"
#define DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_CSM_SIGNAL_RAW             			DIA_PROP_CENTER_CMC_19(((tU32) 0x00000004))  // "DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_RAW"
#define DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_REF_RAW		              			DIA_PROP_CENTER_CMC_19(((tU32) 0x00000005))  // "DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_REF"
#define DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER              				DIA_PROP_CENTER_CMC_19(((tU32) 0x00000006))  // "DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER"
#define DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER_LIMIT                	    DIA_PROP_CENTER_CMC_19(((tU32) 0x00000007))  // "DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER_LIMIT"
#define DIA_PROP_CENTER_CMC_19_VIN_ORIGINAL                                     DIA_PROP_CENTER_CMC_19(((tU32) 0x00000008))  // "DIA_PROP_CENTER_CMC_19_VIN_ORIGINAL"
#define DIA_PROP_CENTER_CMC_19_VIN_CURRENT                                      DIA_PROP_CENTER_CMC_19(((tU32) 0x00000009))  // "DIA_PROP_CENTER_CMC_19_VIN_CURRENT"
#define DIA_PROP_CENTER_CMC_19_VIN_LOCK                                      	DIA_PROP_CENTER_CMC_19(((tU32) 0x0000000A))  // "DIA_PROP_CENTER_CMC_19_VIN_CURRENT"
#define DIA_PROP_CENTER_CMC_19_FINGERPRINT_CONFIG                               DIA_PROP_CENTER_CMC_19(((tU32) 0x0000000B))  // "DIA_PROP_CENTER_CMC_19_FINGERPRINT_CONFIG"
//! Hash generated using /common-tools/hasher.cpp; cmd - ./a.out -c "<string-to-calculate-hash>"
#define DIA_PROP_VIN_ODOMETER_THREAD_PRIO                  						DIA_PROP_CENTER_CMC_19(((tU32) 0x0000000C))  // "DIA_PROP_VIN_ODOMETER_THREAD_PRIO" - 0x9d8dfced
#define DIA_PROP_VIN_ODOMETER_THREAD_STACK_SIZE            						DIA_PROP_CENTER_CMC_19(((tU32) 0x0000000D))  // "DIA_PROP_VIN_ODOMETER_THREAD_STACK_SIZE" - 0x17ed14e3
#define DIA_PROP_VIN_THREAD_PRIO												DIA_PROP_CENTER_CMC_19(((tU32) 0x0000000E))	 // 0x1d9d37cf//
#define DIA_PROP_VIN_THREAD_STACK_SIZE											DIA_PROP_CENTER_CMC_19(((tU32) 0x0000000F))  // 0xcde97145//
#define DIA_PROP_CENTER_CMC_19_CD_PNM_GROUP_10_CONFIG								DIA_PROP_CENTER_CMC_19(((tU32) 0x00000010))  // DIA_PROP_CENTER_CMC_19_PNM_GROUP_10_CONFIG//
#define DIA_PROP_CENTER_CMC_19_HISTORICAL_INTERROGATON_RECORD					DIA_PROP_CENTER_CMC_19(((tU32) 0x00000011))  // DIA_PROP_CENTER_CMC_19_HISTORICAL_INTERROGATON_RECORD//
#define DIA_PROP_CENTER_CMC_19_SECURITY_TESTER_IDENTIFICATION					DIA_PROP_CENTER_CMC_19(((tU32) 0x00000012))  // DIA_PROP_CENTER_CMC_19_SECURITY_TESTER_IDENTIFICATION
#define DIA_PROP_CMC_INSTALLATION_CONTAINER								        DIA_PROP_CENTER_CMC_19(((tU32) 0x00000013))  // DIA_PROP_CMC_INSTALLATION_CONTAINER//
#define DIA_PROP_CMC_INSTALLATION_LOG_FILE								        DIA_PROP_CENTER_CMC_19(((tU32) 0x00000014))  // DIA_PROP_CMC_INSTALLATION_LOG_FILE//
#define DIA_PROP_CMC_AVDECC_CFG_DB_FILE								            DIA_PROP_CENTER_CMC_19(((tU32) 0x00000015))  // DIA_PROP_CMC_AVDECC_CFG_DB_FILE//
#define DIA_PROP_CENTER_CMC_19_PRIVATE_MIC_SWITCH							    DIA_PROP_CENTER_CMC_19(((tU32) 0x00000016))  // "DIA_PROP_CENTER_CMC_19_PRIVATE_MIC_SWITCH"
#define DIA_PROP_CENTER_CMC_19_WAKEIN_STATUS  									DIA_PROP_CENTER_CMC_19(((tU32) 0x00000017))  // "DIA_PROP_CENTER_CMC_19_WAKEIN_STATUS"
#define DIA_PROP_CENTER_CMC_19_TESTMODE_DTM 	                			    DIA_PROP_CENTER_CMC_19(((tU32) 0x00000018))
#define DIA_PROP_CENTER_CMC_19_NVM_PNM_GROUP_10_CONFIG 	                	    DIA_PROP_CENTER_CMC_19(((tU32) 0x00000019))
#define DIA_PROP_CENTER_CMC_19_NVM_PNM_GROUP_10_CONFIG_SCC 	                    DIA_PROP_CENTER_CMC_19(((tU32) 0x0000001A))
#define DIA_PROP_CMC_STARTUPSCREEN_FILE								            DIA_PROP_CENTER_CMC_19(((tU32) 0x0000001B))  // DIA_PROP_CMC_STARTUPSCREEN_FILE//
#define DIA_PROP_CMC_GPIO_EXTERNAL_SWITCH_WAKEOUT    				            DIA_PROP_CENTER_CMC_19(((tU32) 0x0000001C))  // DIA_PROP_CMC_GPIO_EXTERNAL_SWITCH_WAKEOUT//
#define DIA_PROP_CMC_CIS_HMI_LOGO_1				    				            DIA_PROP_CENTER_CMC_19(((tU32) 0x0000001D))  // DIA_PROP_CMC_CIS_HMI_LOGO_1//
#define DIA_PROP_CMC_CIS_HMI_LOGO_2				    				            DIA_PROP_CENTER_CMC_19(((tU32) 0x0000001E))  // DIA_PROP_CMC_CIS_HMI_LOGO_2//
#define DIA_PROP_CENTER_CMC_19_DTC_CONFIG				    				    DIA_PROP_CENTER_CMC_19(((tU32) 0x0000001F))  // DIA_PROP_CENTER_CMC_19_DTC_CONFIG//
#define DIA_PROP_CMC_AVDECC_CONFIG		          		    				    DIA_PROP_CENTER_CMC_19(((tU32) 0x00000020))  // DIA_PROP_CMC_AVDECC_CONFIG//
#define DIA_PROP_CMC_CIS_CONFIG		          		    				        DIA_PROP_CENTER_CMC_19(((tU32) 0x00000021))  // DIA_PROP_CMC_CIS_CONFIG//
#define DIA_PROP_CMC_INTERCOM_PHONE_NAME       		    				        DIA_PROP_CENTER_CMC_19(((tU32) 0x00000022))  // DIA_PROP_CMC_INTERCOM_PHONE_NAME//
#define DIA_PROP_CENTER_CMC_19_CIS_CONFIG_DP   		    				        DIA_PROP_CENTER_CMC_19(((tU32) 0x00000023))  // DIA_PROP_CMC_INTERCOM_PHONE_NAME//
#define DIA_PROP_CENTER_CMC_19_AVDECC_CONFIG_DP  		    				    DIA_PROP_CENTER_CMC_19(((tU32) 0x00000024))  // DIA_PROP_CMC_INTERCOM_PHONE_NAME//
#define DIA_PROP_CMC_CIS_CONFIG_DEFAULT   		    				            DIA_PROP_CENTER_CMC_19(((tU32) 0x00000025))  // DIA_PROP_CMC_CIS_CONFIG-DEFAULT//
#define DIA_PROP_CMC_CIS_CONFIG_CD      		    				            DIA_PROP_CENTER_CMC_19(((tU32) 0x00000126))  // DIA_PROP_CMC_CIS_CONFIG-CD//
#define DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_AM_DP   				            DIA_PROP_CENTER_CMC_19(((tU32) 0x00000127))  // DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_AM_DP-CD//
#define DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_FM_DP   				            DIA_PROP_CENTER_CMC_19(((tU32) 0x00000128))  // DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_FM_DP-CD//
#define DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_DAB_DP   				            DIA_PROP_CENTER_CMC_19(((tU32) 0x00000129))  // DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_DAB_DP-CD//
#define DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SXM_DP   				            DIA_PROP_CENTER_CMC_19(((tU32) 0x0000012A))  // DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SXM_DP-CD//
#define DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_WX_DP   				            DIA_PROP_CENTER_CMC_19(((tU32) 0x0000012B))  // DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_WX_DP-CD//
#define DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_PAS_MAP_OUT_DP 		            DIA_PROP_CENTER_CMC_19(((tU32) 0x0000012C))  // DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_PAS_MAP_OUT_DP-CD//
#define DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_ROUTE_GUIDANCE_DP 		        DIA_PROP_CENTER_CMC_19(((tU32) 0x0000012E))  // DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_ROUTE_GUIDANCE_DP-CD//
#define DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SPEECH_CONT_COUNTER_DP 		    DIA_PROP_CENTER_CMC_19(((tU32) 0x0000012D))  // DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SPEECH_CONT_COUNTER_DP-CD//

// data file property names
extern const tChar* strSigmaFileName;
extern const tChar* strSigmaFilePath;
extern const tChar* strCertificateFileName;
extern const tChar* strCertificateFilePath;
extern const tChar* strInstallationContainerFileName;
extern const tChar* strInstallationContainerFilePath;
extern const tChar* strInstallationLogFileName;
extern const tChar* strInstallationLogFilePath;
extern const tChar* strAvdeccCfgDbFileName;
extern const tChar* strAvdeccCfgDbFilePath;
extern const tChar* strStartupscreenFileName;
extern const tChar* strStartupscreenFilePath;
extern const tChar* strCISHMILogo1Name;
extern const tChar* strCISHMILogo1Path;
extern const tChar* strCISHMILogo2Name;
extern const tChar* strCISHMILogo2Path;

// Datapool names
/* CD */
extern const tChar* strDpNameECNRPhoneNB;
extern const tChar* strDpNameECNRPhoneWB;
extern const tChar* strDpNameECNRCarplayPhoneNB;
extern const tChar* strDpNameECNRCarplayPhoneWB;
extern const tChar* strDpNameECNRCarplayFacetimeSWB;

/* CD-DEF */
extern const tChar* strDpNameDefECNRPhoneNB;
extern const tChar* strDpNameDefECNRPhoneWB;
extern const tChar* strDpNameDefECNRCarplayPhoneNB;
extern const tChar* strDpNameDefECNRCarplayPhoneWB;
extern const tChar* strDpNameDefECNRCarplayFacetimeSWB;

/* PD */
extern const tChar* strDpNameProjectConfigRecords;
extern const tChar* strDpNameVrParam;
extern const tChar* strDpNameAudioSourceOffset;
extern const tChar* strDpNameBtVoiceEcnrNbs;
extern const tChar* strDpNameBtVoiceEcnrWbs;
extern const tChar* strDpNameBtSiriEcnrWbs;
extern const tChar* strDpNameCarplaySiriEcnrWbs;
extern const tChar* strDpNameAndroidAutoVrEcnrWbs;
extern const tChar* strDpNameBrightness;

/* AID ECNR (CD & PD) */
extern const tChar* strDpNameAidEcnr;
extern const tChar* strDpNameAidArkamys;

//Datapool elements
/* CD */
extern const tChar* strDpNamePhoneECNRNbsElemData;
extern const tChar* strDpNamePhoneECNRWbsElemData;
extern const tChar* strDpNameCarPlayPhoneECNRNbsElemData;
extern const tChar* strDpNameCarPlayPhoneECNRWbsElemData;
extern const tChar* strDpNameCarPlayFacetimeECNRSwbElemData;
extern const tChar* strDpNameAcousticParamElemData;
extern const tChar* strDpNameEcnrBtVoiceNBElemData;
extern const tChar* strDpNameEcnrBtVoiceWBElemData;
extern const tChar* strDpNameEcnrBtSiriWBElemData;
extern const tChar* strDpNameEcnrCpVoiceWBElemData;
extern const tChar* strDpNameEcnrAaVoiceWBElemData;
extern const tChar* strDpNameEcnrVpaVoiceWBElemData;

/* CD-DEF */
extern const tChar* strDpNameDefPhoneECNRNbsElemData;
extern const tChar* strDpNameDefPhoneECNRWbsElemData;
extern const tChar* strDpNameDefCarPlayPhoneECNRNbsElemData;
extern const tChar* strDpNameDefCarPlayPhoneECNRWbsElemData;
extern const tChar* strDpNameDefCarPlayFacetimeECNRSwbElemData;
extern const tChar* strDpNameDefAcousticParamElemData;

/* PD */
extern const tChar* strDatasetNameAudioSrcOffset;
extern const tChar* strDpNameVRParamElemData;
extern const tChar* strDpNameBrightnessElemData;
extern const tChar* strFileNameCertificate;

/* CD - CMC */
extern const tChar* strFileNameInstallationContainer;
extern const tChar* strFileNameInstallationLogFile;
extern const tChar* strFileNameAvdeccCfgDbFile;
extern const tChar* strFileNameStartupScreenFile;

/* CD - Programming Session */
extern const tChar* strDpNameLB00ReferenceChks;
extern const tChar* strDpNameLB00ReferenceChksElemData;
extern const tChar* strDpNameESE;
extern const tChar* strDpNameESEElemData;
extern const tChar* strDpNameDigests;
extern const tChar* strDpNameDigestFD00ElemData;
extern const tChar* strDpNameDigestFD01ElemData;
extern const tChar* strDpNameDigestFD02ElemData;
extern const tChar* strDpNameDigestFD03ElemData;
extern const tChar* strDpNameDigestFD04ElemData;
extern const tChar* strDpNameDigestFD05ElemData;
extern const tChar* strDpNameDigestFD06ElemData;
extern const tChar* strDpNameDigestFD07ElemData;
extern const tChar* strDpNameDigestFD08ElemData;
extern const tChar* strDpNameDigestFD09ElemData;
extern const tChar* strDpNameDigestFD0AElemData;
extern const tChar* strDpNameDigestFD0BElemData;
extern const tChar* strDpNameDigestFD0CElemData;
extern const tChar* strDpNameDigestFD0DElemData;
extern const tChar* strDpNameDigestFD0EElemData;
extern const tChar* strDpNameResultCheckProgDep;
extern const tChar* strDpNameResultCheckProgDepElemData;
//Center CMC-19 Datapool elements
extern const tChar* strDpNameTesterIdentification;
extern const tChar* strDpElementNameTesterIdentification;
extern const tChar* strDpNameNVMConfiguration;
extern const tChar* strDpElementNameNVMConfigurationValue;
extern const tChar* strDpNameDTCConfiguration;
extern const tChar* strDpElementNameDTCConfiguration;
extern const tChar* strDpNameCISConfiguration;
extern const tChar* strDpElementNameCISConfiguration;
extern const tChar* strDpNameAVDECCConfiguration;
extern const tChar* strDpElementNameAVDECCConfiguration;
extern const tChar* strDpNameRunTimeSourceAM;
extern const tChar* strDpElementNameRunTimeSourceAM;
extern const tChar* strDpNameRunTimeSourceFM;
extern const tChar* strDpElementNameRunTimeSourceFM;
extern const tChar* strDpNameRunTimeSourceDAB;
extern const tChar* strDpElementNameRunTimeSourceDAB;
extern const tChar* strDpNameRunTimeSourceWX;
extern const tChar* strDpElementNameRunTimeSourceWX;
extern const tChar* strDpNameRunTimeSourceSXM;
extern const tChar* strDpElementNameRunTimeSourceSXM;
extern const tChar* strDpNameRunTimeSourceRouteGuidance;
extern const tChar* strDpElementNameRunTimeSourceRouteGuidance;
extern const tChar* strDpNameRunTimeSourcePassengerMapOut;
extern const tChar* strDpElementNameRunTimeSourcePassengerMapOut;
extern const tChar* strDpNameRunTimeSourceSpeechContCounter;
extern const tChar* strDpElementNameRunTimeSourceSpeechContCounter;

#define AIVI_WIFI_NAME_1_LENGTH      (tU32) 22
#define AIVI_WIFI_NAME_2_LENGTH      (tU32) 22
#define AIVI_BT_NAME_LENGTH          (tU32) 22

//############################################################

struct dia_ConfigToDeliveryInfo
{
   //! current property
   tU32 mCurrentProp;
   //! default Property
   tU32 mDefaultProp;
};

const tCString g_AIVI_SystemSupplierNumber = "BOSCH";
const tCString g_AIVI_VehManHardwareNumber = "0000000000";

#ifndef __DIA_UNIT_TESTING__
extern tU8 g_AIVI_ECUSerialNumber[];
#else
const tU8 g_AIVI_ECUSerialNumber[] = "00000000000000000000";
#endif

//SWUpdateOfAllSubmodules Prj Specific Path Overloaded
namespace dia_SwUpdate
{
	const tCString g_str_SwUpdateMountPoint      = "/var/opt/bosch/persistent/fcswupdate";
	const tCString g_str_SwUpdatePath            = "postImage";
	const tCString g_str_SwUpdateFile            = "Bosch.cms";
}
using namespace dia_SwUpdate;

//#############################################################################
//#
//# Detailed Property Definition
//#
//#############################################################################

enum dia_enPropRegKeyCenterCMC19
{
	DIA_PROP_SRC_REG_KEY_DEVICE_UKNOWN = DIA_PROP_RANGE_START_COMMON,
	DIA_PROP_SRC_REG_KEY_VERSION_SW_BOOT,
	DIA_PROP_SRC_REG_KEY_VERSION_SW_CUSTOMER_BLOCK,
	//...
    DIA_PROP_SRC_REG_KEY_TOTAL_COUNT /* Last element */
};

const dia_RegKeyInfo
aCommonRegKeyDataCenterCMC19[] =
{
	{ DIA_PROP_SRC_REG_KEY_DEVICE_UKNOWN,                   "Unknown"            		          },
	{ DIA_PROP_SRC_REG_KEY_VERSION_SW_BOOT,                 "BOOT_SW_VERSION_CMC"       },
    { DIA_PROP_SRC_REG_KEY_VERSION_SW_CUSTOMER_BLOCK,       "CUSTOMER_SW_VERSION_CMC"   }
};

const dia_PropertyInfo
aDiaGen3gPropData[] = {
//   property key                                    prop type            statMask             size   prop. location

   // overloaded properties
   { DIA_PROP_DEFAULT_SESSION,                       DIA_PROP_TYPE_U8,    SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_RAM,      {0x01,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_SESSION_CTRL_SUPPORT_SPR,              DIA_PROP_TYPE_U8,    SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_RAM,      {0x00,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_DTC_FORMAT_IDENTIFIER,                 DIA_PROP_TYPE_U8,    SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_RAM,      {0x00,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //DTCFormatIdentifier: 0x00 = J2012-DADTCF00
   { DIA_PROP_VERSION_SW_CUSTOMER,                   DIA_PROP_TYPE_U8,    SM_LEADING_ZERO,       10,  DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_CUSTOMER, DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   //SWUpdateOfAllSubmodules Prj Specific Path Overloaded 
   { DIA_PROP_SWUPDATE_MOUNT_POINT,					DIA_PROP_TYPE_STR,	  SM_ZERO_TERMINATED,   128,  DIA_PROP_SRC_RAM,		 { (intptr_t)g_str_SwUpdateMountPoint, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
   { DIA_PROP_SWUPDATE_PATH,						DIA_PROP_TYPE_STR,    SM_ZERO_TERMINATED,   128,  DIA_PROP_SRC_RAM,		 { (intptr_t)g_str_SwUpdatePath, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
   { DIA_PROP_SWUPDATE_FILE,						DIA_PROP_TYPE_STR,    SM_ZERO_TERMINATED,   128,  DIA_PROP_SRC_RAM,		 { (intptr_t)g_str_SwUpdateFile, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },

   { DIA_PROP_CM_MIN_LEN_IOCONTROL_MESSAGE,          DIA_PROP_TYPE_U8,    SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_RAM,      {0x04,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CM_MIN_LEN_ROUTINECTRL_MESSAGE,        DIA_PROP_TYPE_U8,    SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_RAM,      {0x04,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   // overloaded because of project-specific table sizes
   { DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_ONE,         DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,    230,  DIA_PROP_SRC_KDS,      {0xA080, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //InputKeyMappingTable_1 (DID $8101)
   { DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_TWO,         DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,    230,  DIA_PROP_SRC_KDS,      {0xA081, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //InputKeyMappingTable_2 (DID $8102)
   { DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_THREE,       DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,    230,  DIA_PROP_SRC_KDS,      {0xA082, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //InputKeyMappingTable_3 (DID $8103),
   { DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_FOUR,        DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,    230,  DIA_PROP_SRC_KDS,      {0xA083, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //InputKeyMappingTable_4 (DID $8104),

   // KDS properties
   //Override ECU HW Version as per Center CMC-19 Project requirement: DLC- 7 bytes ( Task 325057 )
   { DIA_PROP_CM_ECU_HW_VERSION,                      DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,      7,  DIA_PROP_SRC_KDS,      { 0x010E, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },  // ECU Hardware Version
   { DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION,            DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH, DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH,  DIA_PROP_SRC_KDS,      {0xA125,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_SYSTEM_INFO_COMMON,                DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      64,  DIA_PROP_SRC_KDS,      {0xA110,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CM_BT_NAME,                             DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      22,  DIA_PROP_SRC_KDS,      {0xA030,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_CAMERA_SYSTEM,                     DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      88,  DIA_PROP_SRC_KDS,      {0xA111,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_ECO_ROUTE,                         DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,       2,  DIA_PROP_SRC_KDS,      {0xA113,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_CONFIG_HASH_VALUE,                 DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      20,  DIA_PROP_SRC_KDS,      {0xA115,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_CONFIG_PARTS_NUMBER,               DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      10,  DIA_PROP_SRC_KDS,      {0xA116,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_SENSOR_CONFIG_GYRO,                DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     203,  DIA_PROP_SRC_KDS,      {0x0700,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET,              DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     288,  DIA_PROP_SRC_KDS,      {0x0410, 230, 0x0411, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET_01,           DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     230,  DIA_PROP_SRC_KDS,      {0x0410,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET_02,           DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      58,  DIA_PROP_SRC_KDS,      {0x0411,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_ANTENNA_PARAM_SET,                 DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     131,  DIA_PROP_SRC_KDS,      {0x0430,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DAB_SET,                           DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     230,  DIA_PROP_SRC_KDS,      {0x0440,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET,           DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     417,  DIA_PROP_SRC_KDS,      {0x0420, 230, 0x0421, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET_01,        DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     230,  DIA_PROP_SRC_KDS,      {0x0420,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET_02,        DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     187,  DIA_PROP_SRC_KDS,      {0x0421,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_HD_PARAM_SET,                      DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      64,  DIA_PROP_SRC_KDS,      {0x0450,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_AUDIO_PARAM_SET,                   DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     275,  DIA_PROP_SRC_KDS,      {0xA120, 230, 0xA121, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_AUDIO_PARAM_SET_01,                DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     230,  DIA_PROP_SRC_KDS,      {0xA120,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_AUDIO_PARAM_SET_02,                DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      45,  DIA_PROP_SRC_KDS,      {0xA121,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_SENSOR_CONFIG_GNSS,                DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      12,  DIA_PROP_SRC_KDS,      {0x0530,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_SENSOR_CONFIG_ACC,                 DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,     203,  DIA_PROP_SRC_KDS,      {0x0780,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_ECU_PART_NUMBER,                   DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     10,  DIA_PROP_SRC_KDS,      {0xA124,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEH_MANUFACTURER_ECU_HW_NR,        DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     10,  DIA_PROP_SRC_KDS,      {0xA126,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEH_MANUFACTURER_SPARE_PART_R_NR,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     10,  DIA_PROP_SRC_KDS,      {0xA124,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEH_MANUFACTURER_SPARE_PART_N_NR,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     10,  DIA_PROP_SRC_KDS,      {0xA124,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_ECU_SW_VERSION,                    DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,    240,  DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_RBCM_ECU_BUILD, DIA_PROP_SRC_REG_PATH_VERSIONS,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // SystemSupplierECUsoftwareNumber
   { DIA_PROP_AIVI_ECU_SW_VERSION_NUMBER,             DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,     11,  DIA_PROP_SRC_REGISTRY, {(intptr_t)DIA_PROP_SRC_REG_KEY_VERSION_SW_RBCM_ECU, DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // SystemSupplierECUsoftwareVersionNumber
   { DIA_PROP_AIVI_VARIANT_CODING,                    DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK, DIA_AIVI_VARIANT_CODING_LENGTH,  DIA_PROP_SRC_KDS,      {0xA114,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_INFO,                      DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      65,  DIA_PROP_SRC_KDS,      {0xA112,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CM_WIFI_NAME_1,                         DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      22,  DIA_PROP_SRC_KDS,      {0xA032,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CM_WIFI_NAME_2,                         DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      22,  DIA_PROP_SRC_KDS,      {0xA033,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_SPEED_LOCKOUT,                     DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,      5,  DIA_PROP_SRC_KDS,      {0xA0C0,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_MEX_CONFIG,                        DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      41,  DIA_PROP_SRC_KDS,      {0xA127,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_FACTORY_MODE,                      DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,       1,  DIA_PROP_SRC_KDS,      {0xA128,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_CONNECTIVITY_CONFIG,               DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      25,  DIA_PROP_SRC_KDS,      {0xA129,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_HMI_CONFIG,                        DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      21,  DIA_PROP_SRC_KDS,      {0xA12A,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_SOUND_VOLUME_CONFIG,               DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,      17,  DIA_PROP_SRC_KDS,      {0xA12B,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEH_MANUFACTURER_HW_D_NR,          DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     10, DIA_PROP_SRC_RAM,       {(intptr_t)g_AIVI_VehManHardwareNumber, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },      // VehicleManufacturerHWNumber   (with fix value)
   { DIA_PROP_AIVI_KEY_ILLUMINATION_ALIGNMENT_COEFF2, DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,     10,  DIA_PROP_SRC_KDS,      {0xA1C0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // keyIlluminationAlignmentCoefficients2
   { DIA_PROP_AIVI_DISP_ILLUMINATION_ALIGNMENT_COEFF, DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,      2,  DIA_PROP_SRC_KDS,      {0xA1C1, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // keyIlluminationAlignmentCoefficients2
   { DIA_PROP_AIVI_ECU_SERIAL_NUMBER,                 DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     20, DIA_PROP_SRC_RAM,       {(intptr_t)g_AIVI_ECUSerialNumber, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },

   // KDS DEF properties
   { DIA_PROP_AIVI_DEF_CAMERA_SYSTEM,                 DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     88,  DIA_PROP_SRC_KDS,      {0xA111,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_VEHICLE_INFO,                  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     64,  DIA_PROP_SRC_KDS,      {0xA172,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_ECO_ROUTE,                     DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,      2,  DIA_PROP_SRC_KDS,      {0xA173,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_CONFIG_HASH_VALUE,             DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     20,  DIA_PROP_SRC_KDS,      {0xA175,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_CONFIG_PARTS_NUMBER,           DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     10,  DIA_PROP_SRC_KDS,      {0xA176,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GYRO,            DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,    203,  DIA_PROP_SRC_KDS,      {0xA177, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_FMAM_TUNER_PARAM_SET,          DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,    288,  DIA_PROP_SRC_KDS,      {0xA178, 230, 0xA179, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_ANTENNA_PARAM_SET,             DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,    131,  DIA_PROP_SRC_KDS,      {0xA17A, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_DAB_SET,                       DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,    230,  DIA_PROP_SRC_KDS,      {0xA17B, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_GENERIC_TUNER_PARAM_SET,       DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,    417,  DIA_PROP_SRC_KDS,      {0xA17C, 230, 0xA17D, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_HD_PARAM_SET,                  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     64,  DIA_PROP_SRC_KDS,      {0xA17E,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_SYSTEM_INFO_COMMON,            DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     64,  DIA_PROP_SRC_KDS,      {0xA110,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_BT_NAME,                       DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     22,  DIA_PROP_SRC_KDS,      {0xA174,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_WIFI_NAME_1,                   DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     22,  DIA_PROP_SRC_KDS,      {0xA17F,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_WIFI_NAME_2,                   DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     22,  DIA_PROP_SRC_KDS,      {0xA180,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_ANTITHEF_MAP_SELECTION,        DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,      3,  DIA_PROP_SRC_KDS,      {0xA181,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_AUDIO_PARAM_SET,               DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,    275,  DIA_PROP_SRC_KDS,      {0xA182, 230, 0xA183, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GNSS,            DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     12,  DIA_PROP_SRC_KDS,      {0xA184,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_SENSOR_CONFIG_ACC,             DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,    203,  DIA_PROP_SRC_KDS,      {0xA185, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_MEX_CONFIG,                    DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     41,  DIA_PROP_SRC_KDS,      {0xA186, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_FACTORY_MODE,                  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_KDS,      {0xA187, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_CONNECTIVITY_CONFIG,           DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     25,  DIA_PROP_SRC_KDS,      {0xA188,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_HMI_CONFIG,                    DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     21,  DIA_PROP_SRC_KDS,      {0xA190,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_SOUND_VOLUME_CONFIG,           DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     17,  DIA_PROP_SRC_KDS,      {0xA191,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_DRM_TUNER_PARAMETER_SET,       DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     48,  DIA_PROP_SRC_KDS,      {0xA192,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   // Center CM C-19 Features

   // CMC KDS Properties
   { DIA_PROP_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION,  	     DIA_PROP_TYPE_U8,  	SM_NO_STATUS_MASK,      3,  	DIA_PROP_SRC_KDS,      {0x0D62,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER,      DIA_PROP_TYPE_U8,	    SM_NO_STATUS_MASK,     13,  	DIA_PROP_SRC_KDS,      {0x0D63,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_CSM_SIGNAL_RAW,     DIA_PROP_TYPE_U8,  	SM_NO_STATUS_MASK,      4,  	DIA_PROP_SRC_KDS,      {0x0DC1,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_REF_RAW,     	     DIA_PROP_TYPE_U8,  	SM_NO_STATUS_MASK,      4,  	DIA_PROP_SRC_KDS,      {0x0DC2,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER,     	     DIA_PROP_TYPE_U8,  	SM_NO_STATUS_MASK,      1,  	DIA_PROP_SRC_KDS,      {0x0D64,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER_LIMIT,	     DIA_PROP_TYPE_U8, 	    SM_NO_STATUS_MASK,      1,  	DIA_PROP_SRC_KDS,      {0x0D65,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_VIN_ORIGINAL,             	     DIA_PROP_TYPE_U8,  	SM_NO_STATUS_MASK,     17, 	    DIA_PROP_SRC_KDS,      {0x0D70,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_VIN_CURRENT,              	     DIA_PROP_TYPE_U8,  	SM_NO_STATUS_MASK,     17, 	    DIA_PROP_SRC_KDS,      {0x0D71,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_VIN_LOCK,        	      	     DIA_PROP_TYPE_U8,  	SM_NO_STATUS_MASK,      1, 	    DIA_PROP_SRC_KDS,      {0x0DC3,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_FINGERPRINT_CONFIG ,      	     DIA_PROP_TYPE_U8,  	SM_NO_STATUS_MASK,     10, 	    DIA_PROP_SRC_KDS,      {0x0DC0,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_CD_PNM_GROUP_10_CONFIG ,   	     DIA_PROP_TYPE_STR,  	SM_NO_STATUS_MASK,      8, 	    DIA_PROP_SRC_KDS,      {0x0DC4,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_HISTORICAL_INTERROGATON_RECORD,	 DIA_PROP_TYPE_U8,  	SM_NO_STATUS_MASK,      3, 	    DIA_PROP_SRC_KDS,      {0x0DC5,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_TESTMODE_DTM,                    DIA_PROP_TYPE_U8,      SM_NO_STATUS_MASK,      1,      DIA_PROP_SRC_KDS,      {0xA1D4,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_NVM_PNM_GROUP_10_CONFIG,         DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,      8,      DIA_PROP_SRC_KDS,      {0xA1D5,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_AVDECC_CONFIG,         					 DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     32,      DIA_PROP_SRC_KDS,      {0xA1D6,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_CIS_CONFIG,         					     DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,    230,      DIA_PROP_SRC_KDS,      {0xA1D7,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_INTERCOM_PHONE_NAME, 					     DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,    224,      DIA_PROP_SRC_KDS,      {0xA1D8,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_CIS_CONFIG_DEFAULT,  					     DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,    230,      DIA_PROP_SRC_KDS,      {0xA1DA,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_CIS_CONFIG_CD,       					     DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,    230,      DIA_PROP_SRC_KDS,      {0x0DF7,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },


   // CMC Datapool Properties
   { DIA_PROP_CENTER_CMC_19_NVM_PNM_GROUP_10_CONFIG_SCC,     DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,      8,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameNVMConfiguration,        0x0114, 0xff17, (intptr_t) strDpElementNameNVMConfigurationValue,    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_SECURITY_TESTER_IDENTIFICATION,  DIA_PROP_TYPE_STR,     SM_VAR_LEN,           256,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameTesterIdentification,    0x0114, 0x0016, (intptr_t) strDpElementNameTesterIdentification,     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_DTC_CONFIG,                      DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,    230,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameDTCConfiguration,        0x0114, 0xff18, (intptr_t) strDpElementNameDTCConfiguration,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_CIS_CONFIG_DP,                      DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,    230,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameCISConfiguration,        0x0114, 0xff19, (intptr_t) strDpElementNameCISConfiguration,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_AVDECC_CONFIG_DP,                   DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     32,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameAVDECCConfiguration,     0x0114, 0xff1A, (intptr_t) strDpElementNameAVDECCConfiguration,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_AM_DP,             DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     4,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameRunTimeSourceAM,     0x0114, 0xff1B, (intptr_t) strDpElementNameRunTimeSourceAM,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_FM_DP,             DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     4,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameRunTimeSourceFM,     0x0114, 0xff1C, (intptr_t) strDpElementNameRunTimeSourceFM,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SXM_DP,            DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     4,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameRunTimeSourceSXM,     0x0114, 0xff1D, (intptr_t) strDpElementNameRunTimeSourceSXM,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_WX_DP,             DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     4,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameRunTimeSourceWX,     0x0114, 0xff1E, (intptr_t) strDpElementNameRunTimeSourceWX,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_DAB_DP,            DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     4,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameRunTimeSourceDAB,     0x0114, 0xff1F, (intptr_t) strDpElementNameRunTimeSourceDAB,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_PAS_MAP_OUT_DP,    DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     4,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameRunTimeSourcePassengerMapOut,     0x0114, 0xff20, (intptr_t) strDpElementNameRunTimeSourcePassengerMapOut,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_ROUTE_GUIDANCE_DP, DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     4,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameRunTimeSourceRouteGuidance,     0x0114, 0xff21, (intptr_t) strDpElementNameRunTimeSourceRouteGuidance,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SPEECH_CONT_COUNTER_DP, DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,     4,      DIA_PROP_SRC_DP,       {(intptr_t) strDpNameRunTimeSourceSpeechContCounter,     0x0114, 0xff21, (intptr_t) strDpElementNameRunTimeSourceSpeechContCounter,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   
   // CMC Registry Properties
   { DIA_PROP_CENTER_CMC_19_VERSION_SW_BOOT,				 DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,      7,      DIA_PROP_SRC_REGISTRY, {DIA_PROP_SRC_REG_KEY_VERSION_SW_BOOT,			    DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CENTER_CMC_19_VERSION_SW_CUSTOMER_BLOCK,       DIA_PROP_TYPE_STR,     SM_NO_STATUS_MASK,      7,      DIA_PROP_SRC_REGISTRY, {DIA_PROP_SRC_REG_KEY_VERSION_SW_CUSTOMER_BLOCK,		DIA_PROP_SRC_REG_PATH_VERSIONS, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   
   // CMC Thread properties
   { DIA_PROP_VIN_ODOMETER_THREAD_PRIO,                      DIA_PROP_TYPE_U32,     SM_NO_STATUS_MASK,      4,      DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadPrioEngineUDS,     DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_PRIO,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_VIN_ODOMETER_THREAD_STACK_SIZE,                DIA_PROP_TYPE_U32,     SM_NO_STATUS_MASK,      4,      DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadStackSizeEngineUDS,DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_STACK_SIZE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_VIN_THREAD_PRIO,        		                 DIA_PROP_TYPE_U32,     SM_NO_STATUS_MASK,      4,      DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadPrioEngineUDS,     DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_PRIO,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_VIN_THREAD_STACK_SIZE,  		                 DIA_PROP_TYPE_U32,     SM_NO_STATUS_MASK,      4,      DIA_PROP_SRC_SCD,      {0x0114, (intptr_t) strScdKeyNameAppThread,(intptr_t) strScdKeyValueThreadStackSizeEngineUDS,DIA_C_U32_ENGINE_UDS_DEFAULT_THREAD_STACK_SIZE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   
   // CMC File Properties
   { DIA_PROP_CMC_CIS_HMI_LOGO_1,                            DIA_PROP_TYPE_RAW,     SM_VAR_LEN,   3*1024*1024,      DIA_PROP_SRC_FILE,   {(intptr_t) strCISHMILogo1Name,                (intptr_t) strCISHMILogo1Path,                0, 0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_CIS_HMI_LOGO_2,                            DIA_PROP_TYPE_RAW,     SM_VAR_LEN,   3*1024*1024,      DIA_PROP_SRC_FILE,   {(intptr_t) strCISHMILogo2Name,                (intptr_t) strCISHMILogo2Path,                0, 0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_INSTALLATION_CONTAINER,                    DIA_PROP_TYPE_RAW,     SM_VAR_LEN,   3*1024*1024,      DIA_PROP_SRC_FILE,   {(intptr_t) strInstallationContainerFileName,  (intptr_t) strInstallationContainerFilePath,  0, 0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_INSTALLATION_LOG_FILE,                     DIA_PROP_TYPE_RAW,     SM_VAR_LEN,     1024*1024,      DIA_PROP_SRC_FILE,   {(intptr_t) strInstallationLogFileName,        (intptr_t) strInstallationLogFilePath,        0, 0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_AVDECC_CFG_DB_FILE,                        DIA_PROP_TYPE_RAW,     SM_VAR_LEN,     1024*1024,      DIA_PROP_SRC_FILE,   {(intptr_t) strAvdeccCfgDbFileName,            (intptr_t) strAvdeccCfgDbFilePath,            0, 0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_CMC_STARTUPSCREEN_FILE,                        DIA_PROP_TYPE_RAW,     SM_VAR_LEN,   2*1024*1024,      DIA_PROP_SRC_FILE,   {(intptr_t) strStartupscreenFileName,          (intptr_t) strStartupscreenFilePath,          0, 0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   // CMC GPIO Properties
   #ifndef __DIA_UNIT_TESTING__
   { DIA_PROP_CENTER_CMC_19_PRIVATE_MIC_SWITCH,       DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_MIC_PRIVATE_SW,       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //Private MIC switch 
   { DIA_PROP_CENTER_CMC_19_WAKEIN_STATUS,            DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_WAKE_IN_L,       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, //WakeIn Status 
   { DIA_PROP_CMC_GPIO_EXTERNAL_SWITCH_WAKEOUT,       DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_WAKE_OUT,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   #endif
   // GPIO Signals
   { DIA_PROP_GPIO_SYSTEM_AMP_ON_OUTPUT,              DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_U140_SW_ENABLE,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },// DIA_PROP_GPIO_SYSTEM_AMP_ON_OUTPUT
   { DIA_PROP_GPIO_CD_CDROM_RESET,                    DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_CDDRIVE_RESET_GPIO,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_GPIO_AUDIO_EXT_OUT_TEL_MODE,            DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_TEL_MODE_AMP,        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_GPIO_AUDIO_EXT_OUT_HF_VR,               DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_HF_VR_MODE,          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_GPIO_UNUSED_EXT_IN_DAY_NIGHT,           DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_MR_OUT_DETECT,       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_GPIO_UNUSED_EXT_IN_WIRE_SPEED_INFO,     DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_GALA_DETECT,         0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_GPIO_DETECT_PLUG,                       DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_DETECT_PLUG_1,       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_GPIO_DETECT_PLUG_DIAG,                  DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_DETECT_PLUG_DIAG_1,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_GPIO_EXT_OUT_SPARE3,                    DIA_PROP_TYPE_BOOL, SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_GPIO,     {DIA_PROP_SRC_GPIO_KEY_UNKNOWN, OSAL_EN_OUTPUT_SPARE_3,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   // datapool properties
   { DIA_PROP_AIVI_ACOUSTIC_PARAM,                    DIA_PROP_TYPE_STR,  (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH), 20480, DIA_PROP_SRC_DP,       {(intptr_t) strDpNameAidArkamys,            0x0114, 0xfff9, (intptr_t) strDpNameAcousticParamElemData,            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_BRIGHTNESS,                        DIA_PROP_TYPE_STR,  SM_VAR_LEN,                                   1764, DIA_PROP_SRC_DP,       {(intptr_t) strDpNameBrightness,            0x0114, 0xfffC, (intptr_t) strDpNameBrightnessElemData,               0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   // datapool DEF properties
   { DIA_PROP_AIVI_DEF_PHONE_ECNR_NBS,                DIA_PROP_TYPE_STR,  SM_VAR_LEN,                    20480, DIA_PROP_SRC_DP,       {(intptr_t) strDpNameDefECNRPhoneNB,           0x0114, 0x0010, (intptr_t) strDpNameDefPhoneECNRNbsElemData,             0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_PHONE_ECNR_WBS,                DIA_PROP_TYPE_STR,  SM_VAR_LEN,                    20480, DIA_PROP_SRC_DP,       {(intptr_t) strDpNameDefECNRPhoneWB,           0x0114, 0x0011, (intptr_t) strDpNameDefPhoneECNRWbsElemData,             0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_CARPLAY_PHONE_ECNR_NBS,        DIA_PROP_TYPE_STR,  SM_VAR_LEN,                    20480, DIA_PROP_SRC_DP,       {(intptr_t) strDpNameDefECNRCarplayPhoneNB,    0x0114, 0x0012, (intptr_t) strDpNameDefCarPlayPhoneECNRNbsElemData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_CARPLAY_PHONE_ECNR_WBS,        DIA_PROP_TYPE_STR,  SM_VAR_LEN,                    20480, DIA_PROP_SRC_DP,       {(intptr_t) strDpNameDefECNRCarplayPhoneWB,    0x0114, 0x0013, (intptr_t) strDpNameDefCarPlayPhoneECNRWbsElemData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_CARPLAY_FACETIME_ECNR_SWB,     DIA_PROP_TYPE_STR,  SM_VAR_LEN,                    20480, DIA_PROP_SRC_DP,       {(intptr_t) strDpNameDefECNRCarplayFacetimeSWB,0x0114, 0x0014, (intptr_t) strDpNameDefCarPlayFacetimeECNRSwbElemData,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DEF_ACOUSTIC_PARAM,                DIA_PROP_TYPE_STR,  SM_VAR_LEN,                    20480, DIA_PROP_SRC_DP,       {(intptr_t) strDpNameProjectConfigRecords,     0x0114, 0xfffC, (intptr_t) strDpNameDefAcousticParamElemData,            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   // datapool AUDIO
   { DIA_PROP_AID_AUDIO_SOURCE_OFFSET,                DIA_PROP_TYPE_STR,  (SM_VAR_LEN|SM_NO_DEFAULT),    DIA_PROP_AIVI_AUDIO_SOURCE_OFFSET_LEN, DIA_PROP_SRC_DP, {(intptr_t) strDpNameAudioSourceOffset,    0x0114, 0xff15, (intptr_t) strDatasetNameAudioSrcOffset,        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VR_PARAM,                          DIA_PROP_TYPE_STR,  (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),    20480,                                 DIA_PROP_SRC_DP, {(intptr_t) strDpNameAidEcnr,              0x0114, 0xfffa, (intptr_t) strDpNameVRParamElemData,            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   //CD - Programming Session
   { DIA_PROP_AIVI_RESULT_CHECK_PROG_DEP,             DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK|SM_DISABLE_FLUSH,             1,                                     DIA_PROP_SRC_DP, {(intptr_t) strDpNameResultCheckProgDep,   0x0114, 0x0015, (intptr_t) strDpNameResultCheckProgDepElemData, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_BLOCK_FD00_REFERENCE_CHECKSUM,     DIA_PROP_TYPE_STR,  SM_VAR_LEN|SM_DISABLE_FLUSH,                    1*1024,                                DIA_PROP_SRC_DP, {(intptr_t) strDpNameLB00ReferenceChks,    0x0114, 0x0015, (intptr_t) strDpNameLB00ReferenceChksElemData,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_BLOCK_FD08_ESE,                    DIA_PROP_TYPE_STR,  SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH,  (64*1024)-1,    DIA_PROP_SRC_DP, {(intptr_t) strDpNameESE,                  0x0114, 0xFFF7, (intptr_t) strDpNameESEElemData,                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB,           DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtPhoneNbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB,           DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtPhoneWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB,           DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpPhoneNbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB,           DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpPhoneWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB,       DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpFaceTimeSwbData,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_BT_VOICE_NB,           DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtVoiceNbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_BT_VOICE_WB,           DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtVoiceWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_BT_SIRI_WB,            DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrBtSiriWbData,       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_CP_VOICE_WB,           DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrCpVoiceWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_AA_VOICE_WB,           DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrAaVoiceWbData,      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AID_DATASET_ECNR_VPA_VOICE_WB,          DIA_PROP_TYPE_STR, (SM_VAR_LEN|SM_NO_DEFAULT|SM_DISABLE_FLUSH),       20480,    DIA_PROP_SRC_DP,       {(intptr_t) strDpNameEcnr,    0x0114, 0xfffA, (intptr_t) strDpElemNameEcnrVpaVoiceWbData,     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   //CD - Programming Session - Digest
   { DIA_PROP_AIVI_DIGEST_FD00_REFERENCE_CHECKSUM,       DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1A0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD01_PHONE_ECNR_NBS,           DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1A1, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD02_PHONE_ECNR_WBS,           DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1A2, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD03_VR_PARAM,                 DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1A3, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD04_CARPLAY_PHONE_ECNR_NBS,   DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1A4, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD05_CARPLAY_PHONE_ECNR_WBS,   DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1A5, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD06_CARPLAY_FACETIME_ECNR_SWB,DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1A6, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD07_ACOUSTIC_PARAM,           DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1A7, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD08_ESE_PARAM,                DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1A8, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD09_BT_VOICE_ECNR_NBS,        DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1B0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD0A_BT_VOICE_ECNR_WBS,        DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1B1, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD0B_BT_SIRI_ECNR_WBS,         DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1B2, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD0C_CARPLAY_SIRI_ECNR_WBS,    DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1B3, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD0D_ANDROID_AUTO_VR_ECNR_WBS, DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1B4, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DIGEST_FD0E_ECNR_VPA_VOICE_WB,        DIA_PROP_TYPE_STR,  SM_DISABLE_FLUSH,           20, DIA_PROP_SRC_KDS, {0xA1B5, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   //Status of DTC FTB 0x51 of Logical Blocks
   { DIA_PROP_AIVI_LB00_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB01_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB02_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB03_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB04_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB05_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB06_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB07_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB08_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB09_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB10_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB11_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB12_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB13_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_LB14_DTC_PROGRAMMING_FAILURE_STATUS,  DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,           1,  DIA_PROP_SRC_RAM,      {0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   // Fix coded identification data
   { DIA_PROP_AIVI_CONFIG_SYSTEM_SUPPLIER_NUMBER,     DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,      5,  DIA_PROP_SRC_RAM,      {(intptr_t) g_AIVI_SystemSupplierNumber, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },      // SystemSupplierNumber   (with fix value)
   { DIA_PROP_AIVI_CAN_GEN_NUMBER,                    DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_RAM,      {0x00, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_DISABLE_DTC_AND_CSA_FOR_LBS,       DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_RAM,      {0x00, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VDIAG_NUMBER,                      DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_RAM,      {0x20, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },      // VDIAG
   { DIA_PROP_AIVI_THERMAL_MANAGE_TEMP_THRESHOLDS,    DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,    126,  DIA_PROP_SRC_KDS,      {0x1310, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_OCCURENCE_COUNTER,                 DIA_PROP_TYPE_U8,   SM_NO_STATUS_MASK,      1,  DIA_PROP_SRC_RAM,      {0x00,   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },  // DTC Occurrence Counter
   { DIA_PROP_CM_MIC_INVALID_CURRENT_VALUE,           DIA_PROP_TYPE_U16,  SM_NO_STATUS_MASK,      2,  DIA_PROP_SRC_RAM,      {0xFFFF, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },   // invalid value for microphone current

   // file properties
   { DIA_PROP_AIVI_CERTIFICATE,                       DIA_PROP_TYPE_RAW,  SM_VAR_LEN,       10*1024,  DIA_PROP_SRC_FILE,   {(intptr_t) strCertificateFileName,  (intptr_t) strCertificateFilePath,   0, 0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_SIGMA_DATA,                        DIA_PROP_TYPE_RAW,  SM_NO_STATUS_MASK,   4000,  DIA_PROP_SRC_FILE,   {(intptr_t) strSigmaFileName,        (intptr_t) strSigmaFilePath,         0, 0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   { DIA_PROP_AIVI_VIN,                               DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     17,                       DIA_PROP_SRC_KDS,   {0xA1C8, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }, // Vehicle identification number
   { DIA_PROP_AIVI_HW_REF_A,                          DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,  DIA_AIVI_ECU_HW_NR_LENGTH,   DIA_PROP_SRC_KDS,   {0xA126,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

   // SecurityAccess
   { DIA_PROP_AIVI_SECURITY_FINGERPRINT,              DIA_PROP_TYPE_STR,  SM_NO_STATUS_MASK,     16,  DIA_PROP_SRC_KDS,                {0xA12C,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
   // Vehicle Settings (triggered by HMI)
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM,                              DIA_PROP_TYPE_U8, SM_READ_ONLY,     21,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_MULTIPLE, (intptr_t) &array_BCM[0], sizeof(array_BCM)/sizeof(array_BCM[0])  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ALC,                              DIA_PROP_TYPE_U8, SM_READ_ONLY,      5,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineALC, DIA_PROP_SRC_ENGINE_CLIENT_KEY_MULTIPLE, (intptr_t) &array_ALC[0], sizeof(array_ALC)/sizeof(array_ALC[0])  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ADP,                              DIA_PROP_TYPE_U8, SM_READ_ONLY,      3,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineADP, DIA_PROP_SRC_ENGINE_CLIENT_KEY_MULTIPLE, (intptr_t) &array_ADP[0], sizeof(array_ADP)/sizeof(array_ADP[0])  , 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AUTO_LIGHT_TIM,               DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_AUTO_LIGHT_TIM               , 2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AUTO_LIGHT_DLY_TIM,           DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_AT_LIGHT_DLY_TIM             , 3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_LANE_CHANGES_3_FLASH,         DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_LANE_CHANGES_3_FLASH         , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_LED_HYDERDAY_LIGHT,           DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_LED_HYDERDAY_LIGHT           , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_ANSWER_BACK_EXTERIOR_LIGHT,   DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_ANSWER_BACK_EXTERIOR_LIGHT   , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_ROOM_LIGHT,                   DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_ROOM_LIGHT                   , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_WELCOME_LIGHT,                DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_WELCOME_LIGHT                , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AMBIENT_BRIGHTNESS,           DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_AMBIENT_BRIGHTNESS           , 3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_SELECTIVE_DOOR_UNLOCK,        DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_SELECTIVE_DOOR_UNLOCK        , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AUTO_LOCK,                    DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_AUTO_LOCK                    , 2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_AUTO_UNLOCK,                  DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_AUTO_UNLOCK                  , 2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_ANSWER_BACK,                  DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_ANSWER_BACK                  , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_WIPER_WITH_SPEED,             DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_WIPER_WITH_SPEED             , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_RAIN_SENSOR,                  DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_RAIN_SENSOR                  , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_DRIP_WIPE,                    DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_DRIP_WIPE                    , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_REVERSE_LINK,                 DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_REVERSE_LINK                 , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_LOCK_UNLOCK_BY_HANDS_FREE,    DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_LOCK_UNLOCK_BY_HANDS_FREE    , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_IGN_ACC_BATTERY_SAVER,        DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_IGN_ACC_BATTERY_SAVER        , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_REMOTE_ENGINE_START,          DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_REMOTE_ENGINE_START          , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_TOUCH_DOOR_SENSOR,            DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_TOUCH_DOOR_SENSOR            , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ALC_AMBIENT_BRIGHTNESS,           DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineALC, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_ALC_AMBIENT_BRIGHTNESS           , 3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ALC_FRONT_SEAT_AREA,              DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineALC, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_ALC_FRONT_SEAT_AREA              , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ALC_REAR_SEAT_AREA,               DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineALC, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_ALC_REAR_SEAT_AREA               , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ALC_ROOF_AMBINENT_LIGHT,          DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineALC, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_ALC_ROOF_AMBINENT_LIGHT          , 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ADP_LIFT_COLUMN_UPON_EXIT,        DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineADP, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U8_LID_VEHICLE_SETTING_ADP_LIFT_COLUMN_UPON_EXIT        , 8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ADP_ADJUST_DRIVE_SEAT_UPON_EXIT,  DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineADP, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U8_LID_VEHICLE_SETTING_ADP_ADJUST_DRIVE_SEAT_UPON_EXIT  , 8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_BCM_CUSTOM_RESET_IT,              DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineBCM, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_BCM_CUSTOM_RESET_IT              , 8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ALC_CUSTOM_RESET_IT,              DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineALC, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U16_DID_VEHICLE_SETTING_ALC_CUSTOM_RESET_IT              , 8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { DIA_PROP_AIVI_VEHICLE_SETTING_ADP_RESET_IT,                     DIA_PROP_TYPE_U8, SM_NO_STATUS_MASK, 1,  DIA_PROP_SRC_ENGINE_CLIENT,  {(intptr_t) strNameEngineADP, DIA_PROP_SRC_ENGINE_CLIENT_KEY_SINGLE,  DIA_C_U8_LID_VEHICLE_SETTING_ADP_RESET                        , 8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
#endif
};

const dia_FingerprintInfo aCMFingerprintData[] =
{
   //         property key                                    Crc_len
   /* KDS */  
   /* 01 */{ DIA_PROP_AIVI_VARIANT_CODING,                     0 },
   /* 02 */{ DIA_PROP_CM_SENSOR_CONFIG_ACC,                    0 },
   /* 03 */{ DIA_PROP_CM_SENSOR_CONFIG_GNSS,                   0 },
   /* 04 */{ DIA_PROP_CM_SENSOR_CONFIG_GYRO,                   0 },
   /* 05 */{ DIA_PROP_CM_GENERIC_TUNER_PARAM_SET,              0 },
   /* 06 */{ DIA_PROP_CM_FM_AM_TUNER_PARAMETER_SET,            0 },
   /* 07 */{ DIA_PROP_CM_HD_PARAMETER_SET,                     0 },
   /* 08 */{ DIA_PROP_CM_DAB_TUNER_PARAMETER_SET,              0 },
   /* 09 */{ DIA_PROP_CM_ANTENNA_PARAMETER_SET,                0 },
   /* 10 */{ DIA_PROP_AIVI_DEF_SYSTEM_INFO_COMMON,             0 },
   /* 11 */{ DIA_PROP_THERMALMNGMT_TEMPERATURE_THRESHOLDS,     0 },
   /* 12 */{ DIA_PROP_CM_DIMMING_PARAMETER_SET,                0 },
   /* 13 */{ DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_ONE,          0 },
   /* 14 */{ DIA_PROP_CM_VARIANT_CODING,                       0 },
   /* 15 */{ DIA_PROP_CM_NAVIGATION_DEFAULT_POSITION,          0 },
   /* 16 */{ DIA_PROP_CM_NAVI_DATA_SEC_KEY ,                   0 },
   /* 17 */{ DIA_PROP_SW_UPD_VARIANT_INFO,                     0 },
   /* 18 */{ DIA_PROP_CM_DEVICE_MANAGER,                       0 },
   /* 19 */{ DIA_PROP_CM_MEDIA_PLAYER,                         0 },
   /* 20 */{ DIA_PROP_CM_DISPLAY,                              0 }, 
   /* 21 */{ DIA_PROP_AIVI_DEF_CAMERA_SYSTEM,                  0 },
   /* 22 */{ DIA_PROP_AIVI_VEHICLE_INFO,                       0 },
   /* 23 */{ DIA_PROP_AIVI_SOUND_VOLUME_CONFIG,                0 },
   /* 24 */{ DIA_PROP_AIVI_HMI_CONFIG,                         0 },
   /* 25 */{ DIA_PROP_AIVI_CONFIG_PARTS_NUMBER,                0 },
   /* 26 */{ DIA_PROP_CM_CUSTOMER_ECU_PART_NR,                 0 },
   /* 27 */{ DIA_PROP_CM_EARLY_CONFIG_DISPLAY,                 0 },
   /* 28 */{ DIA_PROP_CM_EARLY_CONFIG_TWO_DISPLAY,             0 },
   /* 29 */{ DIA_PROP_CM_EARLY_CONFIG_TOUCH_DRIVER,            0 },
   /* 30 */{ DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_TWO,          0 },
   /* 31 */{ DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_THREE,        0 },
   /* 32 */{ DIA_PROP_CM_INPUT_KEY_MAPPING_TABLE_FOUR,         0 },
   /* 33 */{ DIA_PROP_AIVI_SPEED_LOCKOUT,                      0 }, 
   /* 34 */{ DIA_PROP_CM_BT_NAME,                              0 },
   /* 35 */{ DIA_PROP_CM_WIFI_NAME_1,                          0 },
   /* 36 */{ DIA_PROP_CENTER_CMC_19_TESTMODE_DTM,              0 },
   /* 37 */{ DIA_PROP_CM_AUDIO_PARAMETER_SET,                  0 },
   /* 38 */{ DIA_PROP_CM_KEY_ILLUMINATION_ALIGNMENT_COEFF,     0 },
   /* 39 */{ DIA_PROP_CENTER_CMC_19_NVM_PNM_GROUP_10_CONFIG,   0 },
   /* 40 */{ DIA_PROP_CM_SMARTPHONE_INTEGRATION,   			   0 },
   /* 41 */{ DIA_PROP_CMC_AVDECC_CONFIG,   					   0 },
   /* 42 */{ DIA_PROP_CMC_CIS_CONFIG_DEFAULT, 				   0 },
   /* 43 */{ DIA_PROP_CMC_INTERCOM_PHONE_NAME, 				   0 },
   /* 44 */{DIA_PROP_CENTER_CMC_19_CD_PNM_GROUP_10_CONFIG,     0 },



   /* Dynamic Length - DP */
   /* 45 */{ DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB,            0 },
   /* 46 */{ DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB,            0 },
   /* 47 */{ DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB,            0 },
   /* 48 */{ DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB ,           0 },
   /* 49 */{ DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB,        0 },
   /* 50 */{ DIA_PROP_AID_DATASET_ECNR_AA_VOICE_WB,            0 },
   /* 51 */{ DIA_PROP_AID_DATASET_ECNR_BT_SIRI_WB,             0 },
   /* 52 */{ DIA_PROP_AID_DATASET_ECNR_BT_VOICE_WB,            0 },
   /* 53 */{ DIA_PROP_AID_DATASET_ECNR_BT_VOICE_NB,            0 },
   /* 54 */{ DIA_PROP_AID_DATASET_ECNR_CP_VOICE_WB,            0 },
   /* 55 */{ DIA_PROP_AIVI_VR_PARAM,                           0 },
   /* 56 */{ DIA_PROP_AID_DATASET_ECNR_VPA_VOICE_WB,           0 }

};


const dia_FingerprintInfo aCustomerFingerprintData_Set1[] =
{
             // key                                     Crc_len
   //KDS
   /*  1. */ { DIA_PROP_AIVI_SENSOR_CONFIG_ACC,         0 },
   /*  2. */ { DIA_PROP_AIVI_SENSOR_CONFIG_GNSS,        0 },
   /*  3. */ { DIA_PROP_AIVI_SENSOR_CONFIG_GYRO,        0 },
   /*  4. */ { DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET,   0 },
   /*  5. */ { DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET,      0 },
   /*  6. */ { DIA_PROP_AIVI_HD_PARAM_SET,              0 },
   /*  7. */ { DIA_PROP_AIVI_DAB_SET,                   0 },
   /*  8. */ { DIA_PROP_AIVI_ANTENNA_PARAM_SET,         0 },
   /*  9. */ { DIA_PROP_AIVI_SYSTEM_INFO_COMMON,        0 },
   /* 10. */ { DIA_PROP_AIVI_VEHICLE_INFO,              0 },
   /* 11. */ { DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION,    0 },
   /* 12. */ { DIA_PROP_AIVI_CAMERA_SYSTEM,             0 },
   /* 13. */ { DIA_PROP_AIVI_ECO_ROUTE,                 0 },
   /* 14. */ { DIA_PROP_CM_BT_NAME,                     0 },
   /*15A. */ { DIA_PROP_CM_WIFI_NAME_1,                 0 },
   /*15B. */ { DIA_PROP_CM_WIFI_NAME_2,                 0 },

   /* Dynamic Length - DP */
   /* 16. */ { DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB,   0 },
   /* 17. */ { DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB,   0 },
   /* 18. */ { DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB,   0 },
   /* 19. */ { DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB,   0 },
   /* 20. */ { DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB,0 },

   //KDS
   /* 22. */ { DIA_PROP_AIVI_AUDIO_PARAM_SET,           0 },
   /* 23. */ { DIA_PROP_AIVI_CONFIG_PARTS_NUMBER,       0 }
//           { DIA_PROP_CM_EXTENDED_VARIANT_CODING,      0},
};

const dia_FingerprintInfo aCustomerFingerprintData_Set2[] =
{
             // key                                     Crc_len
   //KDS
   /*  1. */ { DIA_PROP_AIVI_SENSOR_CONFIG_ACC,         0 },
   /*  2. */ { DIA_PROP_AIVI_SENSOR_CONFIG_GNSS,        0 },
   /*  3. */ { DIA_PROP_AIVI_SENSOR_CONFIG_GYRO,        0 },
   /*  4. */ { DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET,   0 },
   /*  5. */ { DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET,      0 },
   /*  6. */ { DIA_PROP_AIVI_HD_PARAM_SET,              0 },
   /*  7. */ { DIA_PROP_AIVI_DAB_SET,                   0 },
   /*  8. */ { DIA_PROP_AIVI_ANTENNA_PARAM_SET,         0 },
   /*  9. */ { DIA_PROP_AIVI_SYSTEM_INFO_COMMON,        0 },
   /* 10. */ { DIA_PROP_AIVI_VEHICLE_INFO,              0 },
   /* 11. */ { DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION,    0 },
   /* 12. */ { DIA_PROP_AIVI_CAMERA_SYSTEM,             0 },
   /* 13. */ { DIA_PROP_AIVI_ECO_ROUTE,                 0 },
   /* 14. */ { DIA_PROP_CM_BT_NAME,                     0 },
   /*15A. */ { DIA_PROP_CM_WIFI_NAME_1,                 0 },
   /*15B. */ { DIA_PROP_CM_WIFI_NAME_2,                 0 },
   /* 16. */ { DIA_PROP_AIVI_MEX_CONFIG,                0 },
   /* 17. */ { DIA_PROP_AIVI_FACTORY_MODE,              0 },
   /* 18. */ { DIA_PROP_AIVI_CONNECTIVITY_CONFIG,       0 },
   /* 19. */ { DIA_PROP_AIVI_HMI_CONFIG,                0 },
   /* 20. */ { DIA_PROP_AIVI_SOUND_VOLUME_CONFIG,       0 },
   /* 21. */ { DIA_PROP_CM_DRM_TUNER_PARAMETER_SET,     0 },
   /* 22. */ { DIA_PROP_AIVI_CONFIG_PARTS_NUMBER,       0 }
};

const dia_FingerprintInfo aCustomerDefaultFingerprintData_Set1[] =
{
           // key                                           Crc_len
   //KDS
   /*  1. */ { DIA_PROP_AIVI_DEF_SENSOR_CONFIG_ACC,         0 },
   /*  2. */ { DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GNSS,        0 },
   /*  3. */ { DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GYRO,        0 },
   /*  4. */ { DIA_PROP_AIVI_DEF_GENERIC_TUNER_PARAM_SET,   0 },
   /*  5. */ { DIA_PROP_AIVI_DEF_FMAM_TUNER_PARAM_SET,      0 },
   /*  6. */ { DIA_PROP_AIVI_DEF_HD_PARAM_SET,              0 },
   /*  7. */ { DIA_PROP_AIVI_DEF_DAB_SET,                   0 },
   /*  8. */ { DIA_PROP_AIVI_DEF_ANTENNA_PARAM_SET,         0 },
   /*  9. */ { DIA_PROP_AIVI_DEF_SYSTEM_INFO_COMMON,        0 },
   /* 10. */ { DIA_PROP_AIVI_DEF_VEHICLE_INFO,              0 },
   /* 11. */ { DIA_PROP_AIVI_DEF_ANTITHEF_MAP_SELECTION,    0 },
   /* 12. */ { DIA_PROP_AIVI_DEF_CAMERA_SYSTEM,             0 },
   /* 13. */ { DIA_PROP_AIVI_DEF_ECO_ROUTE,                 0 },
   /* 14. */ { DIA_PROP_AIVI_DEF_BT_NAME,                   0 },
   /*15A. */ { DIA_PROP_AIVI_DEF_WIFI_NAME_1,               0 },
   /*15B. */ { DIA_PROP_AIVI_DEF_WIFI_NAME_2,               0 },

   /* Dynamic Length - DP */
   /* 16. */ { DIA_PROP_AIVI_DEF_PHONE_ECNR_NBS,            0 },
   /* 17. */ { DIA_PROP_AIVI_DEF_PHONE_ECNR_WBS,            0 },
   /* 18. */ { DIA_PROP_AIVI_DEF_CARPLAY_PHONE_ECNR_NBS,    0 },
   /* 19. */ { DIA_PROP_AIVI_DEF_CARPLAY_PHONE_ECNR_WBS,    0 },
   /* 20. */ { DIA_PROP_AIVI_DEF_CARPLAY_FACETIME_ECNR_SWB, 0 },

   //KDS
   /* 22. */ { DIA_PROP_AIVI_DEF_AUDIO_PARAM_SET,           0 },
   /* 23. */ { DIA_PROP_AIVI_DEF_CONFIG_PARTS_NUMBER,       0 }
};

const dia_FingerprintInfo aCustomerDefaultFingerprintData_Set2[] =
{
               // key                                          Crc_len
      //KDS
      /*  1. */ { DIA_PROP_AIVI_DEF_SENSOR_CONFIG_ACC,         0 },
      /*  2. */ { DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GNSS,        0 },
      /*  3. */ { DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GYRO,        0 },
      /*  4. */ { DIA_PROP_AIVI_DEF_GENERIC_TUNER_PARAM_SET,   0 },
      /*  5. */ { DIA_PROP_AIVI_DEF_FMAM_TUNER_PARAM_SET,      0 },
      /*  6. */ { DIA_PROP_AIVI_DEF_HD_PARAM_SET,              0 },
      /*  7. */ { DIA_PROP_AIVI_DEF_DAB_SET,                   0 },
      /*  8. */ { DIA_PROP_AIVI_DEF_ANTENNA_PARAM_SET,         0 },
      /*  9. */ { DIA_PROP_AIVI_DEF_SYSTEM_INFO_COMMON,        0 },
      /* 10. */ { DIA_PROP_AIVI_DEF_VEHICLE_INFO,              0 },
      /* 11. */ { DIA_PROP_AIVI_DEF_ANTITHEF_MAP_SELECTION,    0 },
      /* 12. */ { DIA_PROP_AIVI_DEF_CAMERA_SYSTEM,             0 },
      /* 13. */ { DIA_PROP_AIVI_DEF_ECO_ROUTE,                 0 },
      /* 14. */ { DIA_PROP_AIVI_DEF_BT_NAME,                   0 },
      /*15A. */ { DIA_PROP_AIVI_DEF_WIFI_NAME_1,               0 },
      /*15B. */ { DIA_PROP_AIVI_DEF_WIFI_NAME_2,               0 },
      /* 16. */ { DIA_PROP_AIVI_DEF_MEX_CONFIG,                0 },
      /* 17. */ { DIA_PROP_AIVI_DEF_FACTORY_MODE,              0 },
      /* 18. */ { DIA_PROP_AIVI_DEF_CONNECTIVITY_CONFIG,       0 },
      /* 19. */ { DIA_PROP_AIVI_DEF_HMI_CONFIG,                0 },
      /* 20. */ { DIA_PROP_AIVI_DEF_SOUND_VOLUME_CONFIG,       0 },
      /* 21. */ { DIA_PROP_AIVI_DEF_DRM_TUNER_PARAMETER_SET,   0 },
      /* 22. */ { DIA_PROP_AIVI_DEF_CONFIG_PARTS_NUMBER,       0 }
};

enum eCanGen
{
   AIVI_CAN_GEN_UNKNOWN = 0,
   AIVI_CAN_GEN_3,
   AIVI_CAN_GEN_5,
   AIVI_CAN_GEN_6,
   AIVI_CAN_GEN_COUNT
};

#endif
