/*
* dia_EngineConfigGen3g.cpp
*
*  Created on: 10.06.2013
*      Author: stc2hi
*      --------------------------------------------------------------------------------------
*      Date        Author      Modification
*
*     08.01.2016  bsu9kor      Added DID for Device Production Time. (AIVI-17184)
*     08.01.2016  bsu9kor      Added dummy DID for Routine control-NAV Checksum. (CMG3G-6662)
*     12.01.2016  bma9kor    Enabled read External input status for ACC (AIVI 17190)
*     12.01.2016  bma9kor    Enabled read External input status for Reverse Gear (AIVI 17190)
*     25.01.2016  gpu2kor    replaced duplicate enties for SCC SW, BootLoader and Boot Manager version
*                            with new Read features SCC_ApplicationSoftwareVersionLabel,
*                            SCC_BootloaderSoftwareVersionLabel,
*                            SCC_BootManagerSoftwareVersionLabel
*     01.02.2016  bma9kor    Enabled read Iginition and Illumination switches (AIVI 17190)
*     21.03.2016  bma9kor    Enabled read for SDCard1SlotState (AIVI 20999)
*     16.06.2016  dvd5kor    AIVI-23605 - Enabled Read and Write for RadioTypeApprovalMode
*     20.06.2016  dvd5kor    Configured service IOCtrlSystemAmpOnOutput in production session
*     30.06.2016  dvd5kor    Configured ystemSetApmOn as external Amplifier Control line to production session (AIVI-23602)
*     01.07.2016  bma9kor    Enabled read for Alliance Calibration XtraData (AIVI-24904)
*     05.07.2016  bsu9kor    Enabled read for External Input status for Parking Brake ( AIVI-24903).
*     09.08.2016  bma9kor    Enabled read for GPS Reception Level ( AIVI-26188)
*     07.09.2016  bsu9kor    Enabled read for radio state (AIVI-26190).
*     02.09.2016  bma9kor    Enabled rtctrl for Touch Controller SelfTest ( AIVI-25880)
*     10.26.2016  ogm5kor    Enabled Degraded Mode Counter read (AIVI-26132)
*     10.26.2016  ogm5kor    Enabled Degraded Mode Cumulated Duration read (AIVI-26132)
*     11.02.2016  ogm5kor    Enabled Time From Engine Stopped read (AIVI-26134)
*     11.25.2016  ogm5kor    Enabled Vehicle Identifier First Value read (AIVI-37555)
*     12.14.2016  mky6kor    Enabled read for Vehicle Manufacturer Hardware Number(AIVI-24508)
*     01.30.2017  mky6kor    Enabled read for Number of CD Inserted(AIVI-38637)
*     04.12.2017  bma9kor    Enabled read and write to KDS for configRecords for SmartPhone Integration (AIVI-49829)
*     08.05.2017  mky6kor    Enabled read and write to KDS for configRecords for TouchDriver2 (AIVI-53850)
*     08.06.2018  urm7kor    Enabled Routine service Set Diag to Delivery State (INF4CV-241724)
*     08.22.2018  hme4kor    Configured service Read- SoftwareSupplierInfo & HardwareSupplierInfo  (CenterCMC19 RTC-302486)
*	   08.27.2018  ama8kor    Configured service Read- Boot Software Version & Customer Software Version for CENTER_CMC_19. (RTC-302484)
*     08.28.2018  nik6kor    Enabled and mapped PD to CD read System supplier HW and SW part and version number (CenterCMC19 RTC- 302487)
*     10.24.2018  hme4kor    Rework - Device configuration (CenterCMC19 RTC- 350444)
*	   10.22.2018  ama8kor    Configured service Read- Hardware Version Information, customerECUHWVersion for CENTER_CMC_19. (RTC-359909)
*     10.22.2018  ama8kor    Configured service Write- customerECUHWVersion for CENTER_CMC_19. (RTC-359909)
*     10.23.2018  mky6kor    Enabled read for Basic Identification ECU Serial Number  (CenterCMC19 RTC-359900)
*     11.15.2018  mky6kor    Enabled read for Basic Identification Hardware Part Number  (CenterCMC19 RTC-407869)
*     11.15.2018  mky6kor    Enabled read and write Customer Spare Part Number  (CenterCMC19 RTC-407869)
*     11.30.2018  mky6kor    Added SH for Reading Active Diagnostic Information  (CenterCMC19 RTC-425829)
*     11.29.2018  urm7kor    Enabled Default Session for ECU Reset Customer Diagnosis  (CenterCMC19 RTC-426066)
*     01.31.2019  hgr6kor    Configured service read compatibility list  (CenterCMC19 RTC-433641)
*     01.24.2019  urm7kor    Added SH for Read/Write Configuration Fingerprint  (CenterCMC19 RTC-451284)
*     02.27.2019  urm7kor    Added SH for Read Fieldstrength of AM/FM Tuner (CenterCMC19 RTC-433650)
*     02.27.2019  urm7kor    Added SH for Read Fieldstrength of FM Tuner2 (CenterCMC19 RTC-433652)
*     02.27.2019  urm7kor    Added SH for Read Fieldstrength of DAB Tuner (CenterCMC19 RTC-433653)
*     02.27.2019  urm7kor    Added SH for Read Fieldstrength of SXM Tuner (CenterCMC19 RTC-433659)
*     02.27.2019  urm7kor    Added SH for Read Fieldstrength of Weatherband Tuner (CenterCMC19 RTC-433657)
*     03.20.2019  mky6kor    Enabled I/O control for Display Test Screen (CenterCMC19 RTC-430543)
*     03.27.2019  hgr6kor    Configured service read operation time  (CenterCMC19 RTC-470424)
*     04.01.2019  mky6kor	  Added SH for Read Temperature Statistics  (CenterCMC19 RTC-466144)
*     04.05.2019  mky6kor	  Enabled DTC Setting Mode On/Off in Extended Session (CenterCMC19 RTC-426092)
*     04.09.2019  ama8kor	  Configured service read Mercedes Truck Software Part Number [F126]  (CenterCMC19 RTC-483418)
*     04.09.2019  hgr6kor    Configured service read and write PNM Group 10 Configuration (CenterCMC19 RTC-481484)
*     15.04.2019  ama8kor    Bugfix for Tickets CenterCMC19 RTC-446712, RTC-446780
*     19.06.2019  mky6kor    Added Security Access Service for Customer Diagnosis(CenterCMC19 RTC-526465)
*     19.06.2019  mky6kor    Enabled Read Service for Tester Identification (CenterCMC19 RTC-526465)
*     01.07.2019  urm7kor    Added Routine Control service handler for execution of CM-C installation container (CenterCMC19 RTC-460577)
*     01.07.2019  urm7kor    Added Routine Control service handler for copying Installation Log File to USB (CenterCMC19 RTC-483402)
*     08.07.2019  urm7kor    Added SH for Read connection status of the Amplifier CM-A 19   (CenterCMC19 RTC-503601)
*     01.08.2019  urm7kor    Added New SubSystem Diagnosis Session   (CenterCMC19 RTC-571782)
*     10.09.2019  hgr6kor    PD and CD Cleanup activity for CMC Irrelevant features (CenterCMC19 RTC-5990073)
*     13.12.2019  urm7kor    CMC to get an OEM specific logo during the System Installation (CenterCMC19 RTC-671064)
*     03.31.2020  urm7kor    Added SH for Read Fieldstrength of HD Tuner(CenterCMC19 RTC-728676)
*     09.08.2021  aoo2kor    Added SH for Read AudioFilesCounter(CenterCMC19 [SYSFL-5057][RTC1-559523])
*     09.08.2021  aoo2kor    Added SH for Read VideoFilesCounter(CenterCMC19 [SYSFL-5056][RTC1-503558])
*     11.10.2021  aoo2kor    Enabled missing SubSystem Diagnosis features   (CenterCMC19 RTC1-1263831)
*  -------------------------------------------------------------------------------------------------------------------------------------
*/

#ifndef __DIA_UNIT_TESTING__
#define DIA_EN_SECURITY_LEVEL_DOIP_CMC   DIA_EN_SECURITY_LEVEL_PROJECT_02
#else
#define DIA_EN_SECURITY_LEVEL_DOIP_CMC   DIA_EN_SECURITY_LEVEL_NOT_ACTIVE
#endif

#ifndef __DIA_UNIT_TESTING__
#define DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER   DIA_EN_SECURITY_LEVEL_PROJECT_03
#else
#define DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER   DIA_EN_SECURITY_LEVEL_NOT_ACTIVE
#endif

#ifndef __DIA_UNIT_TESTING__
#define DIA_EN_SECURITY_LEVEL_ALD_CMC   DIA_EN_SECURITY_LEVEL_ALD
#else
// ALD Security Access is not available during Unit Tests
#define DIA_EN_SECURITY_LEVEL_ALD_CMC   DIA_EN_SECURITY_LEVEL_NOT_ACTIVE
#endif //__DIA_UNIT_TESTING__

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include "common/framework/security/dia_security.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEYUDS__
#include "common/framework/protocols/uds/dia_LookupKeyUDS.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_SIGMA__
#include "project/framework/sigma/dia_Sigma.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__
#include <project/framework/cis/subsystem/dia_defsSubsystemDiagnosis.h>
#endif

#include "dia_EngineConfigGen3g.h"

using namespace std;

static const tU16 DID_LEN_1 = 1;
static const tU16 DID_LEN_2 = 2;

// set of supported diagnosis sessions (first session is used as default session)
static tU8 supportedSessions[] = {
   DIA_C_U8_UDS_SESSION_DEFAULT,
   DIA_C_U8_UDS_SESSION_PROGRAMMING,
   DIA_C_U8_UDS_SESSION_EXTENDED,
   DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION,
   DIA_C_U8_UDS_SESSION_RBCM_ADR,
   DIA_C_U8_UDS_SESSION_SUBSYSTEM };

// data file property names
const tChar* strSigmaFileName                         = "diaSigmaData.log";
const tChar* strSigmaFilePath                         = "/var/opt/bosch/dynamic";
const tChar* strCertificateFileName                   = "diaCertificateData.raw";
const tChar* strCertificateFilePath                   = "/tmp/partAuth/crt";
//----------------------------------------------------------------------------------------------
const tChar* strInstallationContainerFileName         = "diagcisinstallation.tar.gz";
const tChar* strInstallationContainerFilePath         = "/tmp";
//----------------------------------------------------------------------------------------------
const tChar* strInstallationLogFileName               = "doipcmcinstallresult.xml";
const tChar* strInstallationLogFilePath               = "/var/opt/bosch/persistent/avdecc";
//----------------------------------------------------------------------------------------------
const tChar* strAvdeccCfgDbFileName                   = "AVRoutingAdapter.xml";
const tChar* strAvdeccCfgDbFilePath                   = "/var/opt/bosch/persistent/avdecc";
//----------------------------------------------------------------------------------------------
const tChar* strStartupscreenFileName                 = "oem_logo.mp4";
const tChar* strStartupscreenFilePath                 = "/var/opt/bosch/persistent/avdecc";
//----------------------------------------------------------------------------------------------
const tChar* strCISHMILogo1Name                        = "Setra_Logo_Monitoranzeige_1920x1080px.jpg";
const tChar* strCISHMILogo1Path                        = "/var/opt/bosch/persistent/avdecc/cisinstallation";
//----------------------------------------------------------------------------------------------
const tChar* strCISHMILogo2Name                        = "MBmBusClaim1920x1080px_191118.png";
const tChar* strCISHMILogo2Path                        = "/var/opt/bosch/persistent/avdecc/cisinstallation";
//----------------------------------------------------------------------------------------------
// See XLS file with Datapool configuration: https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-731790/Overview_Parameter_Sets_with_name_conventions.xlsx

// datapool names
/* CD */
const tChar* strDpNameECNRPhoneNB                       = "aidDpDatasetECNRPhoneNB";
const tChar* strDpNameECNRPhoneWB                       = "aidDpDatasetECNRPhoneWB";
const tChar* strDpNameECNRCarplayPhoneNB                = "aidDpDatasetECNRCarplayPhoneNB";
const tChar* strDpNameECNRCarplayPhoneWB                = "aidDpDatasetECNRCarplayPhoneWB";
const tChar* strDpNameECNRCarplayFacetimeSWB            = "aidDpDatasetECNRCarplayFacetimeSWB";

/* CD-DEF */
const tChar* strDpNameDefECNRPhoneNB                    = "defDpDatasetECNRPhoneNB";
const tChar* strDpNameDefECNRPhoneWB                    = "defDpDatasetECNRPhoneWB";
const tChar* strDpNameDefECNRCarplayPhoneNB             = "defDpDatasetECNRCarplayPhoneNB";
const tChar* strDpNameDefECNRCarplayPhoneWB             = "defDpDatasetECNRCarplayPhoneWB";
const tChar* strDpNameDefECNRCarplayFacetimeSWB         = "defDpDatasetECNRCarplayFacetimeSWB";

/* PD */
const tChar* strDpNameProjectConfigRecords              = "DPAID_DatasetProject";               //Remaining Scope2 Audio Parameter Sets
const tChar* strDpNameVrParam                           = "aidDpDatasetECNRVrParam";
const tChar* strDpNameBtVoiceEcnrNbs                    = "aidDpDatasetECNRBtVoiceNB";
const tChar* strDpNameBtVoiceEcnrWbs                    = "aidDpDatasetECNRBtVoiceWB";
const tChar* strDpNameBtSiriEcnrWbs                     = "aidDpDatasetECNRBtSiriWB";
const tChar* strDpNameCarplaySiriEcnrWbs                = "aidDpDatasetECNRCpVoiceWB";
const tChar* strDpNameAndroidAutoVrEcnrWbs              = "aidDpDatasetECNRAaVoiceWB";
const tChar* strDpNameBrightness                        = "DPAID_DatasetProject"; //TODO: Replace with real Dimming Datapool Name

/* AID ECNR (CD & PD) */
const tChar* strDpNameAidEcnr                           = "DPAID_DatasetEcnr";
const tChar* strDpNameAidArkamys                        = "ArkamysDP";

/* CD - Programming Session */
const tChar* strDpNameLB00ReferenceChks                 = "aidDpDatasetAiviReprogramming";
const tChar* strDpNameESE                               = "EngineSoundDP";
const tChar* strDpNameDigests                           = "aidDpDatasetAiviReprogramming";
const tChar* strDpNameResultCheckProgDep                = "aidDpDatasetAiviReprogramming";

// datapool element names
/* CD */
const tChar* strDpNamePhoneECNRNbsElemData              = "DataEcnrBtPhoneNB";
const tChar* strDpNamePhoneECNRWbsElemData              = "DataEcnrBtPhoneWB";
const tChar* strDpNameCarPlayPhoneECNRNbsElemData       = "DataEcnrCpPhoneNB";
const tChar* strDpNameCarPlayPhoneECNRWbsElemData       = "DataEcnrCpPhoneWB";
const tChar* strDpNameCarPlayFacetimeECNRSwbElemData    = "DataEcnrCpFacetimeSWB";
const tChar* strDpNameAcousticParamElemData             = "Arkamys_Eol";               /* Only for Scope2 */
const tChar* strDpNameEcnrBtVoiceNBElemData             = "DataEcnrBtVoiceNB";
const tChar* strDpNameEcnrBtVoiceWBElemData             = "DataEcnrBtVoiceWB";
const tChar* strDpNameEcnrBtSiriWBElemData              = "DataEcnrBtSiriWB";
const tChar* strDpNameEcnrCpVoiceWBElemData             = "DataEcnrCpVoiceWB";
const tChar* strDpNameEcnrAaVoiceWBElemData             = "DataEcnrAaVoiceWB";
const tChar* strDpNameEcnrVpaVoiceWBElemData            = "DataEcnrVpaVoiceWB";

/* CD-DEF */
const tChar* strDpNameDefPhoneECNRNbsElemData           = "DataDefEcnrBtPhoneNB";
const tChar* strDpNameDefPhoneECNRWbsElemData           = "DataDefEcnrBtPhoneWB";
const tChar* strDpNameDefCarPlayPhoneECNRNbsElemData    = "DataDefEcnrCpPhoneNB";
const tChar* strDpNameDefCarPlayPhoneECNRWbsElemData    = "DataDefEcnrCpPhoneWB";
const tChar* strDpNameDefCarPlayFacetimeECNRSwbElemData = "DataDefEcnrCpFacetimeSWB";
const tChar* strDpNameDefAcousticParamElemData          = "DataDefAcousticParam";            /* Only for Scope2 */

/* PD */
const tChar* strDpNameVRParamElemData                   = "DataEcnrIntVoiceWB";
const tChar* strDpNameBrightnessElemData                = "DataBrightnessParam"; //TODO: Replace with real Dimming Datapool Element Name
const tChar* strFileNameCertificate                     = "DataFileCertificate";

/* CD - CMC */
const tChar* strFileNameInstallationContainer			= "CISInstallationContainer";
const tChar* strFileNameInstallationLogFile			    = "CISInstallationLogFile";
const tChar* strFileNameAvdeccCfgDbFile			        = "CISAvdeccConfigurationDatabase";
const tChar* strFileNameStartupScreenFile			        = "CISStartupScreen";

/* CD - Programming Session */
const tChar* strDpNameLB00ReferenceChksElemData         = "DataLb00_REFERENCE_CHECKSUM";
const tChar* strDpNameESEElemData                       = "EngineSound_Data";
const tChar* strDpNameDigestFD00ElemData                = "DataDigestLbFD00_REFERENCE_CHECKSUM";
const tChar* strDpNameDigestFD01ElemData                = "DataDigestLbFD01_PHONE_ECNR_NBS";
const tChar* strDpNameDigestFD02ElemData                = "DataDigestLbFD02_PHONE_ECNR_WBS";
const tChar* strDpNameDigestFD03ElemData                = "DataDigestLbFD03_VR_PARAM";
const tChar* strDpNameDigestFD04ElemData                = "DataDigestLbFD04_CARPLAY_PHONE_ECNR_NBS";
const tChar* strDpNameDigestFD05ElemData                = "DataDigestLbFD05_CARPLAY_PHONE_ECNR_WBS";
const tChar* strDpNameDigestFD06ElemData                = "DataDigestLbFD06_CARPLAY_FACETIME_ECNR_SWB";
const tChar* strDpNameDigestFD07ElemData                = "DataDigestLbFD07_ACOUSTIC_PARAM";
const tChar* strDpNameDigestFD08ElemData                = "DataDigestLbFD08_ESE_PARAM";
const tChar* strDpNameDigestFD09ElemData                = "DataDigestLbFD09_BT_VOICE_ECNR_NBS";
const tChar* strDpNameDigestFD0AElemData                = "DataDigestLbFD0A_BT_VOICE_ECNR_WBS";
const tChar* strDpNameDigestFD0BElemData                = "DataDigestLbFD0B_BT_SIRI_ECNR_WBS";
const tChar* strDpNameDigestFD0CElemData                = "DataDigestLbFD0C_CARPLAY_SIRI_ECNR_WBS";
const tChar* strDpNameDigestFD0DElemData                = "DataDigestLbFD0D_ANDROID_AUTO_VR_ECNR_WBS";
const tChar* strDpNameDigestFD0EElemData                = "DataDigestLbFD0E_ECNR_VPA_VOICE_WB";
const tChar* strDpNameResultCheckProgDepElemData        = "Data_Result_of_CheckProgrammingDependency";

/* CMC */
const tChar* strDpNameTesterIdentification 				= "DPCMC_TesterIdentification"; //Name as in "aidDpCMCTesterIdentification.xml"
const tChar* strDpElementNameTesterIdentification 		= "TesterIdentification";
const tChar* strDpNameNVMConfiguration                  = "DPCMC_PNM_DATA_SYNC_WITH_NVM";
const tChar* strDpElementNameNVMConfigurationValue      = "NVMConfigurationValue";
const tChar* strDpNameDTCConfiguration  				= "AppDiag_CMC"; //Name as in "aidDpCMCDTCConfiguration.xml"
const tChar* strDpElementNameDTCConfiguration   		= "DTCConfiguration";
const tChar* strDpNameCISConfiguration  				= "DPCMC_CISConfiguration";
const tChar* strDpElementNameCISConfiguration   		= "CISConfiguration";
const tChar* strDpNameAVDECCConfiguration  				= "DPCMC_AVDECCConfiguration";
const tChar* strDpElementNameAVDECCConfiguration   		= "AVDECCConfiguration";
const tChar* strDpNameRunTimeSourceAM  					= "DPCMC_RunTimeSourceAM";
const tChar* strDpElementNameRunTimeSourceAM   			= "RunTimeSourceAM";
const tChar* strDpNameRunTimeSourceFM  					= "DPCMC_RunTimeSourceFM";
const tChar* strDpElementNameRunTimeSourceFM   			= "RunTimeSourceFM";
const tChar* strDpNameRunTimeSourceDAB  				= "DPCMC_RunTimeSourceDAB";
const tChar* strDpElementNameRunTimeSourceDAB   		= "RunTimeSourceDAB";
const tChar* strDpNameRunTimeSourceWX  					= "DPCMC_RunTimeSourceWX";
const tChar* strDpElementNameRunTimeSourceWX  			= "RunTimeSourceWX";
const tChar* strDpNameRunTimeSourceSXM  				= "DPCMC_RunTimeSourceSXM";
const tChar* strDpElementNameRunTimeSourceSXM   		= "RunTimeSourceSXM";
const tChar* strDpNameRunTimeSourceRouteGuidance 		= "DPCMC_RunTimeSourceRouteGuidance";
const tChar* strDpElementNameRunTimeSourceRouteGuidance	= "RunTimeSourceRouteGuidance";
const tChar* strDpNameRunTimeSourcePassengerMapOut		= "DPCMC_RunTimeSourcePassengerMapOut";
const tChar* strDpElementNameRunTimeSourcePassengerMapOut 	= "RunTimeSourcePassengerMapOut";
const tChar* strDpNameRunTimeSourceSpeechContCounter		= "DPCMC_RunTimeSourceSpeechContCounter";
const tChar* strDpElementNameRunTimeSourceSpeechContCounter 	= "RunTimeSourceSpeechContCounter";


//-----------------------------------------------------------------------------

//lint -e785 gib2hi: the array of supported sessions only provides initializers for the supported session. other fields are automatically initialized with 0

static dia_EngineServerConfiguration::ServiceInfo serviceInfoRep[] = {
   { DIA_C_U8_UDS_SID_SESSION_CONTROL,          DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {0x01, 0x02, 0x03, 0x60, 0x61, 0x40}},    // Session Control
   { DIA_C_U8_UDS_SID_CLEAR_DIAG_INFO,          DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x00, {0x01,       0x03, 0x60, 0x40} },    // Clear Error Memory
   { DIA_C_U8_UDS_SID_READ_DTC_INFO,            DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {0x01, 0x02, 0x03, 0x60, 0x40      } },    // Read DTC Info

   { DIA_C_U8_UDS_SID_ECU_RESET,                DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {0x01,0x02, 0x03, 0x60, 0x40} },    // ECU Reset

   { DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,  DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x02, {0x01, 0x02, 0x03, 0x60, 0x61, 0x40} },    // Read Data by ID
   { 0x23,                                      DIA_C_U8_UDS_SERVICE_SUPPORTED_SELECTIVELY, 0x01, {                  0x60, 0x61} },    // Read Data by Memory Address
   { DIA_C_U8_UDS_SID_SECURITY_ACCESS,          DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {0x01, 0x02, 0x03, 0x60, 0x61, 0x40} },    // Security Access

   { DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER, DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x02, {0x01, 0x02, 0x03, 0x60, 0x61, 0x40} },    // Write Data by ID
   { DIA_C_U8_UDS_SID_IOCONTROL_BY_IDENTIFIER,  DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x02, {            0x03, 0x60, 0x61} },    // IO Control
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL,          DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {0x01, 0x02, 0x03, 0x60, 0x61, 0x40} },    // Routine Control
   { DIA_C_U8_UDS_SID_COMMUNICATION_CONTROL,          DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {0x40} },    // Communication Control

   { 0x34,  DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x00, {    0x02,  0x03,   0x60      } },    // Request Download
   { 0x35,  DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x00, {           0x03,   0x60      } },    // Request Upload
   { 0x36,  DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x00, {    0x02,  0x03,   0x60      } },    // Transfer Data
   { 0x37,  DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x00, {    0x02,  0x03,   0x60      } },    // Request Transfer Exit

   { 0x38,  DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x00, {            0x60      } },    // Request File Transfer

   { 0x3D, DIA_C_U8_UDS_SERVICE_SUPPORTED_SELECTIVELY,  0x01, {            0x60, 0x61} },     // write data by Memory Address

   { DIA_C_U8_UDS_SID_CONTROL_DTC_SETTING,      DIA_C_U8_UDS_SERVICE_SUPPORTED,              0x01, {       0x03, 0x60, 0x40      } },    // Control DTC Settings

   { 0xFD, DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x02, {0x01, 0x03, 0x60, 0x61} },     // internal diagnosis requests
   { 0x99, DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {0x01, 0x03} }     // Diagnostic request for Monitoring & Calibration (MC)
};

//lint +e785

//-----------------------------------------------------------------------------

//lint -e785 gib2hi: the array of supported sessions only provides initializers for the supported session. other fields are automatically initialized with 0

static dia_EngineServerConfiguration::ServiceDataItem serviceDataInfoRep[] = {
   // session control
   { 0x10, DIA_C_U8_UDS_SESSION_DEFAULT,           0x01, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03, 0x60,      0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   { 0x10, DIA_C_U8_UDS_SESSION_PROGRAMMING,       0x01, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02                       }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x10, DIA_C_U8_UDS_SESSION_EXTENDED,          0x01, DIA_C_U8_RUNLEVEL_1, {0x01,      0x03, 0x60, 0x61, 0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   { 0x10, DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION,   0x01, DIA_C_U8_RUNLEVEL_1, {0x01,      0x03, 0x60, 0x61      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   { 0x10, DIA_C_U8_UDS_SESSION_RBCM_ADR,          0x01, DIA_C_U8_RUNLEVEL_1, {                 0x60, 0x61      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   { 0x10, DIA_C_U8_UDS_SESSION_SUBSYSTEM,         0x01, DIA_C_U8_RUNLEVEL_1, {0x01,      0x03,             0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },

   // ECU reset
   { 0x11, DIA_C_U8_UDS_RESET_HARD,                                  0x01, DIA_C_U8_RUNLEVEL_1, {0x01,0x02, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x11, DIA_C_U8_UDS_RESET_HARD,                                  0x01, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x11, DIA_C_U8_UDS_RESET_KEYONOFF,                              0x01, DIA_C_U8_RUNLEVEL_1, {0x02, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x11, DIA_C_U8_UDS_RESET_KEYONOFF,                              0x01, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x11, DIA_C_U8_UDS_SHUTDOWN_FAST,                               0x01, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, //Called in Bosch Production after ALD is locked
   //RTC-5990073 Cleanup Activity { 0x11, DIA_C_U8_SUBFUNC_AIVI_RESET_CONFIG_TO_DELIVERY_STATE,     0x01, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   // clear error memory
   { 0x14, 0x0000,                                                   0x00, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03,           }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x14, 0x0000,                                                   0x00, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },

   // read DTC
   { 0x19, UDS_REPORT_DTC_BY_STATUS_MASK,                            0x01, DIA_C_U8_RUNLEVEL_2, {0x01,  0x03           }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x19, UDS_REPORT_DTC_BY_STATUS_MASK,                            0x01, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x19, UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER,         0x01, DIA_C_U8_RUNLEVEL_2, {0x01,  0x03           }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x19, UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER,         0x01, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //RTC-5990073 Cleanup Activity{ 0x19, UDS_REPORT_DTC_SNAPSHOT_RECORD_BY_DTC_NUMBER,             0x01, DIA_C_U8_RUNLEVEL_2, {0x01,  0x03           }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x19, UDS_REPORT_DTC_SNAPSHOT_RECORD_BY_DTC_NUMBER,             0x01, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x19, UDS_REPORT_NUMBER_OF_DTC_BY_STATUS_MASK,                  0x01, DIA_C_U8_RUNLEVEL_2, { 0x01,  0x03          }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x19, UDS_REPORT_NUMBER_OF_DTC_BY_STATUS_MASK,                  0x01, DIA_C_U8_RUNLEVEL_2, { 0x60                 }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x19, UDS_REPORT_READ_SUPPORTED_DTCS,                           0x01, DIA_C_U8_RUNLEVEL_2, { 0x01,  0x03          }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x19, UDS_REPORT_READ_SUPPORTED_DTCS,                           0x01, DIA_C_U8_RUNLEVEL_2, { 0x60                 }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   // read data by identifier
   { 0x22, DIA_C_U16_DID_ACTIVE_ALD_LEVEL,                   0x02, DIA_C_U8_RUNLEVEL_1, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - GetActiveALDlevel

   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_RVC_CONTROL_LINE_CURRENT,           0x02, DIA_C_U8_RUNLEVEL_2, {0x81, 0xC0, 0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_RVC_ControlLineCurrent
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_RVC_CONTROL_LINE_STATUS,            0x02, DIA_C_U8_RUNLEVEL_2, {0x81, 0xC0, 0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_RVC_ControlLineStatus
   { 0x22, DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_ACC,                 0x02, DIA_C_U8_RUNLEVEL_1, {               0x60               }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ACC
   { 0x22, DIA_C_U16_DID_RBCM_GPIO_REVERSEGEAR,                   0x02, DIA_C_U8_RUNLEVEL_1, {             0x60                 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Reverse Gear
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_GPIO_ILLUMINATION_SWITCH,           0x02, DIA_C_U8_RUNLEVEL_1, {     0x60                         }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ReadILLUM
   { 0x22, DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_IGNTION,             0x02, DIA_C_U8_RUNLEVEL_1, {     0x60                         }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Ignition
   { 0x22, DIA_C_U16_DID_RBCM_SYSTEM_OPERATION_TIME,              0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_SrvHandler_GetSystemResetInformation
   { 0x22, DIA_C_U16_DID_RBCM_SYSTEM_RESET_INFORMATION,           0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_SrvHandler_GetSystemResetInformation

   //RTC-5990073 Cleanup Activity{ 0x22, 0x1009,                                                0x02, DIA_C_U8_RUNLEVEL_2, {0x03                              }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // Bluetooth Address High Speed

   //RTC-5990073 Cleanup Activity{ 0x22, 0x1009,                                                0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // Bluetooth Address High Speed

   //RTC-5990073 Cleanup Activity{ 0x22, 0x100A,                                                0x02, DIA_C_U8_RUNLEVEL_2, {0x03                              }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // Bluetooth Address Low Speed

   //RTC-5990073 Cleanup Activity{ 0x22, 0x100A,                                                0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // Bluetooth Address Low Speed
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_WIRE_DIMMING_INFORMATION,           0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_WireDimmingInfo_Get
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_LOADER_STATUS,        0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - OpticalDrive_LoadStatus
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_PARKING_BRAKE,       0x02, DIA_C_U8_RUNLEVEL_1, {             0x60                 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - PKB
   { 0x22, DIA_C_U16_DID_RBCM_AUDIO_SOURCE_ACTIVE,                0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_CUSTOMER_ECU_PART_NUMBER,           0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // ReadDataByIdentifier - CustomerECUPartNumber
   { 0x22, DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE,               0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, //LCM_PowerSupplyVoltage
   { 0x22, DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE_STATE,         0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, //LCM_PowerSupplyVoltageState
   { 0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_STATE,                  0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_SrvHandler_HistoryState
   { 0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_RESET,                  0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_SrvHandler_HistoryReset
   { 0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_WAKEUP,                 0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_SrvHandler_HistoryWakeup
   { 0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_01,         0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },               // LCM_ErrorStateHistory_1
   { 0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_02,         0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },               // LCM_ErrorStateHistory_2
   { 0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_03,         0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },               // LCM_ErrorStateHistory_3
   { 0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_04,         0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },               // LCM_ErrorStateHistory_4
   { 0x22, DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_05,         0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },               // LCM_ErrorStateHistory_5
   { 0x22, DIA_C_U16_DID_RBCM_SYSTEM_HMI_ON,                      0x02, DIA_C_U8_RUNLEVEL_2, {             0x60                  }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //RTC-5990073 Cleanup Activity{ 0x22, 0x3200,                                                0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Immobilizer
   { 0x22, DIA_C_U16_DID_ADR3_ANALOG_TUNERINFO_DEMODULATOR_1,     0x02, DIA_C_U8_RUNLEVEL_2, {                              0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3_AnalogTunerInformation_Demodulator_1 Read
   { 0x22, DIA_C_U16_DID_ADR3_ANALOG_TUNERINFO_DEMODULATOR_2,     0x02, DIA_C_U8_RUNLEVEL_2, {                              0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3_AnalogTunerInformation_Demodulator_2 Read
   { 0x22, DIA_C_U16_DID_ADR3_BOOT_MODE,                          0x02, DIA_C_U8_RUNLEVEL_2, {                              0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3_BootMode Read
   { 0x22, DIA_C_U16_DID_ADR3_BACKEND_AGC_LEVEL,                  0x02, DIA_C_U8_RUNLEVEL_2, {                              0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3_BackendAGCLevel Read
   //RTC-5990073 Cleanup Activity{ 0x22, 0x6102, 0x02, DIA_C_U8_RUNLEVEL_2, {                   0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - TunerAMFM_Band
   //RTC-5990073 Cleanup Activity{ 0x22, 0x6103, 0x02, DIA_C_U8_RUNLEVEL_2, {                   0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - AMFMTuner_Fieldstrength
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_AMFM_1_POWER_SUPPLY, 0x02, DIA_C_U8_RUNLEVEL_2, {                   0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_TunerAMFM_FMRDSProgramInformation
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_EMMC_TEMPERATURE_THRESHOLDS,        0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - eMMC_TemperatureThresholds
   { 0x22, DIA_C_U16_DID_RBCM_GNSS_RECEIVER_STATUS,               0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_GNSSReceiverStatus_Get GNSS     : rva5cob
   { 0x22, DIA_C_U16_DID_GNSS_SATELLITE_SIG_QUALITY,              0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_GNSSRBestSattelites_Get GNSS
   { 0x22, DIA_C_U16_DID_RBCM_THERMAL_MGNT_TEMPERATURE_THRESHOLDS, 0x02, DIA_C_U8_RUNLEVEL_2,{            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ThermalManagmentTemperatureThresholds
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_AMFM_SELECT_ACTIVE_TUNER,     0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SelectActiveTuner
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_AMFM_FREQUENCY,               0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - AMFMTuner_Frequency
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_WIRE_SPEED_INFORMATION,             0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_WireSpeedInformation_Get
   { 0x22, DIA_C_U16_DID_SCC_APP_SW_VERSION ,                     0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SCC App SoftwareVersion
   { 0x22, DIA_C_U16_DID_SCC_BL_SW_VERSION ,                      0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SCC_BootloaderSoftwareVersion
   { 0x22, DIA_C_U16_DID_SCC_BM_SW_VERSION ,                      0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SCC_BootManagerSoftwareVersion
   { 0x22, DIA_C_U16_DID_RBCM_BT_MAC_ADDRESS,                     0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03,           }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - BTMACAddress  // dia_SrvHandler_BTMACAddress_Get
   { 0x22, DIA_C_U16_DID_RBCM_BT_MAC_ADDRESS,                     0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - BTMACAddress  // dia_SrvHandler_BTMACAddress_Get
   { 0x22, DIA_C_U16_DID_RBCM_BLUETOOTH_LINK_QUALITY,             0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_ReadBluetoothLinkQuality
   { 0x22, DIA_C_U16_DID_RBCM_DISPLAY_BACKLIGHT_ILLUMINATION,     0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_Disp_BrightnessInfo_Get
   { 0x22, DIA_C_U16_DID_GNSS_SATELLITE_SIG_QUALITY,              0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_GNSSSatellitesSignalQuality_Get GNSS
   { 0x22, DIA_C_U16_DID_SCC_APP_SW_VERSION_LABEL ,               0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SCC App SoftwareVersion Label
   { 0x22, DIA_C_U16_DID_SCC_BL_SW_VERSION_LABEL ,                0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SCC_BootloaderSoftwareVersion Label
   { 0x22, DIA_C_U16_DID_SCC_BM_SW_VERSION_LABEL ,                0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SCC_BootManagerSoftwareVersion Label
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_BLUETOOTH_LINK_QUALITY,             0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_ReadBluetoothLinkQuality
   //{ 0x22, DIA_C_U16_DID_RBCM_DISPLAY_BACKLIGHT_ILLUMINATION,     0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_Disp_BrightnessInfo_Get
   { 0x22, DIA_C_U16_DID_RBCM_DISPLAY_TEMPERATURE,                0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_SrvHandler_Disp_PanelTempInfo_Get
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_CM_UNIQUE_CONFIG_ID, 0x02, DIA_C_U8_RUNLEVEL_1, {0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - EucUniqueConfigId
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_WORM_ID,                                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - WORM-ID
   { 0x22, DIA_C_U16_DID_RBCM_INPUT_HDL_ENCODER_1_COUNTER_VALUE,     0x02, DIA_C_U8_RUNLEVEL_2, {         0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Encoder1SelectCounterValue_Get
   { 0x22, DIA_C_U16_DID_RBCM_INPUT_HDL_ENCODER_2_COUNTER_VALUE,     0x02, DIA_C_U8_RUNLEVEL_2, {         0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Encoder2VolumeCounterValue_Get
   { 0x22, DIA_C_U16_DID_RBCM_INPUT_HDL_TOUCH_PANEL_STATUS,          0x02, DIA_C_U8_RUNLEVEL_2, {         0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, //
   { 0x22, DIA_C_U16_DID_RBCM_INPUT_HDL_KEY_PRESSED,              0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_V850_TEMPERATURE,                   0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_DVD_DRIVER_TEMPERATURE,             0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_PANEL_TEMPERATURE,                  0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_TEMPERATURE,          0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_EMMC_TEMPERATURE,                   0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_HEATSINK_TEMPERATURE,               0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_AMPLIFIER_TEMPERATURE,              0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_GYRO_TEMPERATURE,                   0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_IMX_TEMPERATURE,                    0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_XMMODULE_TEMPERATURE,               0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_TVMODULE_TEMPERATURE,               0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_TVMODULESLAVE_TEMPERATURE,          0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_PANEL2_TEMPERATURE,                 0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_WIFI_MAC_ADDRESS,                   0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - BTMACAddress  // dia_SrvHandler_BTMACAddress_Get
   { 0x22, DIA_C_U16_DID_RBCM_WIFI_MAC_ADDRESS,                   0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - BTMACAddress  // dia_SrvHandler_BTMACAddress_Get
   { 0x22, DIA_C_U16_DID_RBCM_DISPLAY_TEMPERATURE,                0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_ADR3_VERSION_HW,                         0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3 HW version
   { 0x22, DIA_C_U16_DID_ADR3_VERSION_SW,                         0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3 SW version
   { 0x22, DIA_C_U16_DID_ADR3_FRONTEND_CONFIGURATION_ID,          0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3_FrontendConfigurationID Read
   { 0x22, DIA_C_U16_DID_ADR3_VERSION_HDSPL,                      0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3 HDSPL version
   { 0x22, DIA_C_U16_DID_ADR3_VERSION_HDSW,                       0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3 HDSW version
   { 0x22, DIA_C_U16_DID_ADR3_FLASH_CHIP_ID,                      0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3_FlashChipID Read
   { 0x22, DIA_C_U16_DID_ADR3_AMPLIFIER_CONFIGURATION,            0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ADR3_AmplifierConfiguration Read
   { 0x22, DIA_C_U16_DID_RBCM_SYSTEM_OPERATION_TIME,              0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - systemOperationTime   ( -> 1. with CCA Communication)
   { 0x22, DIA_C_U16_DID_SENSOR_GNSS_POS_SYSTEM,                  0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_SXM_TUNER_CHANNEL,                  0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_SXM_TUNER_UPC,                      0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_SXM_TUNER_BER,                      0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_SXM_TUNER_SIGNAL_QUALITY,           0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_SXM_TUNER_ANTENNA_STATUS,           0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_CUSTOMER_SWUP_VARIANT_INFO,         0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SWUPD_VariantInfo
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_SD_CARD_1_MEDIA_INFO,                 0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_SDCard1MediaInfo
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_SD_CARD_1_SLOT_STATE,                 0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_SDCard1SlotState
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_VIN_WMI_AND_VDS,                         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60,     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VIN_WmiAndVdsOnly

   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_DAB_ENSEMBLE_FREQUENCY,         0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_TunerDAB_Antenna1EnsembleFrequency
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_DAB_SERVICE_ID,                 0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_TunerDAB_Antenna1ServiceID
   #endif
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_RADIO_STATE,                          0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03                     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - dia_Srvhandler_RadioState_Get
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_GPIO_ILLUMINATION_SWITCH,             0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC}  }, // ReadDataByIdentifier - ReadILLUM
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_1_STATUS,            0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_TunerAMFM_Antenna1Status
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_1_CURRENT,           0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_TunerAMFM_Antenna1Current
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_2_STATUS,            0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_TunerAMFM_Antenna2Status
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_2_CURRENT,           0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_TunerAMFM_Antenna2Current
   { 0x22, DIA_C_U16_DID_RBCM_USB_DEVICES_INFO,                     0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_1,         0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_SrvHandler_USB_PowerSupplyInfoPort
   { 0x22, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_2,         0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_SrvHandler_USB_PowerSupplyInfoPort
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_3,         0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_SrvHandler_USB_PowerSupplyInfoPort
   { 0x22, DIA_C_U16_DID_RBCM_GNSS_ANTENNA_STATUS,                  0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_GNSSAntennaStatus_Get GNSS
   { 0x22, DIA_C_U16_DID_RBCM_GNSS_ANTENNA_CURRENT,                 0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_GNSSAntennaCurrent_Get GNSS
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_DAB_ANTENNA_STATUS,             0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_TunerDAB_Antenna1Status
   { 0x22, DIA_C_U16_DID_RBCM_TUNER_DAB_ANTENNA_CURRENT,            0x02, DIA_C_U8_RUNLEVEL_2, {                     0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_TunerDAB_Antenna1Current
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_MULTIPLEX_NETWORK_DIAG,               0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Multiplex network diagnostic
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_MULTIMEDIA_NETWORK_DIAG,              0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Multiplex network diagnostic
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_BATTERY_LEVEL,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Read Battery Voltage
   //{ 0x22, DIA_C_U16_DID_AIVI_INPUT_LINES,                          0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_InputLines
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_KEY_PRESS_BUTTONS,                    0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_KeyPressButtons
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_KEY_PRESS_ROTARY,                     0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_KeyPressRotary
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_KEY_PRESS_SWS,                        0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_KeyPressSws
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_KEY_PRESS_CD_DRIVE_EJECT,             0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_KeyPressCDEject
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_TOUCH_PRESS,                          0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_TouchPress
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_WIFI_MONITORING,                      0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - dia_SrvHandler_WifiMonitoring
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_OUTPUT_LINE,                          0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Read OutputLine
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_SPEED_INFO,                           0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_SpeedInformation
   { 0x22, DIA_C_U16_DID_AIVI_VARIANT_CODING,                       0x02, DIA_C_U8_RUNLEVEL_2, {           0x60       }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadAIVIVariantCoding
   { 0x22, DIA_C_U16_DID_CM_ADC_REF_PLUS_ACTUAL_VOLTAGE,            0x02, DIA_C_U8_RUNLEVEL_1, {           0x60       }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadADCRefPlusActualVoltage
   { 0x22, DIA_C_U16_DID_RBCM_GNSS_REC_FIRMWARE_VERSION,            0x02, DIA_C_U8_RUNLEVEL_2, {           0x60       }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_GNSSReceiverFirmwareVersion_Get
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_TOTAL_NUMBER_OF_REPROGRAMMING,        0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Total Number of Reprogramming
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_INITIAL_PROGRAMMING_LOG,              0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Initial Programming Log
   { 0x22, DIA_C_U16_DID_RBCM_ADC_AMP_CLIP_VOLTAGE,                 0x02, DIA_C_U8_RUNLEVEL_2, {           0x60       }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Initial Programming Log
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_FIRST_USB_PROGRAMMING,                0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - First USB Programming
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_CURRENT_N,            0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Current / N)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_1,         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Historic / N-1)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_2,         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Historic / N-2)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_3,         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Historic / N-3)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_4,         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Historic / N-4)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_5,         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Historic / N-5)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_6,         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Historic / N-6)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_7,         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Historic / N-7)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_8,         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Historic / N-8)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_9,         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Programming Log (Historic / N-9)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_OCCURENCE_COUNTER,                    0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Occurence Counter
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_ECU_TEMP,                             0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - ECUTemperatureRead
   
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DTV_SUBMODULE_HW_VERSION,             0x02, DIA_C_U8_RUNLEVEL_2, {           0x60       }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - DTVSubModuleHWVersion
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DTV_SUBMODULE_SW_VERSION,             0x02, DIA_C_U8_RUNLEVEL_2, {           0x60       }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - DTVSubModuleSWVersion
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DTV_SUBMODULE_BOOT_VERSION,           0x02, DIA_C_U8_RUNLEVEL_2, {           0x60       }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - DTVSubModuleBootVersion
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_FPGA_MODULE_SW_VERSION,               0x02, DIA_C_U8_RUNLEVEL_2, {           0x60       }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - FPGAModuleSWVersion
   
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_EMMC_REFRESH_STATUS,                  0x02, DIA_C_U8_RUNLEVEL_2, {0x01,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_EMMC_WRITTEN_BYTES_COUNT,             0x02, DIA_C_U8_RUNLEVEL_2, {0x01,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   { 0x22, DIA_C_U16_DID_RBCM_ECU_SW_BUILD_VERSION_LABEL, 		     0x02, DIA_C_U8_RUNLEVEL_2, {0x81, 0xC0, 0xF0,       0x60      },                   {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ECUSWBuildVersionLabel\r

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x22 (read data by identifier - Implement service for Production related Identification and configuration data)
   //
   ////////////////////////////////////////////////////////////////////////////
   //RTC-5990073 Cleanup Activity#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   { 0x22, DIA_C_U16_DID_AIVI_AUXIN_DETECT,                                   0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_AuxIn_Get
   //RTC-5990073 Cleanup Activity#endif
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_UNUSED_EXT_IN_WIRE_SPEED_INFO,                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_SrvHandler_WireSpeedInformationGPIO
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_DRM_TUNER_PARAMETER_SET,                        0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_ANTENNA_PARAMETER_SET,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadAntennaParamSet
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_ANTENNA_2_PARAMETER_SET ,                       0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadAntenna2ParamSet
   { 0x22, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_ONE,                        0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_ReadInputKeyMappingTable_1
   { 0x22, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_TWO,                        0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_ReadInputKeyMappingTable_2
   { 0x22, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_THREE,                      0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_ReadInputKeyMappingTable_3
   { 0x22, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_FOUR,                       0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_ReadInputKeyMappingTable_4
   { 0x22, DIA_C_U16_DID_RBCM_BT_NAME,                                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadBTName
   { 0x22, DIA_C_U16_DID_RBCM_DIMMING_PARAMETER_SET,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadDimmingParamet1
   { 0x22, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_ALIGNMENT,                     0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadKeyIlluminationAlignmentCoeff
   { 0x22, DIA_C_U16_DID_AIVI_KEY_ILLUMINATION_ALIGNMENT_2,                   0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadKeyIlluminationAlignmentCoeff2
   { 0x22, DIA_C_U16_DID_AIVI_DISP_ILLUMINATION_ALIGNMENT,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadDispIlluminationAlignmentCoeff
   { 0x22, DIA_C_U16_DID_RBCM_EARLY_CONFIG_DISPLAY,                           0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // EarlyConfig_Display
   { 0x22, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TWO_DISPLAY,                       0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // EarlyConfig_TwoDisplay
   { 0x22, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER,                      0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // EarlyConfig_TouchDriver
   { 0x22, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER_2,                    0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // EarlyConfig_TouchDriver2
   { 0x22, DIA_C_U16_DID_RBCM_GENERIC_TUNER_PARAMETER_SET,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadGenTunerParamSet
   { 0x22, DIA_C_U16_DID_RBCM_FM_AM_TUNER_PARAMETER_SET,                      0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadFmAmTunerParamSet
   { 0x22, DIA_C_U16_DID_RBCM_DAB_TUNER_PARAMETER_SET,                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - DAB Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_MICROPHONE_CONNECTION_INFO_1,                   0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier -
   { 0x22, DIA_C_U16_DID_RBCM_MIC_PS_INFO_1,                                  0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - MicrophoneCurrent1
   { 0x22, DIA_C_U16_DID_NAV_DATA_COPY_PROTECTION_SEC_ECC_KEY,                0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Navi data security key (ECC)
   { 0x22, DIA_C_U16_DID_CM_VARIANT_CODING,                                   0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - CM Variant Coding
   { 0x22, DIA_C_U16_DID_NAV_DEFAULT_POSITION,                                0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Navigation default position
   { 0x22, DIA_C_U16_DID_SENSOR_CONFIGURATION_GNSS,                           0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SensorConfigurationGNSS
   { 0x22, DIA_C_U16_DID_SENSOR_CONFIGURATION_GYRO,                           0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SensorConfigurationGyro
   { 0x22, DIA_C_U16_DID_SENSOR_CONFIGURATION_ACC,                            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SensorConfigurationAcc
   { 0x22, DIA_C_U16_DID_CM_CONFIGURATION_INFO,                               0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - CMConfigurationInformation
   { 0x22, DIA_C_U16_DID_RBCM_HD_PARAMETER_SET,                               0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - HDParameterSet
   { 0x22, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION,                               0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_SrvHandler_KeyB_BrightnessInfo_Get.cpp
   { 0x22, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_PWM,                           0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_SrvHandler_KeyB_PwmInfo_Get.cpp
   //   { 0x22, DIA_C_U16_DID_RBCM_DATASET_BLOCK_SIZE,                             0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // upDownloadBlocksize
   { 0x22, DIA_C_U16_DID_RBCM_WIFI_NAME_1,                                    0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadWiFiName_1
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_WIFI_NAME_2,                                    0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadWiFiName_2
   { 0x22, DIA_C_U16_DID_AIVI_NAVI_UNIT,                                      0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - dia_SrvHandler_ReadNaviUnit
   { 0x22, DIA_C_U16_DID_ADR3_ACTUAL_CALIBRATION_DATA,                        0x02, DIA_C_U8_RUNLEVEL_2, {                  0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_ActualAlignmentValues
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_AUDIO_SOURCE_OFFSET_IN,                         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - AudioSourceOffsetIn
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_CAMERA_SYSTEM,                                  0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Camera System
   { 0x22, DIA_C_U16_DID_AIVI_CM_ECU_SOFTWARE_NUMBER,                         0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SystemSupplierECUsoftwareNumber
   { 0x22, DIA_C_U16_DID_AIVI_CM_ECU_SOFTWARE_VERSION_NUMBER,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SystemSupplierECUsoftwareVersionNumber
   { 0x22, DIA_C_U16_DID_AIVI_SYSTEM_VEHICLE_INFO,                            0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Vehicle Information
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_ECO_ROUTE,                                      0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - ECO Route
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_BT_NAME,                                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - BT Name
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_CONFIG_HASH_VALUE,                              0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Configuration Hash Value
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_CALIBRATION_XTRA_DATA_REF,                      0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - ECU Part Number and Calibration Extra Data
   { 0x22, DIA_C_U16_DID_AIVI_CONFIG_PARTS_NUMBER,                            0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Configuration Part Number
   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   { 0x22, DIA_C_U16_DID_AIVI_CONFIG_FILE_REFERENCE_LINK_RUC,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - ConfigurationFileReferenceLink_RUC
   #endif
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_CONFIG_SYSTEM_SUPPLIER_NR,                      0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - SystemSupplierNumber
   { 0x22, DIA_C_U16_DID_AIVI_ECU_SERIAL_NUMBER_IDENTIFIER,                   0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - ECUSerialNumberDataIdentifier
   #if !defined(VARIANT_S_FTR_ENABLE_RNAIVI) && !defined(VARIANT_S_FTR_ENABLE_RIVIE) //only Scope1
   { 0x22, DIA_C_U16_DID_AIVI_HWSW_VERSION,                                   0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - HWSWVersion
   #endif
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GYRO,                             0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SensorConfigurationGyro
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GNSS,                             0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SensorConfigurationGNSS
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_ACC,                              0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SensorConfigurationACC
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET,                           0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - FM/AM Tuner Parameter
   { 0x22, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_01,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - FM/AM Tuner Parameter Set (1/2)
   { 0x22, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_02,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - FM/AM Tuner Parameter Set (2/2)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_ANTENNA_PARAM_SET,                              0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Antenna Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DAB_SET,                                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - DAB Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Generic Tuner Parameter Set
   { 0x22, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_01,                     0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Generic Tuner Parameter Set (1/2)
   { 0x22, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_02,                     0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Generic Tuner Parameter Set (2/2)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_HD_PARAM_SET,                                   0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - HDParameterSet
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_WIFI_NAME,                                      0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Wifi Name
   #ifndef VARIANT_S_FTR_ENABLE_RNAIVI
   { 0x22, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET,                                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Audio parameter set
   { 0x22, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_01,                             0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Audio parameter set (1/2)
   { 0x22, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_02,                             0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Audio parameter set (2/2)
   #endif
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_ANTITHEF_MAP_SELECTION,                         0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Antitheft Map Selection
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_MEX_CONFIG,                                     0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - MEX Config
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_FACTORY_MODE,                                   0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Factory Mode
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_CONNECTIVITY_CONFIG,                            0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Connectivity Config
   { 0x22, DIA_C_U16_DID_AIVI_HMI_CONFIG,                                     0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - HMI Config
   { 0x22, DIA_C_U16_DID_AIVI_SOUND_VOLUME_CONFIG,                            0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Sound Volume Config
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DRM_TUNER_PARAMETER_SET,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - DRM Tuner Parameter Set

   /* ==================================================================================== */
   /* === ALL Services to read supported DIDs with dia_SrvHandler_SupportedIdentifiers === */
   /* ==================================================================================== */
   /* === START Supported DID: ReadDataByIdentifier === */
   /* ================================================= */
   /* ================================================= */
   /* ===  END Supported DID: ReadDataByIdentifier  === */
   /* ================================================= */

   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_SYSTEM_INFO_COMMON,                             0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - System Information Common
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_ECU_HW_NR,                     0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - VehicleManufacturerECUHardwareNumber
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_R_NR,               0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - VehicleManufacturerECUHardwareNumber Renault
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_N_NR,               0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - VehicleManufacturerECUHardwareNumber Nissan
   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI  //In scope2.0 and Scope 2.1, $F013 is DIA_C_U16_DID_AIVI_ALLIANCE_SW_REF
   { 0x22, DIA_C_U16_DID_AIVI_ALLIANCE_SW_REF,                                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Alliance SW Reference
   #else // Scope1: $F013 is DIA_C_U16_DID_AIVI_SECONDARY_OPERATIONAL_REFERENCE
   { 0x22, DIA_C_U16_DID_AIVI_SECONDARY_OPERATIONAL_REFERENCE,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SecondaryOperationnalReference
   #endif
   { 0x22, DIA_C_U16_DID_AIVI_VDIAG,                                          0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VDIAG
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_MILEAGE_VALUE,                                  0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - MileageValue
   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   { 0x22, DIA_C_U16_DID_AIVI_HW_REF_A,                                   0x02, DIA_C_U8_RUNLEVEL_1, {          0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - HW_RefA DID: 3051
   #endif

   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_CD_INSERT_COUNT,                                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },//ReadDataByIdentifier-No. of CD inserted
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_BT_CONNECTED_DEVICE,                            0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - BT devices
   { 0x22, DIA_C_U16_DID_AIVI_DEF_SYSTEM_INFO_COMMON,                        0x02,   DIA_C_U8_RUNLEVEL_1, {           0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default System Information Common

   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_BT_SIGNAL_QUALITY,                              0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - BTSignalQuality

   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_ANTENNA1_PARAMETER_AM_FM1/*0x3001*/,            0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Parameters for Antenna 1 (AM/FM1)

   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_SYSTEM_VEHICLE_INFO  /*0x3001*/,            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Vehicle Information
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_ANTENNA2_PARAMETER_FM2   /*0x3002*/,            0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Parameters for Antenna 2 (FM2)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_ANTENNA3_PARAMETER_DAB   /*0x3003*/,            0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Parameters for Antenna 3 (DR)
   { 0x22, DIA_C_U16_DID_AIVI_DEF_CAMERA_SYSTEM        /*0x3003*/,            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Camera System
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_CONFIG_PARTS_NUMBER,                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Configuration Part Number
   //RTC-5990073 Cleanup Activity	{ 0x22, DIA_C_U16_DID_AIVI_DEF_ACOUSTIC_PARAM,                             0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Acoustic Parameter
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_WBS,                             0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Phone ECNR WBS
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_NBS,                             0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Phone ECNR NBS
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_ECO_ROUTE,                                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default ECO Route
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_BT_NAME,                                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default BT Name
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_ANTITHEF_MAP_SELECTION,                     0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Antiteff Map Selection
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_CONFIG_HASH_VALUE,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Configuration Hash Value
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_AUDIO_PARAM_SET,                            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Audio Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GNSS,                         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Sensor Configuration GNSS
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GYRO,                         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Sensor Configuration GYRO
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_ACC,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Sensor Configuration ACC
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_FMAM_TUNER_PARAM_SET,                       0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default FMAM Tuner Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_GENERIC_TUNER_PARAM_SET,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Generic Tuner Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_ANTENNA_PARAM_SET,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Antenna Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_DAB_SET,                                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default DAB Set
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_HD_PARAM_SET,                               0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default HD Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_WIFI_NAME,                                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Wifi Name
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_MEX_CONFIG,                                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default MEX Config
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_FACTORY_MODE,                               0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default Factory Mode
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_CONNECTIVITY_CONFIG,                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Connectivity Config
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_HMI_CONFIG,                                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - HMI Config
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_SOUND_VOLUME_CONFIG,                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Sound Volume Config
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_DEF_DRM_TUNER_PARAMETER_SET,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Default DRM Tuner Parameter Set

   { 0x22, DIA_C_U16_DID_RBCM_ECU_HW_VERSION,                                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ReadECUHWVersion
   { 0x22, DIA_C_U16_DID_RBCM_ECU_SW_VERSION,                                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ReadECUSWVersion
   { 0x22, DIA_C_U16_DID_RBCM_ECU_SPARE_PART_NUMBER,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ECUSparePartNumber
   //      { 0x22, DIA_C_U16_DID_CM_EXTENDED_VARIANT_CODING,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },// ReadDataByIdentifier - CM Extended Variant Coding
   { 0x22, DIA_C_U16_DID_RBCM_ECU_SERIAL_NUMBER,                              0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ECUSerialNumber
   { 0x22, DIA_C_U16_DID_RBCM_PCB_SPARE_PART_NUMBER,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - mainboardSparePartNumber
   { 0x22, DIA_C_U16_DID_RBCM_PCB_SERIAL_NUMBER,                              0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - mainboardSerialNumber
   { 0x22, DIA_C_U16_DID_RBCM_ECU_SW_BUILD_VERSION_LABEL,                     0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - ECUSWBuildVersionLabel
   { 0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_SW_VERSION,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - BT SW version
   { 0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_SW_VERSION,                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - BT SW version
   { 0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_HW_VERSION,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - BT HW version
   { 0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_HW_VERSION,                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - BT HW version
   { 0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_HW_LOADER_VERSION,                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - BT HW loader version
   { 0x22, DIA_C_U16_DID_RBCM_NAVI_SW_VERSION,                                0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - navigationSWVersion
   { 0x22, DIA_C_U16_DID_CM_CUSTOMER_SOFTWARE_VERSION,                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - CustomerSWVersion
   { 0x22, DIA_C_U16_DID_SXM_SUBBMODULE_HW_VERSION,                           0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - XMSubModuleHWVersion
   { 0x22, DIA_C_U16_DID_SXM_SUBBMODULE_SW_VERSION,                           0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - XMSubModuleSWVersion
   { 0x22, DIA_C_U16_DID_SXM_RADIO_ID,                                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - XMRadioID
   { 0x22, DIA_C_U16_DID_RBCM_DEVICE_MANAGER,                                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - DeviceManager
   { 0x22, DIA_C_U16_DID_RBCM_MEDIA_PLAYER,                                   0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - MediaPlayer
   { 0x22, DIA_C_U16_DID_RBCM_DISPLAY,                                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Display for SPI
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION_DISPLAY,                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SmartPhoneIntegration Display-areas
   { 0x22, DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION,                         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - configuration of SmartPhone component
   { 0x22, DIA_C_U16_DID_RBCM_DEVICE_PRODUCTION_TIME,                         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - DeviceProductionTime
   { 0x22, DIA_C_U16_DID_RBCM_ECU_UNIQUE_FIELDDATA_ID,                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - EucUniqueFieldDataId
   { 0x22, DIA_C_U16_DID_AIVI_SPEED_LOCKOUT,                                  0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - SpeedLockout
   { 0x22, DIA_C_U16_DID_AIVI_SPEED_LOCKOUT,                                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SpeedLockout
   { 0x22, DIA_C_U16_DID_RADIO_TYPE_APPROVAL_MODE,                            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - RadioTypeApprovalMode
   { 0x22, DIA_C_U16_DID_CM_VARIANT_ID,                                       0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Variant ID
   { 0x22, DIA_C_U16_DID_RBCM_EMMC_JEDEC_CID_REG,                             0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_EMMC_JEDEC_CSD_REG,                             0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x22, DIA_C_U16_DID_RBCM_EMMC_JEDEC_ECSD_DATA,                           0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   //{ 0x22, DIA_C_U16_DID_AIVI_VIN,                                            0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03             }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VIN
   { 0x22, DIA_C_U16_DID_AIVI_FAN_ACTIVATION_COUNTER,                         0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03           }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Fan Activation Counter
   { 0x22, DIA_C_U16_DID_AIVI_FAN_ACTIVATION_DURATION,                        0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03           }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Fan Activation Duration
   #endif

   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_SECURITY_FINGERPRINT,                           0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Fingerprint
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_SECURITY_INDEX_SRV_DATA,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - IndexSrvData
   { 0x22, DIA_C_U16_DID_AIVI_DEGRADED_MODE_COUNTER,                          0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Degraded counter
   { 0x22, DIA_C_U16_DID_AIVI_DEGRADED_MODE_TIME,                             0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Degraded Time
   { 0x22, DIA_C_U16_DID_AIVI_GPS_RECEPTION_LEVEL,                            0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - GPS reception level   for scope2.1
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_ENGINE_STOPPED_TIME,                            0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Engine Stopped Time
   { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_ID_VALUE,                               0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Vehicle Identifier Value


   // RDBI - Digests in Programming Session (possible without SecurityAccess)
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_REFERENCE_CHECKSUM,               0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_NBS,                   0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_WBS,                   0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_VR_PARAM,                         0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_NBS,           0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_WBS,           0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_FACETIME_ECNR_SWB,        0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ACOUSTIC_PARAM,                   0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ESE_PARAM,                        0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_NBS,                0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_WBS,                0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_SIRI_ECNR_WBS,                 0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_SIRI_ECNR_WBS,            0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ANDROID_AUTO_VR_ECNR_WBS,         0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ 0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ECNR_VPA_VOICE_WB,                0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   //Center CM-C 19
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_READ_OVERALL_CIS_SW_VERSION,                        0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x02, 0x03 	   }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SOFTWARE_SUPPLIER_INFO,                0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Software Supplier Information
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_HARDWARE_SUPPLIER_INFO,                0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Hardware Supplier Information
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_BOOT_SW_VERSION_INFO,                  0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Boot Software Version
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SW_VERSION_INFO,               	     0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Customer Software Version
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_COMPONENTS_SW_VERSION_INFO,               0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } },
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_SW_VERSION_NUMBER, 0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Read System Supplier ECUSWVersionNumber
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_SW_PART_NUMBER,    0x02, DIA_C_U8_RUNLEVEL_2, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - System Supplier ECUSWPartNumber
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_HW_PART_NUMBER,    0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - System Supplier ECUHWPartNumber
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_HW_VERSION_NUMBER, 0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Read System Supplier ECUHWVersionNumber
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_ECU_SERIAL_NUMBER, 					 0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Read ECU Serial Number
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_HARDWARE_VERSION_INFO,				 0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - hardware version information
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION,				 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, { DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - customerECUHWVersion
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_HARDWARE_PART_NUMBER,				     0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - HardwarePartNumber
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER,			 0x02, DIA_C_U8_RUNLEVEL_1,     {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - CustomerSparePartNumber
   #ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER,				             0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Read VIN Odometer
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER_LIMIT,				     0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Read VIN Odometer Limit
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_VIN_ORIGINAL,				             0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Read VIN Original
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_VIN_CURRENT,				             0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Read VIN Current
   #endif
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_ACTIVE_DIAGNOSTIC_INFO,				 0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x02, 0x03, 0x40 }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Read Active Diagnostic Information
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_COMPATIBILITY_LIST,                    0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x03           }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Compatibility List Information
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_CONFIGURATION_FINGERPRINT,			 0x02, DIA_C_U8_RUNLEVEL_1, { 0x01, 0x02, 0x03     }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE } }, // ReadDataByIdentifier - Read Configuration Fingerprint
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_TUNER_AM_FM_FIELDSTRENGTH,             0x02, DIA_C_U8_RUNLEVEL_2, {0x01,      0x03     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - AMFMTuner_Fieldstrength
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_TUNER_DAB_FIELDSTRENGTH,               0x02, DIA_C_U8_RUNLEVEL_2, {0x01,      0x03     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - DABTuner_Fieldstrength
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_TUNER2_FM_FIELDSTRENGTH,               0x02, DIA_C_U8_RUNLEVEL_2, {0x01,      0x03     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - FMTuner2_Fieldstrength
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_TUNER_SXM_FIELDSTRENGTH,               0x02, DIA_C_U8_RUNLEVEL_2, {0x01,      0x03     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - SXMTuner_Fieldstrength
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_WEATHERBAND_FIELDSTRENGTH,             0x02, DIA_C_U8_RUNLEVEL_2, {0x01,      0x03     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Weatherband_Fieldstrength
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_OPERATION_TIME,                 0x02, DIA_C_U8_RUNLEVEL_2, {       0x01, 0x03     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Operation Time
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_TEMPERATURE_HISTOGRAM_IMX,			 0x02, DIA_C_U8_RUNLEVEL_2, { 0x01, 0x02, 0x03 	   }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },//ReadDataByIdentifier - Temperature_Statistics
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_MERCEDES_TRUCK_SOFTWARE_PART_NUMBER,	 0x02, DIA_C_U8_RUNLEVEL_2, { 0x01, 0x02, 0x03 	   }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },//ReadDataByIdentifier - Mercedes Truck Software
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_PNM_GROUP10_CONFIG,                    0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - PNM Group 10 Configuration
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_CD_DEF_NVM_GROUP10_CONFIG,             0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - PNM Group 10 Configuration
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_TESTER_IDENTIFICATION,                 0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Tester Identification
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_HISTORICLE_INTERROGATION_REC,          0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - ReadHistoricalInterrogationRecord
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_OABR_CONNECTION_STATUS_AMPLIFIER,      0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - ReadAmplifierConnectionStatus
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_TUNER_HD_FIELDSTRENGTH,                0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - HDTuner_Fieldstrength
   // { 0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_HW_D_NR,                       0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VehicleManufacturerHardwareNumber Daimler(later for scope 3.0)
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_PRIVATE_MIC_SWITCH,                    0x02, DIA_C_U8_RUNLEVEL_1, {           0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Mic private SW
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_WAKEIN_STATUS,                         0x02, DIA_C_U8_RUNLEVEL_1, {           0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Status WakeIn port
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_TESTMODE_DTM,             			  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - SrvHandler_ReadTestModeDTM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_NVM_CONFIG,             			  0x02, DIA_C_U8_RUNLEVEL_1, {            0x01,0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - NVM Configuration
   { 0x22, DIA_C_U16_DID_RBCM_AUDIO_PARAMETER_SET,                           0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // Audio Parameter Set
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_DTC_CONFIGURATION,                    0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - DTC Configuration
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_CVBS_CONNECTION_STATUS,               0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - CVBS Connection Status
   { 0x22, DIA_C_U16_DID_LAST_DIAG_ERROR,                                    0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier -  lastErrorDebugInfo
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_AVDECC_CONFIGURATION,                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - AVDECC Configuration
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION,                    0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - CIS Configuration
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_INTERCOM_PHONE_NAME,                  0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - INtercom Phone Name
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_PHONEBOOK_MAX_CONTACT_ENTRIES,        0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Phonebook max contact entries
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION_CD,                 0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - CIS Configuration CD
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SUBSYSTEM_NODE_LIST,                  0x02, DIA_C_U8_RUNLEVEL_2, {            0x40      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - CVBS Connection Status
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_AUDIO_FILES_COUNTER,                  0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - AudioFilesCounter
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_VIDEO_FILES_COUNTER,                  0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - VideoFilesCounter
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_AM,                   0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_FM,                   0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_WBD,                  0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_SXM,                  0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_ARG,                  0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_HD,                   0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_PMO,                  0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_DAB,                  0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SPEECH_CONTROL_COUNTER,               0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_SW_DOWNLOAD_PRIVATE_KEY_STATUS,       0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - Run Time SOurce AM
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_DATA_CARRIER_VERSION,                 0x02, DIA_C_U8_RUNLEVEL_2, {       0x01,0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_CENTER_CMC_19_VEHICLE_INFO,                         0x02, DIA_C_U8_RUNLEVEL_1, {       0x01, 0x03     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },



   /*
      #####################################################################################################################################################
      ###############################################                                                       ###############################################
      ###############################################    Subsystem Diagnosis service configuration start    ###############################################
      ###############################################                                                       ###############################################
      #####################################################################################################################################################
   */
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_AVBOS_VERSION,            	       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_GEN_AVB_VERSION,     		       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CONFIG_READ,     		           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_SPARE_PART_NUMBER,     		   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_SERIAL_NUMBER,                    0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_SW_VERSION,                       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_HW_VERSION,                       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_NAME,                      	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SYSTEM_IDENTIFICATION,          	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SW_FINGERPRINT,            		   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CFG_FINGERPRINT,            		   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AVB_ENTITY_ID,      				   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWITCH_ATU,            			   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DOIP_UDS_STACK_VERSIONS,              0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AVB_GRANDMASTER_ID,            	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CFG,            				   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWIVEL_SW_VERSION,            		   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWIVEL_UUID,            		       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_VIN_ORIGINAL,            		       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_VIN_CURRENT,            			   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEVICE_TEMPERATURE,            	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_TEMPERATURE_STATISTICS,               0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SYSTEM_OPERATION_TIME,                0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SYSTEM_UPDATE,            		       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_1,        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_2,        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_3,        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_4,        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_5,        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_SRK_FUSES,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_ENV_ENCRYPTED,             0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECURITYROOT_FS_VERIFIED,             0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECURITYDATA_IS_ENCRYPTED,            0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_UBOOT_SRK_HASH,            0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_DEVICETREE_SRK_HASH,       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_IMXKERNEL_SRK_HASH,        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_POWER_SUPPLY_VOLTAGE,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AVG_CPU_LOAD,            		       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MAX_RAM_CONSUMPTION,            	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_STARTUP_TIME_STATISTIC,               0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_LOUD_SPEAKER_STATUS,            	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_STATUS,            		   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MICROPHONES_STATUS,            	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_WAKEUP_LINES_STATUS,            	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DIGITAL_OUTPUTS_STATUS,               0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_CONNECTION_STATUS,           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_CON_STATUS_HANDHELDS,        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_CONVERSATION_COUNTER,        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ACTIVE_DIAGNOSTIC_SESSION,            0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_USB_DEVICEINFO,                0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_INPUTLINES_STATUS,             0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_GNSS_RECEIVER_STATUS,          0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_GNSS_ANTENNA_STATUS,           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_MOBILE_NW_ANTENNA_STATUS,      0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_MOBILE_NW_FIELDSTRENGTH,       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_MAC_ADDRESS_IMX6,              0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_CPU_ID,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEVICE_PLACE_OF_PRODUCTION,           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEVICE_PRODUCTION_TIME,               0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CAM_RELAY_ACTIVATION,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AMP_SHUTDOWN_TIMEOUT,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_THRESHOLDS,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_RELEASETIME,                0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_WAKEUP_ALIVE_CONFIGURATION,           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWIVEL_CONFIGURATION,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DISPLAY_SETTINGS,          		      0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_OFFSET_GAIN,          	  0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_IN_OFFSET_GAIN,          	      0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MIC_OFFSET_GAIN,          	          0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_OFFSET_GAIN_MIC,             0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_OFFSET_GAIN_DIGITAL,         0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_AVAILABLE	,          	      0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_MIXOFFSET_GAIN,             0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_PHONEBOX_VOLUME,          	  0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CAMERA_USERNAME,          	      0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CAMERA_PASSWORD,          	      0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_MIC_OFFSET_GAIN_TO_ICOM_DIGITAL,   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DISPLAY_TEST_SCREEN,             0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },//Diagnosis Changes- new DID (0xC280) via CAN diagnostic-porting to Iguacu branch
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_PSK_ADMIN,          	  0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WEB_PASSWORD_ADMIN,           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_NODE_ID,          	          0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_MODE,          	              0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_PSK_USER,          	  0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_BOOT_CONFIG,                          0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_REVOKE_SRK_REG,                       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MQTT_PASSWORD,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECURE_JTAG,                          0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_SSID_ADMIN,              0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_SSID_PASSENGER,          0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_MAC_2G,                  0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_MAC_5G,                  0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x22, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_WRITE_KEY_FOR_SECURITY_ACCESS,        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },


   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AVB_ENTITY_ID,                    	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AVB_GRANDMASTER_ID,               	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CFG,                           	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWIVEL_SW_VERSION,                    0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWIVEL_UUID,                          0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_VIN_ORIGINAL,                     	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_VIN_CURRENT,                      	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CONFIG_WRITE,     		           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CAM_RELAY_ACTIVATION,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AMP_SHUTDOWN_TIMEOUT,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_THRESHOLDS,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_RELEASETIME,                0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_WAKEUP_ALIVE_CONFIGURATION,           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWIVEL_CONFIGURATION,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DISPLAY_SETTINGS,           		   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_OFFSET_GAIN,           	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_IN_OFFSET_GAIN,           	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MIC_OFFSET_GAIN,           	   	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_OFFSET_GAIN_MIC,             0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_OFFSET_GAIN_DIGITAL,         0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_AVAILABLE	,           	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_MIXOFFSET_GAIN,             0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_PHONEBOX_VOLUME,             0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CAMERA_USERNAME,           	       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CAMERA_PASSWORD,           	       0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_MIC_OFFSET_GAIN_TO_ICOM_DIGITAL,   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_PSK_ADMIN,           	   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WEB_PASSWORD_ADMIN,           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_NODE_ID,           	           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_MODE,           	               0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_PSK_USER,                 0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_BOOT_CONFIG,                           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_REVOKE_SRK_REG,                        0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MQTT_PASSWORD,                         0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECURE_JTAG,                           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_SSID_ADMIN,               0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_SSID_PASSENGER,           0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_MAC_2G,                   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_MAC_5G,                   0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x2E, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_WRITE_KEY_FOR_SECURITY_ACCESS,         0x02, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_START_SW_UPDATE,					   0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_PREPARE_SW_UPDATE,					   0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_RELOAD_SUPPLIER_DELIVERYSTATE,		   0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_GNSS_RECEIVER_STATUS,		   0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_IN_OFFSET_GAIN,		   		   0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_START_REMOTE_CONSOLE,                  0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ENABLE_UART_CONSOLE,                   0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DID_TC_ID_413_SECUREBOOT_ACTIVATOR,    0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DID_TC_ID_406_AVB_TEST,                0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_RCID_TC_ID_403_GPS,                    0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x31, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_USB_TEST,                              0x02, DIA_C_U8_RUNLEVEL_2, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   { 0x27, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SAC_LVL_PGMNG_3_SEED,                 0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x27, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SAC_LVL_PGMNG_3_KEY,                  0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x27, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SAC_LVL_CFG_5_SEED,                   0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x27, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SAC_LVL_CFG_5_KEY,                    0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   { 0x28, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_COM_CTRL_ENABLE_TX,                   0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x28, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_COM_CTRL_DISABLE_TX,                  0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   { 0x11, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_HARD_RST,                         0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   { 0x85, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CTRL_DTC_SETTING_ACTIVATE,            0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x85, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CTRL_DTC_SETTING_SUPPRESS,            0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   { 0x14, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_FM_CLEAR_DTC,                         0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   { 0x19, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_FM_READ_DTC_RPRT_NUM_BY_SM,           0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x19, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_FM_READ_DTC_RPRT_DTC_BY_SM,           0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x19, DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_FM_READ_DTC_RPRT_DTC_SPRTD,           0x01, DIA_C_U8_RUNLEVEL_1, {0x40}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   /*
      ###################################################################################################################################################
      ###############################################                                                     ###############################################
      ###############################################    Subsystem Diagnosis service configuration end    ###############################################
      ###############################################                                                     ###############################################
      ###################################################################################################################################################
   */

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x2E (write data by identifier - Implement service for Software Development (debug purposes))
   //
   ////////////////////////////////////////////////////////////////////////////
   { 0x2E, DIA_C_U16_DID_RBCM_PRINT2DIAGNOSIS_TRACE, 0x02, DIA_C_U8_RUNLEVEL_1, {                        0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - dia_SrvHandlerGenericPrint2DiagnosisTrace

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x2E (write data by identifier - Implement service for Production related Identification and configuration data)
   //
   ////////////////////////////////////////////////////////////////////////////

   { 0x2E, DIA_C_U16_DID_RBCM_BT_NAME,                                        0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_WriteBTName
   { 0x2E, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_ONE,                        0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_WriteInputKeyMappingTable_1
   { 0x2E, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_TWO,                        0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_WriteInputKeyMappingTable_2
   { 0x2E, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_THREE,                      0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_WriteInputKeyMappingTable_3
   { 0x2E, DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_FOUR,                       0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_WriteInputKeyMappingTable_4
   { 0x2E, DIA_C_U16_DID_RBCM_CUSTOMER_ECU_PART_NUMBER,                       0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - CustomerECUPartNumber
   { 0x2E, DIA_C_U16_DID_RBCM_CUSTOMER_SWUP_VARIANT_INFO,                     0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SWUPD_VariantInfo
   { 0x2E, DIA_C_U16_DID_RBCM_DIMMING_PARAMETER_SET,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SrvHandler_WriteDimmingParamet1
   { 0x2E, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_ALIGNMENT,                     0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SrvHandler_WriteKeyIlluminationAlignmentCoeff
   { 0x2E, DIA_C_U16_DID_AIVI_KEY_ILLUMINATION_ALIGNMENT_2,                   0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SrvHandler_WriteKeyIlluminationAlignmentCoeff2
   { 0x2E, DIA_C_U16_DID_AIVI_DISP_ILLUMINATION_ALIGNMENT,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SrvHandler_WriteDispIlluminationAlignmentCoeff
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_RBCM_EMMC_TEMPERATURE_THRESHOLDS,                    0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - eMMC_TemperatureThresholds
   { 0x2E, DIA_C_U16_DID_RBCM_THERMAL_MGNT_TEMPERATURE_THRESHOLDS,            0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - ThermalManagmentTemperatureThresholds
   { 0x2E, DIA_C_U16_DID_RBCM_GENERIC_TUNER_PARAMETER_SET,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SrvHandler_WriteGenTunerParamSet
   { 0x2E, DIA_C_U16_DID_RBCM_ANTENNA_PARAMETER_SET,                          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SrvHandler_WriteAntennaParamSet
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_RBCM_ANTENNA_2_PARAMETER_SET,               		 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - SrvHandler_WriteAntenna2ParamSet
   { 0x2E, DIA_C_U16_DID_RBCM_FM_AM_TUNER_PARAMETER_SET,                      0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SrvHandler_WriteFmAmTunerParamSet
   { 0x2E, DIA_C_U16_DID_RBCM_DAB_TUNER_PARAMETER_SET,                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - DAB Parameter Set
   { 0x2E, DIA_C_U16_DID_NAV_DATA_COPY_PROTECTION_SEC_ECC_KEY,                0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Navi data security key (ECC)
   { 0x2E, DIA_C_U16_DID_CM_VARIANT_CODING,                                   0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - CM Variant Coding
   //      { 0x2E, DIA_C_U16_DID_CM_EXTENDED_VARIANT_CODING,                 0x02, DIA_C_U8_RUNLEVEL_1, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },// WriteDataByIdentifier - CM Extended Variant Coding
   { 0x2E, DIA_C_U16_DID_NAV_DEFAULT_POSITION,                                0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Navigation default position
   { 0x2E, DIA_C_U16_DID_SENSOR_CONFIGURATION_GNSS,                           0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SensorConfigurationGNSS
   { 0x2E, DIA_C_U16_DID_SENSOR_CONFIGURATION_GYRO,                           0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SensorConfigurationGyro
   { 0x2E, DIA_C_U16_DID_SENSOR_CONFIGURATION_ACC,                            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SensorConfigurationAcc
   { 0x2E, DIA_C_U16_DID_CM_CONFIGURATION_INFO,                               0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - CMConfigurationInformation
   { 0x2E, DIA_C_U16_DID_RBCM_HD_PARAMETER_SET,                               0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - HDParameterSet
   { 0x2E, DIA_C_U16_DID_RBCM_WIFI_NAME_1,                                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_WriteWiFiName_1
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_RBCM_WIFI_NAME_2,                                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // SrvHandler_WriteWiFiName_2
   { 0x2E, DIA_C_U16_DID_CM_CUSTOMER_AND_BUILD_SW_VERSION,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - CustomerAndSWVersion
   { 0x2E, DIA_C_U16_DID_AIVI_NAVI_UNIT,                                      0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - dia_SrvHandler_WriteNaviUnit
   { 0x2E, DIA_C_U16_DID_AIVI_VARIANT_CODING,                                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - dia_SrvHandler_AIVI_VariantCoding_Write
   { 0x2E, DIA_C_U16_DID_CM_ADC_REF_PLUS_ACTUAL_VOLTAGE,                      0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SrvHandler_WriteADCRefPlusActualVoltage
   { 0x2E, DIA_C_U16_DID_RBCM_DEVICE_PRODUCTION_TIME,                         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - DeviceProductionTime
   { 0x2E, DIA_C_U16_DID_RBCM_DEVICE_MANAGER,                                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - DeviceManager
   { 0x2E, DIA_C_U16_DID_RBCM_MEDIA_PLAYER,                                   0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - MediaPlayer
   { 0x2E, DIA_C_U16_DID_RBCM_DISPLAY,                                        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Display for SPI
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION_DISPLAY,                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SmartPhoneIntegration Display-areas
   { 0x2E, DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION,                         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - configuration of SmartPhone component

   //Center CM-C 19
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION,				 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60    },{ DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - customerECUHWVersion
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER,			 0x02, DIA_C_U8_RUNLEVEL_1,     {            0x60    },{DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - CustomerSparePartNumber
   #ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER,			                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x03      }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // WriteDataByIdentifier - VIN Odometer
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER_LIMIT,			         0x02, DIA_C_U8_RUNLEVEL_1, {            0x03      }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // WriteDataByIdentifier - VIN Odometer Limit
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_VIN_CURRENT,			                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x03      }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // WriteDataByIdentifier - VIN Current
   #endif
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_CONFIGURATION_FINGERPRINT,			 0x02, DIA_C_U8_RUNLEVEL_1, {            0x03      }, { DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // WriteDataByIdentifier - Write Configuration Fingerprint
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_PNM_GROUP10_CONFIG,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // WriteDataByIdentifier - PNM Group 10 Configuration
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_CD_DEF_NVM_GROUP10_CONFIG,             0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - PNM Group 10 Configuration
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_TESTMODE_DTM,                   	   0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, 	// WriteDataByIdentifier - SrvHandler_WriteTestModeDTM
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_NVM_CONFIG,                            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - NVM Configuration
   { 0x2E, DIA_C_U16_DID_RBCM_AUDIO_PARAMETER_SET,                            0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // Audio Parameter Set
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_DTC_CONFIGURATION,                     0x02, DIA_C_U8_RUNLEVEL_1, {            0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // WriteDataByIdentifier - DTC Configuration
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_AVDECC_CONFIGURATION,                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - AVDECC Configuration
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION,                     0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - CIS Configuration
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_INTERCOM_PHONE_NAME,                   0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Intercom Phone Name
   { 0x2E, DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION_CD,                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // WriteDataByIdentifier - CIS Configuration CD


   /* ==================================================================================== */
   /* === ALL Services to read supported DIDs with dia_SrvHandler_SupportedIdentifiers === */
   /* ==================================================================================== */
   /* === START Supported DID: WRITEDataByIdentifier === */
   /* ================================================== */
   /* ================================================ */
   /* === END Supported DID: WRITEDataByIdentifier === */
   /* ================================================ */

   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI //Scope2 and above - supported in both production and extended sessions
   { 0x2E, DIA_C_U16_DID_AIVI_SPEED_LOCKOUT,                                  0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // WriteDataByIdentifier - SpeedLockout
   { 0x2E, DIA_C_U16_DID_AIVI_SPEED_LOCKOUT,                                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SpeedLockout
   #else
   { 0x2E, DIA_C_U16_DID_AIVI_SPEED_LOCKOUT,                                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - SpeedLockout
   #endif
   { 0x2E, DIA_C_U16_DID_RADIO_TYPE_APPROVAL_MODE,                            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - RadioTypeApprovalMode
   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   //{ 0x2E, DIA_C_U16_DID_AIVI_VIN,                                            0x02, DIA_C_U8_RUNLEVEL_1, {      0x03             }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - VIN
   #endif

   // WDBI - Digests in Programming Session with SecurityAccess
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_REFERENCE_CHECKSUM,               0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_NBS,                   0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_WBS,                   0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity	{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_VR_PARAM,                         0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_NBS,           0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_WBS,           0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_FACETIME_ECNR_SWB,        0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ACOUSTIC_PARAM,                   0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ESE_PARAM,                        0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_NBS,                0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_WBS,                0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_SIRI_ECNR_WBS,                 0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_SIRI_ECNR_WBS,            0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ANDROID_AUTO_VR_ECNR_WBS,         0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ECNR_VPA_VOICE_WB,                0x02, DIA_C_U8_RUNLEVEL_1, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_UID_SECURITY_LEVEL_PROJECT_01} },

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x27 (security access)
   //
   ////////////////////////////////////////////////////////////////////////////

   { 0x27, 0x0001, 0x01, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // Security Access A-IVI   request seed           27 01
   { 0x27, 0x0002, 0x01, DIA_C_U8_RUNLEVEL_1, {0x01, 0x02, 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // Security Access A-IVI   send key               27 02 xx xx xx xx xx xx xx xx
   { 0x27, 0x0005, 0x01, DIA_C_U8_RUNLEVEL_1, { 			0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // Security Access CMC   request seed
   { 0x27, 0x0006, 0x01, DIA_C_U8_RUNLEVEL_1, { 			0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // Security Access CMC   send key
   { 0x27, 0x0061, 0x01, DIA_C_U8_RUNLEVEL_1, { 			0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // Security Access for request seed (CIS Installation Container)
   { 0x27, 0x0062, 0x01, DIA_C_U8_RUNLEVEL_1, { 			0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // Security Access for send key (CIS Installation Container)
   //{ 0x27, 0x0061, 0x01, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // Security Access - Level Bosch
   //{ 0x27, 0x0062, 0x01, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // Security Access - Send Key (Level Bosch)
   { 0x27, 0x0063, 0x01, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03, 0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // Security ALD   request seed           27 63
   { 0x27, 0x0064, 0x01, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03, 0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // Security ALD   send key               27 64 xx xx xx xx xx xx xx xx

   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_EMMC,        DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_HEAT_SINK,   DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_GYRO,        DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_DVD_DRIVE,   DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_CD_DRIVE,    DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_AMPLIFIER,   DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_DISPLAY,     DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_IMX,         DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_PANEL,       DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_SCC,         DID_LEN_2, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },

   // write data by identifier
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_RBCM_WRITE_NEXT_TEMPERATURE_HISTOGRAM,   0x02, DIA_C_U8_RUNLEVEL_2, { 0x60  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_RBCM_DRM_TUNER_PARAMETER_SET,   0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x2E, DIA_C_U16_DID_RBCM_EARLY_CONFIG_DISPLAY,      0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // EarlyConfig_Display
   { 0x2E, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TWO_DISPLAY,  0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // EarlyConfig_Display
   { 0x2E, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER, 0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // EarlyConfig_TouchDriver
   { 0x2E, DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER_2, 0x02, DIA_C_U8_RUNLEVEL_2, {                      0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // EarlyConfig_TouchDriver2

   //RTC-5990073 Cleanup Activity{ 0x2E, 0x0047, 0x02, DIA_C_U8_RUNLEVEL_1, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Test

   { 0x2E, DIA_C_U16_DID_CM_CUSTOMER_SOFTWARE_VERSION,               0x02, DIA_C_U8_RUNLEVEL_1, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - CustomerSWVersion

   //RTC-5990073 Cleanup Activity{ 0x2E, 0x3200,                                            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByIdentifier - immobilizer

   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_AUDIO_SOURCE_OFFSET_IN,         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - AudioSourceOffsetIn
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_SYSTEM_INFO_COMMON,             0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - System Information Common
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_CAMERA_SYSTEM,                  0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Camera System
   { 0x2E, DIA_C_U16_DID_AIVI_SYSTEM_VEHICLE_INFO,            0x02, DIA_C_U8_RUNLEVEL_1, {      0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Vehicle Information
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_ECO_ROUTE,                      0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - ECO Route
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_BT_NAME,                        0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - BT Name
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_CONFIG_HASH_VALUE,              0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - ConfigurationHashValue
   { 0x2E, DIA_C_U16_DID_AIVI_CONFIG_PARTS_NUMBER,            0x02, DIA_C_U8_RUNLEVEL_1, {      0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Configuration Part Number
   //{ 0x2E, DIA_C_U16_DID_AIVI_CONFIG_SYSTEM_SUPPLIER_NR,      0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - SystemSupplierNumber
   //{ 0x2E, DIA_C_U16_DID_AIVI_ECU_SERIAL_NUMBER_IDENTIFIER,   0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - ECUSerialNumberDataIdentifier
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GYRO,             0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - SensorConfigurationGyro
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GNSS,             0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - SensorConfigurationGNSS
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_ACC,              0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - SensorConfigurationACC
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET,           0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - FM/AM Tuner Parameter
   { 0x2E, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_01,        0x02, DIA_C_U8_RUNLEVEL_1, {      0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - FM/AM Tuner Parameter Set (1/2)
   { 0x2E, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_02,        0x02, DIA_C_U8_RUNLEVEL_1, {      0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - FM/AM Tuner Parameter Set (2/2)
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_ANTENNA_PARAM_SET,              0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Antenna Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DAB_SET,                        0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - DAB Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET,        0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Generic Tuner Parameter Set
   { 0x2E, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_01,     0x02, DIA_C_U8_RUNLEVEL_1, {      0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Generic Tuner Parameter Set (1/2)
   { 0x2E, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_02,     0x02, DIA_C_U8_RUNLEVEL_1, {      0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Generic Tuner Parameter Set (2/2)
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_HD_PARAM_SET,                   0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - HDParameterSet
   #ifndef VARIANT_S_FTR_ENABLE_RNAIVI
   { 0x2E, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET,                0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Audio parameter set
   { 0x2E, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_01,             0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Audio parameter set (1/2)
   { 0x2E, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_02,             0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Audio parameter set (2/2)
   #endif
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_ANTITHEF_MAP_SELECTION,         0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Antitheft Map Selection   dia_AntitheftMapSelectionWrite
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_WIFI_NAME,                      0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Wifi Name
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_MEX_CONFIG,                     0x02, DIA_C_U8_RUNLEVEL_1, {      0x60            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - MEX Config
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_FACTORY_MODE,                   0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Factory Mode
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_CONNECTIVITY_CONFIG,            0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - Connectivity Config
   { 0x2E, DIA_C_U16_DID_AIVI_HMI_CONFIG,                     0x02, DIA_C_U8_RUNLEVEL_1, {      0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - HMI Config
   { 0x2E, DIA_C_U16_DID_AIVI_SOUND_VOLUME_CONFIG,            0x02, DIA_C_U8_RUNLEVEL_1, {      0x60            }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Sound Volume Config
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DRM_TUNER_PARAMETER_SET,        0x02, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // WriteDataByIdentifier - DRM Tuner Parameter Set

   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_ACOUSTIC_PARAM,             0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Acoustic Parameter
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_ANTENNA_PARAM_SET,          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Antenna Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_AUDIO_PARAM_SET,            0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Audio Parameter Set
   { 0x2E, DIA_C_U16_DID_AIVI_DEF_SYSTEM_INFO_COMMON,         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC } }, // WriteDataByIdentifier - Default System Information Common
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_SYSTEM_VEHICLE_INFO,        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Vehicle Information
   { 0x2E, DIA_C_U16_DID_AIVI_DEF_CAMERA_SYSTEM,              0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC } }, // WriteDataByIdentifier - Default Camera System
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_CONFIG_PARTS_NUMBER,        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Configuration Part Number
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_WBS,             0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Phone ECNR WBS
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_NBS,             0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Phone ECNR NBS
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_ECO_ROUTE,                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default ECO Route
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_BT_NAME,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default BT Name
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_ANTITHEF_MAP_SELECTION,     0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Antiteff Map Selection
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_CONFIG_HASH_VALUE,          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Configuration Hash Value
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GNSS,         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Sensor Configuration GNSS
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GYRO,         0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Sensor Configuration GYRO
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_ACC,          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Sensor Configuration ACC
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_FMAM_TUNER_PARAM_SET,       0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default FMAM Tuner Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_GENERIC_TUNER_PARAM_SET,    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Generic Tuner Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_DAB_SET,                    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default DAB Set
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_HD_PARAM_SET,               0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default HD Parameter Set
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_WIFI_NAME,                  0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Wifi Name
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_MEX_CONFIG,                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default MEX Config
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_FACTORY_MODE,               0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default Factory Mode
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_CONNECTIVITY_CONFIG,        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Connectivity Config
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_HMI_CONFIG,                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - HMI Config
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_SOUND_VOLUME_CONFIG,        0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Sound Volume Config
   //RTC-5990073 Cleanup Activity{ 0x2E, DIA_C_U16_DID_AIVI_DEF_DRM_TUNER_PARAMETER_SET,    0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Default DRM Tuner Parameter Set

   { 0x2E, DIA_C_U16_DID_RBCM_ECU_HW_VERSION,                 0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - WriteECUHWVersion
   { 0x2E, DIA_C_U16_DID_RBCM_ECU_SERIAL_NUMBER,              0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - ECUSparePartNumber
   { 0x2E, DIA_C_U16_DID_RBCM_ECU_SPARE_PART_NUMBER,          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - ECUSparePartNumber
   { 0x2E, DIA_C_U16_DID_RBCM_PCB_SERIAL_NUMBER,              0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - mainboardSerialNumber
   { 0x2E, DIA_C_U16_DID_RBCM_PCB_SPARE_PART_NUMBER,          0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - mainboardSparePartNumber
   { 0x2E, DIA_C_U16_DID_CM_VARIANT_ID,                       0x02, DIA_C_U8_RUNLEVEL_1, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - Variant ID
   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   { 0x2E, DIA_C_U16_DID_AIVI_HW_REF_A,                       0x02, DIA_C_U8_RUNLEVEL_1, {          0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByIdentifier - HW_RefA DID:3051
   #endif

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x2F (ioctrl by identifier)
   //
   ////////////////////////////////////////////////////////////////////////////

   { 0x2F, DIA_C_U16_DID_RBCM_IOCTRL_RVC_CONTROL_LINE,            0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlRVCControlLine

   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6012, 0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      } }, // IOCtrl audioLinearMode


   { 0x2F, DIA_C_U16_DID_ADR3_ACTUAL_CALIBRATION_DATA,        0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_ActualAlignmentValues
   { 0x2F, DIA_C_U16_DID_ADR3_AMPLIFIER_POWER_STATE,          0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_AmplifierPowerState
   { 0x2F, DIA_C_U16_DID_ADR3_AUDIO_ROUTER_1,                 0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_AudioRouter_1
   { 0x2F, DIA_C_U16_DID_ADR3_AUDIO_TEST_TONE,                0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_AudioTesttone
   { 0x2F, DIA_C_U16_DID_ADR3_CONTROL_FRONTEND_CLOCK_OUTPUT,  0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_ControlFrontEndClockOutput Set
   { 0x2F, DIA_C_U16_DID_ADR3_DAB_SET_SERVICE_ID,             0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_DABSetServiceID
   { 0x2F, DIA_C_U16_DID_ADR3_DDS_CONFIGURATION,              0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_DDSConfiguration
   { 0x2F, DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQUENCY_1, 0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_SetPhysicalTunerFrequency 1
   { 0x2F, DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQUENCY_2, 0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_SetPhysicalTunerFrequency 2
   { 0x2F, DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQUENCY_3, 0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_SetPhysicalTunerFrequency 3
   { 0x2F, DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQUENCY_4, 0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_SetPhysicalTunerFrequency 4
   { 0x2F, DIA_C_U16_DID_ADR3_SET_VOLUME,                     0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_SetVolume
   { 0x2F, DIA_C_U16_DID_ADR3_SNOOP_MODE,                     0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_SnoopMode
   { 0x2F, DIA_C_U16_DID_ADR3_SWTICH_BACKGROUND_ANTENNA,      0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_SwitchBackgroundAntenna
   { 0x2F, DIA_C_U16_DID_ADR3_TUNE_DEMODULATOR_1,             0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_TuneDemodulator_1
   { 0x2F, DIA_C_U16_DID_ADR3_TUNE_DEMODULATOR_2,             0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_TuneDemodulator_2 Set
   { 0x2F, DIA_C_U16_DID_ADR3_DRM_SET_SERVICE_ID,             0x02, DIA_C_U8_RUNLEVEL_2, {                           0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_DRMSetServiceID

   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_AIVI_LOUDSPEAKER_TEST_TONE,          0x02, DIA_C_U8_RUNLEVEL_2, {      0x03                     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlLoudspeakerTestTone
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_AIVI_DISPLAY_TEST,                   0x02, DIA_C_U8_RUNLEVEL_2, {      0x03,                    }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlDisplayTest
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_AIVI_REAR_CAMERA_ACTIVATION,         0x02, DIA_C_U8_RUNLEVEL_2, {      0x03                     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlRearCameraActivation
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_AIVI_SYSTEM_AMP_ON_OUTPUT,           0x02, DIA_C_U8_RUNLEVEL_2, {      0x03                     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlSystemAmpOnOutput
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_AIVI_TUNER_SETTINGS,                 0x02, DIA_C_U8_RUNLEVEL_2, {      0x03                     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlTunerSettings
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_AIVI_TWEETER_TEST,                   0x02, DIA_C_U8_RUNLEVEL_2, {      0x03                     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlTweeterTest
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_AIVI_SPEAKER_TEST,                   0x02, DIA_C_U8_RUNLEVEL_2, {      0x03                     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlSpeakerTest
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_AIVI_AUDIO_EXT_OUT_TEL_MODE,         0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60   }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlAudioExtOutTelMode
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_AIVI_AUDIO_EXT_OUT_HF_VR,            0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60   }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlAudioExtOutHfVr
   { 0x2F, DIA_C_U16_DID_AIVI_EXT_AMP_CTRL_LINE_OUTPUT,       0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60   }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlExternalAmplifierControlLine
   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   { 0x2F, DIA_C_U16_DID_AIVI_CD_EJECT,                       0x02, DIA_C_U8_RUNLEVEL_2, {      0x03                     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlCDEject
   { 0x2F, DIA_C_U16_DID_AIVI_EXT_OUT_SPARE3,             0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60   }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlExtOutSpare3
   #endif

   #if !defined(VARIANT_S_FTR_ENABLE_NPIVI) && defined(VARIANT_S_FTR_ENABLE_RIVIE)
   { 0x2F, DIA_C_U16_DID_AIVI_RESET_TOUCH_CTRL_EXT_DISPLAY,   0x02, DIA_C_U8_RUNLEVEL_2, {      0x03             }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlResetTouchCtrlExtDisplay
   #endif
   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6102,                                            0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlTunerAMFM_Band
   { 0x2F, DIA_C_U16_DID_RBCM_TUNER_AMFM_1_POWER_SUPPLY,      0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlTunerAMFM_Antenna_PowerSupply
   { 0x2F, DIA_C_U16_DID_RBCM_TUNER_AMFM_2_POWER_SUPPLY,      0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlTunerAMFM_Antenna_PowerSupply
   { 0x2F, DIA_C_U16_DID_RBCM_COMPRESSED_AUDIO_SELECT_TITLE,  0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlCompressedAudioTitle
   { 0x2F, DIA_C_U16_DID_RBCM_TUNER_AMFM_SELECT_ACTIVE_TUNER, 0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlTunerAMFM_SelectActiveTuner
   { 0x2F, DIA_C_U16_DID_RBCM_TUNER_AMFM_FREQUENCY,           0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlTunerAMFM_Frequency
   { 0x2F, DIA_C_U16_DID_RBCM_ACTIVE_VIDEO_SOURCE,            0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlActiveVideoSource
   //{ 0x2F, DIA_C_U16_DID_RBCM_DISPLAY_TEST_PATTERN,           0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlDisplayTestPattern
   { 0x2F, DIA_C_U16_DID_RBCM_AUDIO_LINEAR_MODE,              0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlAudioLinearMode
   { 0x2F, DIA_C_U16_DID_RBCM_AUDIO_SINK_ACTIVE,              0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlAudioSinkSet
   { 0x2F, DIA_C_U16_DID_RBCM_AUDIO_GAIN,                     0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x2F, DIA_C_U16_DID_RBCM_AUDIO_TEST_TONE,                0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x2F, DIA_C_U16_DID_RBCM_AUDIO_BALANCE,                  0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x2F, DIA_C_U16_DID_RBCM_AUDIO_FADER,                    0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x2F, DIA_C_U16_DID_ADR3_SET_SIGNAL_QUALITY,             0x02, DIA_C_U8_RUNLEVEL_2, {            0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_SetSignalQuality
   { 0x2F, DIA_C_U16_DID_RBCM_DISPLAY_BACKLIGHT_ILLUMINATION, 0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // IOCtrl DisplayBrightness
   { 0x2F, DIA_C_U16_DID_RBCM_BLUETOOTH_MODE,                 0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // IOCtrl dia_IOCtrlBluetoothMode
   { 0x2F, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION,               0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrl_KeyIllumination
   { 0x2F, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_PWM,           0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrl_KeyIlluminationPWM
   { 0x2F, DIA_C_U16_DID_RBCM_DATASET_BLOCK_SIZE,             0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC}  }, // upDownloadBlocksize

   { 0x2F, DIA_C_U16_DID_SENSOR_GNSS_POS_SYSTEM,              0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlGNSSPositioningSystem
   { 0x2F, DIA_C_U16_DID_RBCM_BT_MODULE_RESET,                0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlBtModuleReset
   { 0x2F, DIA_C_U16_DID_RBCM_WIFI_MODULE_RESET,              0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlWifiModuleReset
   { 0x2F, DIA_C_U16_DID_RBCM_SXM_TUNER_CHANNEL,              0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },


   { 0x2F, DIA_C_U16_DID_RBCM_TUNER_DAB_POWER_SUPPLY,         0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlTunerDAB_Antenna_1_PowerSupply
   { 0x2F, DIA_C_U16_DID_RBCM_DISPLAY_TEST_PATTERN,           0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlDisplayTestPatternAIVI
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_RESET_LINE,       0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlCDResetLine
   { 0x2F, DIA_C_U16_DID_CENTER_CMC_19_DISPLAY_TEST_PATTERN,  0x02, DIA_C_U8_RUNLEVEL_2, { 0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlDisplayTestPatternAIVI
   //RTC-913068 Disable in Imx{ 0x2F, DIA_C_U16_DID_CENTER_CMC_19_EXTERNAL_CTRL_SWITCH_WAKEOUT,  0x02, DIA_C_U8_RUNLEVEL_2, { 0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlExternalSwitchWakeOut
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_CDDA_PLAYED_TRACK,              0x02, DIA_C_U8_RUNLEVEL_2, {        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // IOCtrl PlayedTrack
   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6140, 0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlTunerXM_1_Channel
   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6202, 0x02, DIA_C_U8_RUNLEVEL_2, {0x81, 0xC0, 0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlDisplayTestPattern
   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6210, 0x02, DIA_C_U8_RUNLEVEL_2, {0x81, 0xC0, 0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // IOCtrl KeyIllumination
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_KEY_PRESSED,                        0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // IOCtrl dia_IOCtrl_PressedKey
   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6305, 0x02, DIA_C_U8_RUNLEVEL_2, {0x81, 0xC0, 0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlGNSSPositioningSystem
   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6411, 0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlAudioGain
   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6412, 0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlAudioTestTone
   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6413, 0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlAudioBalance
   //RTC-5990073 Cleanup Activity{ 0x2F, 0x6414, 0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlAudioFader
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_AUDIO_EXT_AMPLIFIER_CONT_LINE,      0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlAudioExternalAmplifierContLine

   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_HMI_LANGUAGE,                       0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlHMILanguage

   { 0x2F, DIA_C_U16_DID_RBCM_SYSTEM_REMOTE_CONTROL,           0x02, DIA_C_U8_RUNLEVEL_2, {               0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // IOCtrl dia_IOCtrlHmiRemoteControl
   { 0x2F, DIA_C_U16_DID_RBCM_TUNER_DAB_POWER_SUPPLY,          0x02, DIA_C_U8_RUNLEVEL_2, {               0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlTunerDAB_Antenna_1_PowerSupply
   { 0x2F, DIA_C_U16_DID_RBCM_HMI_LANGUAGE,                       0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlHMILanguage_set
   { 0x2F, DIA_C_U16_DID_RBCM_AUDIO_SOURCE_ACTIVE,                0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   #if defined(VARIANT_S_FTR_ENABLE_RNAIVI) || defined(__DIA_UNIT_TESTING__)
   { 0x2F, DIA_C_U16_DID_RBCM_TUNER_DAB_ENSEMBLE_FREQUENCY,       0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlTunerDAB_Antenna_1_EnsembleFrequency
   #endif
   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   { 0x2F, DIA_C_U16_DID_RBCM_TUNER_DAB_SERVICE_ID,               0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlTunerDAB_Antenna_1_ServiceID
   #endif
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_CD_MODE_CONTROL,                    0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlCDModeControl
   { 0x2F, DIA_C_U16_DID_RBCM_VIDEO_SOURCE_ACTIVE,                0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlVideoSourceSet
   { 0x2F, DIA_C_U16_DID_RBCM_SYSTEM_HMI_ON,                      0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x2F, DIA_C_U16_DID_RBCM_INPUT_HDL_KEY_PRESSED,              0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x2F, DIA_C_U16_DID_RBCM_ACTIVE_VIDEO_SOURCE,                0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlActiveVideoSource
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_IOCTRL_WIFI_MODE,             0x02, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },

   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_IOCTRL_BLUETOOTH_MODULE_RESET,      0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_IOCTRL_MICROPHONE_POWER_SUPPLY,     0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },

   { 0x2F, DIA_C_U16_DID_RBCM_FAN_SPEED,                          0x02, DIA_C_U8_RUNLEVEL_1, {              0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },

   /* ==================================================================================== */
   /* === ALL Services to read supported DIDs with dia_SrvHandler_SupportedIdentifiers === */
   /* ==================================================================================== */
   /* === START Supported DID: IOCtrl === */
   /* =================================== */
   /* ================================= */
   /* === END Supported DID: IOCtrl === */
   /* ================================= */


   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x31 (routine ctrl by identifier)
   //
   ////////////////////////////////////////////////////////////////////////////
   #ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_VIN_RESET,      				 0x02, DIA_C_U8_RUNLEVEL_2, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // reset VIN
   #endif
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_INSTALLATION,      	   0x02, DIA_C_U8_RUNLEVEL_2, {      0x03    }, {DIA_EN_SECURITY_LEVEL_DOIP_CMC,DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER} }, //RoutineCtrlSystemInstallation
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_COPY_INSTALLATION_LOGFILE_TO_USB,0x02, DIA_C_U8_RUNLEVEL_2,{      0x03  }, {DIA_EN_SECURITY_LEVEL_DOIP_CMC,DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER} }, //RoutineCtrlCopyInstallationLogFileToUSB
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_CIS_INSTALL_CONTAINER_EXTRACT, 0x02, DIA_C_U8_RUNLEVEL_2, {      0x03    }, {DIA_EN_SECURITY_LEVEL_DOIP_CMC,DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER} }, //RoutineCtrlSystemInstallation
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_SUB_SYSTEM_CONNECT  ,0x02, DIA_C_U8_RUNLEVEL_2,{      0x40  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, //dia_RoutineCtrlConnectToSpecificSubSystem
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_PHONESET_CONNECT_BT_DEVICE,      0x02, DIA_C_U8_RUNLEVEL_2, {       0x60   }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // connect BT device
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_IDENTIFY_SUB_SYSTEM,           0x02, DIA_C_U8_RUNLEVEL_2, {      0x40  },   {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, //RoutineCtrlIdentifySubSystem
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_CIS_HMI_STARTUP_LOGO_INSTALLATION,0x02, DIA_C_U8_RUNLEVEL_2,{      0x03},   {DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER} }, //RoutineCtrlLogoInstallation
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_RELOAD_SUPPLIER_DELIVERY_STATE,0x02, DIA_C_U8_RUNLEVEL_2, {       0x03   }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },   // dia_RoutineCtrlReloadSupplierDeliveryState
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_CIS_SW_UPDATE_STAGE1,           0x02, DIA_C_U8_RUNLEVEL_2, {      0x03  },   {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_CENTER_CMC_19_CIS_SW_UPDATE_STAGE2,           0x02, DIA_C_U8_RUNLEVEL_2, {      0x03  },   {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },

   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, 0x3010,                                                    0x02, DIA_C_U8_RUNLEVEL_2, {                 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_StartSeek
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, 0x3011,                                                    0x02, DIA_C_U8_RUNLEVEL_2, {                 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_StoreAlignment
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, 0x3013,                                                    0x02, DIA_C_U8_RUNLEVEL_2, {                 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_CalcCRC
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, 0x3014,                                                    0x02, DIA_C_U8_RUNLEVEL_2, {                 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_FormatFFS
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_ADR3_DAB_CALC_MEASUREMENT_VALUE,             0x02, DIA_C_U8_RUNLEVEL_2, {                 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_DABCalcMeasurementValueDemodulator_1
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, 0x3016,                                                    0x02, DIA_C_U8_RUNLEVEL_2, {                 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_FormatFFS
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_ADR3_CHECK_FRONTEND_REGISTER,                0x02, DIA_C_U8_RUNLEVEL_2, {                 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_CheckFrontendregister

   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_ADR3_START_CALIBRATION,                      0x02, DIA_C_U8_RUNLEVEL_2, {0x61},                  {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ADR3_Start_Calibration

   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_AIVI_CLEAR_MCAN_CONNECTION_HISTORY,          0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RtCtrlClearMCANConnectionHistory
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_IPOD_SELFTEST,                          0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // rtcl IPOD selftest    // dia_RoutineCtrlIPODSelfTest
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_SENSOR_ACC_SELF_TEST,                        0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ACC_Selftest
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_SENSOR_GYRO_SELF_TEST,                       0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // GYRO_Selftest
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_MMGR_CDDRIVE_SELFTEST,                  0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // opticalDriveSelftest

   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_RESET_SYSTEM_RESET_INFORMATION,  0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // reset system reset information
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_CM_CONFIGURATION_FINGERPRINT,           0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // calculateCMConfigurationFingerprint
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_CUSTOMER_DEF_CONFIG_FINGERPRINT,        0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // calculateCustomerDefaultConfigurationFingerprint
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_CUSTOMER_CONFIG_FINGERPRINT,            0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // calculateCustomerConfigurationFingerprint

   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, 0xD010, 0x02, DIA_C_U8_RUNLEVEL_2, {            0xF0,       0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RtCtrlSystemOperationTime_Reset
   
   // { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, 0x1001, 0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // FieldStrength of Bluetooth
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, 0x1017, 0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // Bluetooth Connection

   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_GET_WIFI_SNR,                   0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },             // dia_RtCtrlGetWifiSNR
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_SET_SYSTEM_TO_DELIVERY_STATE,   0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // set system to delivery state
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_SET_DIAGNOSTICS_TO_DELIVERY_STATE,0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // set diagnostics to delivery state
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_WRITE_DTC_TEST_RESULT,          0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // write DTC Test Result
   { 0x2F, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_1,                                                0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlUSB_PowerSupply - USB 1
   { 0x2F, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_2,                                                0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlUSB_PowerSupply - USB 2
   //RTC-5990073 Cleanup Activity{ 0x2F, DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_3,                                                0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_IOCtrlUSB_PowerSupply - USB 3


   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_NOR_RAW,           0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum
   //    { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_NOR_FFS,           0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum   //removed
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_RAW,          0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_ROOT,     0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FASTBOOT,     0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_BOOT,         0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_APP,          0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_STATIC,   0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_MAP_DATA, 0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_SDB,      0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_GRACENOTE,0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlChecksum

   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_LCM_START_ALTERNATIVE_SOFTWARE, 0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_RoutineCtrlLcmStartAlternativeSoftware
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_LCM_START_SOFTWARE_UPDATE,      0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_RoutineCtrlStartSoftwareUpdate
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_GNSS_FIRMWARE_CHECKSUM,         0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_RoutineCtrlGNSSCalcAndVerifyChecksum
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_EM_ERASE,                       0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_RoutineCtrlEMErase
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_EM_PRINT2TRACE,                 0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_RoutineCtrlEMPrint2Trace
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_RTCTRL_JTAG_ID_AND_SECURITY_BYTE_CONFIGURE,  0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // V850_ConfigureJTAG_ID_SecurityBits
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_RTCTRL_JTAG_ID_AND_SECURITY_BYTE_VERIFY,     0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // V850_VerifyJTAG_ID_SecurityBits
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_RTCTRL_SWUP_UPDATE_MAP_DATA,                 0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_RoutineCtrlSWUPUpdateMapData
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_RTCTRL_KEY_PAIR_GENERATION,                  0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_RoutineCtrlGenerateKeyPair
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_RTCTRL_GENERATE_CSR,                         0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_RoutineCtrlGenerateCSR
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_RTCTRL_CERTIFICATE_STORING,                  0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // dia_RoutineCtrlCertificateStoring
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_RTCTRL_START_SWUPDATE_OF_ALL_SUBMODULES,     0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },   // RoutineCtrlStartSoftwareUpdateOfAllSubModules
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_RTCTRL_GET_BT_SIGQ_RSSI,                     0x02, DIA_C_U8_RUNLEVEL_2, {      0x03         }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },   // dia_RtCtrlGetBT_SigQ_RSSI
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_GET_PROC_STAT_BY_PROCESSNAME,   0x02, DIA_C_U8_RUNLEVEL_2, {              0x60}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia::RoutineCtrlGetProcStatByProcessname
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_GET_PROC_STATM_BY_PROCESSNAME,  0x02, DIA_C_U8_RUNLEVEL_2, {              0x60}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia::RoutineCtrlGetProcStatMByProcessname

   #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_TOUCH_SELFTEST,                 0x02, DIA_C_U8_RUNLEVEL_2, {              0x60 }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // dia_RoutineCtrlTouchSelfTest
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RTCTRL_SELF_DIAGNOSIS,                     0x02, DIA_C_U8_RUNLEVEL_2, {         0x03      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_RtCtrlSelfDiagnosis
   #endif

   // Routine - Check DTCs in Programming Session (possible without SecurityAccess)
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_AIVI_RTCTRL_CHECK_PROGRAMMING_DEPENDENCIES,  0x02, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_AIVI_RTCTRL_RUN_DTC_TEST_LOGICAL_BLOCK,      0x02, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_AIVI_RTCTRL_BOOT_BS_AND_STMIN,               0x02, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   //RTC-5990073 Cleanup Activity{ DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_ID_AIVI_RTCTRL_BOOT_SPECIFIC_BS_AND_STMIN,      0x02, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_PROGRAMMING }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },


   #ifdef __ENABLE_FEATURE_RUN_IN__
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_DIAGNOSIS_RUN_IN,                             0x02, DIA_C_U8_RUNLEVEL_2, {                   0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // RunIn
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_DIAGNOSIS_RUN_IN_CLEAR_RESULTS,               0x02, DIA_C_U8_RUNLEVEL_2, {                   0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // RunInClearResults
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_1,                      0x02, DIA_C_U8_RUNLEVEL_2, {                   0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // StressTest
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_2,                      0x02, DIA_C_U8_RUNLEVEL_2, {                   0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // StressTest
   { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_DIAGNOSIS_DISPLAY_SLIDESHOW,                  0x02, DIA_C_U8_RUNLEVEL_2, {                   0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // StressTest
   #endif

   // read data by memory address
   { 0x23, 0x0012,                                                                                 0x01, DIA_C_U8_RUNLEVEL_1, {                        0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // ReadDataByMemory - Test
   // write data by memory address
   { 0x3D, 0x0012,                                                                                 0x01, DIA_C_U8_RUNLEVEL_1, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} }, // WriteDataByMemory - Test

   // request download
   { 0x34, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x34, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_PROGRAMMING },     {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x34, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_EXTENDED },     {DIA_EN_SECURITY_LEVEL_DOIP_CMC,DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER} },

   // request upload
   { 0x35, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x35, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_EXTENDED }, {DIA_EN_SECURITY_LEVEL_DOIP_CMC,DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER} },

   // transfer data
   { 0x36, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x36, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_PROGRAMMING },     {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x36, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_EXTENDED },     {DIA_EN_SECURITY_LEVEL_DOIP_CMC,DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER} },

   // request transfer exit
   { 0x37, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x37, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_PROGRAMMING },     {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} },
   { 0x37, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_2, { DIA_C_U8_UDS_SESSION_EXTENDED },     {DIA_EN_SECURITY_LEVEL_DOIP_CMC,DIA_EN_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER} },

   { 0x38, 0x0000,                                                                                 0x00, DIA_C_U8_RUNLEVEL_1, {                        0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },

   //-----------------------------------------------------------------------------------------------------------------------------
   // control error memory
   { 0x85, 0x0001,                                                                                 0x01, DIA_C_U8_RUNLEVEL_2, {0x03, 0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   { 0x85, 0x0002,                                                                                 0x01, DIA_C_U8_RUNLEVEL_2, {0x03, 0x60      }, {DIA_EN_SECURITY_LEVEL_ALD_CMC} },
   //-----------------------------------------------------------------------------------------------------------------------------

   { DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_RUN_IN,                                0x02, DIA_C_U8_RUNLEVEL_2, {                  0x60            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // DIA_C_U16_UDS_SUBID_codingValue update
   { DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_CONFIG_CD_HASH,                        0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03, 0x60                  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, //
   { DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_CONFIG_CD_DEF_HASH,                    0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03, 0x60                  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, //
   { DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_CONFIG_PD_HASH,                        0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03, 0x60                  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, //
   { DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_INPUT_EVENT,                           0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03, 0x60                  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // Test to Enable Input Events
   { DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_LOUDSPEAKER,                           0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03, 0x60                  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_TestLoudspeaker
   { DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_FACTORY_MODE,                          0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03, 0x60                  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_TestFactoryMode
   { DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_PDX_FLASHING,                          0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03, 0x60                  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   { DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_XTRA_DATA,                             0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03, 0x60                  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },

   { 0x99, DIA_C_U8_SUBFUNC_AIVI_XCP_GET_MONITORING_DATA,       0x01, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03                  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_SrvHandler_XCPMonitoring
   { 0xFD, DIA_C_U16_INT_TEST_DID_CENTER_CMC_19_VIN_ODOMETER,   0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x02, 0x03, 0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
   { 0xFD, DIA_C_U16_INT_TEST_DID_CENTER_CMC_19_VIN_CURRENT,    0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x02, 0x03, 0x60, 0x61}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }

};

//lint +e785

//-----------------------------------------------------------------------------

dia_EngineConfigGen3g::dia_EngineConfigGen3g ( void )
   : dia_EngineServerConfiguration("dia_EngineConfigGen3g")
{
   dia_tclFnctTrace trc("dia_EngineConfigGen3g::dia_EngineConfigGen3g()");

   (void) dia_EngineConfigGen3g::loadConfiguration();
}

//-----------------------------------------------------------------------------

dia_EngineConfigGen3g::~dia_EngineConfigGen3g ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineConfigGen3g::loadConfiguration ( void )
{
   dia_tclFnctTrace trc("dia_EngineConfigGen3g::loadConfiuration()");

   DIA_TR_INF("### LOADING SUPPORTED SESIONS (Gen3 Generic) ###");
   tU16 numSessions = sizeof(supportedSessions) / sizeof(supportedSessions[0]);
   vector<tU8> sessions(supportedSessions, supportedSessions + numSessions);
   loadSessions(sessions);

   DIA_TR_INF("### LOADING SERVICE ACCESS INFORMATION (Gen3 Generic) ###");
   tU16 repSize = sizeof(serviceInfoRep) / sizeof(serviceInfoRep[0]);
   vector<ServiceInfo> srvInfoRep(serviceInfoRep, serviceInfoRep + repSize);
   loadServiceInfo(srvInfoRep);

   DIA_TR_INF("### LOADING SERVICE SUBFUNCTION ACCESS INFORMATION (Gen3 Generic) ###");
   repSize = sizeof(serviceDataInfoRep) / sizeof(serviceDataInfoRep[0]);
   vector<ServiceDataItem> srvDataRep = vector<ServiceDataItem>(serviceDataInfoRep, serviceDataInfoRep + repSize);

   //WriteDataByIdentifier services for a lot of DIDs (Variable Length Audio Parameter Sets)
   addVarLengthRWDBIServices(srvDataRep, DIA_C_U16_DID_AIVI_PHONE_ECNR_NBS_BASE_SCOPE2);  //Phone_EC/NR_(NBS)
   addVarLengthRWDBIServices(srvDataRep, DIA_C_U16_DID_AIVI_PHONE_ECNR_WBS_BASE_SCOPE2);  //Phone_EC/NR_(WBS)
   addVarLengthRWDBIServices(srvDataRep, DIA_C_U16_DID_AIVI_CARPLAY_PHONE_ECNR_NBS);      //Carplay_Phone_EC/NR_(NBS)
   addVarLengthRWDBIServices(srvDataRep, DIA_C_U16_DID_AIVI_CARPLAY_PHONE_ECNR_WBS);      //Carplay_Phone_EC/NR_(WBS)
   addVarLengthRWDBIServices(srvDataRep, DIA_C_U16_DID_AIVI_CARPLAY_FACETIME_ECNR_SWB);   //Carplay_Facetime_EC/NR_(SWB)
   addVarLengthRWDBIServices(srvDataRep, DIA_C_U16_DID_AIVI_ACOUSTIC_PARAM_BASE_SCOPE2);  /* Acoustic_Parameter_(Arkamys) */   /* valid for Scope 2.0, keep in Scope 2.1 also (due to customer request) */
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   addVarLengthRWDBIServices(srvDataRep, DIA_C_U16_DID_AIVI_VR_PARAM_AUTO_BARGE_IN_SCOPE2, TRUE);  //VR Parameter (auto-barge-in) (Nuance) - Will not be written in customer plant, will be written in Bosch production.
#endif

#ifndef __DIA_UNIT_TESTING__
   //RTC-5990073 Cleanup Activity//check for Sigma feature and add the DIDs for Sigma if available
   //if(dia_Sigma::isConfigured())
   //{
   //	addSigmaServices(srvDataRep);
   //}
#endif
   loadServiceInfo(srvDataRep);

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------
const std::map<const tU16, const tU16> dia_EngineConfigGen3g::_Conflict_DID_to_PrjSpecific_DID_Map =
{
   //  { Conflicting DID, Project Specific Map DID }
   { DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_VICTIM_D010, DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_MAP_D010},
   { DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_VICTIM_D002, DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_MAP_D002}
};

//-----------------------------------------------------------------------------

void dia_EngineConfigGen3g::addVarLengthRWDBIServices(std::vector<ServiceDataItem>& srvDataRep, tU16 u16DID, tBool bReadOnly) const
{
   //lint -e785 stc2hi: the array of supported sessions only provides initializers for the supported session. other fields are automatically initialized with 0

   ServiceDataItem readService =
   {
      DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
      u16DID, 2,
      DIA_C_U8_RUNLEVEL_1,
      {0x01, 0x60}, //Default session & Production session
      {DIA_EN_SECURITY_LEVEL_ALD_CMC}
   };

   ServiceDataItem writeService =
   {
      DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER,
      u16DID, 2,
      DIA_C_U8_RUNLEVEL_1,
      {0x60}, //Production session
      {DIA_EN_SECURITY_LEVEL_ALD_CMC}
   };

   //lint +e785

#if 0 //Full 20K
   for (tU8 i = 0; i < 93; i++)
#else //Only 4K
   for (tU8 i = 0; i < 19; i++)
#endif
   {

      auto it = _Conflict_DID_to_PrjSpecific_DID_Map.find((u16DID|i));
      
      if(it != _Conflict_DID_to_PrjSpecific_DID_Map.end())
      {
         readService.mDID = writeService.mDID = it->second;
      }
      else
      {
         readService.mDID = writeService.mDID = u16DID | i;
      }
      srvDataRep.push_back(readService);

      if(bReadOnly == FALSE)
      {
         srvDataRep.push_back(writeService);
      }
   }
}

//-----------------------------------------------------------------------------

/*void dia_EngineConfigGen3g::addSigmaServices(std::vector<ServiceDataItem>& srvDataRep) const //RTC-5990073 Cleanup Activity
{
   ServiceDataItem sigmaServiceDataInfoRep[] =
   {
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_00,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VSS data 00
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_01,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VSS data 01
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_02,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VSS data 02
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_01,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_02,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_03,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_04,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_05,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_06,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_07,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_08,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_09,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_10,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_11,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_12,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_13,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_14,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_15,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_16,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_17,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_18,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_19,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_20,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_21,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_22,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_23,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_24,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_25,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_26,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_27,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_28,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_29,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_30,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_31,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - VTD data
      { 0x22, DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_32,                0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} } // ReadDataByIdentifier - VTD data
   };
   tU16 repSize = sizeof(sigmaServiceDataInfoRep) / sizeof(sigmaServiceDataInfoRep[0]);
   DIA_TR_INF("##### ADDING SIGMA SERVICES !!! #####");
   for (int i=0; i<repSize; i++)
   {
      srvDataRep.push_back(sigmaServiceDataInfoRep[i]);
   }
} */

//-----------------------------------------------------------------------------

//kaa1hi 2016-04-04 dia_EngineServerConfiguration::validateRequest shall be used.
#if 0
tDiaResult
dia_EngineConfigGen3g::validateRequest ( const dia_MessageBuffer& request, const dia_Session* /*pSession*/, const std::list<dia_SecurityLevel*>& /*securityLevels*/ ) const
{
   dia_tclFnctTrace trc("dia_EngineConfigGen3g::validateRequest(dia_MessageBuffer,pSession,pSecLevel)");

   tDiaResult rc = DIA_SUCCESS;

   // at this time we only support a certain protocol
   if ( validateProtocol(request) != DIA_SUCCESS )
   {
      DIA_TR_INF("### PROTOCOL %d NOT SUPPORTED ###", request.getProtocol());
      rc = DIA_FAILED;
   }
   else
   {
      tU8  sid = request.getDataU8(1);
      tU16 len = request.u16GetDataLength()-1; /* length byte removed */

      DIA_TR_INF("### VALIDATING UDS REQUEST SID=0x%x, LEN=%d ###", sid, len);

      rc = validateLengthOrFormat(sid, len);
      if (DIA_SUCCESS!=rc)
      {
         DIA_TR_ERR("### LENGHT OR FORMAT INVALID ### rc=0x%08X", rc);
      }
      else
      {
         rc = DIA_E_ACCESS_SERVICE_NOT_SUPPORTED;
         dia_EngineServer* pEngine = dynamic_cast<dia_EngineServer*>(mpEngine);

         if ( pEngine )
         {
            if ( pEngine->getActiveSession() )
            {
               dia_Session* pSession = pEngine->getActiveSession();

               tDiaResult retCodeService = isServiceAllowed(sid,len,pSession->getID());
               if ( retCodeService != DIA_SUCCESS )
               {
                  DIA_TR_INF("### SERVICE NOT ALLOWED (ERR=0x%08x) ###", retCodeService);
                  rc = retCodeService;
               }
               else
               {
                  // here we know that the service itself is supported, so we now need to check the subfunction
                  dia_LookupKeyUDS key(request);

                  rc = isAccessAllowed(key);
               }
            }
         }
      }
   }

   DIA_TR_INF("dia_EngineConfigGen3g::validateRequest returned 0x%08X", rc);

   return rc;
}
#endif
