/*!
 * \file       dia_SubsystemDiagnosisStrategyDefault.h
 *
 * \brief      default strategy used for subsystem diagnosis
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2), Kirty Mayank (RBEI/ECA2)
 *
 * \date       23.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY_DEFAULT__
#define __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY_DEFAULT__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY_CORE__
#include <project/framework/cis/subsystem/dia_SubsystemDiagnosisStrategyCore.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__
#include <common/framework/cis/subsystem/dia_defsSubsystemDiagnosis.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif

class dia_SubsystemDiagnosisStrategyDefault
	: public SubsystemDiagnosisStrategyCore,
	  public dia_ISessionListenerImpl
{
public:
	//! Class Constructor
	dia_SubsystemDiagnosisStrategyDefault ( std::string& name , tU32 Id );
	//! Class Destructor
	virtual ~dia_SubsystemDiagnosisStrategyDefault ( void );
	
	//! 2nd level construction/destruction
	virtual tDiaResult setup ( void );
	virtual tDiaResult teardown ( void );
	
	//! process a subsystem session activation request
	virtual tDiaResult activateSubsystemSession ( void );
	//! process a subsystem session deactivation request
	virtual tDiaResult deactivateSubsystemSession ( void );
	//! process a request to discover entities
	virtual tDiaResult identyfyAllSubsystems ( void );
	//! process a request to discover entities request result
	virtual tDiaResult identyfyAllSubsystemsRequestResult( void );
	//! process a request to connect to subsystem
	virtual tDiaResult connectToSubsystem ( std::vector<tU8>& IP );
	//! process a route request
	virtual tDiaResult routeRequestToSubsystem ( std::vector<tU8>& diagRequest );
	
	//! called by the session control object to notify about a session change
	virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );
	
	virtual tDiaResult readSubsystemNodeList( void );


protected:
   //! depricated class constructor 
   dia_SubsystemDiagnosisStrategyDefault ( void );

   //! register for session changes
   virtual tDiaResult registerSessionChange( void );
   //! unregister for session changes
   virtual tDiaResult unregisterSessionChange( void );
   //! validate the discover entities request
   virtual tDiaResult validateIdentifyEntitiesRequest ( void );
   //! validate the discover entities request result
   virtual tDiaResult validateIdentifyEntitiesRequestResult ( void );
   //! validate the subsystem connect request
   virtual tDiaResult validateSubsystemConnectRequest ( std::vector<tU8>& data );
   //! validate the subsystem route request
   virtual tDiaResult validateSubsystemRouteRequest ( std::vector<tU8>& data );
   
   virtual tDiaResult validateReadSubsytemNodeList ( void );

   virtual tDiaResult acceptEvent ( dia_SubsystemDiagnosisFSM::FsmEvent event, void* pArg );
	
};

#endif /* __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY_DEFAULT__ */
