/*!
 * \file       dia_SubsystemDiagnosisStrategy.cpp
 *
 * \brief      subsystem strategy used for subsystem diagnosis
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       23.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY__ 
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisStrategy.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__
#include <project/framework/cis/subsystem/dia_SubsystemDiagnosisManager.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER_PLUGIN__
#include <project/framework/cis/subsystem/dia_SubsystemDiagnosisManagerPlugin.h>
#endif

//-----------------------------------------------------------------------------

SubsystemDiagnosisStrategy::SubsystemDiagnosisStrategy ( const std::string& name, tU32 Id )
   : mStrategyName(name),
     mStrategyID(Id),
     mpPlugin(0)
{
   dia_tclFnctTrace oTrace("dia::SubsystemDiagnosisStrategy::SubsystemDiagnosisStrategy(const std::string& name, tU32 Id)");
}

//-----------------------------------------------------------------------------

SubsystemDiagnosisStrategy::SubsystemDiagnosisStrategy ( const char* name, tU32 Id )
   : mStrategyName(name),
	 mStrategyID(Id),
     mpPlugin(0)
{
   dia_tclFnctTrace oTrace("dia::SubsystemDiagnosisStrategy::SubsystemDiagnosisStrategy(const char*, tU32 Id)");
}

//-----------------------------------------------------------------------------

SubsystemDiagnosisStrategy::~SubsystemDiagnosisStrategy ( void )
{
   _BP_TRY_BEGIN
   {
      mpPlugin = 0;
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia::SubsystemDiagnosisStrategy::~SubsystemDiagnosisStrategy !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

const std::string&
SubsystemDiagnosisStrategy::getName ( void ) const
{
   return mStrategyName;
}
