/*!
 * \file       dia_SubsystemDiagnosisManagerPlugin.cpp
 *
 * \brief      Manager Plugin class that provides capabality to do pre & post process activities
 *			   for the subsystem identify, connect & routing functions
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       19.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER_PLUGIN__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisManagerPlugin.h"
#endif

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemDiagnosisManagerPlugin::preprocessIdentify ( void ) const
{
   dia_tclFnctTrace trc("dia_SubsystemDiagnosisManagerPlugin::preprocessIdentify()");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemDiagnosisManagerPlugin::postprocessIdentify ( void ) const
{
   dia_tclFnctTrace trc("dia_SubsystemDiagnosisManagerPlugin::postprocessIdentify()");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemDiagnosisManagerPlugin::preprocessConnect ( void ) const
{
   dia_tclFnctTrace trc("dia_SubsystemDiagnosisManagerPlugin::preprocessConnect()");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemDiagnosisManagerPlugin::postprocessConnect ( void ) const
{
   dia_tclFnctTrace trc("dia_SubsystemDiagnosisManagerPlugin::postprocessConnect()");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemDiagnosisManagerPlugin::preprocessRoute ( void ) const
{
   dia_tclFnctTrace trc("dia_SubsystemDiagnosisManagerPlugin::preprocessRoute()");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemDiagnosisManagerPlugin::postprocessRoute ( void ) const
{
   dia_tclFnctTrace trc("dia_SubsystemDiagnosisManagerPlugin::postprocessRoute()");

   return DIA_SUCCESS;
}


