/*!
 * \file       dia_SubsystemDiagnosisDoIPClient.h
 *
 *
 * \brief      ...
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Kirty Mayank (RBEI/ECA2), Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       25.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_DOIP_CLIENT__
#define __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_DOIP_CLIENT__ 

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__
#include <project/framework/cis/subsystem/dia_defsSubsystemDiagnosis.h>
#endif

#ifndef DOIP_TESTER_H
#include "doipclient/DoIP_Tester.h"
#endif

#ifndef DOIP_NODE_H_
#include "doipclient/DoIP_Node.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS__
#include "project/interfaces/dia_ISubsystemDiagnosis.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_PROXY__
#include "project/interfaces/dia_ISubsystemDiagnosisProxy.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_PROXY_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisProxyListener.h"
#endif

class dia_SubsystemDiagnosisDoIPClient
	: public DoIP_Tester,
	  public dia_ITimerListener,
	  public dia_ISubsystemDiagnosis,
	  public dia_ISubsystemDiagnosisProxyListenerImpl,
	  protected DoIP_Node::IDoIPCallback
{
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SubsystemDiagnosisDoIPClient);
public:
	//! class constructor
	dia_SubsystemDiagnosisDoIPClient(const char* pszDevice, tU16 u16Port, tU16 testerAddress, DoIP_Cfg &doipCfg);
	//! class destructor
	virtual ~dia_SubsystemDiagnosisDoIPClient(void);
	
	//! overloaded functions of DoIP Tester
    virtual DoIP_Node* vAddNode(DoIP_Node* node);
    virtual DoIP_Node* vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, tU32 maxDataSize);
    virtual DoIP_Node* vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, const tU8* EID, const tU8* GID, const tU8* VIN, DoIP_NodeType nodeType, tU32 maxDataSize);
	
	//! start/open the UDP threads/sockets
	virtual bool startDoIPComm();
	
	//! stop/close the UDP threads/sockets
	virtual bool stopDoIPComm();
	
	virtual void discoverEntities();
	
	//! check ifthe node is available
	virtual bool isNodeAvailable(tU32 mNodeIP);
	
	//!
	virtual void setCurrentNode(tU32 mNodeIP);
	
	virtual bool isNodeAlreadyConnected(tU32 mNodeIP);
	
	//! create TCP socket for the requested node
	virtual bool createNodeTCPSocket(tU32 mNodeIP);
	
	//! connect to TCP socket of the requested node
	virtual bool connectNodeTCP(tU32 mNodeIP);
	
	//! close the TCP socket of the requested node
	virtual bool closeNodeTCPSocket();
	
	//! send a diagnostic request to requested node
	virtual bool diagSendRequest(tU32 mNodeIP, std::vector<tU8> mSubSysDiagReq);
	
	//! send the entity status request to the requested node
	virtual bool diagSendEntityStatusReq(tU32 mNodeIP);
	
	//! send the power mode request to the requested node
	virtual bool diagSendPowerModeReq(tU32 mNodeIP);
	
	//! send the power mode request to the requested node
	virtual bool diagSendRoutingActivationReq(tU32 mNodeIP);
	
	//! diagnostic response for the requested command from connected subsystem
	virtual void onNodeDiagnosticResponse(tU8 const * data, tU32 U32len) override;
	
	//! routing activation response from the subsystem
	//virtual void activationResp(tU8 respCode);
	
	//! diagnostic acknowledgement (+ve) from the subsystem
	//virtual void diagnosticACK(tU8 ackCode, tU8* data = NULL, tU32 U32len = 0);
	
	//! diagnostic acknowledgement (-ve) from the subsystem
    //virtual void diagnosticNACK(tU8 nackCode, tU8* data = NULL, tU32 U32len = 0);
	
	//! powermode response from the subsystem
	//virtual void powermodeResp(const tU8 pwrMode, sockaddr_in& remoteaddr);
	
	//! on routing activation response
	virtual void onRoutingActivationResponse(tU8 respCode) override ;
	//! on power mode response
	virtual void onPowerModeRequestResponse(tU8 pwrMode) override ;
	
	//! check if the doip list is empty
	virtual bool isDoIPListEmpty( void );
	virtual void clearDoIPNodeList( void );
	
	//! Method to extract DoIP client nodes
	virtual std::list<dia_tSubsystemInfo> getDoIPClientNodes(void);
	
	virtual void enableTesterPresent( void );
	virtual void disableTesterPresent( void );
	virtual void sendTesterPresentRequest( void );
	
	//! timer start/stop functions
	virtual void stopDiscoverEntitiesDelayTimer ( void );
	virtual void startDiscoverEntitiesDelayTimer ( void );
	
	virtual void stopPowerModeRequestDelayTimer ( void );
	virtual void startPowerModeRequestDelayTimer ( void );
	
	virtual void stopRoutingActivationDelayTimer ( void );
	virtual void startRoutingActivationDelayTimer ( void );
	
	virtual void stopSubsystemRoutingDelayTimer ( void );
	virtual void startSubsystemRoutingDelayTimer ( void );
	
	//! methods to get timer id's
	virtual tU32 getTimerId_IE() { 	return mIEDelayTimerID; 	}
	virtual tU32 getTimerId_PMR(){ 	return mPMRDelayTimerID; 	}
	virtual tU32 getTimerId_RA() { 	return mRADelayTimerID; 	}
	virtual tU32 getTimerId_RR() { 	return mRRDelayTimerID; 	}
	
	//! set up callback to the parent
	struct ICallback
	{
		public:
			//! callback to parent on response from subsystem
			virtual void onDiagnosticResponse(tU8 const * data, tU32 U32len) = 0;
			//! on timeout of the timers
			virtual void onTimeout(tU32 timerID) = 0;
			//! on routing activation response
			virtual void onRAResponse(tU8 respCode) = 0;
			//! on power mode response
			virtual void onPMRResponse(tU8 respCode) = 0;
		
		protected:
			//! destructor
			virtual ~ICallback() {}
	};
	
	virtual void setCallback(ICallback* cbk) { mpCallback = cbk; }
	
	//! overloaded method from class dia_ITimerListener
    virtual void vOnTimerElapsed ( dia_TimerID id );
	
protected:
	//! callback with set socket options result
	virtual void onStartUDPComm ( tDiaResult /* result */ ) override;
	virtual void onBroadcastVehIdResults ( tDiaResult /* result */, ::std::vector< subsystem > /*nodeList */ ) override;
	
protected:
	//! callback handle
	ICallback* mpCallback;
	
protected:
	//! Tester Present timer object
	dia_Timer oTesterPresentTimer;
	//! Tester present Timer ID
	tU32 mTesterPresentTimerID;
	//! Local Variable to handle Tester PResent
	bool mIsTesterPresentActive;
	//! Timer Object for Identify Entities Delay
	dia_Timer oIEDelayTimer;
	//! Timer Id for Identify Entities Delay
	tU32 mIEDelayTimerID;
	//! Timer Object for Power Mode Request Delay
	dia_Timer oPMRDelayTimer;
	//! Timer Id for Power Mode Request Delay
	tU32 mPMRDelayTimerID;
	//! Timer Object for Routing Activation Delay
	dia_Timer oRADelayTimer;
	//! Timer Id for Routing Activation Delay
	tU32 mRADelayTimerID;
	//! Timer Object for Subsystem Request Routing Delay
	dia_Timer oRRDelayTimer;
	//! Timer Id  for Subsystem Request Routing Delay
	tU32 mRRDelayTimerID;
	//! size of entity id
	tU32 mSizeInBytes;
	//! list of nodes
	std::list<dia_tSubsystemInfo> mDoipNodes;

	DoIP_Node* poNode;
private:
	//! Current DoIP node in use
	DoIP_Node* pmActiveDoIP_Node;
	
private:
	//! internal timer to handle request and response from slave process
	dia_Timer oSlaveProcessTimer;
	//! Tester present Timer ID
	tU32 mSlaveProcessTimerID;
	
	void vFetchNodeListFromSlaveProcess();
};


#endif /*__INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_DOIP_CLIENT__*/
