/*!
 * \file       dia_defsSubsystemLogoInstallation.h
 *
 * \brief      subsystem logo installation defines
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       13.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#define __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__
#include <project/framework/cis/subsystem/dia_defsSubsystemDiagnosis.h>
#endif

#define DIA_C_SUBSYSTEM_LOGO_INSTALLATION_GID_GLASS_CODE						((tU16) 0x0006)

#define DIA_E_SUBSYSTEM_LOGO_INSTALLATION_DOIP_CLIENT_NOT_AVAILABLE             ((tU32) 0xa2a5177f)  
#define DIA_E_SUBSYSTEM_LOGO_INSTALLATION_INCORRECT_CONDITIONS                  ((tU32) 0x7ba46ba7)  
#define DIA_E_SUBSYSTEM_LOGO_ALREADY_REQUESTED                                  ((tU32) 0x9d6f9687)  

//! logo installation response codes
#define DIA_E_SUBSYSTEM_LOGO_INSTALLATION_RUNNING								((tU32) 0xb8c95b06)
#define DIA_E_SUBSYSTEM_LOGO_INSTALLATION_ABORTED								((tU32) 0x6fedc5e6)
#define DIA_E_SUBSYSTEM_LOGO_INSTALLATION_COMPLETED_NOK							((tU32) 0x81438689)
#define DIA_E_SUBSYSTEM_LOGO_INSTALLATION_COMPLETED_OK							((tU32) 0x0bacb69b)
#define DIA_E_SUBSYSTEM_LOGO_INSTALLATION_STATUS_UNKNOWN						((tU32) 0x442c7db8)

#define DIA_C_SUBSYSTEM_LOGO_INSTALLATION_POS_RESP_SRV_ID_IDX				    ((tU8) 0x00)
#define DIA_C_SUBSYSTEM_LOGO_INSTALLATION_NEG_RESP_SRV_ID_IDX				    ((tU8) 0x00)
#define DIA_C_SUBSYSTEM_LOGO_INSTALLATION_NEG_RESP_SRV_ID     				    ((tU8) 0x7F)

#define DIA_C_SUBSYSTEM_LOGO_INSTALLATION_INVALID_IP                        ((tU32) 0x00000000)


#define DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_INVALID   				    ((tU8) 0xFF)
#define DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_CIS_LOGO_INST				    ((tU8) 0x05)
#define DIA_C_SUBSYSTEM_SECURITY_ACCESS_POS_RESP_SUB_ID_IDX				    ((tU8) 0x01)
#define DIA_C_SUBSYSTEM_SECURITY_ACCESS_POS_RESP_ID      				    ((tU8) 0x67)
#define DIA_C_SUBSYSTEM_SECURITY_ACCESS_SEED_REQ_LEN     				    ((tU8) 0x02)
#define DIA_C_SUBSYSTEM_SECURITY_ACCESS_REQ_SID		     				    ((tU8) 0x27)
#define DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_DOIP_STATIC_KEY_LEN    	    ((tU8) 0x10)
#define DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_DOIP_SEED_LEN         	    ((tU8) 0x10)
#define DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_DOIP_KEY_LEN          	    ((tU8) 0x20)
#define DIA_C_SUBSYSTEM_REQUEST_DOWNLOAD_REQUEST_SID                	    ((tU8) 0x34)
#define DIA_C_SUBSYSTEM_REQUEST_DOWNLOAD_REQUEST_POS_RESP_ID           	    ((tU8) 0x74)
#define DIA_C_SUBSYSTEM_TRANSFER_DATA_REQUEST_SID                   	    ((tU8) 0x36)
#define DIA_C_SUBSYSTEM_TRANSFER_DATA_REQUEST_POS_RESP_ID              	    ((tU8) 0x76)
#define DIA_C_SUBSYSTEM_TRANSFER_EXIT_REQUEST_SID                    	    ((tU8) 0x37)
#define DIA_C_SUBSYSTEM_TRANSFER_EXIT_REQUEST_POS_RESP_ID              	    ((tU8) 0x77)

#define DIA_C_SUBSYSTEM_DEFAULT_DATA_FORMAT_IDENTIFIER                      ((tU8) 0x00)
#define DIA_C_SUBSYSTEM_DEFAULT_ADDRESS_AND_LENGTH_FORMAT_IDENTIFIER        ((tU8) 0x44)

#define UPDOWNLOADABLE_LITTLE_ENDIAN         (DIA_C_U16_DATASET_CFG_UPDOWNLOADABLE | DIA_C_U16_DATASET_CFG_CRC_FMT_LITTLE_ENDIAN)
#define UPDOWNLOADABLE_NO_CRC_CHECK          (DIA_C_U16_DATASET_CFG_UPDOWNLOADABLE | DIA_C_U16_DATASET_CFG_NO_CRC_CHECK)

#define CIS_HMI_LOGO_START             ((tU32)0x00000006)
#define CIS_HMI_LOGO_LEN               ((tU32)3*1024*1024)
#define CIS_HMI_LOGO_END               (CIS_HMI_LOGO_START + CIS_HMI_LOGO_LEN - 1)

//! Subsystem Diagnosis specific timer definitions
#define DIA_C_SUBSYSTEM_LOGO_INSTALLATION_DELAY								  5000 /* Approx. 5 Seconds */


#endif /* __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__ */
 