/*!
 * \file       dia_SubsystemLogoInstallationStrategyDefault.cpp
 *
 * \brief      default strategy used for subsystem logo installation
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       17.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY_DEFAULT__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationStrategyDefault.h"
#endif 

//! This is the helper/wrapper class which is to be implemented yet
// #ifndef __INCLUDED_DIA_DATASET__
// #include "common/framework/datadownload/dia_Dataset.h"
// #endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

//-----------------------------------------------------------------------------

dia_SubsystemLogoInstallationStrategyDefault::dia_SubsystemLogoInstallationStrategyDefault ( std::string& name )
	: dia_SubsystemLogoInstallationStrategyCore(name)
{}

//-----------------------------------------------------------------------------

dia_SubsystemLogoInstallationStrategyDefault::~dia_SubsystemLogoInstallationStrategyDefault ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationStrategyDefault::setup ( void )
{
	dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::setup");
	
	return registerSessionChange();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationStrategyDefault::teardown ( void )
{
	dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::teardown");
	
	return unregisterSessionChange();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationStrategyDefault::acceptEvent ( dia_CISStartupLogoInstallationFSM::FsmEvent event, void* pArg )
{
	dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::acceptEvent(dia_CISStartupLogoInstallationFSM::FsmEvent,void*)");

	if ( !mpFSM )  return DIA_E_FSM_NOT_AVAILABLE;
	
	mErrorCode = DIA_E_NO_ERROR;
	
	DIA_TR_INF("dia_SubsystemLogoInstallationStrategyDefault::acceptEvent - State (before): %s, event = '%d'", mpFSM->getStateName(),event);
	mpFSM->acceptEvent(event,pArg);
	DIA_TR_INF("dia_SubsystemLogoInstallationStrategyDefault::acceptEvent - State (after): %s", mpFSM->getStateName());
	
	return mErrorCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationStrategyDefault::startLogoInstallation (void)
{
   dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::startLogoInstallation(void)");

   tDiaResult retCode = validateLogoInstallationRequest();
   
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_SubsystemLogoInstallationStrategyDefault: FAILED (DATA VALIDATION) !!");
      return retCode;
   }
   
   return start();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationStrategyDefault::requestLogoInstallationResults( void )
{
   dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::requestLogoInstallationResults");
   
   tDiaResult retCode = validateLogoInstallationRequestResult();
   
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_SubsystemLogoInstallationStrategyDefault: FAILED (DATA VALIDATION) !!");
      return retCode;
   }
   
   return requestResults();
}

//----------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationStrategyDefault::validateLogoInstallationRequest ( void )
{
   dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::validateLogoInstallationRequest");
   
   // We can once check here itself, if the file exists!

   return DIA_E_NO_ERROR;
}

//----------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationStrategyDefault::validateLogoInstallationRequestResult ( void )
{
   dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::validateLogoInstallationRequestResult");

   return DIA_E_NO_ERROR;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationStrategyDefault::registerSessionChange ( void )
{
   dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::registerSessionChange");

   tDiaResult retVal = DIA_FAILED;

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      if( pEngine->getSessionController()->addListener(this))
      {
         retVal = DIA_SUCCESS;
      }
   }

   if(DIA_SUCCESS != retVal)
   {
      DIA_TR_ERR("!!! dia_SubsystemLogoInstallationStrategyDefault::registerSessionChange => ERROR: Unable to register for Session changes");
   }

   return retVal;
}

//-----------------------------------------------------------------------------

void
dia_SubsystemLogoInstallationStrategyDefault::vOnSessionChanged ( tU8 newSession, tU8 oldSession )
{
   dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::vOnSessionChanged()");

   //terminate LOGO INSTALLATION if session is switched
   if( DIA_C_U8_UDS_SESSION_EXTENDED != newSession)
   {
      if (mpFSM)
      {
         DIA_TR_INF("::vOnSessionChanged session change from %d to %d in state '%s'", oldSession, newSession, mpFSM->getStateName());

         mpFSM->acceptEvent(dia_CISStartupLogoInstallationFSM::evSessionChange,0);
      }
      else
      {
         DIA_TR_ERR("::vOnSessionChanged => ERROR: FSM IS NULL!!!");
      }
   }
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationStrategyDefault::unregisterSessionChange ( void )
{
   dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationStrategyDefault::unregisterSessionChange");

   tDiaResult retVal = DIA_FAILED;

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      if( pEngine->getSessionController()->removeListener(this))
      {
         retVal = DIA_SUCCESS;
      }
   }

   if(DIA_SUCCESS != retVal)
   {
      DIA_TR_ERR("!!! dia_SubsystemLogoInstallationStrategyDefault::unregisterSessionChange => ERROR: Unable to deregister for Session changes");
   }

   return retVal;
}
