/*!
 * \file       dia_SubsystemLogoInstallationStrategyCore.h
 *
 * \brief      strategy used for subsystem diagnosis
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       16.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY_CORE__
#define __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY_CORE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY__ 
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationStrategy.h"
#endif

#ifndef __INCLUDED_DIA_CISSTARTUPLOGOINSTALLATIONFSM__
#include <project/framework/fsm/generated/dia_CISStartupLogoInstallationFSM.h>
#endif

/*
#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_LOGO_INSTALLATION_LISTENER__
#include "project/interfaces/dia_ISubsystemLogoIstallationListener.h"
#endif
*/

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisListener.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DOIP_CLIENT__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationDoIPClient.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

//! Glass List with Logo Installation Status
struct SubsystemLogoInstCfgItem
{
	dia_tSubsystemInfo Node;
	bool logoInstallationDone;
	bool logoInstallationSucceeded;
	
	SubsystemLogoInstCfgItem():
	   logoInstallationDone(false),
	   logoInstallationSucceeded(false)
	{}
	
	~SubsystemLogoInstCfgItem(){}
};


class dia_SubsystemLogoInstallationStrategyCore
	: public SubsystemLogoInstallationStrategy,
	  protected dia_CISStartupLogoInstallationFSM::FsmBehaviour,
	  protected dia_SubsystemLogoInstallationDoIPClient::ICallback
	  //public dia_ITimerListener
{
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SubsystemLogoInstallationStrategyCore);

public:
	//! Class Constructor
	dia_SubsystemLogoInstallationStrategyCore ( std::string& name );
	//! Class Constructor
	dia_SubsystemLogoInstallationStrategyCore ( char* name );
	//! Class Destructor
	virtual ~dia_SubsystemLogoInstallationStrategyCore ( void );
	
	//! process a subsystem session activation request
	virtual tDiaResult startLogoInstallation ( void ) = 0;
	//! process a subsystem session deactivation request
	virtual tDiaResult requestLogoInstallationResults ( void ) = 0;
	
	//! overloaded method from class dia_ITimerListener
    //virtual void vOnTimerElapsed ( dia_TimerID id );
	
protected:
	//! depricated constructor
	dia_SubsystemLogoInstallationStrategyCore ( void );
	
	tDiaResult start ( void );
	tDiaResult requestResults ( void );
	
	// FSM actions
    virtual void assembleData ( void* /* pArg */ );
    virtual void calcKey ( void* /* pArg */ );
    virtual void chkIfLogoTrnsfrToAllDone ( void* /* pArg */ );
    virtual void chkVehicle ( void* /* pArg */ );
	virtual void closeCurrentConnection ( void* /* pArg */ );
    virtual void connectToVehicle ( void* /* pArg */ );
    virtual void evaluateRequestDownloadResponse ( void* /* pArg */ );
    virtual void evaluateResponseTransferData ( void* /* pArg */ );
    virtual void evaluateResponseTransferExit ( void* /* pArg */ );
    virtual void getNextBlock ( void* /* pArg */ );
    virtual void onFailedPowerMode ( void* /* pArg */ );
    virtual void onFailedRoutingActivation ( void* /* pArg */ );
	virtual void onRoutingActivationSuccess ( void* /* pArg */ );
    virtual void postprocessLogoInstallation ( void* /* pArg */ );
    virtual void postprocessRequestDownloadResp ( void* /* pArg */ );
    virtual void postprocessSecurityUnlock ( void* /* pArg */ );
    virtual void postprocessSeedResponse ( void* /* pArg */ );
    virtual void postprocessSessionSwitch ( void* /* pArg */ );
    virtual void postprocessTransferDataResp ( void* /* pArg */ );
    virtual void postprocessTransferExitResp ( void* /* pArg */ );
    virtual void postprocessVehicleConnected ( void* /* pArg */ );
    virtual void prepareDownload ( void* /* pArg */ );
    virtual void prepareLogoInstallation ( void* /* pArg */ );
    virtual void prepareNextLogoTransfer ( void* /* pArg */ );
    virtual void prepareSecurityUnlock ( void* /* pArg */ );
    virtual void prepareTransferData ( void* /* pArg */ );
    virtual void reset ( void* /* pArg */ );
    virtual void selectVehicleForLogoDownload ( void* /* pArg */ );
    virtual void sendErr_AlreadyRequested ( void* /* pArg */ );
    virtual void sendErr_ConditionsNotCorrect ( void* /* pArg */ );
	virtual void sendErr_InstallationAborted ( void* pArg );
    virtual void sendRequestDownload ( void* /* pArg */ );
    virtual void sendRequestExtSessionChange ( void* /* pArg */ );
    virtual void sendRequestPowerMode ( void* /* pArg */ );
    virtual void sendRequestRoutingActivation ( void* /* pArg */ );
    virtual void sendRequestSecurityKey ( void* /* pArg */ );
    virtual void sendRequestSecuritySeed ( void* /* pArg */ );
    virtual void sendRequestTransferData ( void* /* pArg */ );
    virtual void sendRequestTransferExit ( void* /* pArg */ );
    virtual void sendReqVI ( void* /* pArg */ );
    virtual void sendRoutineFinalResponse ( void* /* pArg */ );
    virtual void sendRoutineRunningResponse ( void* /* pArg */ );
    virtual void setInstallationActivated ( void* /* pArg */ );
    virtual void startDoIPClient ( void* /* pArg */ );
    virtual void startTimerPowerMode ( void* /* pArg */ );
    virtual void startTimerRequestDownload ( void* /* pArg */ );
    virtual void startTimerRoutingActivation ( void* /* pArg */ );
    virtual void startTimerSecurityKey ( void* /* pArg */ );
    virtual void startTimerSecuritySeed ( void* /* pArg */ );
    virtual void startTimerSessionSwitch ( void* /* pArg */ );
    virtual void startTimerTransferData ( void* /* pArg */ );
    virtual void startTimerTransferExit ( void* /* pArg */ );
    virtual void startTimerVI ( void* /* pArg */ );
    virtual void stopLogoInstallation ( void* /* pArg */ );
    virtual void stopTimerPowerMode ( void* /* pArg */ );
    virtual void stopTimerRequestDownload ( void* /* pArg */ );
    virtual void stopTimerRoutingActivation ( void* /* pArg */ );
    virtual void stopTimerSecurityKey ( void* /* pArg */ );
    virtual void stopTimerSecuritySeed ( void* /* pArg */ );
    virtual void stopTimerSessionSwitch ( void* /* pArg */ );
    virtual void stopTimerTransferData ( void* /* pArg */ );
    virtual void stopTimerTransferExit ( void* /* pArg */ );
    virtual void validateLogoInstallationRequest ( void* /* pArg */ );
    virtual void validateSecurityKeyReponse ( void* /* pArg */ );
    virtual void validateSecuritySeedReponse ( void* /* pArg */ );
    virtual void validateSessionChangeReponse ( void* /* pArg */ );
    virtual void validateVehicleList ( void* /* pArg */ );
    virtual void vHandleDataError ( void* /* pArg */ );
    virtual void vHandleFinalResponse ( void* /* pArg */ );
    virtual void vHandleRequestDownloadError ( void* /* pArg */ );
    virtual void vHandleRequestDownloadTimeout ( void* /* pArg */ );
    virtual void vHandleRequestSeedError ( void* /* pArg */ );
    virtual void vHandleSecurityKeyError ( void* /* pArg */ );
    virtual void vHandleSecurityKeyTimeout ( void* /* pArg */ );
    virtual void vHandleSecuritySeedTimeout ( void* /* pArg */ );
    virtual void vHandleSessionChangeError ( void* /* pArg */ );
    virtual void vHandleSessionChangeTimeout ( void* /* pArg */ );
    virtual void vHandleSessionRequest ( void* /* pArg */ );
    virtual void vHandleTransferDataError ( void* /* pArg */ );
    virtual void vHandleTransferDataTimeout ( void* /* pArg */ );
    virtual void vHandleTransferExitError ( void* /* pArg */ );
    virtual void vHandleTransferExitTimeout ( void* /* pArg */ );
    virtual void vHandleVehicleConnectError ( void* /* pArg */ );
    
    // FSM guards
    virtual bool areInstallationConditionsOk ( void* /* pArg */ );
    virtual bool bFsmIsDataTransferComplete ( void* /* pArg */ );
    virtual bool bIsPowerModeOk ( void* /* pArg */ );
    virtual bool bIsRoutingActivationOk ( void* /* pArg */ );
    virtual bool isClientActivationOk ( void* /* pArg */ );
    virtual bool isFinalResponseReady ( void* /* pArg */ );
    virtual bool isTCPSocketOk ( void* /* pArg */ );
    virtual bool isVehicleListEmpty ( void* /* pArg */ );
    virtual bool isVehicleListValid ( void* /* pArg */ );
    virtual bool isVehicleValid ( void* /* pArg */ );
	 
    //! Callbacks of the DOIP Client
    virtual void onDiagnosticResponse (tU8 const * data, tU32 U32len) override;
    virtual void onTimeout (tU32 timerID) override;
    virtual void onRAResponse(tU8 respCode) override;
    virtual void onPMRResponse(tU8 pwrMode) override;
   
	
protected:
	//! pointer to the FSM Object used for Subsystem Logo Installation
    dia_CISStartupLogoInstallationFSM::Fsm* mpFSM;
	
	//! pointer to the DoIP Client Object used for Subsystem Logo Installation
	dia_SubsystemLogoInstallationDoIPClient* mpDoIPClient;
		
	//! error code
    tDiaResult mErrorCode;
	tDiaResult mStatusCode;
	
	//! Glass Node List
	//std::list<dia_tSubsystemInfo> mGlassNodeList;
	
	std::list<SubsystemLogoInstCfgItem> mGlassLogoInstCfgRepo;
	
	//! Flags
	bool mInstCondChkStat;
	bool mDataTransferCompletionStat;
	bool mPowerModeStat;
	bool mRoutingActivationStat;
	bool mDoIPClientActivStat;
	bool mFinalResponseStat;
	bool mTcpSocketStat;
	bool mVehicleListEmptyStat;
	bool mVehicleListValidity;
	bool mVehicleValidity;
	bool mLogoTrnsfrToAllDone;

/*
private:
	//! Timer Object for setting identify entities request results response
	dia_Timer oResponseTimer;
	//! Timer Id for Identify entities request results response
	tU32 mResponseTimerID;
	//! Timer functions that will send the response to the srv handler
	void vStartResponseTimer( void );
	//! Timer functions that will send the response to the srv handler
	void vStopResponseTimer( void );
	*/
	//! Update the logo installation status of the subsystem in repo
	void vUpdateSubsystemLogoInstallationStatus(tU32 /* IP */, bool /* status */);
	//! Update the logo installation success status
	void vUpdateSubsystemLogoInstallationCompletionStatus(tU32 /* IP */, bool /* status */);
	//! local fn to update all status at once
	void vUpdateSubsystemStatusFailed();
	void vUpdateSubsystemStatusSucceeded();
	
	void vOnLogoTransferWaitOver();

};


#endif /* __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY_CORE__ */
