/*!
 * \file       dia_SubsystemLogoInstallationStrategy.h
 *
 * \brief      Abstract strategy used for subsystem logo installation
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       16.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY__
#define __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER_PLUGIN__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationManagerPlugin.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS__
#include <project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationSecurityAccess.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DATA_DOWNLOAD__
#include <project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationDataDownload.h>
#endif

class dia_SubsystemLogoInstallationManagerPlugin;

class SubsystemLogoInstallationStrategy
{
	friend class dia_SubsystemLogoInstallationManager;
	
public:
	//! class constructor
	SubsystemLogoInstallationStrategy ( const std::string& name );
	//! class constructor
	SubsystemLogoInstallationStrategy ( const char* name );
	//! class destructor
	virtual ~SubsystemLogoInstallationStrategy ( void );
	
	//! 2nd level constructor/destructor
	virtual tDiaResult setup ( void ) { return DIA_SUCCESS; }
	virtual tDiaResult tearDown ( void ) { return DIA_SUCCESS; }
	
	//! return strategy name
	virtual const std::string& getName ( void ) const;
	
	//! process a subsystem logo installation request
	virtual tDiaResult startLogoInstallation ( void ) = 0;
	//! process a subsystem logo installation status query
	virtual tDiaResult requestLogoInstallationResults ( void ) = 0;
	
	//! return the request data for the subsystem request
	virtual const std::vector<tU8>* getRequestData ( void ) const { return &mSubSysDiagReq; }
	//! return the response data for the processed request
	virtual const std::vector<tU8>* getResponseData ( void ) const { return &mSubSysDiagRes; }
	
	//! assign the plugin used for project specific NRC handling etcetera.
	void setPlugin ( const dia_SubsystemLogoInstallationManagerPlugin& plugin ) { mpPlugin = &plugin; }
	//!
	void setSecurityAlgorithm (  SubsystemLogoInstallationSecurityAccess& pObj ) { mpSecurityAlgorithm = &pObj; }
	//!
	void setDownloader (  dia_SubsystemLogoInstallationDataDownload& pObj ) { mpDataDownloader = &pObj; }
	
protected:
	//! depricated default constructor
	SubsystemLogoInstallationStrategy ( void );
	
protected:
	//! name of the subsystem strategy
	std::string mStrategyName;
	//! configuration object to customise project specific NRC handling etcetera
	const dia_SubsystemLogoInstallationManagerPlugin* mpPlugin;
	//! pointer to the security algorithm Object used for Subsystem Logo Installation
    SubsystemLogoInstallationSecurityAccess* mpSecurityAlgorithm;
	//! pointer to the data download strategy used for Subsystem Logo Installation
    dia_SubsystemLogoInstallationDataDownload* mpDataDownloader;
	//! vector to store the diagnostic request
	std::vector<tU8> mSubSysDiagReq;
	//! vector to store the diagnostic response
	std::vector<tU8> mSubSysDiagRes;
	//! vector to store security key;
	std::vector<tU8> mKey;
	
};

#endif /* __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY__ */
