/*!
 * \file       dia_SubsystemLogoInstallationStrategy.h
 *
 * \brief      Abstract strategy used for subsystem logo installation
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       16.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY__ 
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationStrategy.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationManager.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER_PLUGIN__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationManagerPlugin.h"
#endif

//-----------------------------------------------------------------------------

SubsystemLogoInstallationStrategy::SubsystemLogoInstallationStrategy ( const std::string& name )
   : mStrategyName(name),
     mpPlugin(0),
	 mpDataDownloader(0),
	 mpSecurityAlgorithm(0)
{
   dia_tclFnctTrace oTrace("dia::dia_SubsystemLogoInstallationStrategy::dia_SubsystemLogoInstallationStrategy(const std::string& name)");
}

//-----------------------------------------------------------------------------

SubsystemLogoInstallationStrategy::SubsystemLogoInstallationStrategy ( const char* name )
   : mStrategyName(name),
     mpPlugin(0),
	 mpDataDownloader(0),
	 mpSecurityAlgorithm(0)
{
   dia_tclFnctTrace oTrace("dia::dia_SubsystemLogoInstallationStrategy::dia_SubsystemLogoInstallationStrategy(const char*)");
}

//-----------------------------------------------------------------------------

SubsystemLogoInstallationStrategy::~SubsystemLogoInstallationStrategy ( void )
{
   _BP_TRY_BEGIN
   {
      mpPlugin = 0;
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia::dia_SubsystemLogoInstallationStrategy::~dia_SubsystemLogoInstallationStrategy !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

const std::string&
SubsystemLogoInstallationStrategy::getName ( void ) const
{
   return mStrategyName;
}
