/*!
 * \file       SubsystemLogoInstallationSecurityAccess.h
 *
 * \brief      Abstract Security Access Algorithm used for subsystem logo installation
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       19.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS__
#define __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

class SubsystemLogoInstallationSecurityAccess
{
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(SubsystemLogoInstallationSecurityAccess);
	
public:
    //! class constructor
    SubsystemLogoInstallationSecurityAccess( tU8 securitylevel, tU8 seedLength, tU8 keyLength );
	
	//! depricated class destructor
    virtual ~SubsystemLogoInstallationSecurityAccess( void );
	
	//! get the seed request 
	virtual tDiaResult getSeedRequest(std::vector<tU8>& /* mySeedRequest */);
	virtual tDiaResult getKeyRequest(std::vector<tU8>& /* myKeyRequest */);
	//! initialise 
	virtual void initialize( void );
	//! finalise
	virtual void finalize( void );
	//! calculate key
	virtual tDiaResult calculateKey ( std::vector<tU8>& /* seed */, tU8* /* eid */, tU8* /* gid */) = 0;
	
	//! change the security level
	virtual void setNewSecurityLevel( tU8 level ) { _securityLevel = level; }
	//! return current security level
	virtual tU8 getCurrentSecurityLevel ( void ) { return _securityLevel; }
	virtual tU8 getSeedLength ( void ) { return _seedLength; }
	virtual tU8 getKeyLength ( void ) { return _keyLength; }
	
protected :
	std::vector<tU8> _seedRequest;
	std::vector<tU8> _seed;
	std::vector<tU8> _key;
	tU8 _securityLevel = 0xFF;
	tU8 _seedLength;
	tU8 _keyLength;
	
};

#endif /* __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS__ */
