/*!
 * \file       SubsystemLogoInstallationSecurityAccess.h
 *
 * \brief      Abstract Security Access Algorithm used for subsystem logo installation
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       19.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS__
#include <project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationSecurityAccess.h>
#endif

//-----------------------------------------------------------------------------

//! class constructor
SubsystemLogoInstallationSecurityAccess::SubsystemLogoInstallationSecurityAccess( tU8 securitylevel, tU8 seedLength, tU8 keyLength)
	:_securityLevel(securitylevel),
	_seedLength(seedLength),
	_keyLength(keyLength)
{ 
	dia_tclFnctTrace oTrace("SubsystemLogoInstallationSecurityAccess::SubsystemLogoInstallationSecurityAccess()");
	
	_seedRequest.clear();
	_seedRequest.reserve(DIA_C_SUBSYSTEM_SECURITY_ACCESS_SEED_REQ_LEN);
	_seedRequest.push_back(DIA_C_SUBSYSTEM_SECURITY_ACCESS_REQ_SID);
	_seedRequest.push_back(_securityLevel);
	
	_seed.clear();
	_seed.reserve(_seedLength);
	_key.clear();
	_key.reserve(_keyLength);
};

//-----------------------------------------------------------------------------
	
//! class destructor
SubsystemLogoInstallationSecurityAccess::~SubsystemLogoInstallationSecurityAccess( void ) 
{};
	
//-----------------------------------------------------------------------------

tDiaResult
SubsystemLogoInstallationSecurityAccess::getSeedRequest(std::vector<tU8>&  seedRequestOut )
{
	dia_tclFnctTrace oTrace("SubsystemLogoInstallationSecurityAccess::getSeedRequest(...)");
	
	tDiaResult retVal = DIA_FAILED;
	
	if(DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_INVALID != _securityLevel)
	{
		seedRequestOut.clear();
		
		for(int i = 0; i < _seedRequest.size(); ++i)
		{
			seedRequestOut.push_back(_seedRequest[i]);
		}
		retVal = DIA_SUCCESS;
	}
	
	return retVal;
	
}

//-----------------------------------------------------------------------------

tDiaResult
SubsystemLogoInstallationSecurityAccess::getKeyRequest(std::vector<tU8>&  keyRequestOut )
{
	dia_tclFnctTrace oTrace("SubsystemLogoInstallationSecurityAccess::getKeyRequest(...)");
	
	tDiaResult retVal = DIA_FAILED;
	
	if(_keyLength == _key.size())
	{
		keyRequestOut.clear();
		keyRequestOut.push_back(DIA_C_SUBSYSTEM_SECURITY_ACCESS_REQ_SID);
		keyRequestOut.push_back(_securityLevel+1);
		
		for(int i = 0; i < _key.size(); ++i)
		{
			keyRequestOut.push_back(_key[i]);
		}
		retVal = DIA_SUCCESS;
	}
	
	return retVal;
	
}

//-----------------------------------------------------------------------------

void
SubsystemLogoInstallationSecurityAccess::initialize ( void )
{
	dia_tclFnctTrace oTrace("SubsystemLogoInstallationSecurityAccess::initialize(...)");
	
	_seed.clear();
	_key.clear();
	_seedRequest.clear();
	
	_seedRequest.reserve(DIA_C_SUBSYSTEM_SECURITY_ACCESS_SEED_REQ_LEN);
	_seedRequest.push_back(DIA_C_SUBSYSTEM_SECURITY_ACCESS_REQ_SID);
	_seedRequest.push_back(_securityLevel);
		
}

//-----------------------------------------------------------------------------

void
SubsystemLogoInstallationSecurityAccess::finalize ( void )
{
	dia_tclFnctTrace oTrace("SubsystemLogoInstallationSecurityAccess::finalize(...)");
	
	_seed.clear();
	_key.clear();
	_seedRequest.clear();
}

//-----------------------------------------------------------------------------


/*
	// Copying vector by assign function 
    _seed.assign(seedIn.begin(), seedIn.end()); 
	// Using assignment operator to copy one vector to other 
    _seed = seedIn;
	// A loop to copy elements of old vector into new vector by Iterative method 
    for (int i=0; i<seedIn.size(); i++)
	{		
        _seed.push_back(seedIn[i]);
	}
*/