/*!
 * \file       dia_SubsystemLogoInstallationDataDownload.h
 *
 * \brief      Data Download Strategy used for subsystem logo installation
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       20.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DATA_DOWNLOAD__
#define __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DATA_DOWNLOAD__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_DATASET__
#include <common/framework/datadownload/dia_Dataset.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

struct dia_DatasetConfigLogo
{
	dia_DatasetConfigLogo ( tU8 logoId, tCString name, tU32 startAddr, tU32 endAddr, tU32 length, tU16 settingsMask, tU32 propID)
      : mLogoId(logoId), mName(name), mAddrStart(startAddr), mAddrEnd(endAddr), mSizeInBytes(length), mSettings(settingsMask), mPropID(propID)
   {}
   
    //! id of the data set
	tU8      mLogoId;
	 //! name of the data set
	tCString mName;
	//! logical memory start address
	tU32     mAddrStart;
	//! logical memory end address
	tU32     mAddrEnd;
	//! size of the data set in bytes. In case that the dataset might have a variable length this is the maximum size
	tU32     mSizeInBytes;
	//! bit mask with settings for the data set
	tU16     mSettings;
	//! config manager property ID
	tU32     mPropID;
};

class dia_SubsystemLogoInstallationDataDownload
{
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SubsystemLogoInstallationDataDownload);
	
public:
    //! class constructor
    dia_SubsystemLogoInstallationDataDownload( const dia_DatasetConfigLogo& cfgObj,
											   tU8 DataFormatIdentifier = DIA_C_SUBSYSTEM_DEFAULT_DATA_FORMAT_IDENTIFIER, 
											   tU8 AddressAndLengthFormatIDentifier = DIA_C_SUBSYSTEM_DEFAULT_ADDRESS_AND_LENGTH_FORMAT_IDENTIFIER
											 );
	
	//! depricated class destructor
    ~dia_SubsystemLogoInstallationDataDownload( void );
	
	//! check if the dataset might have a variable length
    virtual bool hasVariableLength ( void ) const;
    //! check if dataset was loaded from NVM
    virtual bool isLoaded ( void ) const { return mIsLoaded; }
    //! set the block size from the download request response
    virtual tDiaResult setBlockSize ( tU16 /* bs */ );
	//! check if a data transfer for this dataset is currently active
    virtual bool isDataTransferActive ( void ) const;
    //! check if the data download is complete. will return false in case that no data transfer is currently active
    virtual bool isDataTransferComplete ( void ) const;
	//! 
	virtual void postprocessTransferData( void );
	//!
	virtual void initializeDataDownload();
	virtual void finaliseDataDownload();
	
public:
	//! load the data associated with this dataset from NVM
    virtual tDiaResult load ( void );
	//! split the data into blocks
    virtual tDiaResult split ( void );
	//!
	virtual tDiaResult setNextBlock();
	//!
	virtual tDiaResult assembleData();
	//!
	virtual tDiaResult getNextTransferDataRequest(std::vector<tU8>& /* Transfer Data Request */ );
	
	virtual tDiaResult getDownloadRequest(std::vector<tU8>& /* Data Download Request */ );
	
protected :
	//! name for this data download set
	tCString mName;
	//! logical start address of data download set
	tU32 mStartAddr;
	//! length of the data download set in bytes
	tU32 mSizeInBytes;
	//! requested size for the current ongoing up-/download
	tU32 mSizeInBytesRequested;
	//! bit mask with settings for the data set
	tU16 mSettingsBitmask;
	//! ID of the associated config manager property
	tU32 mPropID;
	//! block sequence number
	tU16 mBSN;
	//! flag to indicate that a data transfer is in progress
	bool mIsDataTransferActive;
	//! flag to indicate that a data transfer is in progress
	bool mIsDataTransferComplete;
	//! vector to store the logo data
	std::vector<char> mFlashData;
	//! pointer to the byte buffer
    tU8* mpByteBuffer;
	//! loaded flag (indicates that the data was loaded from persistent memory
    bool mIsLoaded;
   
	tU32 mBlockSize;
	std::vector< std::vector<tU8> > mBlockData;
	std::vector<tU8> mNextTransferData;
	tU32 mBlockSizeInBytes;
	tU32 mCurrentBlockSize;
	tU32 mTotalNumberOfBlocks;
	tU32 mRemainingBlocks;
	tU32 mCurrentDataBlockIndex;
	tU32 mNumOfBytesTransmitted;
	tU8  mDataFmtId;
	tU8  mAddrAndLenFmtId;
};

#endif /* __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DATA_DOWNLOAD__ */
