#ifndef __INCLUDED_DIA_DEFS_PROJECT__
#define __INCLUDED_DIA_DEFS_PROJECT__

//
// Feature switches
//

#define __ENABLE_FEATURE_UDD_DRIVER_VIA_INC__

// configuration


//
// project specific diagnostic service identifiers (Robert Bosch Car Multimedia)
//

//
// project specific diagnostic service identifiers
//

#define DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET                                ((tU16) 0xDB10)
#define DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_01                             ((tU16) 0xDB11)
#define DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_02                             ((tU16) 0xDB12)
#define DIA_C_U16_DID_AIVI_ANTITHEF_MAP_SELECTION                         ((tU16) 0xDAB2)
#define DIA_C_U16_DID_AIVI_TOTAL_NUMBER_OF_REPROGRAMMING                  ((tU16) 0x1100)
#define DIA_C_U16_DID_AIVI_INITIAL_PROGRAMMING_LOG                        ((tU16) 0x1102)
#define DIA_C_U16_DID_AIVI_FIRST_USB_PROGRAMMING                          ((tU16) 0x1103)
#define DIA_C_U16_DID_AIVI_BT_NAME                                        ((tU16) 0xDAF1)
#define DIA_C_U16_DID_AIVI_CAMERA_SYSTEM                                  ((tU16) 0xDAE0)
#define DIA_C_U16_DID_AIVI_CLEAR_MCAN_CONNECTION_HISTORY                  ((tU16) 0x1010)
#define DIA_C_U16_DID_AIVI_CONFIG_HASH_VALUE                              ((tU16) 0xDEFF)
#define DIA_C_U16_DID_AIVI_DEF_ANTENNA_PARAM_SET                          ((tU16) 0x3114)
#define DIA_C_U16_DID_AIVI_DEF_ACOUSTIC_PARAM                             ((tU16) 0x3008)
#define DIA_C_U16_DID_AIVI_DEF_SYSTEM_INFO_COMMON                         ((tU16) 0x3000)
#define DIA_C_U16_DID_AIVI_DEF_SYSTEM_VEHICLE_INFO                        ((tU16) 0x3001)
#define DIA_C_U16_DID_AIVI_DEF_CAMERA_SYSTEM                              ((tU16) 0x3003)
#define DIA_C_U16_DID_AIVI_DEF_CONFIG_PARTS_NUMBER                        ((tU16) 0x3004)
#define DIA_C_U16_DID_AIVI_DEF_CONFIG_HASH_VALUE                          ((tU16) 0x3005)
#define DIA_C_U16_DID_AIVI_DEF_AUDIO_PARAM_SET                            ((tU16) 0x3006)
#define DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_WBS                             ((tU16) 0x3009)
#define DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_NBS                             ((tU16) 0x300A)
#define DIA_C_U16_DID_AIVI_DEF_WIFI_NAME                                  ((tU16) 0x300B)
#define DIA_C_U16_DID_AIVI_DEF_BT_NAME                                    ((tU16) 0x300C)
#define DIA_C_U16_DID_AIVI_DEF_ANTITHEF_MAP_SELECTION                     ((tU16) 0x300D)
#define DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GNSS                         ((tU16) 0x3104)
#define DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GYRO                         ((tU16) 0x3105)
#define DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_ACC                          ((tU16) 0x3106)
#define DIA_C_U16_DID_AIVI_DEF_ECO_ROUTE                                  ((tU16) 0x3011)
#define DIA_C_U16_DID_AIVI_DEF_FMAM_TUNER_PARAM_SET                       ((tU16) 0x3112)
#define DIA_C_U16_DID_AIVI_DEF_GENERIC_TUNER_PARAM_SET                    ((tU16) 0x3113)
#define DIA_C_U16_DID_AIVI_DEF_DAB_SET                                    ((tU16) 0x3115)
#define DIA_C_U16_DID_AIVI_DEF_HD_PARAM_SET                               ((tU16) 0x3116)
#define DIA_C_U16_DID_AIVI_DEF_MEX_CONFIG                                 ((tU16) 0x3117)
#define DIA_C_U16_DID_AIVI_DEF_FACTORY_MODE                               ((tU16) 0x3118)
#define DIA_C_U16_DID_AIVI_DEF_CONNECTIVITY_CONFIG                        ((tU16) 0x3119)
#define DIA_C_U16_DID_AIVI_DEF_HMI_CONFIG                                 ((tU16) 0x311A)
#define DIA_C_U16_DID_AIVI_DEF_SOUND_VOLUME_CONFIG                        ((tU16) 0x311B)
#define DIA_C_U16_DID_AIVI_DEF_DRM_TUNER_PARAMETER_SET                    ((tU16) 0x3103)
#define DIA_C_U16_DID_AIVI_SYSTEM_INFO_COMMON                             ((tU16) 0xDAB1)
#define DIA_C_U16_DID_AIVI_SYSTEM_VEHICLE_INFO                            ((tU16) 0xDAB0)
#define DIA_C_U16_DID_AIVI_ECO_ROUTE                                      ((tU16) 0xDAE5)
#define DIA_C_U16_DID_AIVI_MILEAGE_VALUE                                  ((tU16) 0xF0D0)
#define DIA_C_U16_DID_AIVI_CALIBRATION_XTRA_DATA_REF                      ((tU16) 0xF012)
#define DIA_C_U16_DID_AIVI_CM_ECU_SOFTWARE_NUMBER                         ((tU16) 0xF194)
#define DIA_C_U16_DID_AIVI_CM_ECU_SOFTWARE_VERSION_NUMBER                 ((tU16) 0xF195)
#define DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_ECU_HW_NR                     ((tU16) 0xF191)
#define DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_R_NR               ((tU16) 0xF187)
#define DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_N_NR               ((tU16) 0xF1A1)
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#define DIA_C_U16_DID_AIVI_CONFIG_FILE_REFERENCE_LINK_RUC                 ((tU16) 0xF188)
#define DIA_C_U16_DID_AIVI_CONFIG_PARTS_NUMBER                            ((tU16) 0xF1A2)
#else
#define DIA_C_U16_DID_AIVI_CONFIG_PARTS_NUMBER                            ((tU16) 0xF188)
#endif
#define DIA_C_U16_DID_AIVI_CONFIG_SYSTEM_SUPPLIER_NR                      ((tU16) 0xF18A)
#define DIA_C_U16_DID_AIVI_ECU_SERIAL_NUMBER_IDENTIFIER                   ((tU16) 0xF18C)
#define DIA_C_U16_DID_AIVI_NAVI_UNIT                                      ((tU16) 0x2010)
#define DIA_C_U16_DID_AIVI_HWSW_VERSION                                   ((tU16) 0xDE01)
#define DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GYRO                             ((tU16) 0xDAD0)
#define DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GNSS                             ((tU16) 0xDAD1)
#define DIA_C_U16_DID_AIVI_SENSOR_CONFIG_ACC                              ((tU16) 0xDAD2)
#define DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET                           ((tU16) 0xDAC5)
#define DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_01                        ((tU16) 0xDAC6)
#define DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_02                        ((tU16) 0xDAC7)
#define DIA_C_U16_DID_AIVI_ANTENNA_PARAM_SET                              ((tU16) 0xDACC)
#define DIA_C_U16_DID_AIVI_DAB_SET                                        ((tU16) 0xDACB)
#define DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET                        ((tU16) 0xDAC0)
#define DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_01                     ((tU16) 0xDAC1)
#define DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_02                     ((tU16) 0xDAC2)
#define DIA_C_U16_DID_AIVI_HD_PARAM_SET                                   ((tU16) 0xDAC9)
#define DIA_C_U16_DID_AIVI_OCCURENCE_COUNTER                              ((tU16) 0xF0D1)
#define DIA_C_U16_DID_AIVI_INPUT_LINES                                    ((tU16) 0x0101)
#define DIA_C_U16_DID_AIVI_KEY_PRESS_BUTTONS                              ((tU16) 0x0300)
#define DIA_C_U16_DID_AIVI_KEY_PRESS_ROTARY                               ((tU16) 0x0301)
#define DIA_C_U16_DID_AIVI_KEY_PRESS_SWS                                  ((tU16) 0x0302)
#define DIA_C_U16_DID_AIVI_KEY_PRESS_CD_DRIVE_EJECT                       ((tU16) 0x0305)
#define DIA_C_U16_DID_AIVI_TOUCH_PRESS                                    ((tU16) 0x0306)
#define DIA_C_U16_DID_AIVI_WIFI_MONITORING                                ((tU16) 0x0308)
#define DIA_C_U16_DID_AIVI_LOUDSPEAKER_TEST_TONE                          ((tU16) 0x9002)
#define DIA_C_U16_DID_AIVI_DISPLAY_TEST                                   ((tU16) 0x9005)
#define DIA_C_U16_DID_AIVI_REAR_CAMERA_ACTIVATION                         ((tU16) 0x9006)
#define DIA_C_U16_DID_AIVI_SUPPORTED_IDENTIFIER_BASE                      ((tU16) 0xDF00)
#define DIA_C_U16_DID_AIVI_SUPPORTED_IDENTIFIER                           ((tU16) 0xDFDF)
#define DIA_C_U16_DID_AIVI_SYSTEM_AMP_ON_OUTPUT                           ((tU16) 0x9009)
#define DIA_C_U16_DID_AIVI_TUNER_SETTINGS                                 ((tU16) 0x9001)
#define DIA_C_U16_DID_AIVI_TWEETER_TEST                                   ((tU16) 0x900A)
#define DIA_C_U16_DID_AIVI_SPEAKER_TEST                                   ((tU16) 0x900B)
#define DIA_C_U16_DID_AIVI_CD_EJECT                                       ((tU16) 0x9000)
#define DIA_C_U16_DID_AIVI_BATTERY_LEVEL                                  ((tU16) 0x0200)
#define DIA_C_U16_DID_AIVI_MULTIPLEX_NETWORK_DIAG                         ((tU16) 0xEF82)
#define DIA_C_U16_DID_AIVI_MULTIMEDIA_NETWORK_DIAG                        ((tU16) 0xEF85)
#define DIA_C_U16_DID_AIVI_OUTPUT_LINE                                    ((tU16) 0x0100)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_CURRENT_N                      ((tU16) 0x1110)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_1                   ((tU16) 0x1111)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_2                   ((tU16) 0x1112)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_3                   ((tU16) 0x1113)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_4                   ((tU16) 0x1114)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_5                   ((tU16) 0x1115)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_6                   ((tU16) 0x1116)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_7                   ((tU16) 0x1117)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_8                   ((tU16) 0x1118)
#define DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_9                   ((tU16) 0x1119)
#define DIA_C_U16_DID_AIVI_AUDIO_EXT_OUT_TEL_MODE                         ((tU16) 0x1501)
#define DIA_C_U16_DID_AIVI_AUDIO_EXT_OUT_HF_VR                            ((tU16) 0x1502)
#define DIA_C_U16_DID_AIVI_UNUSED_EXT_IN_DAY_NIGHT                        ((tU16) 0x1006)
#define DIA_C_U16_DID_AIVI_UNUSED_EXT_IN_WIRE_SPEED_INFO                  ((tU16) 0x1008)
#define DIA_C_U16_DID_RBCM_MICROPHONE_CONNECTION_INFO_1                   ((tU16) 0x1024)
#define DIA_C_U16_DID_AIVI_SPEED_LOCKOUT                                  ((tU16) 0x2301)
#define DIA_C_U16_DID_AIVI_MEX_CONFIG                                     ((tU16) 0x2123)
#define DIA_C_U16_DID_AIVI_FACTORY_MODE                                   ((tU16) 0xDEF0)
#define DIA_C_U16_DID_AIVI_CONNECTIVITY_CONFIG                            ((tU16) 0x2107)
#define DIA_C_U16_DID_AIVI_HMI_CONFIG                                     ((tU16) 0x2108)
#define DIA_C_U16_DID_AIVI_SOUND_VOLUME_CONFIG                            ((tU16) 0x2109)
#define DIA_C_U16_DID_AIVI_DRM_TUNER_PARAMETER_SET                        ((tU16) 0xDACA)
#define DIA_C_U16_DID_RTCTRL_SELF_DIAGNOSIS                                ((tU16) 0x8002)
#define DIA_C_U16_DID_AIVI_RESET_TOUCH_CTRL_EXT_DISPLAY                   ((tU16) 0x9010)
#define DIA_C_U16_DID_AIVI_DTV_SUBMODULE_HW_VERSION                       ((tU16) 0x2020)
#define DIA_C_U16_DID_AIVI_DTV_SUBMODULE_SW_VERSION                       ((tU16) 0x2021)
#define DIA_C_U16_DID_AIVI_DTV_SUBMODULE_BOOT_VERSION                     ((tU16) 0x2022)
#define DIA_C_U16_DID_AIVI_FPGA_MODULE_SW_VERSION                         ((tU16) 0x2023)
#define DIA_C_U16_DID_AIVI_DISP_ILLUMINATION_ALIGNMENT                    ((tU16) 0x810A)
#define DIA_C_U16_DID_AIVI_KEY_ILLUMINATION_ALIGNMENT_2                   ((tU16) 0x810B)

/* Dynamic Length */
#define DIA_C_U16_DID_AIVI_PHONE_ECNR_NBS_BASE_SCOPE2                     ((tU16) 0xD000)
#define DIA_C_U16_DID_AIVI_PHONE_ECNR_WBS_BASE_SCOPE2                     ((tU16) 0xD100)
#define DIA_C_U16_DID_AIVI_VR_PARAM_AUTO_BARGE_IN_SCOPE2                  ((tU16) 0xD200)
#define DIA_C_U16_DID_AIVI_CARPLAY_PHONE_ECNR_NBS                         ((tU16) 0xD300)
#define DIA_C_U16_DID_AIVI_CARPLAY_PHONE_ECNR_WBS                         ((tU16) 0xD400)
#define DIA_C_U16_DID_AIVI_CARPLAY_FACETIME_ECNR_SWB                      ((tU16) 0xD500)
#define DIA_C_U16_DID_AIVI_ACOUSTIC_PARAM_BASE_SCOPE2                     ((tU16) 0xD600)  //valid for Scope 2.0, keep in Scope 2.1 also (due to customer request)
#define DIA_C_U16_DID_AIVI_AUDIO_SOURCE_OFFSET_IN                         ((tU16) 0x8250)

// Other
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#define DIA_C_U16_DID_AIVI_ALLIANCE_SW_REF                          ((tU16) 0xF013) //Scope2.0, 2.1
#else
#define DIA_C_U16_DID_AIVI_SECONDARY_OPERATIONAL_REFERENCE                ((tU16) 0xF013) //Scope1
#endif
#define DIA_C_U16_DID_AIVI_SPEED_INFO                                     ((tU16) 0x0201)
#define DIA_C_U16_DID_AIVI_VARIANT_CODING                                 ((tU16) 0x3040)
#define DIA_C_U16_DID_AIVI_VDIAG                                          ((tU16) 0xF1A0)
#define DIA_C_U16_DID_AIVI_WIFI_NAME                                      ((tU16) 0xDAF0)

// SIGMA
#define DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_00                ((tU16) 0xDA00)
#define DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_01                ((tU16) 0xDA01)
#define DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_02                ((tU16) 0xDA02)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_01                ((tU16) 0xDA10)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_02                ((tU16) 0xDA11)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_03                ((tU16) 0xDA12)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_04                ((tU16) 0xDA13)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_05                ((tU16) 0xDA14)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_06                ((tU16) 0xDA15)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_07                ((tU16) 0xDA16)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_08                ((tU16) 0xDA17)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_09                ((tU16) 0xDA18)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_10                ((tU16) 0xDA19)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_11                ((tU16) 0xDA1A)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_12                ((tU16) 0xDA1B)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_13                ((tU16) 0xDA1C)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_14                ((tU16) 0xDA1D)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_15                ((tU16) 0xDA1E)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_16                ((tU16) 0xDA1F)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_17                ((tU16) 0xDA20)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_18                ((tU16) 0xDA21)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_19                ((tU16) 0xDA22)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_20                ((tU16) 0xDA23)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_21                ((tU16) 0xDA24)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_22                ((tU16) 0xDA25)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_23                ((tU16) 0xDA26)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_24                ((tU16) 0xDA27)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_25                ((tU16) 0xDA28)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_26                ((tU16) 0xDA29)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_27                ((tU16) 0xDA2A)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_28                ((tU16) 0xDA2B)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_29                ((tU16) 0xDA2C)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_30                ((tU16) 0xDA2D)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_31                ((tU16) 0xDA2E)
#define DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_32                ((tU16) 0xDA2F)

// UDS sub function
#define DIA_C_U8_SUBFUNC_AIVI_RESET_CONFIG_TO_DELIVERY_STATE              ((tU8) 0x40)

/* Project specific System Setting Features */
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_CLEAR_MCAN_HISTORIES           DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_1
#define DIA_C_STR_SYSTEM_SETTING_TYPE_CLEAR_MCAN_HISTORIES                ((tCString) "DIA_SYSSET_TYPE_CLEAR_MCAN_HISTORIES")
#define DIA_C_UID_SYSTEM_SETTING_TYPE_CLEAR_MCAN_HISTORIES                ((dia_UID) 0xf41a805b)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_SELF_DIAGNOSIS                DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_2
#define DIA_C_STR_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS                     ((tCString) "DIA_SYSSET_TYPE_SELF_DIAGNOSIS")
#define DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS                     ((dia_UID) 0xf60e4fa7)

// ---- BT OR WIFI ----
#define DIA_C_U16_DID_AIVI_BT_CONNECTED_DEVICE                            ((tU16) 0x3000)
#if 0
#define DIA_C_U16_DID_AIVI_BT_SIGNAL_QUALITY                              ((tU16) 0x3001)
#else
#define DIA_C_U16_DID_AIVI_ANTENNA1_PARAMETER_AM_FM1                      ((tU16) 0x3001)
#define DIA_C_U16_DID_AIVI_ANTENNA2_PARAMETER_FM2                         ((tU16) 0x3002)
#define DIA_C_U16_DID_AIVI_ANTENNA3_PARAMETER_DAB                         ((tU16) 0x3003)
#endif
#define DIA_C_U8_SUBFUNC_AIVI_XCP_GET_MONITORING_DATA                     ((tU8) 0x01)
#define DIA_C_U16_DID_AIVI_VIN                                            ((tU16) 0xF190) // DID for Vehicle Indentification Number (VIN)
#define DIA_C_U16_DID_AIVI_HW_REF_A                                       ((tU16) 0x3051) // DID for RefA (same as VEH_MANUFACTURER_ECU_HW_NR) in prod session
#define DIA_C_U16_DID_AIVI_AUXIN_DETECT                                   ((tU16) 0x1010)
#define DIA_C_U16_DID_AIVI_EXT_OUT_SPARE3                                 ((tU16) 0x1085) // DID for Spare3
#define DIA_C_U16_DID_AIVI_SECURITY_FINGERPRINT                           ((tU16) 0xF010)
#define DIA_C_U16_DID_AIVI_SECURITY_INDEX_SRV_DATA                        ((tU16) 0xF011)
#define DIA_C_U16_DID_AIVI_RADIO_STATE                                    ((tU16) 0x1005)
#define DIA_C_U16_DID_AIVI_ECU_TEMP                                       ((tU16) 0x1007) // DID for ECU Temperature
#define DIA_C_U16_DID_AIVI_DEGRADED_MODE_COUNTER                          ((tU16) 0x1010)     // DID for Degraded mode counter
#define DIA_C_U16_DID_AIVI_DEGRADED_MODE_TIME                             ((tU16) 0x1011)     // DID for Degraded mode cumulated duration
#define DIA_C_U16_DID_AIVI_GPS_RECEPTION_LEVEL                            ((tU16) 0x3004)   //DID for GPS reception level in customer session in scp 2.1
#define DIA_C_U16_DID_AIVI_ENGINE_STOPPED_TIME                            ((tU16) 0x1012)   // DID for Time from Engine Stopped
#define DIA_C_U16_DID_AIVI_VEHICLE_ID_VALUE                               ((tU16) 0x1000)   // DID for Vehicle Identifier Value
#define DIA_C_U16_DID_AIVI_FAN_ACTIVATION_COUNTER                         ((tU16) 0x1008)
#define DIA_C_U16_DID_AIVI_FAN_ACTIVATION_DURATION                        ((tU16) 0x1009)

// ---- INTERNAL COMMANDS ----
#define DIA_C_U16_DID_RBCM_TEST_FACTORY_MODE                               ((tU16) 0xFD20)
#define DIA_C_U16_DID_RBCM_TEST_CALIBRATION                                ((tU16) 0xFD21)
#define DIA_C_U16_DID_RBCM_TEST_XTRA_DATA                                  ((tU16) 0xFD22)

// Reprogramming and Calibration
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_REFERENCE_CHECKSUM                ((tU16) 0xFD00)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_NBS                    ((tU16) 0xFD01)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_WBS                    ((tU16) 0xFD02)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_VR_PARAM                          ((tU16) 0xFD03)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_NBS            ((tU16) 0xFD04)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_WBS            ((tU16) 0xFD05)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_FACETIME_ECNR_SWB         ((tU16) 0xFD06)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ACOUSTIC_PARAM                    ((tU16) 0xFD07)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ESE_PARAM                         ((tU16) 0xFD08)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_NBS                 ((tU16) 0xFD09)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_WBS                 ((tU16) 0xFD0A)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_SIRI_ECNR_WBS                  ((tU16) 0xFD0B)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_SIRI_ECNR_WBS             ((tU16) 0xFD0C)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ANDROID_AUTO_VR_ECNR_WBS          ((tU16) 0xFD0D)
#define DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ECNR_VPA_VOICE_WB                 ((tU16) 0xFD0E)
#define DIA_C_U16_ID_AIVI_RTCTRL_CHECK_PROGRAMMING_DEPENDENCIES            ((tU16) 0xFF01)
#define DIA_C_U16_ID_AIVI_RTCTRL_RUN_DTC_TEST_LOGICAL_BLOCK                ((tU16) 0xFF06)
#define DIA_C_U16_ID_AIVI_RTCTRL_BOOT_BS_AND_STMIN                         ((tU16) 0x0200)
#define DIA_C_U16_ID_AIVI_RTCTRL_BOOT_SPECIFIC_BS_AND_STMIN                ((tU16) 0x02FF)

//Routine Controls
#define DIA_C_U16_ID_RTCTRL_GENERATE_CSR                                   ((tU16) 0x1100)
#define DIA_C_U16_ID_RTCTRL_KEY_PAIR_GENERATION                            ((tU16) 0x1101)
#define DIA_C_U16_ID_RTCTRL_CERTIFICATE_STORING                            ((tU16) 0x1102)
#define DIA_C_U16_ID_RTCTRL_START_SWUPDATE_OF_ALL_SUBMODULES               ((tU16) 0x1110)
#define DIA_C_U16_ID_RTCTRL_SWUP_UPDATE_MAP_DATA                           ((tU16) 0x1111)
#define DIA_C_U16_ID_RTCTRL_GET_BT_SIGQ_RSSI                               ((tU16) 0x8001)

// Enum of unique identifiers for concrete routines
#define DIA_EN_RTCTRL_ID_RUN_DTC_TEST_LOGICAL_BLOCK                        DIA_EN_RTCTRL_ID_PROJECT_01
#define DIA_EN_RTCTRL_ID_SWUP_UPDATE_MAP_DATA                              DIA_EN_RTCTRL_ID_PROJECT_02

#define  DIA_LOGICAL_BLOCK_00_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0051)
#define  DIA_LOGICAL_BLOCK_01_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0151)
#define  DIA_LOGICAL_BLOCK_02_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0251)
#define  DIA_LOGICAL_BLOCK_03_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0351)
#define  DIA_LOGICAL_BLOCK_04_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0451)
#define  DIA_LOGICAL_BLOCK_05_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0551)
#define  DIA_LOGICAL_BLOCK_06_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0651)
#define  DIA_LOGICAL_BLOCK_07_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0751)
#define  DIA_LOGICAL_BLOCK_08_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0851)
#define  DIA_LOGICAL_BLOCK_09_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0951)
#define  DIA_LOGICAL_BLOCK_10_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0A51)
#define  DIA_LOGICAL_BLOCK_11_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0B51)
#define  DIA_LOGICAL_BLOCK_12_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0C51)
#define  DIA_LOGICAL_BLOCK_13_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0D51)
#define  DIA_LOGICAL_BLOCK_14_FTB_PROGRAMMING_FAILURE  ((tU32)0xFD0E51)

//FTB - Failure Type Bytes
#define FTB_PROGRAMMING_FAILURE ((tU32)0x51)   /* Type "Programming Failure/Not programmed" is cleared/set at digest check */
#define FTB_INTERNAL_FAILURE    ((tU32)0x42)
#define FTB_ALGORITHM_FAILURE   ((tU32)0x06)

#define DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_HW_D_NR                        ((tU16) 0xF111)//DID later for Scope 3.0
#define DIA_C_U16_DID_AIVI_CD_INSERT_COUNT                                 ((tU16) 0x3005)
#endif

//Center CM-C 19
#define DIA_C_U16_DID_CENTER_CMC_19_READ_OVERALL_CIS_SW_VERSION                      ((tU16) 0x1F48)
#define DIA_C_U16_DID_CENTER_CMC_19_HARDWARE_SUPPLIER_INFO                 ((tU16) 0xF154) // DID for Hardware Supplier Information
#define DIA_C_U16_DID_CENTER_CMC_19_SOFTWARE_SUPPLIER_INFO                 ((tU16) 0xF155) // DID for Software Supplier Information
#define DIA_C_U16_DID_CENTER_CMC_19_BOOT_SW_VERSION_INFO                   ((tU16) 0xF153) // DID for Boot Software Version
#define DIA_C_U16_DID_CENTER_CMC_19_SW_VERSION_INFO                        ((tU16) 0xF151) // DID for Customer Software Version
#define DIA_C_U16_DID_CENTER_CMC_19_COMPONENTS_SW_VERSION_INFO             ((tU16) 0x1F4B)
#define DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_HW_PART_NUMBER     ((tU16) 0xF192) // DID for System Supplier ECUHWPartNumber
#define DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_HW_VERSION_NUMBER  ((tU16) 0xF193) // DID for System Supplier ECUHWVersionNumber
#define DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_SW_PART_NUMBER     ((tU16) 0xF194) // DID for System Supplier ECUSWPartNumber
#define DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_SW_VERSION_NUMBER  ((tU16) 0xF195) // DID for System Supplier ECUSWVersionNumber
#define DIA_C_U16_DID_CENTER_CMC_19_ECU_SERIAL_NUMBER					   ((tU16) 0xF18C) // DID for ECU Serial Number(Customer Diagnosis)
#define DIA_C_U16_DID_CENTER_CMC_19_HARDWARE_VERSION_INFO				   ((tU16) 0xF150) // DID for System Supplier hardware version information
#define DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION				   ((tU16) 0x2008) // DID for System Supplier customerECUHWVersion
#define DIA_C_U16_DID_CENTER_CMC_19_HARDWARE_PART_NUMBER				   ((tU16) 0xF116) // DID for Hardware Part Number(for Customer Diagnosis)
#define DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER			   ((tU16) 0x2001) // DID for Customer Spare Part Number(in BOSCH Production Diagnosis)
#define DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER			               ((tU16) 0x0103) // DID for VIN Odometer
#define DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER_LIMIT			           ((tU16) 0x0104) // DID for VIN Odometer Limit
#define DIA_C_U16_DID_CENTER_CMC_19_VIN_ORIGINAL			               ((tU16) 0xF190) // DID for VIN Original
#define DIA_C_U16_DID_CENTER_CMC_19_VIN_CURRENT			                   ((tU16) 0xF1A0) // DID for VIN Current
#define DIA_C_U16_DID_CENTER_CMC_19_VIN_RESET			                   ((tU16) 0x0212) // DID for VIN Reset
#define DIA_C_U16_DID_CENTER_CMC_19_ACTIVE_DIAGNOSTIC_INFO			       ((tU16) 0xF100) // DID for Active Diagnostic Information
#define DIA_C_U16_DID_CENTER_CMC_19_COMPATIBILITY_LIST                     ((tU16) 0xE000) // DID for Compatibility List Information
#define DIA_C_U16_DID_CENTER_CMC_19_CONFIGURATION_FINGERPRINT			   ((tU16) 0xF15D) // DID for Configuration Fingerprint
#define DIA_C_U16_DID_CENTER_CMC_19_TUNER_AM_FM_FIELDSTRENGTH			   ((tU16) 0x1F40) // DID for Tuner AM/FM Fieldstrength
#define DIA_C_U16_DID_CENTER_CMC_19_TUNER2_FM_FIELDSTRENGTH			       ((tU16) 0x1F41) // DID for Tuner FM Fieldstrength
#define DIA_C_U16_DID_CENTER_CMC_19_TUNER_DAB_FIELDSTRENGTH			       ((tU16) 0x1F42) // DID for Tuner AM/FM Fieldstrength
#define DIA_C_U16_DID_CENTER_CMC_19_WEATHERBAND_FIELDSTRENGTH			   ((tU16) 0x1F43) // DID for Tuner Weatherband Fieldstrength
#define DIA_C_U16_DID_CENTER_CMC_19_TUNER_SXM_FIELDSTRENGTH			       ((tU16) 0x1F44) // DID for Tuner SXM Fieldstrength
#define DIA_C_U16_DID_CENTER_CMC_19_DISPLAY_TEST_PATTERN	               ((tU16) 0xDF01) // DID for Display Test Pattern
#define DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_OPERATION_TIME			       ((tU16) 0xF119) // DID for Operation Time (Customer Diagnosis)
#define DIA_C_U16_DID_CENTER_CMC_19_TEMPERATURE_HISTOGRAM_IMX              ((tU16) 0x1F10) // DID for Temperature Histogram Read
#define DIA_C_U16_DID_CENTER_CMC_19_MERCEDES_TRUCK_SOFTWARE_PART_NUMBER    ((tU16) 0xF126) // DID for Software Part Number
#define DIA_C_U16_DID_CENTER_CMC_19_PNM_GROUP10_CONFIG			           ((tU16) 0x1F80) // DID for PNM Group 10 Configuration
#define DIA_C_U16_DID_CENTER_CMC_19_HISTORICLE_INTERROGATION_REC		   ((tU16) 0x0101) // DID for Historical Interrogation Record
#define DIA_C_U16_DID_CENTER_CMC_19_TESTER_IDENTIFICATION				   ((tU16) 0xC211) //DID for Tester Identification Stored Record
#define DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_INSTALLATION		               ((tU16) 0x1F54) // DID for RoutineCtrlSystemInstallation
#define DIA_C_U16_DID_CENTER_CMC_19_COPY_INSTALLATION_LOGFILE_TO_USB       ((tU16) 0x1F55) // DID for RoutineCtrlCopyInstallationLogFileToUSB
#define DIA_C_U16_DID_CENTER_CMC_19_OABR_CONNECTION_STATUS_AMPLIFIER       ((tU16) 0x1F02) // DID for ReadAmplifierConnectionStatus
#define DIA_C_U16_DID_CENTER_CMC_19_PRIVATE_MIC_SWITCH			           ((tU16) 0x1012) // DID for PrivateMicSwitch
#define DIA_C_U16_DID_CENTER_CMC_19_WAKEIN_STATUS						   ((tU16) 0x1011) // DID for StatusWakeIn 
#define DIA_C_U16_DID_CENTER_CMC_19_TESTMODE_DTM 				           ((tU16) 0x3201) // DID for DTM Test Mode Application
#define DIA_C_U16_DID_CENTER_CMC_19_NVM_CONFIG 				               ((tU16) 0x3202) // DID for NVM Configuration
#define DIA_C_U16_DID_CENTER_CMC_19_IDENTIFY_SUB_SYSTEM 				   ((tU16) 0x1F00) // DID for identify SubSystem
#define DIA_C_U16_DID_CENTER_CMC_19_SUB_SYSTEM_CONNECT           		   ((tU16) 0x1F01) // DID for Connect to specific subsystem Routine
#define DIA_C_U16_DID_CENTER_CMC_19_EXTERNAL_CTRL_SWITCH_WAKEOUT           ((tU16) 0x1014) // DID for I/O Control set external switch wake-out pin
#define DIA_C_U16_DID_CENTER_CMC_19_TUNER_HD_FIELDSTRENGTH			       ((tU16) 0x1F45) // DID for Tuner HD Fieldstrength
#define DIA_C_U16_DID_CENTER_CMC_19_CIS_HMI_STARTUP_LOGO_INSTALLATION      ((tU16) 0x1F56) // DID for CIS HMI Startup Logo Installation
#define DIA_C_U16_DID_CENTER_CMC_19_DTC_CONFIGURATION                      ((tU16) 0x1F81) // DID for DTC Configuration
#define DIA_C_U16_DID_CENTER_CMC_19_CVBS_CONNECTION_STATUS                 ((tU16) 0x1F01) // DID for CVBS Connection status
#define DIA_C_U16_DID_CENTER_CMC_19_RELOAD_SUPPLIER_DELIVERY_STATE         ((tU16) 0x0224) // DID for Reload supplier Delivery state
#define DIA_C_U16_DID_CENTER_CMC_19_AVDECC_CONFIGURATION                   ((tU16) 0x3203) // DID for  AVDECC Configuration
#define DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION                      ((tU16) 0x3204) // DID for  CIS Configuration
#define DIA_C_U16_DID_CENTER_CMC_19_INTERCOM_PHONE_NAME                    ((tU16) 0x3205) // DID for  Intercom Phone Name
#define DIA_C_U16_DID_CENTER_CMC_19_CIS_INSTALL_CONTAINER_EXTRACT          ((tU16) 0x1F53) // DID for RoutineCtrCISInstallationContainerExtract
#define DIA_C_U16_DID_CENTER_CMC_19_PHONEBOOK_MAX_CONTACT_ENTRIES          ((tU16) 0x1F32) // DID for ReadPhoneBookMaxContactEntries
#define DIA_C_U16_DID_CENTER_CMC_19_CIS_CONFIGURATION_CD                   ((tU16) 0x1F82) // DID for  CIS Configuration CD
#define DIA_C_U16_DID_CENTER_CMC_19_CD_DEF_NVM_GROUP10_CONFIG              ((tU16) 0x3206) // DID for  NVM Configuration CD default
#define DIA_C_U16_DID_CENTER_CMC_19_SUBSYSTEM_NODE_LIST              	   ((tU16) 0x1F47) // DID for  Subsystem node list
#define DIA_C_U16_DID_CENTER_CMC_19_AUDIO_FILES_COUNTER                    ((tU16) 0x1F33) // DID for ReadAudioFilesCounter
#define DIA_C_U16_DID_CENTER_CMC_19_VIDEO_FILES_COUNTER                    ((tU16) 0x1F34) // DID for ReadVideoFilesCounter
#define DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_AM                     ((tU16) 0x1F22) // DID for Center CM-C 19 Runtime Source AM
#define DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_FM                     ((tU16) 0x1F23) // DID for Center CM-C 19 Runtime Source FM
#define DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_DAB                    ((tU16) 0x1F24) // DID for Center CM-C 19 Runtime Source DAB
#define DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_WBD                    ((tU16) 0x1F25) // DID for Center CM-C 19 Runtime Source WBD
#define DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_SXM                    ((tU16) 0x1F26) // DID for Center CM-C 19 Runtime Source SXM
#define DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_ARG                    ((tU16) 0x1F27) // DID for Center CM-C 19 Runtime Active Route Guidance
#define DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_PMO                    ((tU16) 0x1F28) // DID for Center CM-C 19 Runtime Passenger Map Out
#define DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_HD                     ((tU16) 0x1F46) // DID for Center CM-C 19 Runtime HD
#define DIA_C_U16_DID_CENTER_CMC_19_SPEECH_CONTROL_COUNTER                 ((tU16) 0x1F36) // DID for Center CM-C 19 Runtime Speech Counter
#define DIA_C_U16_DID_CENTER_CMC_19_SW_DOWNLOAD_PRIVATE_KEY_STATUS         ((tU16) 0x6640) // DID for Center CM-C 19 SW Download Private Key status
#define DIA_C_U16_DID_CENTER_CMC_19_DATA_CARRIER_VERSION                   ((tU16) 0x1F49)
#define DIA_C_U16_DID_CENTER_CMC_19_VEHICLE_INFO                           ((tU16) 0x1F4A)
#define DIA_C_U16_DID_CENTER_CMC_19_CIS_SW_UPDATE_STAGE1                   ((tU16) 0x1F57)
#define DIA_C_U16_DID_CENTER_CMC_19_CIS_SW_UPDATE_STAGE2                   ((tU16) 0x1F58)

//New Session->SubSystem Diagnosis Session for CMC-19
#define  DIA_C_U8_UDS_SESSION_SUBSYSTEM                                	   ((tU8) 0x40)
//
// Create new Test Conditions / unique identifier for the internal test
//
#define DIA_EN_TESTCONDITION_PROCESS_ODOMETER                              ((dia_enTestCondition) DIA_EN_TESTCONDITION_PROJECT_04)
#define DIA_EN_TESTCONDITION_PROCESS_VIN                                   ((dia_enTestCondition) DIA_EN_TESTCONDITION_PROJECT_05)
//
// Create and Configure a new DID for the new INTERNAL test
//
#define DIA_C_U16_INT_TEST_DID_CENTER_CMC_19_VIN_ODOMETER               ((tU16) 0xFD15) // project specific test
#define DIA_C_U16_INT_TEST_DID_CENTER_CMC_19_VIN_CURRENT                ((tU16) 0xFD16) // project specific test
//
//! The Variable length features have DID's that are conflicting with other features.
//! To avoid the same such conflicting DID'd are replaced with unique internal DID's 
//! This Section provides definition for the conflicting DID's & corresponding unique DID's
//
// Create & Configure Project Specific DID's & Conflicting DID's 
//
#define DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_MAP_D010			((tU16) 0x3FFF)
#define DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_VICTIM_D010		((tU16) 0xD010)
#define DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_MAP_D002			((tU16) 0x3FFE)
#define DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_VICTIM_D002		((tU16) 0xD002)




