/**
 * \file      dia_common_services_uds_production.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      08.11.2012
 *
 * \copyright Robert Bosch Car Multimedia 2012
 *--------------------------------------------------------
 * Date      | Author             | Modification
 * 19.06.14  | NCE5KOR            | Added header file for USB power supply Read(dia_USB_1_PowerSupply_Read.h).
 * 05.06.14  | NCE5KOR            | Added header file for USB power supply(dia_IOCtrl_USB_1_PowerSupply.h).
 * 09.03.16  | BMA9KOR			  | Added header file for ADR Amplifier Configuration (dia_SrvHandler_ReadADR3AmpConfig.h)
 * 09.07.16  | DVD5KOR			  | Added header file for Fan Related IOCtrl and Read Services
 * 09.08.16  | BMA9KOR			  | Added header file for Touch Selftest RtCtrl
 *--------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_COMMON_SERVICES_UDS_PRODUCTION__
#define __INCLUDED_DIA_COMMON_SERVICES_UDS_PRODUCTION__

// -------------------------  ioctrl services -----------------------------

// --- LCM ---

// --- TUNER ---
#include "dia_IOCtrlTunerAMFM_Antenna_PowerSupply.h"
#include "dia_IOCtrlTunerAMFM_Band.h"
#include "dia_IOCtrlTunerAMFM_Frequency.h"
#include "dia_IOCtrlTunerAMFM_SelectActiveTuner.h"
#include "dia_IOCtrlTunerDAB_Antenna_1_PowerSupply.h"
#include "dia_IOCtrlTunerDAB_Antenna_1_EnsembleFrequency.h"
#include "dia_IOCtrlTunerDAB_Antenna_1_ServiceID.h"
#include "dia_IOCtrlADR3SetSignalQuality.h"
#include "dia_IOCtrlTunerDRM_Antenna_ServiceID.h"
#include "dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency.h"
#include "dia_SrvHandler_GetActiveALDlevel.h"


// --- DIMMING ---
#include "dia_IOCtrl_KeyIllumination.h"
#include "dia_IOCtrl_KeyIlluminationPWM.h"
#include "dia_IOCtrlDisplayBrightness.h"
#include "dia_IOCtrlDisplayTestPattern.h"

// --- INPUT HANDLING ---
#include "dia_IOCtrlInputHdlPressedKey.h"
#include "dia_RoutineCtrlTouchSelfTest.h"

// --- MEDIA ---
#include "dia_IOCtrl_PlayedTrack.h"
#include "dia_IOCtrlActiveVideoSource.h"
#include "dia_IOCtrlAudioBalance.h"
#include "dia_IOCtrlAudioExternalAmplifierContLine.h"
#include "dia_IOCtrlAudioFader.h"
#include "dia_IOCtrlAudioGain.h"
#include "dia_IOCtrlAudioLinearMode.h"
#include "dia_IOCtrlAudioSourceSet.h"
#include "dia_IOCtrlAudioTestTone.h"
#include "dia_IOCtrlCompressedAudioTitle.h"
#include "dia_IOCtrlCDModeControl.h"
#include "dia_IOCtrlCDResetLine.h"
#include "dia_IOCtrlUSB_PowerSupply.h"
#include "dia_IOCtrlAudioSinkSet.h"

// --- SENSOR ---
#include "dia_IOCtrlGNSSPositioningSystem.h"

// --- XM ---
#include "dia_IOCtrlTunerXM_1_Channel.h"

// --- BT ---
#include "dia_IOCtrlBluetoothMode.h"
#include "dia_IOCtrlBluetoothModuleReset.h"
#include "dia_IOCtrlBtModuleReset.h"
#include "dia_IOCtrlWifiModuleReset.h"
#include "dia_IOCtrlWifiMode.h"
#include "dia_SrvHandler_ReadWifiMode.h"

// --- HMI ---
#include "dia_IOCtrlHMILanguage.h"
#include "dia_IOCtrlHmiRemoteControl.h"
#include "dia_IOCtrlSystemHmiOn.h"

// --- RVC ---
#include "dia_IOCtrlRVCControlLine.h"

// --- GPIO ---
#include "dia_IOCtrlMicrophonePowerSupply.h"

// --- HeatCtrl ---
#include "dia_IOCtrlFanSpeed.h"


// ---------------------------- rtctrl services ------------------------------

// --- LCM ---
#include "dia_RoutineCtrlLcmStartAlternativeSoftware.h"
#include "dia_RtCtrlresetSystemResetInformation.h"
#include "dia_RtCtrlSystemOperationTime_Reset.h"
#include "dia_RoutineCtrlStartSoftwareUpdate.h"


#include "dia_RtCtrlReadAverageCpuLoadForSwVer.h"
#include "dia_RtCtrlReadErrorStateHistoryForSwVer.h"
#include "dia_RtCtrlReadMaximumRamConsumptionForSwVer.h"
#include "dia_RtCtrlReadResetHistoryForSwVer.h"
#include "dia_RtCtrlReadResetInformationForSwVer.h"
#include "dia_RtCtrlReadStartupTimeStatisticForSwVer.h"
#include "dia_RtCtrlReadStateHistoryForSwVer.h"
#include "dia_RtCtrlReadSystemOperationTimeForSwVer.h"
#include "dia_RtCtrlReadWakeupHistoryForSwVer.h"

// --- TUNER ---

// --- DIMMING ---

// --- INPUT HANDLING ---
#include "dia_RoutineCtrlTouchPanelAlignment.h"

// --- MEDIA ---
#include "dia_RoutineCtrlIPODSelfTest.h"
#include "dia_RtCtrlCDDriveSelftest.h"

// --- XM ---

// --- BT OR WIFI ---
#include "dia_RtCtrlGetWifiSNR.h"

// --- TEF OR DEFSET ---
#include "dia_RoutineCtrlSetSystemToDeliveryState.h"
#include "dia_RoutineCtrlSetDiagnosticsToDeliveryState.h"

// --- SENSOR ---
#include "dia_RtCtrlAccSelftest.h"
#include "dia_RtCtrlGyroSelftest.h"

#include "dia_RoutineCtrlGNSSCalcAndVerifyChecksum.h"

// --- NAVI ---
#include "dia_RoutineCtrlCalculateRoute.h"

// ------------------------------------ read services ------------------------------------

// --- GENERIC ---
#include "dia_SrvHandler_ReadDataByMemory.h"

// --- LCM ---
#include "dia_SrvHandler_GetSystemOperationTime.h"
#include "dia_SrvHandler_GetSystemResetInformation.h"
#include "dia_SrvHandler_PowerSupply.h"
#include "dia_SrvHandler_PowerSupplyStatus.h"
#include "dia_SrvHandler_HistoryState.h"
#include "dia_SrvHandler_HistoryReset.h"
#include "dia_SrvHandler_HistoryWakeup.h"
#include "dia_SrvHandler_HistoryErrState.h"
#include "dia_SrvHandler_PowerSupplyVoltageHistogram.h"
#include "dia_SrvHandler_PowerSupplyVoltageStateCounter.h"
#include "dia_SrvHandler_AverageCpuLoad.h"
#include "dia_SrvHandler_MaximumRamConsumption.h"
#include "dia_SrvHandler_StartupTimeStatistic.h"

// --- TUNER ---
#include "dia_SrvHandler_TunerAMFM_Antenna1Current.h"
#include "dia_SrvHandler_TunerAMFM_Antenna1Status.h"
#include "dia_SrvHandler_TunerAMFM_Antenna2Current.h"
#include "dia_SrvHandler_TunerAMFM_Antenna2Status.h"
#include "dia_SrvHandler_TunerAMFM_Band.h"
#include "dia_SrvHandler_TunerAMFM_Fieldstrength.h"
#include "dia_SrvHandler_TunerAMFM_FMRDSProgramInformation.h"
#include "dia_SrvHandler_TunerAMFM_Frequency.h"
#include "dia_SrvHandler_TunerAMFM_SelectActiveTuner.h"
#include "dia_SrvHandler_TunerDAB_Antenna1Current.h"
#include "dia_SrvHandler_TunerDAB_Antenna1Status.h"
#include "dia_SrvHandler_TunerDAB_Antenna1EnsembleFrequency.h"
#include "dia_SrvHandler_TunerDAB_Antenna1ServiceID.h"
#include "dia_SrvHandler_TunerDRM_AntennaEnsembleFrequency.h"
#include "dia_SrvHandler_TunerDRM_AntennaServiceID.h"
#include "dia_SrvHandler_ReadADR3AmpConfig.h"
// --- DIMMING ---
#include "dia_SrvHandler_DimmingLedClassInfo_Get.h"
#include "dia_SrvHandler_Disp_BrightnessInfo_Get.h"
#include "dia_SrvHandler_KeyB_BrightnessInfo_Get.h"
#include "dia_SrvHandler_KeyB_PwmInfo_Get.h"
#include "dia_SrvHandler_Pwm_BrightnessInfo_Get.h"
#include "dia_SrvHandler_WireDimmingInfo_Get.h"

// --- INPUT HANDLING ---
#include "dia_SrvHandler_InputHdlEncoder1CounterValue_Get.h"
#include "dia_SrvHandler_InputHdlEncoder2CounterValue_Get.h"
#include "dia_SrvHandler_InputHdlPressedKey_Get.h"
#include "dia_SrvHandler_InputHdlTouchPanelStatus_Get.h"

// --- MEDIA ---
#include "dia_SrvHandler_AudioSourceActiveGet.h"
#include "dia_SrvHandler_GetPlayedTrack.h"
#include "dia_SrvHandler_OpticaldriveLoaderstatus.h"
#include "dia_SrvHandler_SDCard1MediaInfo.h"
#include "dia_SrvHandler_SDCard1SlotState.h"
#include "dia_SrvHandler_USBDeviceInfo.h"
#include "dia_SrvHandler_USB_PowerSupply.h"
#include "dia_SrvHandler_USB_PowerSupplyInfoPort.h"

// --- SENSOR ---
//#include "dia_SrvHandler_SensorConfigurationGNSS_Get.h"
#include "dia_SrvHandler_GNSSAntennaCurrent_Get.h"
#include "dia_SrvHandler_GNSSAntennaStatus_Get.h"
#include "dia_SrvHandler_GNSSBestSattelites_Get.h"
#include "dia_SrvHandler_GNSSPositioningSystem_Get.h"
#include "dia_SrvHandler_GNSSReceiverFirmwareVersion_Get.h"
#include "dia_SrvHandler_GNSSReceiverStatus_Get.h"
#include "dia_SrvHandler_GNSSSatellitesSignalQuality_Get.h"
#include "dia_SrvHandler_WireSpeedInformation_Get.h"

// --- TEMPERATURE ---
#include "dia_SrvHandler_Disp_PanelTempInfo_Get.h"

// --- HMI ---
#include "dia_SrvHandler_SystemHmiOnGet.h"

// --- RVC ---
#include "dia_SrvHandler_RVC_ControlLineCurrent.h"
#include "dia_SrvHandler_RVC_ControlLineStatus.h"

// --- XM ---
#include "dia_SrvHandler_TunerXM_AntennaStatus.h"
#include "dia_SrvHandler_TunerXM_Channel.h"
#include "dia_SrvHandler_TunerXM_ChannelLabel.h"
#include "dia_SrvHandler_TunerXM_SignalQuality.h"
#include "dia_SrvHandler_TunerXM_UPC.h"
#include "dia_SrvHandler_TunerXM_BER.h"

// --- BT ---
#include "dia_ReadBluetoothConnectedDevice.h"
#include "dia_ReadBluetoothLinkQuality.h"
#include "dia_ReadBluetoothMACAddress.h"

// --- IDENTIFICATION & STORED DATA ---
#include "dia_SrvHandler_ReadADCRefPlusActualVoltage.h"
#include "dia_SrvHandler_ReadAdcEcall.h"
#include "dia_SrvHandler_WriteADCRefPlusActualVoltage.h"
#include "dia_SrvHandler_WriteADCThresholdValues.h"
#include "dia_SrvHandler_WriteCMConfigString.h"
#include "dia_SrvHandler_WriteCustoberSWVersion.h"
#include "dia_SrvHandler_WriteDataByMemory.h"
#include "dia_SrvHandler_CustomerAndBuildSWVersion_Write.h"
#include "dia_SrvHandler_ECUUniqueFieldDataId.h"
#include "dia_SrvHandler_ODXFileIdentifier.h"
#include "dia_SrvHandler_ReadAnonymousVIN.h"

// --- emmc
#include "dia_SrvHandler_ReadEmmcJedecCidReg.h"
#include "dia_SrvHandler_ReadEmmcJedecEcsdData.h"
#include "dia_SrvHandler_ReadRefreshStatusManagement.h"
#include "dia_SrvHandler_ReadTotalWrittenBlockCount.h"

// --- OTHERS ---
#include "dia_SrvHandler_SystemCurrentDiagnosticSession.h"

#ifndef __INCLUDED_DIA_IOCTRL_DATASET_BLOCK_SIZE__
#include "common/services/uds/production/dia_IOCtrlDatasetBlockSize.h"
#endif


#include "dia_IOCtrlVideoSourceSet.h"
#include "dia_SrvHandler_RadioTypeApprovalModeWrite.h"
#include "dia_SrvHandler_RadioTypeApprovalModeRead.h"

#include "dia_SrvHandler_ReadLastDiagnosisError.h"
#endif /* __INCLUDED_DIA_COMMON_SERVICES_UDS_PRODUCTION__ */
