/*!
 * \file       dia_UdsHelpersSpm.h
 *
 * \brief      Functions to convert between UDS- and diag-format for SPM-specific types
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_TO_UDS_HELPERS_SPM__
#define __INCLUDED_DIA_TO_UDS_HELPERS_SPM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

// todo:demangle types between Spm and SpmSVP
#include "common/interfaces/dia_ISpm.h"
#include "common/interfaces/dia_ISpmSVP.h"
#include "common/services/uds/generic/dia_ToUdsHelpers.h"

namespace dia {
bool dia_diaToUds(dia_tSpmTimeDate const &dia, std::vector<tU8>& uds);
bool dia_diaToUds(dia_tSpmSVPSwVersionInfo const &dia, std::vector<tU8>& uds);
bool dia_diaToUds(dia_tSpmResetCounterStatus  const &dia, std::vector<tU8>& uds);


bool dia_diaToUds(dia_tSpmSVPSubStateElement  const &dia, std::vector<tU8>& uds);
bool dia_diaToUds(dia_tSpmSVPStateHistoryElement const &dia, std::vector<tU8>& uds);

bool dia_diaToUds(dia_tSpmStatisticData const &dia, std::vector<tU8>& uds);

bool dia_diaToUds(dia_eSpmSystemState const &dia, std::vector<tU8>& uds);
bool dia_diaToUds(dia_tSpmSVPWakeupReasonElement  const &dia, std::vector<tU8>& uds);
bool dia_diaToUds(dia_tSpmSVPResetElement  const &dia, std::vector<tU8>& uds);


}
#endif
