/**
 * \file      dia_SrvHandler_WriteADCRefPlusActualVoltage.h
 *
 * \brief     {Reference + Actual/ Measured bytes => ADC Voltage write}
 *
 * \details   {Reference + Actual/ Measured bytes => ADC Voltage write}
 *
 * \author    bhs1hi
 * \date      Jul 28, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_ADC_REF_ACTUAL_VOLTAGE_WRITE__
#define __INCLUDED_DIA_ADC_REF_ACTUAL_VOLTAGE_WRITE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

class dia_SrvHandler_WriteADCRefPlusActualVoltage
   : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_WriteADCRefPlusActualVoltage);

public:
   //! class constructor
   dia_SrvHandler_WriteADCRefPlusActualVoltage ( void );
   //! class destructor
   virtual ~dia_SrvHandler_WriteADCRefPlusActualVoltage ( void ) {}

   //! process the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

protected:
   //! check if length is inside of the given range
   virtual tDiaResult checkLength ( tU16 length, tU16 minValue, tU16 maxValue );
};
#endif /* __INCLUDED_DIA_ADC_REF_ACTUAL_VOLTAGE_WRITE__ */
